/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.combine;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalFormulaInfo;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.calculate.thread.CalInitData;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TempTableData {
    private static final String WHERE_CONDITION_FLAG = "@WHERE";
    private CalInitData initData;

    public TempTableData(CalInitData initData) {
        this.initData = initData;
    }

    public Map<String, Map<String, Object>> combineTempTable(List<CalFormulaInfo> formulaList) throws Exception {
        String tempId;
        HashMap<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>();
        String tempIds = "";
        HashMap<String, String> columnTableMap = new HashMap<String, String>();
        for (CalFormulaInfo c : formulaList) {
            String[] tempTableArr;
            String tempTables = c.getListTable();
            if (StringUtils.isEmpty((String)tempTables)) continue;
            for (String s : tempTableArr = tempTables.split(";")) {
                tempId = s.split("~")[1];
                String column = s.split("~")[2];
                if (columnTableMap.containsKey(tempId)) {
                    columnTableMap.put(tempId, (String)columnTableMap.get(tempId) + column + ",");
                    continue;
                }
                columnTableMap.put(tempId, column + ",");
                tempIds = tempIds + "'" + tempId + "',";
            }
        }
        if (columnTableMap.size() < 1) {
            return dataMap;
        }
        String endDate = this.initData.getSchemeInfo().getEndDate().toString();
        String sql = "SELECT FID, FDEFINE, FSQLS, FPERIODFROM, FPERIODTO FROM T_HR_SFORMULATMPTABLE WHERE FID IN ( " + tempIds.substring(0, tempIds.length() - 1) + " )";
        IRowSet rowSet = DbUtil.executeQuery((Context)this.initData.getCtx(), (String)sql);
        String condition = " T_HR_SCmpCalTable.FID in (" + this.initData.getFilterSql() + ") AND ";
        while (rowSet.next()) {
            String tableDefine = rowSet.getString("FDEFINE");
            String fsqls = rowSet.getString("FSQLS");
            fsqls = fsqls.indexOf(WHERE_CONDITION_FLAG) > -1 ? fsqls : fsqls.replace("WHERE", WHERE_CONDITION_FLAG).replace("where", WHERE_CONDITION_FLAG);
            StringBuilder str = new StringBuilder(fsqls);
            if (str.indexOf(WHERE_CONDITION_FLAG) == -1) {
                int orderIndex = str.indexOf("ORDER BY");
                int insertIndex = orderIndex > -1 ? orderIndex : str.length();
                str.insert(insertIndex, " @WHERE 1 = 1 ");
            }
            str.insert(str.indexOf(WHERE_CONDITION_FLAG) + 7, condition);
            sql = str.toString().replaceAll("@YEARFROM", FunctionTools.adustStringDate(endDate, rowSet.getInt("FPeriodFrom"), "@YEARFROM")).replaceAll("@MONTHFROM", FunctionTools.adustStringDate(endDate, rowSet.getInt("FPeriodFrom"), "@MONTHFROM")).replaceAll("@YEARTO", FunctionTools.adustStringDate(endDate, rowSet.getInt("FPeriodTo"), "@YEARTO")).replaceAll("@MONTHTO", FunctionTools.adustStringDate(endDate, rowSet.getInt("FPeriodTo"), "@MONTHTO")).replaceAll(WHERE_CONDITION_FLAG, "WHERE");
            IRowSet rowSet1 = DbUtil.executeQuery((Context)this.initData.getCtx(), (String)sql);
            tempId = rowSet.getString("FID");
            String columns = (String)columnTableMap.get(tempId);
            columns = columns.substring(0, columns.length() - 1);
            String[] columnsArr = columns.split(",");
            while (rowSet1.next()) {
                String calId = rowSet1.getString("FID");
                Map rowMap = dataMap.containsKey(calId) ? (Map)dataMap.get(calId) : new HashMap();
                for (String s : columnsArr) {
                    rowMap.put(tableDefine + "_" + s, rowSet1.getObject(s));
                }
                dataMap.put(calId, rowMap);
            }
        }
        return dataMap;
    }
}

