/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.cost;

import com.kingdee.shr.compensation.cost.CmpPoint;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CmpAxle {
    Map<Integer, CmpPoint> map;
    int minKey;
    int maxKey;
    Set<Integer> safePoint;
    private CmpPoint linkedPoint;
    private Calendar maxCalendar = Calendar.getInstance();
    private Set<String> idSet;

    public CmpAxle() {
        this.maxCalendar.set(2199, 11, 1);
        this.safePoint = new HashSet<Integer>();
        this.map = new HashMap<Integer, CmpPoint>();
        this.idSet = new HashSet<String>();
    }

    public Set<Integer> getSafePoint() {
        return this.safePoint;
    }

    public void addSafePoint(int key) {
        this.safePoint.add(key);
    }

    public void put(String id, int key, double perc, int index) {
        CmpPoint lastPoint = this.map.get(key);
        this.map.put(key, new CmpPoint(id, perc, index, lastPoint));
        this.setCriticalValue(key);
    }

    public void put(String id, Date beginDate, Date endDate, double perc, int index) {
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginDate);
        begin.set(begin.get(1), begin.get(2), 1);
        Calendar end = Calendar.getInstance();
        if (null == endDate) {
            end.set(2199, 11, 1);
        } else {
            end.setTime(endDate);
            end.set(end.get(1), end.get(2), 1);
        }
        if (end.compareTo(this.maxCalendar) >= 0) {
            end.setTime(begin.getTime());
            this.extendNaNLinked(id, perc, index, this.getKey(begin));
        }
        this.addSafePoint(this.getKey(begin));
        while (begin.compareTo(end) <= 0) {
            this.put(id, this.getKey(begin), perc, index);
            begin.add(2, 1);
        }
        end.add(2, 1);
        this.addSafePoint(this.getKey(end));
        this.extendAxleByNaN();
        this.idSet.add(id);
    }

    private int getKey(Calendar calendar) {
        String year = Integer.valueOf(calendar.get(1)) + "";
        String month = calendar.get(2) + 1 + "";
        return Integer.valueOf(year + (month.length() <= 1 ? "0" + month : month));
    }

    private void extendNaNLinked(String id, double perc, int index, int current) {
        if (null == this.linkedPoint) {
            this.linkedPoint = new CmpPoint(id, perc, index, current, null);
        } else {
            CmpPoint next = this.linkedPoint;
            this.linkedPoint = new CmpPoint(id, perc, index, current, next);
        }
    }

    private void extendAxleByNaN() {
        CmpPoint p = this.linkedPoint;
        while (null != p) {
            this.put(p.getId(), p.getCurrent(), this.maxKey, p.getPerc(), p.getIndex());
            p.setCurrent(this.maxKey);
            p = p.next;
        }
    }

    private void put(String id, int beginKey, int endKey, double perc, int index) {
        Calendar begin = Calendar.getInstance();
        begin.set(beginKey / 100, beginKey % 100 - 1, 1);
        begin.add(2, 1);
        Calendar end = Calendar.getInstance();
        end.set(endKey / 100, endKey % 100 - 1, 1);
        while (begin.compareTo(end) <= 0) {
            this.put(id, this.getKey(begin), perc, index);
            begin.add(2, 1);
        }
    }

    private void setCriticalValue(int key) {
        if (0 == this.minKey || 0 != this.minKey && this.minKey > key) {
            this.minKey = key;
        }
        if (0 == this.maxKey || 0 != this.maxKey && this.maxKey < key) {
            this.maxKey = key;
        }
    }

    public CmpPoint remove(int key) {
        CmpPoint p = this.map.get(key);
        if (null == p) {
            return null;
        }
        this.map.put(key, null);
        return p;
    }

    public double getSumPerc(int key) {
        double perc = 0.0;
        BigDecimal total = new BigDecimal(0);
        CmpPoint lastPoint = this.map.get(key);
        if (null == lastPoint) {
            return perc;
        }
        CmpPoint p = lastPoint;
        while (null != p) {
            BigDecimal tempValue = new BigDecimal(String.valueOf(p.getPerc()));
            total = total.add(tempValue);
            p = p.next;
        }
        return total.doubleValue();
    }

    public Set<Integer> getIndexSet(int key) {
        HashSet<Integer> set = new HashSet<Integer>();
        CmpPoint lastPoint = this.map.get(key);
        if (null == lastPoint) {
            return set;
        }
        CmpPoint p = lastPoint;
        while (null != p) {
            if (p.getIndex() != 0) {
                set.add(p.getIndex());
            }
            p = p.next;
        }
        return set;
    }

    public Set<String> getIdSet(int key) {
        HashSet<String> set = new HashSet<String>();
        CmpPoint lastPoint = this.map.get(key);
        if (null == lastPoint) {
            return set;
        }
        CmpPoint p = lastPoint;
        while (null != p) {
            if (null != p.getId()) {
                set.add(p.getId());
            }
            p = p.next;
        }
        return set;
    }

    public Set<String> getAllId() {
        return this.idSet;
    }
}

