/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record.factory.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.record.RecordConstant;
import com.kingdee.shr.compensation.record.dto.RecordDataInfo;
import com.kingdee.shr.compensation.record.factory.AbstractEmpOrgRelation;
import com.kingdee.shr.compensation.record.factory.AbstractRecord;
import com.kingdee.shr.compensation.record.util.RecordInstanceFactory;
import com.kingdee.shr.compensation.sql.record.CmpRecordSQL;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpEntityUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpRecordImpl
extends AbstractRecord {
    Logger logger = Logger.getLogger(CmpRecordImpl.class);
    private AbstractEmpOrgRelation empOrgRelation = RecordInstanceFactory.getRelationInstance(RecordInstanceFactory.CATEGORY.CMP);

    public List<String> createRecordsByAssignType(Context ctx, List<RecordDataInfo> recList) throws BOSException, EASBizException {
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        String insertSql = "Fid,FIsSendSalary,FPersonId,FHrOrgUnitID,FEffectDate,FLeffectDate";
        String creRecordSql = SQLHandleUtil.getInsertSql(ctx, "T_HR_SPersonCmp", insertSql);
        int size = recList.size();
        for (int i = 0; i < size; ++i) {
            Object[] batchParam = new Object[6];
            String recordId = BOSUuid.create((String)"9B78154F").toString();
            RecordDataInfo recordDataInfo = recList.get(i);
            recordDataInfo.setRecordId(recordId);
            batchParam[0] = recordId;
            batchParam[1] = 1;
            batchParam[2] = recordDataInfo.getPersonId();
            batchParam[3] = recordDataInfo.getHrOrgUnitId();
            batchParam[4] = null == recordDataInfo.getEnterDate() ? recordDataInfo.getEmpEffdt() : recordDataInfo.getEnterDate();
            batchParam[5] = RecordConstant.LEFFECT;
            paramsList.add(batchParam);
        }
        CmpSQLUtil.executeBatch(ctx, creRecordSql, paramsList);
        this.createBankInfo(ctx, paramsList);
        return this.empOrgRelation.createEmpOrgRelationsByAssignType(ctx, recList);
    }

    protected void createBankInfo(Context ctx, List<Object[]> paramsList) throws BOSException {
        LinkedList<Object[]> bankParams = new LinkedList<Object[]>();
        String insertSql = "FIsEnable, FAccountNum, FPersonID, FSortn, FID, FPersonCmpID, FPersonBankId, FHrBankID, FProvince, FCity, FHRORGUNITID, FCONTROLUNITID, FAccountName";
        String selectSql = "select FAccountNum, FID, FBankID, FProvince, FCity, FAccountName";
        String entityNameSource = "com.kingdee.eas.hr.emp.app.PersonBankRecord";
        String entityName = "com.kingdee.shr.compensation.app.CmpEmpAccount";
        List<String> list = CmpEntityUtil.getCommonExtendField(ctx, entityNameSource, entityName);
        int filedSize = list.size();
        if (filedSize > 0) {
            String listSql = "," + CmpStrUtil.join(list, ",", null);
            insertSql = insertSql + listSql;
            selectSql = selectSql + listSql;
        }
        String creRecordSql = SQLHandleUtil.getInsertSql(ctx, "T_HR_SCmpEmpAccount", insertSql);
        this.logger.info((Object)("insertSql:" + creRecordSql));
        int size = paramsList.size();
        for (int i = 0; i < size; ++i) {
            Object[] params = paramsList.get(i);
            try {
                String sql = selectSql + " from T_HR_PersonBankRecord where FPersonID = '" + params[2] + "'";
                IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql.toString());
                while (rs.next()) {
                    Object[] batchParam = new Object[13 + filedSize];
                    batchParam[0] = 1;
                    batchParam[1] = rs.getObject(1);
                    batchParam[2] = params[2];
                    batchParam[3] = 0;
                    batchParam[4] = BOSUuid.create((String)"89828AC9").toString();
                    batchParam[5] = params[0];
                    batchParam[6] = rs.getObject(2);
                    batchParam[7] = rs.getObject(3);
                    batchParam[8] = rs.getObject(4);
                    batchParam[9] = rs.getObject(5);
                    batchParam[10] = params[3];
                    if (ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                        batchParam[11] = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
                    }
                    batchParam[12] = rs.getObject(6);
                    for (int j = 1; j <= filedSize; ++j) {
                        batchParam[12 + j] = rs.getObject(6 + j);
                    }
                    bankParams.add(batchParam);
                    System.out.println("params:" + batchParam.toString());
                    this.logger.info((Object)("params:" + batchParam.toString()));
                    this.logger.error((Object)("params:" + batchParam.toString()));
                }
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label117", (Locale)ctx.getLocale()), (Throwable)e);
            }
        }
        CmpSQLUtil.executeBatch(ctx, creRecordSql, bankParams);
    }

    @Override
    public List<String> createRecords(Context ctx, List<RecordDataInfo> recList) throws BOSException, EASBizException {
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        String insertSql = "Fid,FIsSendSalary,FPersonId,FHrOrgUnitID,FEffectDate,FLeffectDate";
        String creRecordSql = SQLHandleUtil.getInsertSql(ctx, "T_HR_SPersonCmp", insertSql);
        int size = recList.size();
        for (int i = 0; i < size; ++i) {
            Object[] batchParam = new Object[6];
            String recordId = BOSUuid.create((String)"9B78154F").toString();
            RecordDataInfo recordDataInfo = recList.get(i);
            recordDataInfo.setRecordId(recordId);
            batchParam[0] = recordId;
            batchParam[1] = 1;
            batchParam[2] = recordDataInfo.getPersonId();
            batchParam[3] = recordDataInfo.getHrOrgUnitId();
            batchParam[4] = null == recordDataInfo.getEnterDate() ? recordDataInfo.getEffdt() : (recordDataInfo.getEffdt().before(recordDataInfo.getEnterDate()) ? recordDataInfo.getEnterDate() : recordDataInfo.getEffdt());
            batchParam[5] = RecordConstant.LEFFECT;
            paramsList.add(batchParam);
        }
        CmpSQLUtil.executeBatch(ctx, creRecordSql, paramsList);
        this.createBankInfo(ctx, paramsList);
        return this.empOrgRelation.createEmpOrgRelations(ctx, recList);
    }

    @Override
    public void updateRecords(Context ctx, List<RecordDataInfo> udpateLis) throws BOSException, EASBizException {
        StringBuilder recIdStr = new StringBuilder();
        for (RecordDataInfo recordDataInfo : udpateLis) {
            recIdStr.append("'").append(recordDataInfo.getRecordId()).append("',");
        }
        HashMap<String, Date> map = new HashMap<String, Date>();
        String recordEffectSql = CmpRecordSQL.getRecordEffect(recIdStr.substring(0, recIdStr.lastIndexOf(",")));
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, recordEffectSql);
        try {
            while (rowSet.next()) {
                map.put(rowSet.getString("recordId"), rowSet.getDate("effectDate"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        String updateSql = SQLHandleUtil.getUpdateSql("T_HR_SPersonCmp", "FIsSendSalary,FLeffectDate,FEffectDate", "fid", null);
        int size = udpateLis.size();
        for (int i = 0; i < size; ++i) {
            RecordDataInfo recordDataInfo = udpateLis.get(i);
            String recordId = recordDataInfo.getRecordId();
            java.util.Date effectDate = recordDataInfo.getEffdt();
            java.util.Date oldEffectDate = (java.util.Date)map.get(recordId);
            if (effectDate == null || oldEffectDate == null) continue;
            java.util.Date realEffdt = effectDate.compareTo(oldEffectDate) < 0 ? effectDate : oldEffectDate;
            Object[] batchParam = new Object[]{1, RecordConstant.LEFFECT, null == recordDataInfo.getEnterDate() ? realEffdt : (recordDataInfo.getEnterDate().after(realEffdt) ? recordDataInfo.getEnterDate() : realEffdt), recordId};
            paramsList.add(batchParam);
        }
        CmpSQLUtil.executeBatch(ctx, updateSql, paramsList);
    }

    @Override
    public void loseRecords(Context ctx, Map<String, java.util.Date> recordMap) throws BOSException, EASBizException {
        String recordIds = CmpStrUtil.converMapToString(recordMap);
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        java.util.Date leffdt = null;
        for (Map.Entry<String, java.util.Date> entry : recordMap.entrySet()) {
            leffdt = entry.getValue();
            Object[] batchParam = new Object[]{CmpDateUtil.toSqlDate(entry.getValue()), entry.getKey()};
            paramsList.add(batchParam);
        }
        String recordSql = SQLHandleUtil.getUpdateSql("T_HR_SPersonCmp", "FLeffectDate", "fid", null);
        String sysPerSql = SQLHandleUtil.getUpdateSql("T_HR_SCmpSystemPerson", "FLeffectDate", "FPersonCmpID", "(FLeffectDate >= {ts '2199-12-31'} or FLeffectDate is null) ");
        CmpSQLUtil.executeBatch(ctx, sysPerSql, paramsList);
        StringBuffer str = new StringBuffer();
        str.append(" select tt.fid, t0.fid recId ");
        str.append(" from T_HR_SCmpSystemPerson tt");
        str.append(" inner join T_HR_SPersonCmp t0 on t0.fid = tt.FPersonCmpID ");
        str.append(" where t0.fid in (" + recordIds + ") and t0.FLeffectDate < {ts '2199-12-31'} ");
        str.append(" and tt.FLeffectDate = t0.FLeffectDate ");
        IRowSet r = CmpSQLUtil.executeQuery(ctx, str.toString());
        if (r.size() > 0) {
            String updateSql = "update T_HR_SCmpSystemPerson set FLeffectDate = ? where fid = ? ";
            LinkedList<Object[]> fixParamList = new LinkedList<Object[]>();
            try {
                while (r.next()) {
                    Object[] fixParam = new Object[]{CmpDateUtil.toSqlDate(recordMap.get(r.getString("recId"))), r.getString("fid")};
                    fixParamList.add(fixParam);
                }
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            CmpSQLUtil.executeBatch(ctx, updateSql, fixParamList);
        }
        HashMap<String, java.util.Date> empMap = new HashMap<String, java.util.Date>();
        String empSql = CmpRecordSQL.getCmpEmpDatasByRecord(recordIds, leffdt);
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, empSql);
        try {
            while (rowSet.next()) {
                empMap.put(rowSet.getString("empFid"), recordMap.get(rowSet.getString("recFid")));
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
        this.empOrgRelation.loseEmpRelations(ctx, empMap);
        CmpSQLUtil.executeBatch(ctx, recordSql, paramsList);
        this.updateScmpcaltableRealEndDate(ctx, empMap);
    }

    private void updateScmpcaltableRealEndDate(Context ctx, Map<String, java.util.Date> empMap) throws BOSException {
        if (empMap.size() < 1) {
            return;
        }
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, java.util.Date> entry : empMap.entrySet()) {
            str.append("'").append(entry.getKey()).append("',");
        }
        String cmpEmpIds = str.substring(0, str.length() - 1).toString();
        StringBuilder sb = new StringBuilder();
        sb.append("   update t_hr_scmpcaltable calTable set FRealEndDate = ").append("\r\n");
        sb.append(" ( ").append("\r\n");
        sb.append(" select case when FLEFFECTDATE>calTable.fenddate then calTable.fenddate else FLEFFECTDATE end cmpEmpDate ").append("\r\n");
        sb.append(" from T_HR_SCmpEmpORelation ").append("\r\n");
        sb.append("  where fid=caltable.FCMPEMPORELATIONID").append("\r\n");
        sb.append("  ) where calTable.FCMPEMPORELATIONID in (").append(cmpEmpIds).append(")");
        sb.append(" and calTable.FCALSTATE in (1 , 4)").append("\r\n");
        CmpSQLUtil.execute(ctx, sb.toString());
    }

    @Override
    public void deleteRecords(Context ctx, String recordIds, boolean isDelete) throws BOSException, EASBizException {
        if (!recordIds.contains("'") && !recordIds.toLowerCase(Locale.ENGLISH).contains("select")) {
            recordIds = "'" + recordIds + "'";
        }
        String sql = " delete from T_HR_PersonBURelation where fid in (select FPersonBURelationID from T_HR_SCmpEmpORelation where FPersonCmpID in (" + recordIds + "))";
        CmpSQLUtil.execute(ctx, sql);
        CmpSQLUtil.execute(ctx, "delete from T_HR_SCostBearOrg where FCmpEmpORelationID in (select fid from T_HR_SCmpEmpORelation where FPersonCmpID in (" + recordIds + ") ) ");
        CmpSQLUtil.execute(ctx, "delete from T_HR_SCmpEmpORelation where FPersonCmpID in (" + recordIds + ")");
        CmpSQLUtil.execute(ctx, "delete from T_HR_SCmpSystemPerson where FPersonCmpID in (" + recordIds + ")");
        CmpSQLUtil.execute(ctx, "delete from T_HR_SCmpEmpAccount where FPersonCmpID in (" + recordIds + ")");
        CmpSQLUtil.execute(ctx, "delete from T_HR_SPersonCmp where fid in (" + recordIds + ")");
    }

    @Override
    public void updateRecordForEffect(Context ctx, List<String> recordList) throws BOSException, EASBizException {
        String updateStr = CmpRecordSQL.getUpdateRecordForEffectSql(CmpStrUtil.convertListToString(recordList));
        try {
            CmpSQLUtil.execute(ctx, updateStr.toString());
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

