/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalFormulaCollection;
import com.kingdee.shr.compensation.CalFormulaFactory;
import com.kingdee.shr.compensation.CalFormulaInfo;
import com.kingdee.shr.compensation.CalSchemeCollection;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpExchangeRuleEnum;
import com.kingdee.shr.compensation.CmpPeriodTypeEnum;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.currency.CurrencyUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalFunItemSalary
extends SalaryCalFunction {
    private final String itemKey = "CalFunItemSalary_CALFUNITEMSALARY_ITEM";
    private final String calSchemeItemMapKey = "CalFunItemSalary_CALSCHEMEITEMMAP_KEY";
    private final String split_key = "_";
    private Logger logger = Logger.getLogger(CalFunItemSalary.class);
    private static final Map<String, String> FORMULADEFINE_LISTFUNC_MAPPER = new HashMap<String, String>();

    @Deprecated
    public double getPeriodItemSalary(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String cmpItemName) {
        String number = calScheme.getNumber();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        CmpPeriodTypeEnum cmpPeriodType = calScheme.getCmpPeriodType();
        Calendar pal = Calendar.getInstance();
        pal.set(1, periodYear);
        pal.set(2, periodMonth - 1);
        pal.set(5, 1);
        if (cmpPeriodType == CmpPeriodTypeEnum.month) {
            pal.add(2, -1);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.quarter) {
            pal.add(2, -3);
        }
        if (cmpPeriodType == CmpPeriodTypeEnum.half) {
            pal.add(2, -6);
        }
        if (cmpPeriodType == CmpPeriodTypeEnum.yeay) {
            pal.add(2, -12);
        }
        int year = pal.get(1);
        int month = pal.get(2) + 1;
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String fid = (String)paramMap.get("T_HR_SCMPCALTABLE_FID");
        String fieldSn = cmpItemName.substring(cmpItemName.lastIndexOf("_") + 1);
        if (StringUtils.isEmpty((String)cmpItemName) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
            return 0.0;
        }
        String tempMapKey = "PeriodItem_" + personId + "_" + cmpItemName;
        String tempMapKey2 = "";
        if (tempMap.get(tempMapKey) == null) {
            String sql_B = "select fpersonId from T_HR_SCmpCalTable where fid='" + fid + "'";
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                sql_B = "select fpersonId from T_HR_SCmpCalTable where " + mainTableRowFilter;
            }
            String sql = "select A.fpersonId,A." + fieldSn + ",A.FCmpPeriodType from T_HR_SCmpCalTable A inner join (" + sql_B + ") B on B.fpersonId=A.fpersonId inner join t_hr_scalscheme  C on A.fcalschemeid = C.fid where A.FPeriodYear=" + year + " and  A.FPeriodMonth=" + month + " and C.fnumber = '" + number + "'";
            double pay = 0.0;
            Context ctx = Tools.getInstance().getCtx();
            try {
                IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (set.next()) {
                    tempMapKey2 = "PeriodItem_" + set.getString(1) + "_" + cmpItemName;
                    pay = set.getDouble(2);
                    tempMap.put(tempMapKey2, pay);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        double resultValue = 0.0;
        if (tempMap.get(tempMapKey) != null) {
            resultValue = (Double)tempMap.get(tempMapKey);
        }
        return resultValue;
    }

    private Map<String, Double> getHistoryItem(CalSchemeInfo calScheme, String personId, String mainTableRowFilter, String schemeName, String fieldSn, int year, int month, int calTime) throws SQLException, BOSException {
        CalSchemeCollection calCol;
        HashMap<String, Double> dataMap = new HashMap<String, Double>();
        Context ctx = Tools.getInstance().getCtx();
        BigDecimal rate = new BigDecimal(1);
        String name = calScheme.getName();
        if (StringUtils.isEmpty((String)schemeName)) {
            schemeName = name;
        }
        if ((calCol = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeCollection("where name = '" + schemeName + "'")) == null || calCol.size() == 0) {
            return dataMap;
        }
        CalSchemeInfo calSchemeInfo = calCol.get(0);
        String calschemeid = calScheme.getId().toString();
        String personSql = "select FPersonID from T_HR_SCmpCalTable  where FcalSchemeID = '" + calschemeid + "' and FcalTime = " + calScheme.getCalTime() + " and FperiodYear = " + calScheme.getPeriodYear() + " and FperiodMonth = " + calScheme.getPeriodMonth() + "";
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            personSql = personSql + " and " + mainTableRowFilter;
        }
        StringBuilder str = new StringBuilder();
        str.append(" SELECT FPERSONID, CALTABLE.").append(fieldSn).append(" MONEY, FCURRENCYID, FEXCHANGETABLEID ");
        str.append(" FROM T_HR_SCMPCALTABLE CALTABLE ");
        str.append(" WHERE CALTABLE.FCALSCHEMEID = '").append(calSchemeInfo.getId().toString()).append("' ");
        str.append(" AND CALTABLE.FPERIODYEAR=").append(year);
        str.append(" AND CALTABLE.FPERIODMONTH=").append(month);
        str.append(" AND CALTABLE.FCALTIME=").append(calTime);
        if ("test".equals(this.getType())) {
            str.append(" AND CALTABLE.FPERSONID = '" + personId + "'");
        } else {
            str.append(" AND FPERSONID in ( ").append(personSql).append(" ) ");
        }
        if (null != calScheme.getCurrency()) {
            String targetCurrencyId = calScheme.getCurrency().getId().toString();
            String exchangeTableId = calScheme.getExchangeTable().getId().toString();
            Date effdt = calScheme.getExchangeRule().equals((Object)CmpExchangeRuleEnum.PERIOD_BEGIN) ? calScheme.getBeginDate() : calScheme.getEndDate();
            Map<String, BigDecimal> currencyMap = CurrencyUtil.getTargetExchangeRateMap(ctx, exchangeTableId, targetCurrencyId, effdt);
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    String currencyId = rowSet.getString("FCURRENCYID");
                    rate = null != currencyId ? (null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId)) : new BigDecimal(1);
                    BigDecimal money = rowSet.getBigDecimal("MONEY") == null ? new BigDecimal(0) : rowSet.getBigDecimal("MONEY");
                    dataMap.put(rowSet.getString("FPERSONID"), money.multiply(rate).doubleValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)e);
            }
        } else {
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    dataMap.put(rowSet.getString("FPERSONID"), rowSet.getDouble("MONEY"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)e);
            }
        }
        return dataMap;
    }

    public double getHistoryItemSalary(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String schemeName, String cmpItemsName, double periodValue, double accountNum) throws SQLException, BOSException {
        Map perMap;
        Map resultMap;
        String fieldSn = null;
        String name = calScheme.getName();
        if (StringUtils.isEmpty((String)schemeName)) {
            schemeName = name;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, calScheme.getPeriodYear());
        calendar.set(2, calScheme.getPeriodMonth() - 1);
        calendar.set(5, 1);
        calendar.add(2, (int)periodValue);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        if (StringUtils.isEmpty((String)cmpItemsName) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
            return 0.0;
        }
        String dataKey = "GETHISTORYITEMSALARY_" + schemeName + "_" + periodValue + "_" + accountNum;
        Map<Object, Object> dataMap = new HashMap();
        if (tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM") == null) {
            tempMap.put("CalFunItemSalary_CALFUNITEMSALARY_ITEM", this.getCmpCalTableName(calScheme));
        }
        if ((resultMap = (Map)tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM")).get(cmpItemsName) == null) {
            return 0.0;
        }
        Set<String> calSchemeItems = this.getCalSchemeItemMap(Tools.getInstance().getCtx(), calScheme, tempMap, "GETHISTORYITEMSALARY_", "FunGetHistoryItemSalary");
        fieldSn = "S" + (String)resultMap.get(cmpItemsName);
        if (calSchemeItems == null || calSchemeItems.size() == 0) {
            calSchemeItems = new HashSet<String>();
            calSchemeItems.add(fieldSn);
        }
        if (tempMap.get(dataKey) == null) {
            dataMap = this.getHistoryItems(calScheme, personId, mainTableRowFilter, schemeName, calSchemeItems, year, month, (int)accountNum);
            tempMap.put(dataKey, dataMap);
        } else {
            dataMap = (Map)tempMap.get(dataKey);
        }
        double result = 0.0;
        if (dataMap.containsKey(personId) && null != (perMap = (Map)dataMap.get(personId)) && perMap.containsKey(fieldSn)) {
            result = (Double)perMap.get(fieldSn);
        }
        return result;
    }

    public String getHistoryItemSalaryZF(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String schemeName, String cmpItemsName, double periodValue, double accountNum) throws SQLException {
        Map perMap;
        Map resultMap;
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        Calendar pal = Calendar.getInstance();
        pal.set(1, periodYear);
        pal.set(2, periodMonth - 1);
        pal.set(5, 1);
        pal.add(2, (int)periodValue);
        Context ctx = Tools.getInstance().getCtx();
        String l = calScheme.getLanType().getValue();
        int year = pal.get(1);
        int month = pal.get(2) + 1;
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String fid = (String)paramMap.get("T_HR_SCMPCALTABLE_FID");
        String fieldSn = "";
        if (StringUtils.isEmpty((String)cmpItemsName) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
            return "";
        }
        String dataKey = "GetHistoryItemSalaryZF_" + schemeName + "_" + periodValue + "_" + accountNum;
        Map dataMap = new HashMap();
        if (tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM") == null) {
            tempMap.put("CalFunItemSalary_CALFUNITEMSALARY_ITEM", this.getCmpCalTableName(calScheme));
        }
        if ((resultMap = (Map)tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM")).get(cmpItemsName) == null) {
            return "";
        }
        Set<String> calSchemeItems = null;
        try {
            calSchemeItems = this.getCalSchemeItemMap(ctx, calScheme, tempMap, "GetHistoryItemSalaryZF_", "FunGetHistoryItemSalaryZF");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        fieldSn = "S" + (String)resultMap.get(cmpItemsName);
        if (calSchemeItems == null || calSchemeItems.size() == 0) {
            calSchemeItems = new HashSet<String>();
            calSchemeItems.add(fieldSn);
        }
        if (tempMap.get(dataKey) == null) {
            String sql_B = "select fpersonId from T_HR_SCmpCalTable where fid='" + fid + "'";
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                sql_B = "select fpersonId from T_HR_SCmpCalTable where " + mainTableRowFilter;
            }
            String sql = "select A.fpersonId," + calSchemeItems.toString().replace("[", "").replace("]", "") + ",A.FCmpPeriodType from T_HR_SCmpCalTable A inner join (" + sql_B + ") B on B.fpersonId=A.fpersonId inner join t_hr_scalscheme  C on A.fcalschemeid = C.fid where A.FPeriodYear=" + year + " and  A.FPeriodMonth=" + month + " and C.fname_" + l + " = '" + schemeName + "' and A.FCalTime = " + accountNum;
            String tempPersonId = "";
            try {
                List<IRowSet> rowSets = this.executeQueryPaging(ctx, sql);
                for (IRowSet rowSet : rowSets) {
                    while (rowSet.next()) {
                        tempPersonId = rowSet.getString("FPERSONID");
                        HashMap<String, String> perMap2 = new HashMap<String, String>();
                        for (String sn : calSchemeItems) {
                            perMap2.put(sn, rowSet.getString(sn));
                        }
                        dataMap.put(tempPersonId, perMap2);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tempMap.put(dataKey, dataMap);
        } else {
            dataMap = (Map)tempMap.get(dataKey);
        }
        String resultValue = "";
        if (dataMap.get(personId) != null && (perMap = (Map)dataMap.get(personId)) != null && perMap.containsKey(fieldSn)) {
            resultValue = (String)perMap.get(fieldSn);
        }
        return resultValue;
    }

    public double getHistoryItemSalaryByTime(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String schemeName, String cmpItemsName, double countYear, double countMonth, double accountNum) throws SQLException, BOSException {
        Context ctx = Tools.getInstance().getCtx();
        String l = ctx.getLocale().getLanguage();
        Calendar pal = Calendar.getInstance();
        pal.set(1, new Double(countYear).intValue());
        pal.set(2, new Double(countMonth - 1.0).intValue());
        pal.set(5, 1);
        int year = pal.get(1);
        int month = pal.get(2) + 1;
        int calTime = new Double(accountNum).intValue();
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String key = "PeriodItem_" + schemeName + "_" + year + "_" + month + "_" + accountNum + "_" + cmpItemsName;
        Map<String, Double> resultMap = new HashMap();
        Map<Object, Object> currencyMap = new HashMap();
        BigDecimal rate = new BigDecimal(1);
        if (tempMap.get(key) == null) {
            Map itemMap;
            String itemKey = "CalItem_getCmpCalTableName";
            if (tempMap.get(itemKey) == null) {
                tempMap.put(itemKey, this.getCmpCalTableName(calScheme));
            }
            if ((itemMap = (Map)tempMap.get(itemKey)).get(cmpItemsName) == null) {
                return 0.0;
            }
            String fieldSn = "S" + (String)itemMap.get(cmpItemsName);
            if (null != calScheme.getCurrency()) {
                Date effdt = calScheme.getExchangeRule().equals((Object)CmpExchangeRuleEnum.PERIOD_BEGIN) ? calScheme.getBeginDate() : calScheme.getEndDate();
                currencyMap = CurrencyUtil.getTargetExchangeRateMap(Tools.getInstance().getCtx(), calScheme.getExchangeTable().getId().toString(), calScheme.getCurrency().getId().toString(), effdt);
            }
            StringBuilder str = new StringBuilder();
            str.append(" select A.fpersonId, A." + fieldSn + ",A.FCurrencyID currencyId from T_HR_SCmpCalTable A ");
            str.append(" inner join t_hr_scalscheme  C on A.fcalschemeid = C.fid ");
            str.append(" where A.FPeriodYear= " + year);
            str.append(" and A.FPeriodMonth= " + month);
            str.append(" and C.fname_").append(l).append(" = '" + schemeName + "' ");
            str.append(" and A.FCalTime = " + calTime);
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                String personSql = "select fpersonId from t_hr_scmpcaltable where " + mainTableRowFilter;
                str.append(" AND A.FPERSONID in (").append(personSql).append(")");
            }
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    rate = null == currencyMap.get(rowSet.getString("currencyId")) ? new BigDecimal(1) : (BigDecimal)currencyMap.get(rowSet.getString("currencyId"));
                    resultMap.put(rowSet.getString(1), new BigDecimal(rowSet.getDouble(2)).multiply(rate).doubleValue());
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            tempMap.put(key, resultMap);
        } else {
            resultMap = (Map)tempMap.get(key);
        }
        double resultValue = 0.0;
        if (resultMap.get(personId) != null) {
            resultValue = (Double)resultMap.get(personId);
        }
        return resultValue;
    }

    private Calendar getCalendarByPeriod(CalSchemeInfo calScheme, int periodValue) {
        CmpPeriodTypeEnum cmpPeriodType = calScheme.getCmpPeriodType();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, calScheme.getPeriodYear());
        calendar.set(2, calScheme.getPeriodMonth() - 1);
        calendar.set(5, 1);
        if (cmpPeriodType == CmpPeriodTypeEnum.month) {
            calendar.add(2, periodValue);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.quarter) {
            calendar.add(2, periodValue * 3);
        }
        if (cmpPeriodType == CmpPeriodTypeEnum.half) {
            calendar.add(2, periodValue * 6);
        }
        if (cmpPeriodType == CmpPeriodTypeEnum.yeay) {
            calendar.add(2, periodValue * 12);
        }
        return calendar;
    }

    public double getItemOrgSumSalary(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String schemeName, String cmpItemsName, double periodValue, double accountNum) throws SQLException, BOSException {
        Map<String, Double> dataMap;
        Context ctx = Tools.getInstance().getCtx();
        String calPersonId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String oldOrgId = null;
        String newOrgId = null;
        BigDecimal tempSum = new BigDecimal(0);
        BigDecimal rate = new BigDecimal(1);
        boolean i = false;
        Calendar calendar = this.getCalendarByPeriod(calScheme, (int)periodValue);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        String dataKey = "GETITEMORGSUMSALARY__" + cmpItemsName + schemeName + periodValue + accountNum;
        Map map = dataMap = tempMap.get(dataKey) != null ? (Map)tempMap.get(dataKey) : new HashMap();
        if (tempMap.get(dataKey) == null) {
            BigDecimal money;
            String personId;
            Map resultMap;
            if (tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM") == null) {
                tempMap.put("CalFunItemSalary_CALFUNITEMSALARY_ITEM", this.getCmpCalTableName(calScheme));
            }
            if ((resultMap = (Map)tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM")).get(cmpItemsName) == null) {
                return 0.0;
            }
            String fieldSn = "S" + (String)resultMap.get(cmpItemsName);
            CalSchemeCollection calCol = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeCollection("where name = '" + schemeName + "'");
            if (calCol == null || calCol.size() == 0) {
                return 0.0;
            }
            CalSchemeInfo calSchemeInfo = calCol.get(0);
            HashMap<String, String> personMap = new HashMap<String, String>();
            HashMap<String, Double> orgMap = new HashMap<String, Double>();
            StringBuilder str = new StringBuilder();
            str.append(" SELECT CALTABLE.").append(fieldSn).append(" MONEY, CALTABLE.FADMINORGUNITID ORGID, CALTABLE.FPERSONID PERSONID, CALTABLE.FCURRENCYID, CALTABLE.FEXCHANGETABLEID ");
            str.append(" FROM T_HR_SCMPCALTABLE CALTABLE ");
            str.append(" WHERE CALTABLE.FPERIODYEAR = ").append(year);
            str.append(" AND CALTABLE.FPERIODMONTH = ").append(month);
            str.append(" AND CALTABLE.FCALTIME = ").append((int)accountNum);
            str.append(" AND CALTABLE.FCALSCHEMEID = '").append(calSchemeInfo.getId().toString()).append("' ");
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                String personSql = "select fpersonId from t_hr_scmpcaltable where " + mainTableRowFilter;
                str.append(" AND CALTABLE.FPERSONID in (").append(personSql).append(")");
            }
            str.append(" ORDER BY CALTABLE.FADMINORGUNITID ");
            if (null != calScheme.getCurrency()) {
                Date effdt = calScheme.getExchangeRule().equals((Object)CmpExchangeRuleEnum.PERIOD_BEGIN) ? calScheme.getBeginDate() : calScheme.getEndDate();
                String targetCurrencyId = calScheme.getCurrency().getId().toString();
                String exchangeTableId = calScheme.getExchangeTable().getId().toString();
                Map<String, BigDecimal> currencyMap = CurrencyUtil.getTargetExchangeRateMap(ctx, exchangeTableId, targetCurrencyId, effdt);
                try {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                    while (rowSet.next()) {
                        oldOrgId = rowSet.getString("ORGID");
                        personId = rowSet.getString("PERSONID");
                        personMap.put(personId, oldOrgId);
                        String currencyId = rowSet.getString("FCURRENCYID");
                        rate = null != currencyId ? (null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId)) : new BigDecimal(1);
                        money = rowSet.getBigDecimal("MONEY") == null ? new BigDecimal(0) : rowSet.getBigDecimal("MONEY");
                        tempSum = orgMap.get(oldOrgId) == null ? money.multiply(rate) : new BigDecimal((Double)orgMap.get(oldOrgId)).add(money.multiply(rate));
                        orgMap.put(oldOrgId, tempSum.doubleValue());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error((Object)e);
                }
            } else {
                try {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                    while (rowSet.next()) {
                        personId = rowSet.getString("PERSONID");
                        oldOrgId = rowSet.getString("ORGID");
                        personMap.put(personId, oldOrgId);
                        money = rowSet.getBigDecimal("MONEY") == null ? new BigDecimal(0) : rowSet.getBigDecimal("MONEY");
                        tempSum = dataMap.get(oldOrgId) == null ? money.multiply(rate) : new BigDecimal((Double)dataMap.get(oldOrgId)).add(money.multiply(rate));
                        orgMap.put(oldOrgId, tempSum.doubleValue());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error((Object)e);
                }
            }
            for (Map.Entry entry : personMap.entrySet()) {
                personId = (String)entry.getKey();
                newOrgId = (String)entry.getValue();
                dataMap.put(personId, orgMap.get(newOrgId) == null ? 0.0 : (Double)orgMap.get(newOrgId));
            }
            tempMap.put(dataKey, dataMap);
        } else {
            dataMap = (Map)tempMap.get(dataKey);
        }
        return dataMap.containsKey(calPersonId) ? (Double)dataMap.get(calPersonId) : 0.0;
    }

    public double getItemSumSalary(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String schemeName, String cmpItemsName, double periodValue, double accountNum) throws SQLException, BOSException {
        Context ctx = Tools.getInstance().getCtx();
        BigDecimal sumMoney = new BigDecimal(0);
        String calPersonId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        Calendar calendar = this.getCalendarByPeriod(calScheme, (int)periodValue);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        String dataKey = "GETITEMSUMSALARY_" + cmpItemsName + schemeName + periodValue + accountNum;
        Map<String, Double> dataMap = new HashMap();
        Map<Object, Object> currencyMap = new HashMap();
        BigDecimal rate = new BigDecimal(1);
        if (tempMap.get(dataKey) == null) {
            Map resultMap;
            if (tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM") == null) {
                tempMap.put("CalFunItemSalary_CALFUNITEMSALARY_ITEM", this.getCmpCalTableName(calScheme));
            }
            if ((resultMap = (Map)tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM")).get(cmpItemsName) == null) {
                return 0.0;
            }
            String fieldSn = "S" + (String)resultMap.get(cmpItemsName);
            CalSchemeCollection calCol = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeCollection("where name = '" + schemeName + "'");
            if (calCol == null || calCol.size() == 0) {
                return 0.0;
            }
            CalSchemeInfo calSchemeInfo = calCol.get(0);
            if (null != calScheme.getCurrency()) {
                Date effdt = calScheme.getExchangeRule().equals((Object)CmpExchangeRuleEnum.PERIOD_BEGIN) ? calScheme.getBeginDate() : calScheme.getEndDate();
                currencyMap = CurrencyUtil.getTargetExchangeRateMap(Tools.getInstance().getCtx(), calScheme.getExchangeTable().getId().toString(), calScheme.getCurrency().getId().toString(), effdt);
            }
            StringBuilder str = new StringBuilder();
            str.append(" select CALTABLE.").append(fieldSn).append(" MONEY").append(" ,");
            str.append("  CALTABLE.FCurrencyID currencyId");
            str.append(" FROM T_HR_SCMPCALTABLE CALTABLE ");
            str.append(" WHERE CALTABLE.FCALSCHEMEID = '").append(calSchemeInfo.getId().toString()).append("' ");
            str.append(" AND CALTABLE.FPERIODYEAR = ").append(year);
            str.append(" AND CALTABLE.FPERIODMONTH = ").append(month);
            str.append(" AND CALTABLE.FCALTIME = ").append((int)accountNum);
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                String personSql = "select fpersonId from t_hr_scmpcaltable where " + mainTableRowFilter;
                str.append(" AND CALTABLE.FPERSONID in (").append(personSql).append(")");
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (rowSet.next()) {
                rate = null == currencyMap.get(rowSet.getString("currencyId")) ? new BigDecimal(1) : (BigDecimal)currencyMap.get(rowSet.getString("currencyId"));
                sumMoney = rowSet.getBigDecimal(1) == null ? new BigDecimal(0) : sumMoney.add(rowSet.getBigDecimal(1).multiply(rate));
            }
            double sumMoneyDou = sumMoney.doubleValue();
            str = new StringBuilder();
            str.append(" SELECT CURTABLE.FPERSONID ");
            str.append(" FROM T_HR_SCMPCALTABLE CURTABLE ");
            str.append(" WHERE CURTABLE.FCALSCHEMEID = '").append(calScheme.getId().toString()).append("' ");
            str.append(" AND FPERIODYEAR = ").append(calScheme.getPeriodYear());
            str.append(" AND FPERIODMONTH = ").append(calScheme.getPeriodMonth());
            str.append(" AND FCALTIME = ").append(calScheme.getCalTime());
            str.append(" AND EXISTS (");
            str.append(" SELECT 1 FROM T_HR_SCMPCALTABLE TARGETTABLE WHERE CURTABLE.FPERSONID = TARGETTABLE.FPERSONID ");
            str.append(" AND TARGETTABLE.FCALSCHEMEID = '").append(calSchemeInfo.getId().toString()).append("' ");
            str.append(" AND TARGETTABLE.FPERIODYEAR = ").append(year);
            str.append(" AND TARGETTABLE.FPERIODMONTH = ").append(month);
            str.append(" AND TARGETTABLE.FCALTIME = ").append((int)accountNum);
            str.append(") ");
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                String replace = mainTableRowFilter.replace("t_hr_scmpcaltable.fid", "CURTABLE.fid").replace("t_hr_scmpcaltable.FCalState", "CURTABLE.FCalState");
                str.append(" AND ").append(replace);
            }
            try {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    dataMap.put(rowSet.getString(1), sumMoneyDou);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)e);
            }
            tempMap.put(dataKey, dataMap);
        } else {
            dataMap = (Map)tempMap.get(dataKey);
        }
        return dataMap.containsKey(calPersonId) ? (Double)dataMap.get(calPersonId) : 0.0;
    }

    public double getItemSum(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String schemeName, String cmpItemsName, double periodValue, double accountNum) throws SQLException, BOSException {
        Context ctx = Tools.getInstance().getCtx();
        BigDecimal sumMoney = new BigDecimal(0);
        BigDecimal rate = new BigDecimal(1);
        Calendar calendar = this.getCalendarByPeriod(calScheme, (int)periodValue);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        String dataKey = "GETITEMSUM_" + cmpItemsName + schemeName + periodValue + accountNum;
        Map<Object, Object> currencyMap = new HashMap();
        if (tempMap.get(dataKey) == null) {
            Map resultMap;
            if (tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM") == null) {
                tempMap.put("CalFunItemSalary_CALFUNITEMSALARY_ITEM", this.getCmpCalTableName(calScheme));
            }
            if ((resultMap = (Map)tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM")).get(cmpItemsName) == null) {
                return 0.0;
            }
            String fieldSn = "S" + (String)resultMap.get(cmpItemsName);
            CalSchemeCollection calCol = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeCollection("where name = '" + schemeName + "'");
            if (calCol == null || calCol.size() == 0) {
                return 0.0;
            }
            CalSchemeInfo calSchemeInfo = calCol.get(0);
            if (null != calScheme.getCurrency()) {
                Date effdt = calScheme.getExchangeRule().equals((Object)CmpExchangeRuleEnum.PERIOD_BEGIN) ? calScheme.getBeginDate() : calScheme.getEndDate();
                currencyMap = CurrencyUtil.getTargetExchangeRateMap(Tools.getInstance().getCtx(), calScheme.getExchangeTable().getId().toString(), calScheme.getCurrency().getId().toString(), effdt);
            }
            StringBuilder str = new StringBuilder();
            str.append(" select CALTABLE.").append(fieldSn).append(" MONEY").append(" ,");
            str.append("  CALTABLE.FCurrencyID currencyId");
            str.append(" FROM T_HR_SCMPCALTABLE CALTABLE ");
            str.append(" WHERE CALTABLE.FCALSCHEMEID = '").append(calSchemeInfo.getId().toString()).append("' ");
            str.append(" AND CALTABLE.FPERIODYEAR = ").append(year);
            str.append(" AND CALTABLE.FPERIODMONTH = ").append(month);
            str.append(" AND CALTABLE.FCALTIME = ").append((int)accountNum);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (rowSet.next()) {
                rate = null == currencyMap.get(rowSet.getString("currencyId")) ? new BigDecimal(1) : (BigDecimal)currencyMap.get(rowSet.getString("currencyId"));
                sumMoney = sumMoney.add(rowSet.getBigDecimal(1) == null ? new BigDecimal(0) : rowSet.getBigDecimal(1).multiply(rate));
            }
            tempMap.put(dataKey, sumMoney);
        }
        return tempMap.containsKey(dataKey) ? ((BigDecimal)tempMap.get(dataKey)).doubleValue() : 0.0;
    }

    public Map<String, String> getCmpCalTableName(CalSchemeInfo calScheme) throws SQLException {
        Context ctx = Tools.getInstance().getCtx();
        String l = calScheme.getLanType().getValue();
        String sql = "select FIELDSN,FNAME_" + l + " from T_HR_SCmpItem order by FIELDSN";
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String resultKey = executeQuery.getString("FNAME_" + l + "");
                String resultValue = executeQuery.getString("FIELDSN");
                resultMap.put(resultKey, resultValue);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public double getHistoryItemSalarySum(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String schemeName, String cmpItemsName, double periodYear, double periodMonth, double calTime, double periods) throws SQLException, BOSException {
        String calPersonId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        Context ctx = Tools.getInstance().getCtx();
        BigDecimal tempSum = new BigDecimal(0);
        BigDecimal rate = new BigDecimal(1);
        String personId = null;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, (int)periodYear);
        calendar.set(2, (int)periodMonth - 1);
        String beginDateStr = "{ts '" + calendar.get(1) + "-" + (calendar.get(2) + 1) + "-01'}";
        String dataKey = "GETHISTORYITEMSALARYSUM_" + cmpItemsName + schemeName + periodYear + periodMonth + periods;
        Map<String, Double> dataMap = new HashMap();
        if (tempMap.get(dataKey) == null) {
            Map resultMap;
            if (tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM") == null) {
                tempMap.put("CalFunItemSalary_CALFUNITEMSALARY_ITEM", this.getCmpCalTableName(calScheme));
            }
            if ((resultMap = (Map)tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM")).get(cmpItemsName) == null) {
                return 0.0;
            }
            String fieldSn = "S" + (String)resultMap.get(cmpItemsName);
            CalSchemeCollection calCol = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeCollection("where name = '" + schemeName + "'");
            if (calCol == null || calCol.size() == 0) {
                return 0.0;
            }
            CalSchemeInfo calSchemeInfo = calCol.get(0);
            CmpPeriodTypeEnum cmpPeriodType = calSchemeInfo.getCmpPeriodType();
            Calendar cal = Calendar.getInstance();
            String periodYearStr = String.valueOf(periodYear);
            int periodYearVal = Integer.parseInt(periodYearStr.substring(0, periodYearStr.indexOf(".")));
            String periodMonthStr = String.valueOf(periodMonth);
            int periodMonthVal = Integer.parseInt(periodMonthStr.substring(0, periodMonthStr.indexOf(".")));
            String periodsStr = String.valueOf(periods);
            int periodsVal = Integer.parseInt(periodsStr.substring(0, periodsStr.indexOf(".")));
            cal.set(1, periodYearVal);
            cal.set(2, periodMonthVal - 1);
            if (cmpPeriodType == CmpPeriodTypeEnum.month) {
                cal.add(2, periodsVal);
            } else if (cmpPeriodType == CmpPeriodTypeEnum.quarter) {
                cal.add(2, (periodsVal - 1) * 3);
            }
            if (cmpPeriodType == CmpPeriodTypeEnum.half) {
                cal.add(2, (periodsVal - 1) * 6);
            }
            if (cmpPeriodType == CmpPeriodTypeEnum.yeay) {
                cal.add(2, (periodsVal - 1) * 12);
            }
            cal.set(5, cal.getActualMaximum(5));
            String endDate = "{ts '" + cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5) + "'}";
            StringBuffer str = new StringBuffer();
            StringBuffer bodyStr = new StringBuffer();
            bodyStr.append(" FROM T_HR_SCMPCALTABLE A01 ");
            bodyStr.append(" WHERE FCALSCHEMEID = '").append(calSchemeInfo.getId().toString()).append("' ");
            bodyStr.append(" AND FBEGINDATE >= ").append(beginDateStr);
            bodyStr.append(" AND FENDDATE <= ").append(endDate);
            if ((int)calTime != 0) {
                bodyStr.append(" AND FCALTIME = ").append((int)calTime);
            }
            if ("test".equals(this.getType())) {
                bodyStr.append(" AND FPERSONID = '").append(calPersonId).append("' ");
            } else {
                bodyStr.append(" AND EXISTS (SELECT 1 FROM T_HR_SCMPCALTABLE A02 WHERE ").append(" A01.FPERSONID = A02.FPERSONID ");
                if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                    String mainTableRowFilterRepalace = mainTableRowFilter.replace("t_hr_scmpcaltable.fid", "A02.fid").replace("t_hr_scmpcaltable.FCalState", "A02.FCalState");
                    bodyStr.append(" and ").append(mainTableRowFilterRepalace);
                }
                bodyStr.append(" ) ");
            }
            if (null != calScheme.getCurrency()) {
                Date effdt = calScheme.getExchangeRule().equals((Object)CmpExchangeRuleEnum.PERIOD_BEGIN) ? calScheme.getBeginDate() : calScheme.getEndDate();
                String targetCurrencyId = calScheme.getCurrency().getId().toString();
                String exchangeTableId = calScheme.getExchangeTable().getId().toString();
                str.append(" SELECT ").append(fieldSn).append(" MONEY, FPERSONID, FCURRENCYID, FEXCHANGETABLEID ");
                str.append(bodyStr);
                str.append("  ORDER BY FPERSONID ");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                Map<String, BigDecimal> currencyMap = CurrencyUtil.getTargetExchangeRateMap(ctx, exchangeTableId, targetCurrencyId, effdt);
                while (rowSet.next()) {
                    personId = rowSet.getString("FPERSONID");
                    String currencyId = rowSet.getString("FCURRENCYID");
                    rate = null != currencyId ? (null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId)) : new BigDecimal(1);
                    BigDecimal money = rowSet.getBigDecimal("MONEY") == null ? new BigDecimal(0) : rowSet.getBigDecimal("MONEY");
                    tempSum = dataMap.get(personId) == null ? money.multiply(rate) : new BigDecimal((Double)dataMap.get(personId)).add(money.multiply(rate));
                    dataMap.put(personId, tempSum.doubleValue());
                }
            } else {
                str.append(" SELECT SUM(").append(fieldSn).append(") SUMMONEY, FPERSONID ");
                str.append(bodyStr);
                str.append(" GROUP BY FPERSONID ");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    dataMap.put(rowSet.getString(2), rowSet.getDouble(1));
                }
            }
            tempMap.put(dataKey, dataMap);
        } else {
            dataMap = (Map)tempMap.get(dataKey);
        }
        return dataMap.containsKey(calPersonId) ? (Double)dataMap.get(calPersonId) : 0.0;
    }

    public double getRelativeHistoryItemSalarySum(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String schemeName, String cmpItemsName, double beginRelativePeriod, double calTime, double periods) throws SQLException, BOSException {
        Calendar calendar = this.getCalendarByPeriod(calScheme, (int)beginRelativePeriod);
        return this.getHistoryItemSalarySum(paramMap, tempMap, calScheme, mainTableRowFilter, schemeName, cmpItemsName, calendar.get(1), calendar.get(2) + 1, calTime, periods);
    }

    public double getItemSumSalaryByOrg(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String schemeName, String orgDisplayName, String cmpItemsName, double periodValue, double accountNum) throws SQLException, BOSException {
        Context ctx = Tools.getInstance().getCtx();
        String multiValue = calScheme.getLanType().getValue();
        BigDecimal sumMoney = new BigDecimal(0);
        Calendar calendar = this.getCalendarByPeriod(calScheme, (int)periodValue);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        String dataKey = "GETITEMSUMSALARYBYORG_" + orgDisplayName + "_" + cmpItemsName + schemeName + periodValue + accountNum;
        Map<Object, Object> currencyMap = new HashMap();
        BigDecimal rate = new BigDecimal(1);
        if (tempMap.get(dataKey) == null) {
            Map resultMap;
            if (tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM") == null) {
                tempMap.put("CalFunItemSalary_CALFUNITEMSALARY_ITEM", this.getCmpCalTableName(calScheme));
            }
            if ((resultMap = (Map)tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM")).get(cmpItemsName) == null) {
                return 0.0;
            }
            String fieldSn = "S" + (String)resultMap.get(cmpItemsName);
            Calendar schemeCalendar = Calendar.getInstance();
            schemeCalendar.setTime(calScheme.getEndDate());
            calendar.set(5, schemeCalendar.get(5));
            String endDateStr = "{ts '" + calendar.get(1) + "-" + calendar.get(2) + "-" + calendar.get(5) + "'}";
            CalSchemeCollection calCol = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeCollection("where name = '" + schemeName + "'");
            if (calCol == null || calCol.size() == 0) {
                return 0.0;
            }
            CalSchemeInfo calSchemeInfo = calCol.get(0);
            if (null != calScheme.getCurrency()) {
                Date effdt = calScheme.getExchangeRule().equals((Object)CmpExchangeRuleEnum.PERIOD_BEGIN) ? calScheme.getBeginDate() : calScheme.getEndDate();
                currencyMap = CurrencyUtil.getTargetExchangeRateMap(Tools.getInstance().getCtx(), calScheme.getExchangeTable().getId().toString(), calScheme.getCurrency().getId().toString(), effdt);
            }
            StringBuilder str = new StringBuilder();
            str.append(" select CALTABLE.").append(fieldSn).append(" MONEY").append(" ,");
            str.append("  CALTABLE.FCurrencyID currencyId");
            str.append(" FROM T_HR_SCMPCALTABLE CALTABLE ");
            str.append(" WHERE CALTABLE.FPERIODYEAR = ").append(year);
            str.append(" AND CALTABLE.FPERIODMONTH = ").append(month);
            str.append(" AND CALTABLE.FCALTIME = ").append((int)accountNum);
            str.append(" AND CALTABLE.FCalSchemeId = '").append(calSchemeInfo.getId().toString()).append("' ");
            str.append(" AND EXISTS (");
            str.append(" SELECT 1 FROM T_ORG_ADMINORGtreehis TREEHIS ");
            str.append(" WHERE ( TREEHIS.FDISPLAYNAME_l1 ").append(" = '").append(orgDisplayName).append("' ");
            str.append(" OR TREEHIS.FDISPLAYNAME_l2 ").append(" = '").append(orgDisplayName).append("' ");
            str.append(" OR TREEHIS.FDISPLAYNAME_l3 ").append(" = '").append(orgDisplayName).append("' ");
            str.append(" OR TREEHIS.FDISPLAYNAME_L1 ").append(" LIKE '").append(orgDisplayName).append("%' ");
            str.append(" OR TREEHIS.FDISPLAYNAME_L2 ").append(" LIKE '").append(orgDisplayName).append("%' ");
            str.append(" OR TREEHIS.FDISPLAYNAME_L3 ").append(" LIKE '").append(orgDisplayName).append("%') ");
            str.append(" AND CALTABLE.FADMINORGUNITID = TREEHIS.FAdminOrgID ");
            str.append(" )");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (rowSet.next()) {
                rate = null == currencyMap.get(rowSet.getString("currencyId")) ? new BigDecimal(1) : (BigDecimal)currencyMap.get(rowSet.getString("currencyId"));
                sumMoney = sumMoney.add(rowSet.getBigDecimal(1) == null ? new BigDecimal(0) : rowSet.getBigDecimal(1).multiply(rate));
            }
            tempMap.put(dataKey, sumMoney.doubleValue());
        }
        return tempMap.containsKey(dataKey) ? (Double)tempMap.get(dataKey) : 0.0;
    }

    private Map<String, Map<String, Double>> getHistoryItems(CalSchemeInfo calScheme, String personId, String mainTableRowFilter, String schemeName, Set<String> fieldSns, int year, int month, int calTime) throws SQLException, BOSException {
        HashMap<String, Map<String, Double>> dataMap = new HashMap<String, Map<String, Double>>();
        Context ctx = Tools.getInstance().getCtx();
        BigDecimal rate = new BigDecimal(1);
        CalSchemeCollection calCol = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeCollection("where name = '" + schemeName + "'");
        if (calCol == null || calCol.size() == 0) {
            return dataMap;
        }
        CalSchemeInfo calSchemeInfo = calCol.get(0);
        String calschemeid = calScheme.getId().toString();
        String personSql = "select FPersonID from T_HR_SCmpCalTable  where FcalSchemeID = '" + calschemeid + "' and FcalTime = " + calScheme.getCalTime() + " and FperiodYear = " + calScheme.getPeriodYear() + " and FperiodMonth = " + calScheme.getPeriodMonth() + "";
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            personSql = personSql + " and " + mainTableRowFilter;
        }
        StringBuilder str = new StringBuilder();
        str.append(" SELECT ").append(fieldSns.toString().replace("[", "").replace("]", "")).append(", FPERSONID, FCURRENCYID, FEXCHANGETABLEID ");
        str.append(" FROM T_HR_SCMPCALTABLE CALTABLE ");
        str.append(" WHERE CALTABLE.FCALSCHEMEID = '").append(calSchemeInfo.getId().toString()).append("' ");
        str.append(" AND CALTABLE.FPERIODYEAR=").append(year);
        str.append(" AND CALTABLE.FPERIODMONTH=").append(month);
        str.append(" AND CALTABLE.FCALTIME=").append(calTime);
        if ("test".equals(this.getType())) {
            str.append(" AND CALTABLE.FPERSONID = '" + personId + "'");
        } else {
            str.append(" AND FPERSONID in ( ").append(personSql).append(" ) ");
        }
        if (null != calScheme.getCurrency()) {
            String targetCurrencyId = calScheme.getCurrency().getId().toString();
            String exchangeTableId = calScheme.getExchangeTable().getId().toString();
            Date effdt = calScheme.getExchangeRule().equals((Object)CmpExchangeRuleEnum.PERIOD_BEGIN) ? calScheme.getBeginDate() : calScheme.getEndDate();
            Map<String, BigDecimal> currencyMap = CurrencyUtil.getTargetExchangeRateMap(ctx, exchangeTableId, targetCurrencyId, effdt);
            try {
                List<IRowSet> rowSets = this.executeQueryPaging(ctx, str.toString());
                for (IRowSet rowSet : rowSets) {
                    while (rowSet.next()) {
                        String currencyId = rowSet.getString("FCURRENCYID");
                        rate = null != currencyId ? (null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId)) : new BigDecimal(1);
                        HashMap<String, Double> perMap = new HashMap<String, Double>();
                        for (String sn : fieldSns) {
                            BigDecimal money = rowSet.getBigDecimal(sn) == null ? new BigDecimal(0) : rowSet.getBigDecimal(sn);
                            perMap.put(sn, money.multiply(rate).doubleValue());
                        }
                        dataMap.put(rowSet.getString("FPERSONID"), perMap);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)e);
            }
        } else {
            try {
                List<IRowSet> rowSets = this.executeQueryPaging(ctx, str.toString());
                for (IRowSet rowSet : rowSets) {
                    while (rowSet.next()) {
                        HashMap<String, Double> perMap = new HashMap<String, Double>();
                        for (String sn : fieldSns) {
                            perMap.put(sn, rowSet.getDouble(sn));
                        }
                        dataMap.put(rowSet.getString("FPERSONID"), perMap);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)e);
            }
        }
        return dataMap;
    }

    public Set<String> getCalSchemeItemMap(Context ctx, CalSchemeInfo calScheme, HashMap<String, Object> tempMap, String schemeName, String formulaDefine) throws BOSException {
        Map<String, Set<String>> calSchemeItemMap = null;
        String resultKey = schemeName + "###" + formulaDefine;
        if (tempMap.containsKey("CalFunItemSalary_CALSCHEMEITEMMAP_KEY")) {
            calSchemeItemMap = (Map)tempMap.get(this.calSchemeItemMapKey);
        }
        if (calSchemeItemMap == null) {
            calSchemeItemMap = new HashMap();
        }
        if (calSchemeItemMap.containsKey(resultKey)) {
            return (Set)calSchemeItemMap.get(resultKey);
        }
        String funclist = "~" + FORMULADEFINE_LISTFUNC_MAPPER.get(formulaDefine) + "~" + formulaDefine;
        CalFormulaCollection calFormulaCollection = CalFormulaFactory.getLocalInstance(ctx).getCalFormulaCollection("select id,express where calScheme.id = '" + calScheme.getId().toString() + "' and isCal = 1 and listFunc like '%" + funclist + "%'");
        if (calFormulaCollection == null || calFormulaCollection.size() == 0) {
            calSchemeItemMap.put(resultKey, null);
        }
        Map itemMap = (Map)tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM");
        int size = calFormulaCollection.size();
        for (int i = 0; i < size; ++i) {
            CalFormulaInfo calFormulaInfo = calFormulaCollection.get(i);
            String express = calFormulaInfo.getExpress();
            this.getUsedCalSchemeItem(calSchemeItemMap, itemMap, express, schemeName, formulaDefine);
        }
        tempMap.put("CalFunItemSalary_CALSCHEMEITEMMAP_KEY", calSchemeItemMap);
        return (Set)calSchemeItemMap.get(resultKey);
    }

    public boolean getUsedCalSchemeItem(Map<String, Set<String>> result, Map<String, String> itemMap, String express, String schemeName, String formulaDefine) {
        String formulaDefineReal = formulaDefine + "(";
        int lastIndexOf = express.lastIndexOf(formulaDefineReal);
        if (lastIndexOf > 0) {
            String funExpress = express.substring(lastIndexOf + formulaDefineReal.length());
            String tempExpress = express.substring(0, lastIndexOf);
            String[] split = funExpress.split(",");
            String calScheme = schemeName;
            String item = split[1].trim().replace("\"", "");
            String resultKey = calScheme + "###" + formulaDefine;
            Set<Object> itemSet = result.containsKey(resultKey) ? result.get(resultKey) : new HashSet();
            if (itemMap.containsKey(item)) {
                itemSet.add("S" + itemMap.get(item));
            }
            result.put(resultKey, itemSet);
            boolean a = this.getUsedCalSchemeItem(result, itemMap, tempExpress, schemeName, formulaDefine);
            return a;
        }
        return false;
    }

    public double getCmpItemSumBySpecifyDimension(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String schemeName, String specifyDimension, double specifyType, String cmpItem, double calcuType, double periodValue, double calTime) throws SQLException, BOSException {
        Map cmpItemmap;
        CalSchemeInfo calSchemeInfo;
        Context ctx = Tools.getInstance().getCtx();
        String name = calScheme.getName();
        if (StringUtils.isEmpty((String)schemeName)) {
            calSchemeInfo = calScheme;
        } else if (schemeName.equals(name)) {
            calSchemeInfo = calScheme;
        } else {
            CalSchemeCollection calCol = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeCollection("where name = '" + schemeName + "'");
            if (calCol.isEmpty()) {
                return 0.0;
            }
            calSchemeInfo = calCol.get(0);
        }
        if (!StringUtils.isEmpty((String)specifyDimension) && (specifyDimension.contains("[") || specifyDimension.contains("]"))) {
            specifyDimension = specifyDimension.replace("[", "").replace("]", "");
        }
        String calPersonId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        Calendar calendar = this.getCalendarByPeriod(calSchemeInfo, (int)periodValue);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        String calschemeId = calSchemeInfo.getId().toString();
        BigDecimal returnValue = BigDecimal.ZERO;
        String dataKey = "specifyDimension_" + calschemeId + "_" + year + month + calTime + "_" + specifyDimension + "_" + specifyType + "_" + cmpItem + "_" + calcuType;
        if (!tempMap.containsKey(dataKey) && !tempMap.containsKey("CalFunItemSalary_CALFUNITEMSALARY_ITEM")) {
            tempMap.put("CalFunItemSalary_CALFUNITEMSALARY_ITEM", this.getCmpCalTableName(calSchemeInfo));
        }
        if (!(cmpItemmap = (Map)tempMap.get("CalFunItemSalary_CALFUNITEMSALARY_ITEM")).containsKey(cmpItem)) {
            return 0.0;
        }
        String cmpItemSn = "S" + (String)cmpItemmap.get(cmpItem);
        if (specifyType < 1.0) {
            if (StringUtils.isEmpty((String)specifyDimension)) {
                return 0.0;
            }
            if (!cmpItemmap.containsKey(specifyDimension)) {
                return 0.0;
            }
            String specifyDimensionSn = "S" + (String)cmpItemmap.get(specifyDimension);
            String fromSql = " from T_HR_SCmpCalTable  where FcalSchemeID = '" + calschemeId + "' and FperiodYear = " + year + " and FperiodMonth = " + month + " and FcalTime = ? ";
            String personKey = dataKey + "_person0";
            String sumKey = dataKey + "_sum0";
            if (!tempMap.containsKey(personKey)) {
                tempMap.put(personKey, this.getPersonIdAndSpecifyDimensionSnMap(ctx, fromSql, specifyDimensionSn, calTime));
            }
            if (!tempMap.containsKey(sumKey)) {
                tempMap.put(sumKey, this.getSpecifyDimensionSnAndSumMap(ctx, fromSql, specifyDimensionSn, cmpItemSn, calTime, calcuType));
            }
            Map specifyDimensionSnAndSumMap = (Map)tempMap.get(sumKey);
            Map personIdAndSpecifyDimensionSnMap = (Map)tempMap.get(personKey);
            if (!personIdAndSpecifyDimensionSnMap.containsKey(calPersonId)) {
                return 0.0;
            }
            String specify = (String)personIdAndSpecifyDimensionSnMap.get(calPersonId);
            if (specifyDimensionSnAndSumMap.containsKey(specify) && specifyDimensionSnAndSumMap.get(specify) != null) {
                returnValue = (BigDecimal)specifyDimensionSnAndSumMap.get(specify);
            }
        } else if (specifyType < 2.0) {
            String personKey = dataKey + "_person1";
            String sumKey = dataKey + "_sum1";
            String specifyDimensionClientNumAndColNum = this.getClientNumberAndColNumber(ctx, specifyDimension, "002");
            if (StringUtils.isEmpty((String)specifyDimensionClientNumAndColNum)) {
                return 0.0;
            }
            String sql = "";
            if (!tempMap.containsKey(sumKey)) {
                sql = this.buildDataSetSql(ctx, specifyDimensionClientNumAndColNum, cmpItemSn, calschemeId, year, month, calTime);
                tempMap.put(sumKey, this.getClientNumAndColNumMap(ctx, sql, cmpItemSn, calcuType));
            }
            if (!tempMap.containsKey(personKey)) {
                if (StringUtils.isEmpty((String)sql)) {
                    sql = this.buildDataSetSql(ctx, specifyDimensionClientNumAndColNum, cmpItemSn, calschemeId, year, month, calTime);
                }
                tempMap.put(personKey, this.getPersonIdAndClientNumMap(ctx, sql));
            }
            Map clientNumAndColNumMap = (Map)tempMap.get(sumKey);
            Map personIdAndClientNumMap = (Map)tempMap.get(personKey);
            if (!personIdAndClientNumMap.containsKey(calPersonId)) {
                return 0.0;
            }
            String specify = (String)personIdAndClientNumMap.get(calPersonId);
            if (clientNumAndColNumMap.containsKey(specify) && clientNumAndColNumMap.get(specify) != null) {
                returnValue = (BigDecimal)clientNumAndColNumMap.get(specify);
            }
        }
        return returnValue.doubleValue();
    }

    private Map<String, String> getPersonIdAndClientNumMap(Context ctx, String sql) throws BOSException, SQLException {
        HashMap<String, String> personIdAndClientNumMap = new HashMap<String, String>();
        String personSql = sql.replace("SELECT ", "SELECT \"CMP_CTB\".FPersonID \"personId\" ,");
        personSql = personSql.replaceAll(" AS ", " ");
        IRowSet personRowSet = DbUtil.executeQuery((Context)ctx, (String)personSql);
        while (personRowSet.next()) {
            String personId = personRowSet.getString("personId");
            String clientNumAndColNum = personRowSet.getString("clientNumAndColNum");
            personIdAndClientNumMap.put(personId, clientNumAndColNum);
        }
        return personIdAndClientNumMap;
    }

    private Map<String, BigDecimal> getClientNumAndColNumMap(Context ctx, String sql, String cmpItemSn, double calcuType) throws BOSException, SQLException {
        HashMap<String, BigDecimal> clientNumAndColNumMap = new HashMap<String, BigDecimal>();
        String speSql = this.specifySqlConcatenation(cmpItemSn, sql, calcuType);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)speSql);
        while (rowSet.next()) {
            String clientNumber = rowSet.getString("clientNumAndColNum");
            BigDecimal colNumber = rowSet.getBigDecimal("sumData");
            clientNumAndColNumMap.put(clientNumber, colNumber);
        }
        return clientNumAndColNumMap;
    }

    private String specifySqlConcatenation(String cmpItemSn, String sql, double calcuType) {
        int selectIndex = sql.indexOf("SELECT");
        int asIndex = sql.indexOf("AS");
        String alias = sql.substring(selectIndex + 6, asIndex);
        String cmpCtbCmpItem = "\"CMP_CTB\"." + cmpItemSn;
        String replaceStr = "";
        replaceStr = calcuType >= 1.0 && calcuType < 2.0 ? "SELECT " + this.getCalculationType(calcuType) + "(case when " + cmpCtbCmpItem + " is null then 0 else " + cmpCtbCmpItem + " end) sumData , " : "SELECT " + this.getCalculationType(calcuType) + "(" + cmpCtbCmpItem + ") sumData , ";
        String speSql = sql.replace("SELECT ", replaceStr);
        String groupByStr = " group by " + alias;
        speSql = speSql + groupByStr;
        speSql = speSql.replaceAll(" AS ", " ");
        return speSql;
    }

    protected String buildDataSetSql(Context ctx, String specifyDimensionClientNumAndColNum, String cmpItemSn, String calschemeId, int year, int month, double calTime) throws BOSException, SQLException {
        String filterStr = " CMP_CTB.calScheme.id = '" + calschemeId + "' and CMP_CTB.periodYear = " + year + " and CMP_CTB.periodMonth = " + month + " and CMP_CTB.calTime = " + calTime;
        String sql = "";
        try {
            FilterInfo filter = new FilterInfo(filterStr);
            SqlParam sqlParam = new SqlParam();
            HashMap<String, String> selectMapping = new HashMap<String, String>();
            selectMapping.put(specifyDimensionClientNumAndColNum, "clientNumAndColNum");
            if (selectMapping.size() < 1) {
                return null;
            }
            sqlParam.setSelectMapping(selectMapping);
            sqlParam.setFilterInfo(filter);
            sqlParam.setScheme("002");
            sqlParam.setHistoryMode(true);
            sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
        }
        catch (ParserException e) {
            this.logger.error((Object)"buildDataSetSql parse error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            this.logger.error((Object)"buildDataSetSql eas error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return sql;
    }

    private String getClientNumberAndColNumber(Context ctx, String specifyDimension, String structSchemeNumber) throws BOSException, SQLException {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT sconfig.FClientNumber clientNumber , columns.FNumber colNumber ");
        builder.append(" FROM T_HR_SCmpQueryConfigField field ");
        builder.append(" left join T_HR_StructureConfigColumns columns on field.FFactFieldID = columns.Fid ");
        builder.append(" left join T_HR_StructureConfig sconfig on sconfig.Fid = columns.FStructureConfigID ");
        builder.append(" left join T_HR_StructureConfigScheme cscheme on cscheme.Fid = sconfig.FSchemeID ");
        builder.append(" where field.FAlias_").append(ctx.getLocale().getLanguage()).append(" = ? and cscheme.FNumber = ? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString(), (Object[])new Object[]{specifyDimension, structSchemeNumber});
        if (rowSet.next()) {
            String clientNumber = rowSet.getString("clientNumber");
            String colNumber = rowSet.getString("colNumber");
            return clientNumber + "." + colNumber;
        }
        return "";
    }

    private Map<String, String> getPersonIdAndSpecifyDimensionSnMap(Context ctx, String fromSql, String specifyDimensionSn, double calTime) throws BOSException, SQLException {
        HashMap<String, String> personIdAndSpecifyDimensionSnMap = new HashMap<String, String>();
        String sql = "select FpersonId, " + specifyDimensionSn + fromSql;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{calTime});
        while (rowSet.next()) {
            String personId = rowSet.getString("FpersonId");
            String specifySn = rowSet.getString(specifyDimensionSn);
            personIdAndSpecifyDimensionSnMap.put(personId, specifySn);
        }
        return personIdAndSpecifyDimensionSnMap;
    }

    private Map<String, BigDecimal> getSpecifyDimensionSnAndSumMap(Context ctx, String fromSql, String specifyDimensionSn, String cmpItemSn, double calTime, double calcuType) throws BOSException, SQLException {
        HashMap<String, BigDecimal> specifyDimensionSnAndSumMap = new HashMap<String, BigDecimal>();
        String calcuDataStr = "";
        calcuDataStr = calcuType >= 1.0 && calcuType < 2.0 ? this.getCalculationType(calcuType) + "(case when " + cmpItemSn + " is null then 0 else " + cmpItemSn + " end) calcuData " : this.getCalculationType(calcuType) + "(" + cmpItemSn + ") calcuData ";
        String apecifySql = "select " + specifyDimensionSn + " , " + calcuDataStr + fromSql;
        apecifySql = apecifySql + " group by " + specifyDimensionSn;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)apecifySql, (Object[])new Object[]{calTime});
        while (rowSet.next()) {
            String specifyDim = rowSet.getString(specifyDimensionSn);
            BigDecimal sumData = rowSet.getBigDecimal("calcuData");
            specifyDimensionSnAndSumMap.put(specifyDim, sumData);
        }
        return specifyDimensionSnAndSumMap;
    }

    private String getCalculationType(double calcuType) {
        String calcuName = "sum";
        if (calcuType >= 1.0 && calcuType < 2.0) {
            calcuName = "avg";
        } else if (calcuType >= 2.0 && calcuType < 3.0) {
            calcuName = "min";
        } else if (calcuType >= 3.0 && calcuType < 4.0) {
            calcuName = "max";
        }
        return calcuName;
    }

    static {
        FORMULADEFINE_LISTFUNC_MAPPER.put("FunGetHistoryItemSalarySum", "e74AAABs3xgkATlo");
        FORMULADEFINE_LISTFUNC_MAPPER.put("FunGetHistoryItemSalary", "qo4TnBudSTOyn3q/+Mc/9SQBOWg=");
        FORMULADEFINE_LISTFUNC_MAPPER.put("FunGetHistoryItemSalaryZF", "8r0AAAAKFpckATlo");
    }
}

