/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.budget.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateCollection;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateFactory;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateInfo;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeCollection;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.SubBalanceTypeEnum;
import com.kingdee.shr.compensation.exception.BudgetEASBizException;
import com.kingdee.shr.compensation.service.budget.BudgetAndUsedData;
import com.kingdee.shr.compensation.service.budget.BudgetData;
import com.kingdee.shr.compensation.service.budget.DeductionParam;
import com.kingdee.shr.compensation.service.budget.DeductionResult;
import com.kingdee.shr.compensation.service.budget.ExpenseDetailsVO;
import com.kingdee.shr.compensation.service.budget.IDeductionService;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public abstract class AbstractDeductionService
implements IDeductionService {
    private static final Logger LOG = Logger.getLogger(AbstractDeductionService.class);
    protected Context ctx;
    protected final Timestamp now = new Timestamp(System.currentTimeMillis());
    protected DeductionParam deductionParam;
    protected DeductionResult deductionResult = new DeductionResult();
    protected BudgetPeriodEnum budgetPeriod;
    protected UserInfo user;
    protected String budgetSchemeId;
    protected CmpBudgetSchemeInfo budgetScheme;
    protected String budgetTemplateId;
    protected int budgetYear;
    protected BudgetTemplateInfo budgetTemplate;
    protected List<ExpenseDetailsVO> expenseList;
    protected boolean checkingOnly;
    protected BigDecimal budgetItemDeductAmount = BigDecimal.ZERO;

    @Override
    public void setCheckingOnly(boolean checkingOnly) {
        this.checkingOnly = checkingOnly;
    }

    @Override
    public DeductionResult deduct(Context ctx, DeductionParam deductionParam) throws BOSException, EASBizException {
        LOG.debug((Object)("DeductionParam for deduct: " + deductionParam));
        this.deductionParam = deductionParam;
        this.ctx = ctx;
        boolean havingBudget = this.checkBudgetData();
        if (!havingBudget) {
            return this.deductionResult;
        }
        this.checkAcross();
        boolean flag = this.loadData();
        if (!flag) {
            this.deductionResult.setErrMsg(EASResource.getString((String)"com.kingdee.shr.compensation.app.cmpBudget.CmpBudgetCommonResource", (String)"label9", (Locale)ctx.getLocale()));
            return this.deductionResult;
        }
        this.dealDeductConfig();
        if (this.checkingOnly) {
            return this.deductionResult;
        }
        this.executeOffSet();
        this.updateExpenseDetails();
        this.deductionResult.setDeductionParam(deductionParam);
        return this.deductionResult;
    }

    @Override
    public void rollback(Context ctx, DeductionParam deductionParam) throws BOSException, EASBizException {
        LOG.debug((Object)("DeductionParam for rollback: " + deductionParam));
        this.ctx = ctx;
        this.deductionParam = deductionParam;
        this.user = new UserInfo();
        String currentUserId = HRFilterUtils.getCurrentUserId((Context)ctx);
        this.user.setId(BOSUuid.read((String)currentUserId));
        boolean isReverseApprove = this.isReverseApprove(deductionParam);
        boolean isExisted = this.loadRollbackDeduConfigInfo(isReverseApprove);
        if (!isExisted) {
            return;
        }
        this.doRollback(isReverseApprove);
    }

    protected abstract boolean isReverseApprove(DeductionParam var1);

    protected abstract void doRollback(boolean var1) throws BOSException, EASBizException;

    protected abstract boolean loadRollbackDeduConfigInfo(boolean var1) throws BOSException;

    protected void updateExpenseDetails() {
        if (null == this.expenseList || this.expenseList.isEmpty()) {
            LOG.error((Object)"========>error: expenseList is empty");
            return;
        }
        List<String> updateSQL = this.getUpdateSQLs();
        if (!updateSQL.isEmpty()) {
            CmpSQLUtil.executeBatchSql(this.ctx, updateSQL.toArray());
        }
        this.batchInsertExpenseDetails();
    }

    protected List<String> getUpdateSQLs() {
        ArrayList<String> updateSQLs = new ArrayList<String>();
        this.expenseList.stream().filter(e -> e.getId() != null).collect(Collectors.toList()).forEach(e -> updateSQLs.add(this.concatFieldsAndValue(e.getId(), e.getExpenseMap())));
        return updateSQLs;
    }

    protected String concatFieldsAndValue(String baseId, Map<String, BigDecimal> expenseMap) {
        StringBuilder updateSQL = new StringBuilder("update T_HR_SExpenseDetailsBase set ");
        for (Map.Entry<String, BigDecimal> entry : expenseMap.entrySet()) {
            String field = entry.getKey();
            BigDecimal value = entry.getValue();
            if (null == value || value.compareTo(BigDecimal.ZERO) == 0) {
                value = BigDecimal.ZERO;
            }
            updateSQL.append(field).append(" = (case when ").append(field).append(" is null then 0 else ").append(field).append(" end) + ").append(value).append(", ");
        }
        updateSQL.append("FLastUpdateUserID = '").append(this.user.getId().toString()).append("', FLastUpdateTime = now()");
        updateSQL.append(" where fid = '").append(baseId).append("'");
        return updateSQL.toString();
    }

    public void batchInsertExpenseDetails() {
        if (this.expenseList.isEmpty()) {
            return;
        }
        String[] expenseFields = new String[]{"Fid", "FCmpEmpORelationId", "FBudgetTemplateId", "FBudgetSchemeId", "FBudgetManageId", "FSubBudgetQueryId", "FCostBearOrgId", "FCostTypeId", "FBudgetYear", "FRate", "FCurrencyId", "FStandingBookId", "FSubStandingBookId", "FCreatorID", "FCreateTime", "FLastUpdateUserID", "FLastUpdateTime", "FPersonId"};
        StringBuilder insertSQL = new StringBuilder("insert into T_HR_SExpenseDetailsBase ( ");
        for (String expenseField : expenseFields) {
            insertSQL.append(expenseField).append(", ");
        }
        ArrayList<String> insertSQLs = new ArrayList<String>();
        List list = this.expenseList.stream().filter(e -> e.getId() == null).collect(Collectors.toList());
        for (ExpenseDetailsVO expense : list) {
            Map<String, BigDecimal> expenseMap = expense.getExpenseMap();
            if (expenseMap.isEmpty()) continue;
            StringBuilder values = new StringBuilder();
            String baseId = BOSUuid.create((String)"55D3C1E2").toString();
            values.append("('").append(baseId).append("', '").append(expense.getCmpEmpORelationId()).append("', '").append(expense.getBudgetTemplateId()).append("', '").append(expense.getBudgetSchemeId()).append("', '").append(expense.getBudgetManageId()).append("', ").append(AbstractDeductionService.ifNull(expense.getSubBudgetQueryId())).append(", '").append(expense.getCostBearOrgId()).append("', '").append(expense.getCostTypeId()).append("', ").append(expense.getBudgetYear()).append(", ").append(expense.getRate()).append(", '").append(expense.getCurrencyId()).append("', '").append(expense.getStandingBookId()).append("', ").append(AbstractDeductionService.ifNull(expense.getSubStandingBookId())).append(", '").append(this.user.getId().toString()).append("', now(), '").append(this.user.getId().toString()).append("', ").append(" now(), '").append(expense.getPersonId()).append("', ");
            StringBuilder sql = new StringBuilder(insertSQL.toString());
            boolean flag = false;
            for (Map.Entry<String, BigDecimal> entry : expenseMap.entrySet()) {
                if (flag) {
                    sql.append(",");
                    values.append(",");
                }
                sql.append(entry.getKey());
                BigDecimal val = entry.getValue();
                values.append(val == null || val.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(0) : val);
                flag = true;
            }
            sql.append(") values ").append((CharSequence)values).append(")");
            insertSQLs.add(sql.toString());
            LOG.debug((Object)("insertSQL for batchInsertExpenseDetails: " + sql));
            String insertSmtSQL = this.getExtendInsertSQL(expense, baseId);
            insertSQLs.add(insertSmtSQL);
        }
        CmpSQLUtil.executeBatchSql(this.ctx, insertSQLs.toArray());
    }

    protected static String ifNull(String val) {
        return null == val ? null : "'" + val + "'";
    }

    protected abstract String getExtendInsertSQL(ExpenseDetailsVO var1, String var2);

    protected boolean loadData() throws BOSException, EASBizException {
        this.loadBudgetTemplateAndScheme(this.budgetTemplateId, this.budgetSchemeId);
        boolean isExisted = this.loadDeduConfigInfo();
        if (!isExisted) {
            return false;
        }
        this.loadUserInfo();
        this.loadOffSetConfigInfo();
        this.initLastDeductionSnapshots();
        this.loadDeductionAndSnapshot();
        return true;
    }

    protected abstract void initLastDeductionSnapshots() throws BOSException;

    protected void loadUserInfo() {
        String currentUserId = HRFilterUtils.getCurrentUserId((Context)this.ctx);
        this.user = new UserInfo();
        this.user.setId(BOSUuid.read((String)currentUserId));
    }

    protected abstract void loadDeductionAndSnapshot() throws BOSException;

    protected void dealDeductConfig() throws BOSException, EASBizException {
        if (BudgetPeriodEnum.YEAR == this.budgetPeriod) {
            this.doDeductionByYear();
        } else {
            this.doDeductionByPeriod();
        }
    }

    protected abstract void executeOffSet() throws BOSException, EASBizException;

    protected abstract void doDeductionByPeriod() throws BOSException, EASBizException;

    protected abstract void doDeductionByYear() throws BOSException, EASBizException;

    protected abstract boolean loadDeduConfigInfo() throws BOSException;

    protected abstract void loadOffSetConfigInfo() throws BOSException;

    protected abstract void checkAcross() throws BOSException, EASBizException;

    protected BudgetPeriodEnum getBudgetPeriodEnum() throws BOSException {
        String submitOql = "select budgetPeriod where id = '" + this.budgetTemplateId + "'";
        BudgetTemplateCollection templates = BudgetTemplateFactory.getLocalInstance(this.ctx).getBudgetTemplateCollection(submitOql);
        if (templates.isEmpty()) {
            return null;
        }
        return templates.get(0).getBudgetPeriod();
    }

    protected abstract boolean checkBudgetData() throws EASBizException;

    protected void checkAcrossOfSub(String subBookTableIdOfSnapshot) throws BOSException, EASBizException {
        this.budgetPeriod = this.getBudgetPeriodEnum();
        if (this.budgetPeriod != null && 0 != this.budgetPeriod.getValue()) {
            String deductDate = this.getDeductDate();
            int balanceTypeEnumValue = this.getBalanceTypeEnumValue();
            if (2 == balanceTypeEnumValue) {
                String subSqlBuild = " select sb.FID  FROM T_HR_SSubBudgetQuery ss  left join T_HR_SBudgetManage s on s.FID = ss.FBudgetManageID  left join T_HR_SCmpBudgetScheme cbs on s.FBudgetSchemeID = cbs.fid  left join T_HR_SCmpStandingBook b on b.FBudgetManageID=s.FID  left join T_HR_SubCmpStandingBook sb on sb.FCmpStandingBookID=b.FID and sb.FSubBudgetQueryID=ss.FID  where s.FAdminOrgUnitID " + this.getCostBearOrgComparator() + this.getCompareValue() + " and s.FCostTypeID = '" + this.getCostTypeId() + "' and s.FBudgetSchemeID = '" + this.budgetSchemeId + "' and cbs.FEffectDate <= " + deductDate + " and cbs.FExpiryDate >= " + deductDate + " and s.FState = 1  and ss.FEffectDate <= " + deductDate + " and ss.FExpiryDate >= " + deductDate;
                IRowSet subRowSet = DbUtil.executeQuery((Context)this.ctx, (String)subSqlBuild);
                try {
                    while (subRowSet.next()) {
                        String id = subRowSet.getString("FID");
                        if (subBookTableIdOfSnapshot == null || subBookTableIdOfSnapshot.equals(id)) continue;
                        throw new EASBizException(new NumericExceptionSubItem("CMP_COMMON_INFO", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label12", (Locale)this.ctx.getLocale())));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected abstract String getDeductDate();

    protected int getBalanceTypeEnumValue() throws BOSException {
        int returnVal = Integer.MIN_VALUE;
        String balanceTypeOql = " SELECT id,subBalanceTypeEnum where id = '" + this.budgetSchemeId + "'";
        CmpBudgetSchemeCollection budgetSchemeCollection = CmpBudgetSchemeFactory.getLocalInstance(this.ctx).getCmpBudgetSchemeCollection(balanceTypeOql);
        if (budgetSchemeCollection == null || budgetSchemeCollection.isEmpty()) {
            return returnVal;
        }
        CmpBudgetSchemeInfo budgetSchemeInfo = budgetSchemeCollection.get(0);
        if (budgetSchemeInfo == null || budgetSchemeInfo.getSubBalanceTypeEnum() == null) {
            return returnVal;
        }
        return budgetSchemeInfo.getSubBalanceTypeEnum().getValue();
    }

    protected BudgetData initBudgetData(String costBearOrgId, String costTypeId, String budgetSnCol, String stbSnCol, String leftSnCol, String budgetItemId) throws BOSException, EASBizException {
        BudgetData budgetData = new BudgetData();
        String deductDate = this.getDeductDate();
        String lan = LocaleUtils.getShortCode((Context)this.ctx);
        String sql = " SELECT b.FState,s.FID as SFID,b.FID as BDIF,c.FUsedAmount as usedAmount, org.fName_" + lan + " adminOrgUnit,  b." + budgetSnCol + ", s." + stbSnCol + " ,s." + leftSnCol + " FROM T_HR_SBudgetManage b  LEFT JOIN T_HR_SCmpBudgetScheme cbs on b.FBudgetSchemeId = cbs.fid  LEFT JOIN T_ORG_Admin org on b.FAdminOrgUnitID = org.fid  LEFT JOIN T_HR_SCmpStandingBook s on b.FID = s.FBudgetManageID  LEFT JOIN T_HR_SCmpUsedAmount c on c.FBudgetManageID=b.FID and c.FCmpBudgetItemID = '" + budgetItemId + "' where b.FAdminOrgUnitID = '" + costBearOrgId + "' and b.FCostTypeID = '" + costTypeId + "' and cbs.FEffectDate <= " + deductDate + " and cbs.FExpiryDate >= " + deductDate + " and b.FBudgetSchemeID = '" + this.budgetSchemeId + "'";
        IRowSet yearRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        boolean hasLeft = false;
        try {
            while (yearRowSet.next()) {
                int state = yearRowSet.getInt("FState");
                if (2 == state) {
                    String adminOrgUnitName = yearRowSet.getString("adminOrgUnit");
                    throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION36, new Object[]{adminOrgUnitName});
                }
                budgetData.setBookId(yearRowSet.getString("SFID"));
                budgetData.setBudgetManageId(yearRowSet.getString("BDIF"));
                budgetData.setUsedAmount(yearRowSet.getBigDecimal("usedAmount") == null ? BigDecimal.ZERO : yearRowSet.getBigDecimal("usedAmount"));
                budgetData.setStbAmount(yearRowSet.getBigDecimal(stbSnCol) == null ? BigDecimal.ZERO : yearRowSet.getBigDecimal(stbSnCol));
                budgetData.setBudgetAmount(yearRowSet.getBigDecimal(budgetSnCol) == null ? BigDecimal.ZERO : yearRowSet.getBigDecimal(budgetSnCol));
                BigDecimal leftData = yearRowSet.getBigDecimal(leftSnCol);
                if (leftData != null) {
                    hasLeft = true;
                } else {
                    leftData = BigDecimal.ZERO;
                }
                budgetData.setLeftBudgetData(leftData);
                budgetData.setHasLeft(hasLeft);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return budgetData;
    }

    protected void loadBudgetTemplateAndScheme(String budgetTemplateId, String budgetSchemeId) throws BOSException {
        if (StringUtils.isEmpty((String)budgetSchemeId)) {
            throw new BOSException("budgetSchemeId is empty");
        }
        if (StringUtils.isEmpty((String)budgetTemplateId)) {
            throw new BOSException("budgetTemplateId is empty");
        }
        String templateOql = "where id = '" + budgetTemplateId + "'";
        String schemeOql = "where id = '" + budgetSchemeId + "'";
        this.budgetTemplate = BudgetTemplateFactory.getLocalInstance(this.ctx).getBudgetTemplateCollection(templateOql).get(0);
        this.budgetScheme = CmpBudgetSchemeFactory.getLocalInstance(this.ctx).getCmpBudgetSchemeCollection(schemeOql).get(0);
    }

    public abstract String getCostTypeId();

    protected String doYearlyDeduction(String stbSnCol, String leftSnCol, BudgetData budgetData, BigDecimal deductVal) throws BudgetEASBizException, BOSException {
        String standingBookId;
        BigDecimal leftAmount;
        this.budgetItemDeductAmount = this.budgetItemDeductAmount.add(deductVal);
        if (budgetData.isHasLeft()) {
            BigDecimal isEnoughData;
            BigDecimal leftBudgetData = budgetData.getLeftBudgetData();
            BigDecimal bigDecimal = isEnoughData = this.checkingOnly ? leftBudgetData.subtract(this.budgetItemDeductAmount) : leftBudgetData.subtract(deductVal);
            if (this.isOverdraw(isEnoughData)) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION12);
            }
            leftAmount = leftBudgetData.subtract(deductVal);
        } else {
            BigDecimal balance = budgetData.getBudgetAmount().subtract(budgetData.getUsedAmount()).subtract(budgetData.getStbAmount());
            BigDecimal bigDecimal = leftAmount = this.checkingOnly ? balance.subtract(this.budgetItemDeductAmount) : balance.subtract(deductVal);
            if (this.isOverdraw(leftAmount)) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION12);
            }
        }
        if (this.checkingOnly) {
            return null;
        }
        BigDecimal newStbDecimal = budgetData.getStbAmount().add(deductVal);
        if (StringUtils.isEmpty((String)budgetData.getBookId())) {
            String insertStbSqlBuilder = " insert into T_HR_SCmpStandingBook (FID,FBudgetManageID," + stbSnCol + "," + leftSnCol + ") values(?,?,?,?)";
            standingBookId = BOSUuid.create((String)"8B07DDF4").toString();
            DbUtil.execute((Context)this.ctx, (String)insertStbSqlBuilder, (Object[])new Object[]{standingBookId, budgetData.getBudgetManageId(), newStbDecimal, leftAmount});
        } else {
            standingBookId = this.updateStandingBook(stbSnCol, leftSnCol, budgetData, leftAmount, newStbDecimal);
        }
        return standingBookId;
    }

    protected String updateStandingBook(String stbSnCol, String leftSnCol, BudgetData budgetData, BigDecimal leftAmount, BigDecimal newStbDecimal) throws BOSException {
        String updateStbSql = "update T_HR_SCmpStandingBook set " + stbSnCol + " = ?," + leftSnCol + " = ? where FID = ? ";
        String standingBookId = budgetData.getBookId();
        DbUtil.execute((Context)this.ctx, (String)updateStbSql, (Object[])new Object[]{newStbDecimal, leftAmount, standingBookId});
        return standingBookId;
    }

    protected boolean isOverdraw(BigDecimal isEnoughData) {
        return BigDecimal.ZERO.compareTo(isEnoughData) > 0;
    }

    protected Map<String, String> getBudgetSchemeIdAndCurrency(Date oprDate, String templateId) throws BOSException {
        String operateKsqlDate = CmpDateUtil.toKSqlDate(oprDate);
        HashMap<String, String> map = new HashMap<String, String>();
        String schemeSql = " SELECT FID,FCurrencyID FROM T_HR_SCmpBudgetScheme where FTemplateID = '" + templateId + "' and FEffectDate <= " + operateKsqlDate + " and FExpiryDate >= " + operateKsqlDate;
        IRowSet budgetRowSet = DbUtil.executeQuery((Context)this.ctx, (String)schemeSql);
        try {
            while (budgetRowSet.next()) {
                map.put("budgetSchemeId", budgetRowSet.getString("FID"));
                map.put("currencyId", budgetRowSet.getString("FCurrencyID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    protected void doPeriodDeduction(String stbSnCol, String leftSnCol, String budgetSnCol, String budgetItemId) throws EASBizException, BOSException {
        Map<String, Object> budgetDataMap = this.getBudgetAndStandingData(stbSnCol, leftSnCol, budgetSnCol, budgetItemId);
        List leftDataList = (List)budgetDataMap.get("sourceDataList");
        if (!leftDataList.isEmpty()) {
            BigDecimal totalSubBalance = BigDecimal.ZERO;
            BigDecimal expenseHis = BigDecimal.ZERO;
            BigDecimal outerUsedData = BigDecimal.ZERO;
            BigDecimal totalBudget = BigDecimal.ZERO;
            BigDecimal totalBalance = BigDecimal.ZERO;
            BigDecimal totalExpense = BigDecimal.ZERO;
            boolean hasDeduction = false;
            boolean hasLeftDataOfTotal = false;
            for (BudgetAndUsedData dataMap : leftDataList) {
                BigDecimal totalLeft;
                BigDecimal expense = dataMap.getItemMap().get(stbSnCol) == null ? BigDecimal.ZERO : dataMap.getItemMap().get(stbSnCol);
                expenseHis = expenseHis.add(expense);
                outerUsedData = dataMap.getTotalUsedAmount();
                if (dataMap.getItemMap().get(leftSnCol) != null) {
                    hasDeduction = true;
                }
                if ((totalLeft = dataMap.getTotalLeft()) != null) {
                    hasLeftDataOfTotal = true;
                }
                BigDecimal leftData = dataMap.getItemMap().get(leftSnCol) == null ? BigDecimal.ZERO : dataMap.getItemMap().get(leftSnCol);
                totalSubBalance = totalSubBalance.add(leftData);
                totalBudget = dataMap.getTotalBudget() == null ? BigDecimal.ZERO : dataMap.getTotalBudget();
                totalBalance = totalLeft == null ? BigDecimal.ZERO : totalLeft;
                totalExpense = dataMap.getTotalUsed() == null ? BigDecimal.ZERO : dataMap.getTotalUsed();
            }
            outerUsedData = outerUsedData == null ? BigDecimal.ZERO : outerUsedData;
            BigDecimal submitBigDecimalOfSum = this.getTotalDeduction();
            if (hasDeduction) {
                this.checkBudgetEnoughWhenHasLeft(totalSubBalance, submitBigDecimalOfSum);
                if (!this.checkingOnly) {
                    this.deductSubmitData(leftDataList, hasDeduction);
                }
            } else {
                List allSubBudgetDataList = (List)budgetDataMap.get("allSubBudgetDataList");
                this.deductOuterUsedData(budgetSnCol, leftDataList);
                this.checkBudgetEnough(budgetSnCol, leftDataList, expenseHis, submitBigDecimalOfSum);
                if (!this.checkingOnly) {
                    this.deductUsedData(stbSnCol, budgetSnCol, leftDataList);
                    this.deductSubmitData(leftDataList, hasDeduction);
                    this.fillData(budgetSnCol, leftSnCol, leftDataList, allSubBudgetDataList);
                }
            }
            if (this.checkingOnly) {
                return;
            }
            BigDecimal totalLeftData = hasLeftDataOfTotal ? totalBalance.subtract(submitBigDecimalOfSum) : totalBudget.subtract(outerUsedData).subtract(expenseHis).subtract(submitBigDecimalOfSum);
            BigDecimal totalUsedData = submitBigDecimalOfSum.add(totalExpense);
            BudgetAndUsedData rowSetDataMap = (BudgetAndUsedData)leftDataList.get(0);
            String standingBookId = rowSetDataMap.getStandingBookId();
            this.updateStandingBookDataOfDeduct(stbSnCol, budgetSnCol, leftSnCol, leftDataList, totalLeftData, totalUsedData, standingBookId);
            this.updateNullLeftDataSubPeriod(leftSnCol, budgetDataMap);
        }
    }

    protected void updateNullLeftDataSubPeriod(String leftSnCol, Map<String, Object> budgetDataMap) throws BOSException {
        Map subBudgetDataMap = (Map)budgetDataMap.get("subBudgetDataMap");
        if (subBudgetDataMap != null) {
            String updateSql = "update T_HR_SubCmpStandingBook set " + leftSnCol + " = ? where FID = ? and " + leftSnCol + " is null";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (Map.Entry entry : subBudgetDataMap.entrySet()) {
                String subStandingBookId = (String)entry.getKey();
                if (StringUtils.isEmpty((String)subStandingBookId)) continue;
                Object[] paramArr = new Object[2];
                BigDecimal budgetData = (BigDecimal)entry.getValue();
                paramArr[0] = budgetData;
                paramArr[1] = subStandingBookId;
                paramList.add(paramArr);
            }
            DbUtil.executeBatch((Context)this.ctx, (String)updateSql, paramList);
        }
    }

    protected void updateStandingBookDataOfDeduct(String stbSnCol, String budgetSnCol, String leftSnCol, List<BudgetAndUsedData> leftDataList, BigDecimal totalLeftData, BigDecimal totalUsedData, String standingBookId) throws BOSException {
        StringBuilder updateBuilder = new StringBuilder();
        updateBuilder.append("update T_HR_SCmpStandingBook set ").append(stbSnCol).append(" = ?,");
        updateBuilder.append(leftSnCol).append("= ? where FID = ? ");
        DbUtil.execute((Context)this.ctx, (String)updateBuilder.toString(), (Object[])new Object[]{totalUsedData, totalLeftData, standingBookId});
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (BudgetAndUsedData leftMap : leftDataList) {
            Map<String, BigDecimal> itemMap = leftMap.getItemMap();
            BigDecimal leftMapOfLeftData = itemMap.get(budgetSnCol) == null ? BigDecimal.ZERO : itemMap.get(budgetSnCol);
            BigDecimal usedData = itemMap.get(stbSnCol) == null ? BigDecimal.ZERO : itemMap.get(stbSnCol);
            Object[] dbParams = new Object[]{usedData, leftMapOfLeftData, leftMap.getTrueSubStandingBookId()};
            paramList.add(dbParams);
        }
        updateBuilder = new StringBuilder();
        updateBuilder.append("update T_HR_SubCmpStandingBook set ").append(stbSnCol).append(" = ?,");
        updateBuilder.append(leftSnCol).append(" = ? where FID = ?");
        DbUtil.executeBatchAndReturn((Context)this.ctx, (String)updateBuilder.toString(), paramList);
    }

    private void fillData(String budgetSnCol, String leftSnCol, List<BudgetAndUsedData> leftDataList, List<Map<String, Object>> allSubBudgetDataList) {
        String subBudgetQueryId;
        HashSet<String> leftDataIdSet = new HashSet<String>();
        for (BudgetAndUsedData budgetAndUsedData : leftDataList) {
            if (budgetAndUsedData == null || StringUtils.isEmpty((String)(subBudgetQueryId = budgetAndUsedData.getSubBudgetQueryId()))) continue;
            leftDataIdSet.add(subBudgetQueryId);
        }
        for (Map map : allSubBudgetDataList) {
            if (map == null || leftDataIdSet.contains(subBudgetQueryId = (String)map.get("subBudgetQueryId"))) continue;
            BudgetAndUsedData data = new BudgetAndUsedData();
            data.setFromFillData(true);
            data.setBudgetId((String)map.get("budgetId"));
            data.setSubBudgetQueryId((String)map.get("subBudgetQueryId"));
            data.setTrueSubStandingBookId((String)map.get("trueSubStandingBookId"));
            HashMap<String, BigDecimal> itemMap = new HashMap<String, BigDecimal>();
            itemMap.put(budgetSnCol, (BigDecimal)map.get(budgetSnCol));
            itemMap.put(leftSnCol, (BigDecimal)map.get(budgetSnCol));
            data.setItemMap(itemMap);
            leftDataList.add(data);
        }
    }

    protected void deductUsedData(String stbSnCol, String budgetSnCol, List<BudgetAndUsedData> leftDataList) {
        for (BudgetAndUsedData map : leftDataList) {
            Map<String, BigDecimal> itemMap = map.getItemMap();
            BigDecimal budget = itemMap.get(budgetSnCol) == null ? BigDecimal.ZERO : itemMap.get(budgetSnCol);
            BigDecimal expense = itemMap.get(stbSnCol) == null ? BigDecimal.ZERO : itemMap.get(stbSnCol);
            BigDecimal balance = budget.subtract(expense);
            itemMap.put(budgetSnCol, balance);
        }
    }

    protected void checkBudgetEnough(String budgetSnCol, List<BudgetAndUsedData> leftDataList, BigDecimal expenseHis, BigDecimal submitBigDecimalOfSum) throws EASBizException {
        BigDecimal leftBudgetSum = BigDecimal.ZERO;
        for (BudgetAndUsedData map : leftDataList) {
            if (map == null) continue;
            BigDecimal leftBudget = map.getItemMap().get(budgetSnCol);
            leftBudget = leftBudget == null ? BigDecimal.ZERO : leftBudget;
            leftBudgetSum = leftBudgetSum.add(leftBudget);
        }
        this.budgetItemDeductAmount = this.budgetItemDeductAmount.add(submitBigDecimalOfSum);
        BigDecimal totalUsed = this.checkingOnly ? expenseHis.add(this.budgetItemDeductAmount) : expenseHis.add(submitBigDecimalOfSum);
        BigDecimal leftData = leftBudgetSum.subtract(totalUsed);
        if (this.isOverdraw(leftData)) {
            throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label28", (Locale)this.ctx.getLocale())));
        }
    }

    protected void deductOuterUsedData(String budgetSnCol, List<BudgetAndUsedData> leftDataList) {
        for (BudgetAndUsedData data : leftDataList) {
            BigDecimal periodUsedAmount = data.getUsedAmount();
            periodUsedAmount = periodUsedAmount == null ? BigDecimal.ZERO : periodUsedAmount;
            BigDecimal periodBudget = data.getItemMap().get(budgetSnCol);
            periodBudget = periodBudget == null ? BigDecimal.ZERO : periodBudget;
            BigDecimal balance = periodBudget.subtract(periodUsedAmount);
            data.getItemMap().put(budgetSnCol, balance);
        }
    }

    protected abstract void deductSubmitData(List<BudgetAndUsedData> var1, boolean var2) throws BOSException;

    protected abstract BigDecimal getTotalDeduction();

    protected void checkBudgetEnoughWhenHasLeft(BigDecimal totalLeftDataOfSub, BigDecimal submitBigDecimalOfSum) throws EASBizException {
        BigDecimal leftBudget;
        this.budgetItemDeductAmount = this.budgetItemDeductAmount.add(submitBigDecimalOfSum);
        BigDecimal bigDecimal = leftBudget = this.checkingOnly ? totalLeftDataOfSub.subtract(this.budgetItemDeductAmount) : totalLeftDataOfSub.subtract(submitBigDecimalOfSum);
        if (this.isOverdraw(leftBudget)) {
            throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label28", (Locale)this.ctx.getLocale())));
        }
    }

    protected Map<String, Object> getBudgetAndStandingData(String stbSnCol, String leftSnCol, String budgetSnCol, String budgetItemId) throws BOSException, EASBizException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String operateKsqlDate = this.getDeductDate();
        StringBuilder sqlBuilder = new StringBuilder();
        String lan = LocaleUtils.getShortCode((Context)this.ctx);
        sqlBuilder.append(" SELECT s.FState, s.FID as BID,ss.FID as BBID,b.FID as SID,sb.FID as SSID,ss.FPeriod,c.FAmount as usedAmount,cua.FUsedAmount as totalUsedAmount, org.fName_").append(lan).append(" adminOrgUnit,");
        sqlBuilder.append(" s.").append(budgetSnCol).append(" as totalBudget,").append("b.").append(leftSnCol).append(" as totalLeft,b.").append(stbSnCol).append(" as totalUsed ,");
        sqlBuilder.append(" ss.").append(budgetSnCol).append(",sb.").append(stbSnCol).append(",sb.").append(leftSnCol);
        sqlBuilder.append(" FROM T_HR_SSubBudgetQuery ss ");
        sqlBuilder.append(" left join T_HR_SBudgetManage s on s.FID = ss.FBudgetManageID ");
        sqlBuilder.append(" left join T_ORG_Admin org on s.FAdminOrgUnitID = org.fid ");
        sqlBuilder.append(" left join T_HR_SCmpUsedAmount cua on s.FID = cua.FBudgetManageID and cua.FCmpBudgetItemID = '").append(budgetItemId).append("'");
        sqlBuilder.append(" left join T_HR_SCmpBudgetScheme cbs on s.FBudgetSchemeID = cbs.fid ");
        sqlBuilder.append(" left join T_HR_SCmpStandingBook b on b.FBudgetManageID=s.FID ");
        sqlBuilder.append(" left join T_HR_SubCmpStandingBook sb on sb.FCmpStandingBookID=b.FID and sb.FSubBudgetQueryID=ss.FID ");
        sqlBuilder.append(" left join T_HR_SCmpPeriodUsedAmount c on sb.fid = c.FSubStandingBookId and c.FCmpBudgetItemID = '").append(budgetItemId).append("'");
        sqlBuilder.append(" where s.FCostTypeID = '").append(this.getCostTypeId()).append("'");
        sqlBuilder.append(" and s.FAdminOrgUnitID = '").append(this.getCostBearOrgId()).append("'");
        sqlBuilder.append(" and s.FBudgetSchemeID = '").append(this.budgetSchemeId).append("'");
        sqlBuilder.append(" and cbs.FEffectDate <= ").append(operateKsqlDate);
        sqlBuilder.append(" and cbs.FExpiryDate >= ").append(operateKsqlDate);
        if (SubBalanceTypeEnum.NONE == this.budgetScheme.getSubBalanceTypeEnum()) {
            sqlBuilder.append(" and ss.FEffectDate <= ").append(operateKsqlDate);
            sqlBuilder.append(" and ss.FExpiryDate >= ").append(operateKsqlDate);
        } else if (SubBalanceTypeEnum.CUMULATIVE_CHECKOUT == this.budgetScheme.getSubBalanceTypeEnum()) {
            sqlBuilder.append(" and ss.FEffectDate <= ").append(operateKsqlDate);
        }
        sqlBuilder.append(" order by ss.FEffectDate asc,ss.FExpiryDate asc ");
        IRowSet subRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuilder.toString());
        List<BudgetAndUsedData> rowSetDataList = this.rowSet2ListMap(stbSnCol, budgetSnCol, leftSnCol, subRowSet);
        String budgetManageId = "";
        for (BudgetAndUsedData data : rowSetDataList) {
            String budgetId = data.getBudgetId();
            if (StringUtils.isEmpty((String)budgetId)) continue;
            budgetManageId = budgetId;
        }
        BigDecimal subBudgetSum = BigDecimal.ZERO;
        String allSubSqlBuild = " select ss.FID,ss." + budgetSnCol + ",sb.FID as subStandingBookId  FROM T_HR_SSubBudgetQuery ss  left join T_HR_SBudgetManage s on s.FID = ss.FBudgetManageID  left join T_HR_SCmpStandingBook b on b.FBudgetManageID=s.FID  left join T_HR_SubCmpStandingBook sb on sb.FCmpStandingBookID=b.FID and sb.FSubBudgetQueryID=ss.FID  where ss.FBudgetManageID = ?  order by ss.FEffectDate asc,ss.FExpiryDate asc ";
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)allSubSqlBuild, (Object[])new Object[]{budgetManageId});
        HashMap<String, BigDecimal> subBudgetDataMap = new HashMap<String, BigDecimal>();
        ArrayList allSubBudgetDataList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, Object> subBudgetMap = new HashMap<String, Object>();
                BigDecimal data = rowSet.getBigDecimal(budgetSnCol) == null ? BigDecimal.ZERO : rowSet.getBigDecimal(budgetSnCol);
                subBudgetMap.put("budgetId", budgetManageId);
                subBudgetMap.put("subBudgetQueryId", rowSet.getString("FID"));
                String subStandingBookId = rowSet.getString("subStandingBookId");
                subBudgetMap.put("subStandingBookId", subStandingBookId);
                subBudgetMap.put("trueSubStandingBookId", subStandingBookId);
                subBudgetMap.put(budgetSnCol, data);
                allSubBudgetDataList.add(subBudgetMap);
                subBudgetSum = subBudgetSum.add(data);
                subBudgetDataMap.put(subStandingBookId, data);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        returnMap.put("sourceDataList", rowSetDataList);
        returnMap.put("allSubBudgetDataList", allSubBudgetDataList);
        returnMap.put("subBudgetDataMap", subBudgetDataMap);
        return returnMap;
    }

    protected abstract String getCostBearOrgId();

    protected abstract String getCostBearOrgComparator();

    protected abstract String getCompareValue() throws BOSException;

    protected List<BudgetAndUsedData> rowSet2ListMap(String stbSnCol, String budgetSnCol, String leftSnCol, IRowSet subRowSet) throws BOSException, BudgetEASBizException {
        ArrayList<BudgetAndUsedData> rowSetDataList = new ArrayList<BudgetAndUsedData>();
        try {
            while (subRowSet.next()) {
                int state = subRowSet.getInt("FState");
                if (2 == state) {
                    String adminOrgUnitName = subRowSet.getString("adminOrgUnit");
                    throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION36, new Object[]{adminOrgUnitName});
                }
                BudgetAndUsedData data = new BudgetAndUsedData();
                HashMap<String, BigDecimal> itemMap = new HashMap<String, BigDecimal>();
                data.setBudgetId(subRowSet.getString("BID"));
                data.setSubBudgetQueryId(subRowSet.getString("BBID"));
                data.setStandingBookId(subRowSet.getString("SID"));
                data.setSubStandingBookId(subRowSet.getString("SSID"));
                data.setUsedAmount(subRowSet.getBigDecimal("usedAmount"));
                data.setTotalUsedAmount(subRowSet.getBigDecimal("totalUsedAmount"));
                data.setTotalBudget(subRowSet.getBigDecimal("totalBudget"));
                data.setTotalLeft(subRowSet.getBigDecimal("totalLeft"));
                data.setTotalUsed(subRowSet.getBigDecimal("totalUsed"));
                data.setBudgetPeriod(subRowSet.getString("FPeriod"));
                itemMap.put(budgetSnCol, subRowSet.getBigDecimal(budgetSnCol));
                itemMap.put(stbSnCol, subRowSet.getBigDecimal(stbSnCol));
                itemMap.put(leftSnCol, subRowSet.getBigDecimal(leftSnCol));
                data.setItemMap(itemMap);
                rowSetDataList.add(data);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return rowSetDataList;
    }

    protected void setLeftDataListId(List<BudgetAndUsedData> leftDataList) {
        for (BudgetAndUsedData leftDataMap : leftDataList) {
            String subStandingBookId = leftDataMap.getSubStandingBookId();
            String trueSubStandingBookId = StringUtils.isEmpty((String)subStandingBookId) ? BOSUuid.create((String)"81534082").toString() : subStandingBookId;
            leftDataMap.setTrueSubStandingBookId(trueSubStandingBookId);
        }
    }

    protected void updateBookTableDataOfRollback(BudgetTemplateSTBItemInfo templateSTBItemInfo, Map<String, BigDecimal> sumValueForOffsetMap, String splitFlag) throws BOSException {
        int expense = templateSTBItemInfo.getStandingBookItem().getFieldSn();
        int balance = templateSTBItemInfo.getBalanceLedgerItem().getFieldSn();
        String expenseField = "S" + expense;
        String balanceField = "S" + balance;
        String yearlyUpdateSQL = "update T_HR_SCmpStandingBook set " + balanceField + " = " + balanceField + " + ?, " + expenseField + " = " + expenseField + " - ? where fid = ?";
        String periodUpdateSQL = "update T_HR_SubCmpStandingBook set " + balanceField + " = " + balanceField + " + ?, " + expenseField + " = " + expenseField + " - ? where fid = ?";
        ArrayList<Object[]> yearlyUpdateParams = new ArrayList<Object[]>();
        ArrayList<Object[]> periodUpdateParams = new ArrayList<Object[]>();
        for (Map.Entry<String, BigDecimal> data : sumValueForOffsetMap.entrySet()) {
            String key = data.getKey();
            BigDecimal value = data.getValue();
            if (value == null || BigDecimal.ZERO.compareTo(value) == 0) {
                value = BigDecimal.ZERO;
            }
            String[] tableSplit = key.split(splitFlag);
            Object[] yearlyUpdateParam = new Object[]{value, value, tableSplit[0]};
            yearlyUpdateParams.add(yearlyUpdateParam);
            if (BudgetPeriodEnum.YEAR == this.budgetPeriod) continue;
            Object[] periodUpdateParam = new Object[]{value, value, tableSplit[1]};
            periodUpdateParams.add(periodUpdateParam);
        }
        if (!yearlyUpdateParams.isEmpty()) {
            DbUtil.executeBatch((Context)this.ctx, (String)yearlyUpdateSQL, yearlyUpdateParams);
        }
        if (!periodUpdateParams.isEmpty()) {
            DbUtil.executeBatch((Context)this.ctx, (String)periodUpdateSQL, periodUpdateParams);
        }
    }

    protected void updateBookTableDataOfReOffset(BudgetTemplateSTBItemInfo templateSTBItemInfo, Map<String, BigDecimal> sumValueForOffsetMap, String splitFlag) throws BOSException {
        int expense = templateSTBItemInfo.getStandingBookItem().getFieldSn();
        String expenseField = "S" + expense;
        String yearlyUpdateSQL = "update T_HR_SCmpStandingBook set " + expenseField + " = " + expenseField + " - ? where fid = ?";
        String periodUpdateSQL = "update T_HR_SubCmpStandingBook set " + expenseField + " = " + expenseField + " - ? where fid = ?";
        ArrayList<Object[]> yearlyUpdateParams = new ArrayList<Object[]>();
        ArrayList<Object[]> periodUpdateParams = new ArrayList<Object[]>();
        for (Map.Entry<String, BigDecimal> data : sumValueForOffsetMap.entrySet()) {
            String key = data.getKey();
            BigDecimal value = data.getValue();
            if (value == null || BigDecimal.ZERO.compareTo(value) == 0) {
                value = BigDecimal.ZERO;
            }
            String[] tableSplit = key.split(splitFlag);
            Object[] yearlyUpdateParam = new Object[]{value, tableSplit[0]};
            Object[] periodUpdateParam = new Object[2];
            periodUpdateParam[0] = value;
            if (BudgetPeriodEnum.YEAR == this.budgetPeriod) {
                yearlyUpdateParams.add(yearlyUpdateParam);
                continue;
            }
            periodUpdateParam[1] = tableSplit[1];
            yearlyUpdateParams.add(yearlyUpdateParam);
            periodUpdateParams.add(periodUpdateParam);
        }
        if (!yearlyUpdateParams.isEmpty()) {
            DbUtil.executeBatch((Context)this.ctx, (String)yearlyUpdateSQL, yearlyUpdateParams);
        }
        if (!periodUpdateParams.isEmpty()) {
            DbUtil.executeBatch((Context)this.ctx, (String)periodUpdateSQL, periodUpdateParams);
        }
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void setUser(UserInfo user) {
        this.user = user;
    }

    public void setExpenseList(List<ExpenseDetailsVO> expenseList) {
        this.expenseList = expenseList;
    }
}

