/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.budget.impl;

import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.BudgetSnapshotCollection;
import com.kingdee.shr.compensation.app.budget.BudgetSnapshotFactory;
import com.kingdee.shr.compensation.app.budget.BudgetSnapshotInfo;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemInfo;
import com.kingdee.shr.compensation.app.budget.BusinessTypeEnum;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.DataStateEnum;
import com.kingdee.shr.compensation.app.budget.ExpenseDetailsSubmitBillCollection;
import com.kingdee.shr.compensation.app.budget.ExpenseDetailsSubmitBillFactory;
import com.kingdee.shr.compensation.app.budget.ExpenseDetailsSubmitBillInfo;
import com.kingdee.shr.compensation.app.budget.RollBackNodeEnum;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigCollection;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigFactory;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigInfo;
import com.kingdee.shr.compensation.app.budget.UpdateDirectionEnum;
import com.kingdee.shr.compensation.app.budget.UpdateNodeEnum;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.compensation.app.integrate.multiinspire.CostTypeInfo;
import com.kingdee.shr.compensation.currency.CurrencyUtil;
import com.kingdee.shr.compensation.service.budget.BudgetAndUsedData;
import com.kingdee.shr.compensation.service.budget.BudgetData;
import com.kingdee.shr.compensation.service.budget.DeductionParam;
import com.kingdee.shr.compensation.service.budget.DeductionParamSubmitBill;
import com.kingdee.shr.compensation.service.budget.ExpenseDetailsVO;
import com.kingdee.shr.compensation.service.budget.SubmitBillExpenseDetailsVO;
import com.kingdee.shr.compensation.service.budget.impl.AbstractDeductionService;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.budget.BudgetUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.integrate.CmpIntegrateUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class SubmitBillDeductionService
extends AbstractDeductionService {
    private static final Logger LOG = Logger.getLogger(SubmitBillDeductionService.class);
    private SchemeDeduConfigCollection deduConfigCollection;
    private SchemeDeduConfigCollection offsetConfigCollection;
    protected Map<String, BigDecimal> submitSnDataMap = new HashMap<String, BigDecimal>();
    protected Map<String, List<BudgetSnapshotInfo>> snapshotMap = new HashMap<String, List<BudgetSnapshotInfo>>();
    protected List<Map<String, Object>> entryDataList = new ArrayList<Map<String, Object>>();
    protected List<BudgetSnapshotInfo> realSnapshotList = new ArrayList<BudgetSnapshotInfo>();
    protected BudgetSnapshotCollection lastDeductSnapshots;
    private String costBearOrgId;
    private String costTypeId;
    private SchemeDeduConfigInfo deduConfig;
    protected int firstNode;

    @Override
    protected void doDeductionByYear() throws BOSException, EASBizException {
        if (this.deduConfigCollection.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.deduConfigCollection.size(); ++i) {
            SchemeDeduConfigInfo deduConfig = this.deduConfigCollection.get(i);
            String budgetSnCol = "T" + deduConfig.getCmpBudgetItem().getFieldSn();
            String stbSnCol = "S" + deduConfig.getTemplateStbItem().getStandingBookItem().getFieldSn();
            String leftSnCol = "S" + deduConfig.getTemplateStbItem().getBalanceLedgerItem().getFieldSn();
            String budgetItemId = deduConfig.getCmpBudgetItem().getId().toString();
            BudgetData budgetData = this.initBudgetData(this.costBearOrgId, this.costTypeId, budgetSnCol, stbSnCol, leftSnCol, budgetItemId);
            String submitSnCol = "S" + deduConfig.getCalSubmitItem().getFieldSn();
            BigDecimal deductVal = this.submitSnDataMap.get(submitSnCol);
            if (null == deductVal) continue;
            String standingBookId = this.doYearlyDeduction(stbSnCol, leftSnCol, budgetData, deductVal);
            if (this.checkingOnly) continue;
            this.saveSnapshotData(deduConfig.getCmpBudgetItem(), submitSnCol, deduConfig.getTemplateStbItem(), standingBookId, budgetData.getBudgetManageId());
        }
        if (!this.checkingOnly) {
            this.saveOffsetSnapshotData();
        }
    }

    @Override
    protected String getExtendInsertSQL(ExpenseDetailsVO expense, String baseId) {
        SubmitBillExpenseDetailsVO vo = (SubmitBillExpenseDetailsVO)expense;
        return "insert into T_HR_SExpenseDetailsSubmitBill (Fid, FBudgetYear, FSubmitCurrencyId, FSubmitBillEntryId, FSubmitBillId, FBaseId) values (newBosId('FAA57690'), " + expense.getBudgetYear() + ", '" + vo.getSubmitBillCurrencyId() + "', '" + vo.getEntryId() + "', '" + vo.getBillId() + "', '" + baseId + "')";
    }

    @Override
    protected void initLastDeductionSnapshots() throws BOSException {
        if (this.offsetConfigCollection.isEmpty()) {
            return;
        }
        HashSet<String> rels = new HashSet<String>();
        for (int i = 0; i < this.offsetConfigCollection.size(); ++i) {
            rels.add(this.offsetConfigCollection.get(i).getTemplateStbItem().getId().toString());
        }
        this.lastDeductSnapshots = this.getLastDeductSnapshots(rels);
    }

    @Override
    protected void doDeductionByPeriod() throws BOSException, EASBizException {
        if (this.deduConfigCollection.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.deduConfigCollection.size(); ++i) {
            this.deduConfig = this.deduConfigCollection.get(i);
            String budgetSnCol = "T" + this.deduConfig.getCmpBudgetItem().getFieldSn();
            String stbSnCol = "S" + this.deduConfig.getTemplateStbItem().getStandingBookItem().getFieldSn();
            String leftSnCol = "S" + this.deduConfig.getTemplateStbItem().getBalanceLedgerItem().getFieldSn();
            String budgetItemId = this.deduConfig.getCmpBudgetItem().getId().toString();
            this.doPeriodDeduction(stbSnCol, leftSnCol, budgetSnCol, budgetItemId);
        }
        if (this.checkingOnly) {
            return;
        }
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        for (BudgetSnapshotInfo snapshotInfo : this.realSnapshotList) {
            coreBaseCollection.add((CoreBaseInfo)snapshotInfo);
        }
        BudgetSnapshotFactory.getLocalInstance(this.ctx).saveBatchData(coreBaseCollection);
        this.saveOffsetSnapshotData();
    }

    private SubmitBillExpenseDetailsVO copyExpenseDetails(SubmitBillExpenseDetailsVO smtExpense) throws BOSException {
        SubmitBillExpenseDetailsVO newExpense = new SubmitBillExpenseDetailsVO();
        try {
            BeanUtils.copyProperties((Object)newExpense, (Object)smtExpense);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return newExpense;
    }

    protected void saveOffsetSnapshotData() throws BOSException, EASBizException {
        if (this.lastDeductSnapshots == null || this.lastDeductSnapshots.isEmpty()) {
            return;
        }
        CoreBaseCollection offsetSnapshots = new CoreBaseCollection();
        for (int i = 0; i < this.lastDeductSnapshots.size(); ++i) {
            BudgetSnapshotInfo snapshot = this.lastDeductSnapshots.get(i);
            BOSUuid id = snapshot.getId();
            snapshot.setId(BOSUuid.create((BOSObjectType)snapshot.getBOSType()));
            snapshot.setDataState(DataStateEnum.OFFSET);
            snapshot.setUpdateDirection(UpdateDirectionEnum.ADD);
            snapshot.setLastUpdateUser(this.user);
            snapshot.setCreator(this.user);
            snapshot.setCreateTime(this.now);
            snapshot.setLastUpdateTime(this.now);
            snapshot.setDataState(DataStateEnum.OFFSET);
            snapshot.setUpdateDirection(UpdateDirectionEnum.ADD);
            snapshot.setIsOffset(false);
            snapshot.setIsRollback(false);
            snapshot.setIsRollbackOffset(false);
            snapshot.setOffsetSnapshotId(id.toString());
            offsetSnapshots.add((CoreBaseInfo)snapshot);
        }
        BudgetSnapshotFactory.getLocalInstance(this.ctx).saveBatchData(offsetSnapshots);
    }

    protected BudgetSnapshotCollection getLastDeductSnapshots(Set<String> templateStbItemIds) throws BOSException {
        DeductionParamSubmitBill param = (DeductionParamSubmitBill)this.deductionParam;
        String oqlBuilder = " where billEntry.id in " + param.getEntryIdInSql() + " and templateStbItem.id in (" + CmpStrUtil.convertCollectionToSql(templateStbItemIds) + ") and dataState != " + 30 + " order by createTime desc";
        BudgetSnapshotCollection collection = BudgetSnapshotFactory.getLocalInstance(this.ctx).getBudgetSnapshotCollection(oqlBuilder);
        if (collection.isEmpty()) {
            return collection;
        }
        Iterator iterator = collection.iterator();
        HashMap deductionTimeMap = Maps.newHashMap();
        while (iterator.hasNext()) {
            BudgetSnapshotInfo info = (BudgetSnapshotInfo)iterator.next();
            String entryId = info.getBillEntry().getId().toString();
            long createTime = info.getCreateTime().getTime();
            if (info.getDataState() == DataStateEnum.ROLLBACK) {
                if (!deductionTimeMap.containsKey(entryId)) {
                    deductionTimeMap.put(entryId, createTime);
                }
                iterator.remove();
                continue;
            }
            Long newestTime = (Long)deductionTimeMap.get(entryId);
            if (newestTime != null && newestTime.compareTo(createTime) > 0) {
                iterator.remove();
                continue;
            }
            deductionTimeMap.put(entryId, info.getCreateTime().getTime());
        }
        return collection;
    }

    protected void saveSnapshotData(CmpBudgetItemInfo cmpBudgetItem, String submitSnCol, BudgetTemplateSTBItemInfo templateSTBItemInfo, String standingBookId, String budgetManageId) throws BOSException, EASBizException {
        List<BudgetSnapshotInfo> snapshotInfoList = this.snapshotMap.get(submitSnCol);
        if (null == snapshotInfoList) {
            return;
        }
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        CmpBudgetSchemeInfo budgetSchemeInfo = null;
        if (!StringUtils.isEmpty((String)this.budgetSchemeId)) {
            budgetSchemeInfo = new CmpBudgetSchemeInfo();
            budgetSchemeInfo.setId(BOSUuid.read((String)this.budgetSchemeId));
        }
        for (BudgetSnapshotInfo snapshotInfo : snapshotInfoList) {
            if (budgetSchemeInfo != null) {
                snapshotInfo.setBudgetScheme(budgetSchemeInfo);
            }
            snapshotInfo.setBudgetCurrency(this.budgetScheme.getCurrency());
            snapshotInfo.setCmpBudgetItem(cmpBudgetItem);
            snapshotInfo.setStandingBookItem(templateSTBItemInfo.getStandingBookItem());
            snapshotInfo.setBalanceLedgerItem(templateSTBItemInfo.getBalanceLedgerItem());
            snapshotInfo.setTemplateStbItem(templateSTBItemInfo);
            snapshotInfo.setBookTableId(standingBookId);
            snapshotInfo.setCreateTime(this.now);
            snapshotInfo.setLastUpdateTime(this.now);
            snapshotInfo.setCreator(this.user);
            snapshotInfo.setLastUpdateUser(this.user);
            coreBaseCollection.add((CoreBaseInfo)snapshotInfo);
            Optional<ExpenseDetailsVO> optional = this.expenseList.stream().filter(e -> ((SubmitBillExpenseDetailsVO)e).getEntryId().equals(snapshotInfo.getBillEntry().getId().toString())).findFirst();
            if (!optional.isPresent()) continue;
            ExpenseDetailsVO expense = optional.get();
            expense.setStandingBookId(standingBookId);
            expense.setBudgetManageId(budgetManageId);
            Map<String, BigDecimal> expenseMap = expense.getExpenseMap();
            String expenseField = "S" + templateSTBItemInfo.getStandingBookItem().getFieldSn();
            BigDecimal val = expenseMap.computeIfAbsent(expenseField, k -> BigDecimal.ZERO);
            val = val.add(snapshotInfo.getValue());
            expenseMap.put(expenseField, val);
        }
        BudgetSnapshotFactory.getLocalInstance(this.ctx).saveBatchData(coreBaseCollection);
    }

    @Override
    protected boolean isReverseApprove(DeductionParam deductionParam) {
        return RollBackNodeEnum.REVERSE_APPROVE == deductionParam.getRollbackNodeEnum();
    }

    @Override
    protected void doRollback(boolean isReverseApprove) throws BOSException, EASBizException {
        DeductionParamSubmitBill param = (DeductionParamSubmitBill)this.deductionParam;
        Set<String> entries = param.getEntries();
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String entryIdInSql = cmpInSql.createInSqlBaseOnFId(this.ctx, entries);
        for (int i = 0; i < this.deduConfigCollection.size(); ++i) {
            BudgetSnapshotCollection snapshotCollection;
            BudgetTemplateSTBItemInfo templateStbItem;
            SchemeDeduConfigInfo configInfo = this.deduConfigCollection.get(i);
            CalSubmitItemInfo calSubmitItem = configInfo.getCalSubmitItem();
            if (calSubmitItem == null || calSubmitItem.getId() == null) continue;
            String calSubmitItemId = calSubmitItem.getId().toString();
            CmpBudgetItemInfo cmpBudgetItem = configInfo.getCmpBudgetItem();
            if (cmpBudgetItem == null || cmpBudgetItem.getId() == null || (templateStbItem = configInfo.getTemplateStbItem()) == null || templateStbItem.getId() == null || templateStbItem.getStandingBookItem() == null) continue;
            String stdBookItem = "S" + templateStbItem.getStandingBookItem().getFieldSn();
            String templateStbItemId = templateStbItem.getId().toString();
            UpdateNodeEnum updateNodeEnum = this.deductionParam.getUpdateNodeEnum();
            RollBackNodeEnum rollBackNode = configInfo.getRollBackNode();
            boolean isWithdrawInDeApprove = this.isWithdrawInDeApprove(isReverseApprove, rollBackNode);
            if (isWithdrawInDeApprove) {
                updateNodeEnum = UpdateNodeEnum.WITHDRAW;
            }
            if ((snapshotCollection = this.getSnapshotNeedToRollBack(entryIdInSql, cmpBudgetItem.getId().toString(), calSubmitItemId, templateStbItemId)) == null || snapshotCollection.isEmpty()) {
                LOG.error((Object)"=====>\u5f53\u524d\u7684\u914d\u7f6e\u4e0b\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u5feb\u7167\u6570\u636e, \u56de\u6eda\u5904\u7406\u5931\u8d25");
                continue;
            }
            this.budgetPeriod = snapshotCollection.get(0).getBudgetTemplate().getBudgetPeriod();
            int snapshotSize = snapshotCollection.size();
            HashMap<String, BigDecimal> sumValueForOffsetMap = new HashMap<String, BigDecimal>();
            String splitFlag = "###";
            for (int j = 0; j < snapshotSize; ++j) {
                BudgetSnapshotInfo snapshotInfo = snapshotCollection.get(j);
                String bookTableId = snapshotInfo.getBookTableId();
                String subBookTableId = snapshotInfo.getSubBookTableId();
                if (StringUtils.isEmpty((String)bookTableId)) {
                    LOG.error((Object)"=====>bookTableId\u4e3a\u7a7a, \u56de\u6eda\u5904\u7406\u5931\u8d25");
                    continue;
                }
                String key = bookTableId + splitFlag + subBookTableId;
                BigDecimal sumVal = (BigDecimal)sumValueForOffsetMap.get(key);
                if (sumVal == null) {
                    sumVal = BigDecimal.ZERO;
                }
                BigDecimal value = snapshotInfo.getValue() == null ? BigDecimal.ZERO : snapshotInfo.getValue();
                sumVal = sumVal.add(value);
                sumValueForOffsetMap.put(key, sumVal);
            }
            this.updateBookTableDataOfRollback(templateStbItem, sumValueForOffsetMap, splitFlag);
            this.recordRollbackSnapshot(snapshotCollection, updateNodeEnum);
            int deduNode = configInfo.getDeduNode().getValue();
            String reverseOffsetOql = "select calSubmitItem.id, calSubmitItem.fieldSn, cmpBudgetItem.fieldSn, cmpBudgetItem.id, templateStbItem.standingBookItem.id, templateStbItem.standingBookItem.fieldSn, templateStbItem.balanceLedgerItem.fieldSn, templateStbItem.balanceLedgerItem.id where calSubmitScheme = '" + this.deductionParam.getCalSchemeId() + "' and calSubmitItem = '" + calSubmitItemId + "' and cmpBudgetItem = '" + cmpBudgetItem.getId().toString() + "' and offsetNode = " + deduNode;
            SchemeDeduConfigCollection offsetConfigCollection = SchemeDeduConfigFactory.getLocalInstance(this.ctx).getSchemeDeduConfigCollection(reverseOffsetOql);
            if (offsetConfigCollection.isEmpty() && this.isTheFirstNode(deduNode)) {
                CmpInSql<String> inSqlObj = CmpInSqlFactory.getInstance();
                String inSql = inSqlObj.createInSqlBaseOnFId(this.ctx, param.getEntries());
                this.deleteExpenseDetails(inSql);
                continue;
            }
            this.updateExpenseDetailsAfterRollback(stdBookItem, snapshotCollection);
            if (offsetConfigCollection.isEmpty()) continue;
            BudgetSnapshotCollection collection = this.reverseOffsetData(entryIdInSql, offsetConfigCollection.get(0));
            String offsetField = "S" + offsetConfigCollection.get(0).getTemplateStbItem().getStandingBookItem().getFieldSn();
            this.updateExpenseDetails4Offset(offsetField, collection);
        }
    }

    protected boolean isTheFirstNode(int deduNode) {
        return deduNode == this.firstNode;
    }

    protected boolean isWithdrawInDeApprove(boolean isReverseApprove, RollBackNodeEnum rollBackNode) {
        return isReverseApprove && 150 == rollBackNode.getValue();
    }

    protected void updateExpenseDetails4Offset(String offsetField, BudgetSnapshotCollection snapshots) throws BOSException {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object[]> snapshotParams = new ArrayList<Object[]>();
        boolean hasPeriod = this.budgetPeriod != BudgetPeriodEnum.YEAR;
        for (int i = 0; i < snapshots.size(); ++i) {
            Object[] snapshotParam = new Object[]{snapshots.get(i).isIsRollbackOffset() ? 1 : 0, snapshots.get(i).getId().toString()};
            snapshotParams.add(snapshotParam);
            Object[] param = hasPeriod ? new Object[3] : new Object[]{snapshots.get(i).getValue(), snapshots.get(i).getBillEntry().getId().toString()};
            if (hasPeriod) {
                param[2] = snapshots.get(i).getSubBookTableId();
            }
            params.add(param);
        }
        String updateSQL = hasPeriod ? "update T_HR_SExpenseDetailsBase set " + offsetField + " = " + offsetField + " + ? where fid in (select base.fid from T_HR_SExpenseDetailsBase base, T_HR_SExpenseDetailsSubmitBill smt     where base.fid = smt.fBaseId and smt.FSubmitBillEntryId = ? and base.FSubStandingBookId = ?)" : "update T_HR_SExpenseDetailsBase set " + offsetField + " = " + offsetField + " + ? where fid in (select fBaseId from T_HR_SExpenseDetailsSubmitBill where FSubmitBillEntryId = ?)";
        DbUtil.executeBatch((Context)this.ctx, (String)updateSQL, params);
        DbUtil.executeBatch((Context)this.ctx, (String)"update T_HR_SBudgetSnapshot set FIsRollbackOffset = ? where fid = ?", snapshotParams);
    }

    protected void updateExpenseDetailsAfterRollback(String stdBookItem, BudgetSnapshotCollection snapshots) throws BOSException {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        boolean hasPeriod = this.budgetPeriod != BudgetPeriodEnum.YEAR;
        for (int i = 0; i < snapshots.size(); ++i) {
            Object[] param = hasPeriod ? new Object[3] : new Object[]{snapshots.get(i).getValue(), snapshots.get(i).getBillEntry().getId().toString()};
            if (hasPeriod) {
                param[2] = snapshots.get(i).getSubBookTableId();
            }
            params.add(param);
        }
        String updateSQL = hasPeriod ? "update T_HR_SExpenseDetailsBase set " + stdBookItem + " = " + stdBookItem + " - ? where fid in (select base.fid from T_HR_SExpenseDetailsBase base, T_HR_SExpenseDetailsSubmitBill smt     where base.fid = smt.fBaseId and smt.FSubmitBillEntryId = ? and base.FSubStandingBookId = ?)" : "update T_HR_SExpenseDetailsBase set " + stdBookItem + " = " + stdBookItem + " - ? where fid in (select fBaseId from T_HR_SExpenseDetailsSubmitBill where FSubmitBillEntryId = ?)";
        DbUtil.executeBatch((Context)this.ctx, (String)updateSQL, params);
    }

    private void deleteExpenseDetails(String entryIdInSql) throws BOSException {
        String sql = "delete from T_HR_SExpenseDetailsBase where Fid in (select FBaseId from T_HR_SExpenseDetailsSubmitBill where FSubmitBillEntryId in " + entryIdInSql + ")";
        DbUtil.execute((Context)this.ctx, (String)sql);
        sql = "delete from T_HR_SExpenseDetailsSubmitBill where FSubmitBillEntryId in " + entryIdInSql;
        DbUtil.execute((Context)this.ctx, (String)sql);
    }

    protected BudgetSnapshotCollection reverseOffsetData(String entryIdInSql, SchemeDeduConfigInfo offsetConfig) throws BOSException, EASBizException {
        BudgetSnapshotCollection collection = new BudgetSnapshotCollection();
        CalSubmitItemInfo calSubmitItemOffset = offsetConfig.getCalSubmitItem();
        if (calSubmitItemOffset == null || calSubmitItemOffset.getId() == null) {
            return collection;
        }
        String calSubmitItemId = calSubmitItemOffset.getId().toString();
        CmpBudgetItemInfo cmpBudgetItemOffset = offsetConfig.getCmpBudgetItem();
        if (cmpBudgetItemOffset == null || cmpBudgetItemOffset.getId() == null) {
            return collection;
        }
        BudgetTemplateSTBItemInfo templateStbItemOffset = offsetConfig.getTemplateStbItem();
        if (templateStbItemOffset == null || templateStbItemOffset.getId() == null || templateStbItemOffset.getStandingBookItem() == null) {
            return collection;
        }
        BudgetSnapshotCollection snapshotNeedToReverseOffset = this.getSnapshotNeedToReverseOffset(entryIdInSql, cmpBudgetItemOffset.getId().toString(), calSubmitItemId, templateStbItemOffset.getId().toString());
        String reSplitFlag = "###";
        HashMap<String, BigDecimal> sumValueForReOffsetMap = new HashMap<String, BigDecimal>();
        for (int k = 0; k < snapshotNeedToReverseOffset.size(); ++k) {
            BudgetSnapshotInfo snapshotInfo = snapshotNeedToReverseOffset.get(k);
            String bookTableId = snapshotInfo.getBookTableId();
            String subBookTableId = snapshotInfo.getSubBookTableId();
            if (StringUtils.isEmpty((String)bookTableId) && StringUtils.isEmpty((String)subBookTableId)) continue;
            String key = bookTableId + reSplitFlag + subBookTableId;
            BigDecimal sumVal = (BigDecimal)sumValueForReOffsetMap.get(key);
            if (sumVal == null) {
                sumVal = BigDecimal.ZERO;
            }
            BigDecimal value = snapshotInfo.getValue() == null ? BigDecimal.ZERO : snapshotInfo.getValue();
            sumVal = sumVal.subtract(value);
            sumValueForReOffsetMap.put(key, sumVal);
            snapshotInfo.setIsRollbackOffset(true);
            collection.add(snapshotInfo);
        }
        this.updateBookTableDataOfReOffset(templateStbItemOffset, sumValueForReOffsetMap, reSplitFlag);
        this.recordReOffsetSnapshot(snapshotNeedToReverseOffset);
        return collection;
    }

    protected void recordReOffsetSnapshot(BudgetSnapshotCollection snapshotCollection) throws BOSException, EASBizException {
        CoreBaseCollection updateSnapshotColl = new CoreBaseCollection();
        for (int j = 0; j < snapshotCollection.size(); ++j) {
            BudgetSnapshotInfo snapshotInfo = snapshotCollection.get(j);
            if (!snapshotInfo.isIsRollbackOffset()) continue;
            snapshotInfo.setLastUpdateTime(this.now);
            snapshotInfo.setLastUpdateUser(this.user);
            updateSnapshotColl.add((CoreBaseInfo)snapshotInfo);
        }
        if (updateSnapshotColl.size() > 0) {
            BudgetSnapshotFactory.getLocalInstance(this.ctx).saveBatchData(updateSnapshotColl);
        }
    }

    protected BudgetSnapshotCollection getSnapshotNeedToReverseOffset(String entryIdInSql, String budgetItemId, String calSubmitItemId, String templateStbItemId) throws BOSException {
        String oqlBuilder = "where calSubmitScheme.id ='" + this.deductionParam.getCalSchemeId() + "' and cmpBudgetItem.id = '" + budgetItemId + "' and calSubmitItem.id = '" + calSubmitItemId + "' and templateStbItem.id ='" + templateStbItemId + "' and billEntry.id in " + entryIdInSql + " and dataState = " + 30 + " and isOffset = 1  and (isRollbackOffset = 0 or isRollbackOffset is null) ";
        return BudgetSnapshotFactory.getLocalInstance(this.ctx).getBudgetSnapshotCollection(oqlBuilder);
    }

    protected void recordRollbackSnapshot(BudgetSnapshotCollection snapshotCollection, UpdateNodeEnum updateNodeEnum) throws BOSException, EASBizException {
        CoreBaseCollection insertCoreBaseColl = new CoreBaseCollection();
        for (int j = 0; j < snapshotCollection.size(); ++j) {
            BudgetSnapshotInfo snapshotInfo = snapshotCollection.get(j);
            snapshotInfo.setId(null);
            snapshotInfo.setCreateTime(this.now);
            snapshotInfo.setLastUpdateTime(this.now);
            snapshotInfo.setDataState(DataStateEnum.ROLLBACK);
            snapshotInfo.setUpdateDirection(UpdateDirectionEnum.ADD);
            snapshotInfo.setUpdateNode(updateNodeEnum);
            snapshotInfo.setIsOffset(false);
            snapshotInfo.setIsRollback(true);
            snapshotInfo.setIsRollbackOffset(false);
            snapshotInfo.setCreator(this.user);
            snapshotInfo.setLastUpdateUser(this.user);
            insertCoreBaseColl.add((CoreBaseInfo)snapshotInfo);
        }
        if (insertCoreBaseColl.size() > 0) {
            BudgetSnapshotFactory.getLocalInstance(this.ctx).saveBatchData(insertCoreBaseColl);
        }
    }

    protected BudgetSnapshotCollection getSnapshotNeedToRollBack(String entryIdInSql, String budgetItemId, String calSubmitItemId, String templateStbItemId) throws BOSException {
        String oqlBuilder = "select *, budgetTemplate.budgetPeriod where calSubmitScheme.id ='" + this.deductionParam.getCalSchemeId() + "' and cmpBudgetItem.id = '" + budgetItemId + "' and calSubmitItem.id = '" + calSubmitItemId + "' and templateStbItem.id ='" + templateStbItemId + "' and billEntry.id in " + entryIdInSql + " and dataState != " + 30 + " order by createTime desc";
        BudgetSnapshotCollection collection = BudgetSnapshotFactory.getLocalInstance(this.ctx).getBudgetSnapshotCollection(oqlBuilder);
        if (collection.isEmpty()) {
            return collection;
        }
        Iterator iterator = collection.iterator();
        HashMap deductionTimeMap = Maps.newHashMap();
        while (iterator.hasNext()) {
            BudgetSnapshotInfo info = (BudgetSnapshotInfo)iterator.next();
            String entryId = info.getBillEntry().getId().toString();
            long createTime = info.getCreateTime().getTime();
            if (info.getDataState() == DataStateEnum.ROLLBACK) {
                if (!deductionTimeMap.containsKey(entryId)) {
                    deductionTimeMap.put(entryId, createTime);
                }
                iterator.remove();
                continue;
            }
            Long newestTime = (Long)deductionTimeMap.get(entryId);
            if (newestTime != null && newestTime.compareTo(createTime) > 0) {
                iterator.remove();
                continue;
            }
            deductionTimeMap.put(entryId, info.getCreateTime().getTime());
        }
        return collection;
    }

    @Override
    protected boolean loadRollbackDeduConfigInfo(boolean isReverseApprove) throws BOSException {
        this.initFirstNode();
        String deductOql = "select calSubmitItem.id, calSubmitItem.fieldSn, deduNode, rollBackNode,  cmpBudgetItem.fieldSn, cmpBudgetItem.id, calSubmitScheme.budgetTemplate.budgetPeriod,  templateStbItem.standingBookItem.id, templateStbItem.standingBookItem.fieldSn, templateStbItem.balanceLedgerItem.fieldSn, templateStbItem.balanceLedgerItem.id where calSubmitScheme = '" + this.deductionParam.getCalSchemeId() + "'";
        deductOql = isReverseApprove ? deductOql + " and rollBackNode in (150,250) order by rollBackNode desc" : deductOql + " and rollBackNode = " + this.deductionParam.getRollbackNodeEnum().getValue();
        this.deduConfigCollection = SchemeDeduConfigFactory.getLocalInstance(this.ctx).getSchemeDeduConfigCollection(deductOql);
        return this.deduConfigCollection != null && !this.deduConfigCollection.isEmpty();
    }

    private void initFirstNode() throws BOSException {
        String minNodeSQL = "select min(fDeduNode) deduNode from T_HR_SSchemeDeduConfig where FCalSubmitSchemeID = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)minNodeSQL, (Object[])new Object[]{this.deductionParam.getCalSchemeId()});
            while (rs.next()) {
                this.firstNode = rs.getInt("deduNode");
            }
        }
        catch (BOSException | SQLException e) {
            throw new BOSException(e);
        }
    }

    @Override
    protected void loadDeductionAndSnapshot() throws BOSException {
        String billId = this.deductionParam.getBillId();
        String submitSchemeId = this.deductionParam.getCalSchemeId();
        String dynamicEntryTableName = CmpIntegrateUtils.getCalShemeTableName(this.ctx, submitSchemeId);
        HashMap<String, String> submitSnIdMap = new HashMap<String, String>();
        HashSet<String> submitItemFields = new HashSet<String>();
        StringBuilder querySubmitItemFields = new StringBuilder();
        for (int i = 0; i < this.deduConfigCollection.size(); ++i) {
            SchemeDeduConfigInfo deduConfig = this.deduConfigCollection.get(i);
            int fieldSn = deduConfig.getCalSubmitItem().getFieldSn();
            String key = "S" + fieldSn;
            if (submitItemFields.contains(key)) continue;
            submitItemFields.add(key);
            querySubmitItemFields.append(",entry.").append(key);
            submitSnIdMap.put(key, deduConfig.getCalSubmitItem().getId().toString());
        }
        String exchangeTableId = this.getExChangeTableId(submitSchemeId);
        IRowSet entryRowSet = this.getBillEntryData(billId, dynamicEntryTableName, querySubmitItemFields);
        this.prepareDeductionAndSnapshot(submitSnIdMap, submitItemFields, exchangeTableId, entryRowSet);
    }

    @Override
    protected void executeOffSet() throws BOSException, EASBizException {
        if (null == this.offsetConfigCollection || this.offsetConfigCollection.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.offsetConfigCollection.size(); ++i) {
            SchemeDeduConfigInfo configInfo = this.offsetConfigCollection.get(i);
            BudgetTemplateSTBItemInfo templateStbItem = configInfo.getTemplateStbItem();
            CalSubmitItemInfo submitItem = configInfo.getCalSubmitItem();
            BOSUuid cmpBudgetItemId = configInfo.getCmpBudgetItem().getId();
            BudgetSnapshotCollection snapshotCollection = this.filterByNode(this.lastDeductSnapshots, submitItem);
            int snapshotSize = snapshotCollection.size();
            HashMap<String, BigDecimal> sumValueForOffsetMap = new HashMap<String, BigDecimal>();
            String splitFlag = "###";
            for (int j = 0; j < snapshotSize; ++j) {
                BudgetSnapshotInfo snapshotInfo = snapshotCollection.get(j);
                String bookTableId = snapshotInfo.getBookTableId();
                String subBookTableId = snapshotInfo.getSubBookTableId();
                if (StringUtils.isEmpty((String)bookTableId)) continue;
                String key = bookTableId + splitFlag + subBookTableId;
                BigDecimal sumVal = (BigDecimal)sumValueForOffsetMap.get(key);
                if (sumVal == null) {
                    sumVal = BigDecimal.ZERO;
                }
                BigDecimal value = snapshotInfo.getValue() == null ? BigDecimal.ZERO : snapshotInfo.getValue();
                sumVal = sumVal.add(value);
                sumValueForOffsetMap.put(key, sumVal);
                snapshotInfo.setIsOffset(true);
            }
            this.updateBookTableDataOfReOffset(templateStbItem, sumValueForOffsetMap, splitFlag);
            String stdField = "S" + templateStbItem.getStandingBookItem().getFieldSn();
            this.recordOffsetSnapshot(snapshotCollection, stdField, cmpBudgetItemId);
        }
    }

    private BudgetSnapshotCollection filterByNode(BudgetSnapshotCollection lastDeductSnapshots, CalSubmitItemInfo submitItem) {
        if (lastDeductSnapshots == null || lastDeductSnapshots.isEmpty()) {
            return new BudgetSnapshotCollection();
        }
        BudgetSnapshotCollection collection = new BudgetSnapshotCollection();
        for (int i = 0; i < lastDeductSnapshots.size(); ++i) {
            if (!lastDeductSnapshots.get(i).getCalSubmitItem().getId().equals((Object)submitItem.getId())) continue;
            collection.add(lastDeductSnapshots.get(i));
        }
        return collection;
    }

    protected void recordOffsetSnapshot(BudgetSnapshotCollection snapshotCollection, String stdField, BOSUuid cmpBudgetItemId) throws BOSException, EASBizException {
        CoreBaseCollection updateSnapshotColl = new CoreBaseCollection();
        boolean havingPeriods = this.budgetTemplate.getBudgetPeriod() != BudgetPeriodEnum.YEAR;
        for (int j = 0; j < snapshotCollection.size(); ++j) {
            BudgetSnapshotInfo snapshotInfo = snapshotCollection.get(j);
            snapshotInfo.setLastUpdateTime(this.now);
            snapshotInfo.setLastUpdateUser(this.user);
            updateSnapshotColl.add((CoreBaseInfo)snapshotInfo);
            BigDecimal offsetVal = snapshotInfo.getValue() == null ? BigDecimal.ZERO : snapshotInfo.getValue();
            Optional<ExpenseDetailsVO> optional = this.expenseList.stream().filter(e -> {
                SubmitBillExpenseDetailsVO smt = (SubmitBillExpenseDetailsVO)e;
                if (havingPeriods) {
                    return smt.getEntryId().equals(snapshotInfo.getBillEntry().getId().toString()) && snapshotInfo.getSubBookTableId().equals(smt.getSubStandingBookId());
                }
                return smt.getEntryId().equals(snapshotInfo.getBillEntry().getId().toString());
            }).findFirst();
            if (!optional.isPresent()) continue;
            ExpenseDetailsVO expenseDetailsVO = optional.get();
            BigDecimal val = expenseDetailsVO.getExpenseMap().get(stdField);
            BigDecimal bigDecimal = val = val == null ? BigDecimal.ZERO : val;
            if (!cmpBudgetItemId.equals((Object)snapshotInfo.getCmpBudgetItem().getId())) continue;
            expenseDetailsVO.getExpenseMap().put(stdField, val.subtract(offsetVal));
        }
        if (updateSnapshotColl.size() > 0) {
            BudgetSnapshotFactory.getLocalInstance(this.ctx).saveBatchData(updateSnapshotColl);
        }
    }

    protected void prepareDeductionAndSnapshot(Map<String, String> submitSnIdMap, Set<String> submitItemFields, String exchangeTableId, IRowSet entryRowSet) throws BOSException {
        String currencyId = this.budgetScheme.getCurrency().getId().toString();
        HashMap<String, ExchangeRateInfo> rateInfoMap = new HashMap<String, ExchangeRateInfo>();
        try {
            this.expenseList = this.loadExpenseList();
            HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
            while (entryRowSet.next()) {
                String entryId = entryRowSet.getString("FID");
                String currencyIdEntry = entryRowSet.getString("FCURRENCYID");
                String cmpEmpORelationId = entryRowSet.getString("FCmpEmpORelationId");
                String costBearOrgID = entryRowSet.getString("FCostBearOrgID");
                String personId = entryRowSet.getString("FPersonId");
                HashMap<String, Object> entryMap = new HashMap<String, Object>();
                entryMap.put("entryId", entryId);
                this.initExpense(entryId, cmpEmpORelationId, currencyIdEntry, costBearOrgID, personId);
                for (String submitItemField : submitItemFields) {
                    BigDecimal entryData;
                    BigDecimal bigDecimal = entryData = entryRowSet.getBigDecimal(submitItemField) == null ? BigDecimal.ZERO : entryRowSet.getBigDecimal(submitItemField);
                    if (entryData.compareTo(BigDecimal.ZERO) == 0) continue;
                    String submitItemId = submitSnIdMap.get(submitItemField);
                    BigDecimal snSumData = this.submitSnDataMap.get(submitItemField) == null ? BigDecimal.ZERO : this.submitSnDataMap.get(submitItemField);
                    BigDecimal realVal = entryData;
                    BigDecimal rate = BigDecimal.ONE;
                    ArrayList<BudgetSnapshotInfo> snapshotInfoList = this.snapshotMap.get(submitItemField) == null ? new ArrayList<BudgetSnapshotInfo>() : this.snapshotMap.get(submitItemField);
                    BudgetSnapshotInfo snapshotInfo = this.initSnapshot(entryRowSet, entryId, currencyIdEntry, submitItemId);
                    snapshotInfoList.add(snapshotInfo);
                    if (StringUtils.isEmpty((String)currencyIdEntry) || StringUtils.isEmpty((String)exchangeTableId)) {
                        snSumData = snSumData.add(entryData);
                    } else {
                        ExchangeRateInfo exchangeRateInfo;
                        if (rateInfoMap.containsKey(currencyIdEntry)) {
                            exchangeRateInfo = (ExchangeRateInfo)rateInfoMap.get(currencyIdEntry);
                        } else {
                            exchangeRateInfo = CurrencyUtil.getClosestExchangeRate(this.ctx, exchangeTableId, currencyId, currencyIdEntry, this.now);
                            rateInfoMap.put(currencyIdEntry, exchangeRateInfo);
                        }
                        if (exchangeRateInfo == null) {
                            snSumData = snSumData.add(entryData);
                        } else {
                            BigDecimal convertRate = exchangeRateInfo.getConvertRate();
                            int scale = entryData.scale();
                            BigDecimal afterRateData = entryData.multiply(convertRate).setScale(scale, RoundingMode.HALF_UP);
                            snSumData = snSumData.add(afterRateData);
                            realVal = afterRateData;
                            rate = convertRate;
                        }
                    }
                    snapshotInfo.setRate(rate);
                    snapshotInfo.setValue(realVal);
                    this.submitSnDataMap.put(submitItemField, snSumData);
                    this.snapshotMap.put(submitItemField, snapshotInfoList);
                    entryMap.put(submitItemField, realVal);
                    rateMap.put(entryId, rate);
                }
                this.entryDataList.add(entryMap);
            }
            this.setRate4Expense(rateMap);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void setRate4Expense(Map<String, BigDecimal> rateMap) {
        this.expenseList.forEach(e -> {
            SubmitBillExpenseDetailsVO vo = (SubmitBillExpenseDetailsVO)e;
            e.setRate((BigDecimal)rateMap.get(vo.getEntryId()));
        });
    }

    protected List<ExpenseDetailsVO> loadExpenseList() throws BOSException {
        DeductionParamSubmitBill param = (DeductionParamSubmitBill)this.deductionParam;
        String oql = "select submitBillEntry, submitBill.id, submitCurrency.id, budgetYear, base.person.id,  base.subStandingBook.id, base.id, base.cmpEmpORelation.id, base.budgetTemplate.id, base.budgetScheme.id, base.budgetManage.id, base.costBearOrg.id, base.costType.id, base.currency.id, base.standingBook.id, base.subBudgetQuery.id where submitBillEntry in " + param.getEntryIdInSql() + " and budgetYear = " + this.budgetYear + " and base.budgetYear = " + this.budgetYear;
        ExpenseDetailsSubmitBillCollection expenseList = ExpenseDetailsSubmitBillFactory.getLocalInstance(this.ctx).getExpenseDetailsSubmitBillCollection(oql);
        ArrayList<ExpenseDetailsVO> list = new ArrayList<ExpenseDetailsVO>();
        if (expenseList.isEmpty()) {
            return list;
        }
        for (int i = 0; i < expenseList.size(); ++i) {
            ExpenseDetailsSubmitBillInfo info = expenseList.get(i);
            SubmitBillExpenseDetailsVO vo = new SubmitBillExpenseDetailsVO();
            vo.setEntryId(info.getSubmitBillEntry());
            vo.setBillId(info.getSubmitBill().getId().toString());
            vo.setSubmitBillCurrencyId(info.getSubmitCurrency().getId().toString());
            vo.setBudgetYear(info.getBudgetYear());
            vo.setSubStandingBookId(info.getBase().getSubStandingBook() == null ? null : info.getBase().getSubStandingBook().getId().toString());
            vo.setId(info.getBase().getId().toString());
            if (null != info.getBase().getPerson() && null != info.getBase().getPerson().getId()) {
                vo.setPersonId(info.getBase().getPerson().getId().toString());
            }
            vo.setCmpEmpORelationId(info.getBase().getCmpEmpORelation().getId().toString());
            vo.setBudgetTemplateId(info.getBase().getBudgetTemplate().getId().toString());
            vo.setBudgetSchemeId(info.getBase().getBudgetScheme().getId().toString());
            vo.setBudgetManageId(info.getBase().getBudgetManage().getId().toString());
            vo.setCostBearOrgId(info.getBase().getCostBearOrg().getId().toString());
            vo.setCostTypeId(info.getBase().getCostType().getId().toString());
            vo.setCurrencyId(info.getBase().getCurrency().getId().toString());
            vo.setStandingBookId(info.getBase().getStandingBook().getId().toString());
            vo.setSubBudgetQueryId(info.getBase().getSubBudgetQuery() == null ? null : info.getBase().getSubBudgetQuery().getId().toString());
            list.add(vo);
        }
        return list;
    }

    private void initExpense(String entryId, String cmpEmpORelationId, String entryCurrency, String costBearOrgId, String personId) {
        Optional<ExpenseDetailsVO> optional = this.expenseList.stream().filter(e -> {
            SubmitBillExpenseDetailsVO vo = (SubmitBillExpenseDetailsVO)e;
            return vo.getEntryId().equals(entryId);
        }).findAny();
        if (optional.isPresent()) {
            return;
        }
        SubmitBillExpenseDetailsVO expense = new SubmitBillExpenseDetailsVO();
        expense.setBillId(this.deductionParam.getBillId());
        expense.setEntryId(entryId);
        expense.setBudgetYear(this.budgetScheme.getBudgetYear());
        expense.setBudgetSchemeId(this.budgetSchemeId);
        expense.setBudgetTemplateId(this.budgetTemplateId);
        expense.setCostTypeId(this.costTypeId);
        expense.setPersonId(personId);
        expense.setCmpEmpORelationId(cmpEmpORelationId);
        expense.setCostBearOrgId(costBearOrgId);
        expense.setCurrencyId(this.budgetScheme.getCurrency().getId().toString());
        expense.setSubmitBillCurrencyId(entryCurrency);
        this.expenseList.add(expense);
    }

    private BudgetSnapshotInfo initSnapshot(IRowSet entryRowSet, String entryId, String currencyIdEntry, String submitItemId) throws SQLException {
        BudgetSnapshotInfo snapshotInfo = new BudgetSnapshotInfo();
        this.setSubmitSchemeInfo(snapshotInfo);
        this.setSubmitItemInfo(submitItemId, snapshotInfo);
        this.setBillInfo(this.deductionParam.getBillId(), snapshotInfo);
        this.setBillEntryInfo(entryId, snapshotInfo);
        this.setPersonInfo(entryRowSet, snapshotInfo);
        this.setAdminOrgUnitInfo(entryRowSet, snapshotInfo);
        this.setBudgetYear(entryRowSet, snapshotInfo);
        this.setCostBearOrgInfo(entryRowSet, snapshotInfo);
        this.setCostTypeInfo(entryRowSet, snapshotInfo);
        this.setBusinessType(entryRowSet, snapshotInfo);
        this.setHrOrgInfo(entryRowSet, snapshotInfo);
        this.setCurrencyInfo(currencyIdEntry, snapshotInfo);
        snapshotInfo.setIsRollback(false);
        snapshotInfo.setIsOffset(false);
        snapshotInfo.setIsRollbackOffset(false);
        snapshotInfo.setBudgetTemplate(this.budgetTemplate);
        snapshotInfo.setUpdateNode(this.deductionParam.getUpdateNodeEnum());
        snapshotInfo.setDataState(DataStateEnum.DEDUCT);
        this.setUpdateDirection(DataStateEnum.DEDUCT, snapshotInfo);
        snapshotInfo.setBudgetCurrency(this.budgetScheme.getCurrency());
        snapshotInfo.setCreator(this.user);
        snapshotInfo.setCreateTime(this.now);
        snapshotInfo.setBudgetScheme(this.budgetScheme);
        snapshotInfo.setLastUpdateTime(this.now);
        snapshotInfo.setLastUpdateUser(this.user);
        return snapshotInfo;
    }

    private void setBudgetYear(IRowSet entryRowSet, BudgetSnapshotInfo snapshotInfo) throws SQLException {
        int budgetYear = entryRowSet.getInt("FBudgetYear");
        snapshotInfo.setBudgetYear(budgetYear);
    }

    private void setUpdateDirection(DataStateEnum dataStateEnum, BudgetSnapshotInfo snapshotInfo) {
        if (dataStateEnum != null) {
            if (10 == dataStateEnum.getValue()) {
                snapshotInfo.setUpdateDirection(UpdateDirectionEnum.SUBTRACT);
            } else if (20 == dataStateEnum.getValue()) {
                snapshotInfo.setUpdateDirection(UpdateDirectionEnum.ADD);
            } else if (30 == dataStateEnum.getValue()) {
                snapshotInfo.setUpdateDirection(UpdateDirectionEnum.ADD);
            }
        }
    }

    private void setBusinessType(IRowSet entryRowSet, BudgetSnapshotInfo snapshotInfo) throws SQLException {
        int submitSchemeType = entryRowSet.getInt("FSubmitSchemeType");
        BusinessTypeEnum businessTypeEnum = null;
        if (submitSchemeType == 1) {
            businessTypeEnum = BusinessTypeEnum.SUBMIT_MANAGE;
        } else if (submitSchemeType == 2) {
            businessTypeEnum = BusinessTypeEnum.INSPIRE_MANAGE;
        } else if (submitSchemeType == 3) {
            businessTypeEnum = BusinessTypeEnum.ADJUST_SALARY_MANAGE;
        }
        snapshotInfo.setBusinessType(businessTypeEnum);
    }

    private void setCostTypeInfo(IRowSet entryRowSet, BudgetSnapshotInfo snapshotInfo) throws SQLException {
        String costTypeID = entryRowSet.getString("FCostTypeID");
        if (!StringUtils.isEmpty((String)costTypeID)) {
            CostTypeInfo costTypeInfo = new CostTypeInfo();
            costTypeInfo.setId(BOSUuid.read((String)costTypeID));
            snapshotInfo.setCostType(costTypeInfo);
        }
    }

    private void setCostBearOrgInfo(IRowSet entryRowSet, BudgetSnapshotInfo snapshotInfo) throws SQLException {
        String costBearOrgID = entryRowSet.getString("FCostBearOrgID");
        if (!StringUtils.isEmpty((String)costBearOrgID)) {
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)costBearOrgID));
            snapshotInfo.setCostBearOrg(adminOrgUnitInfo);
        }
    }

    private void setAdminOrgUnitInfo(IRowSet entryRowSet, BudgetSnapshotInfo snapshotInfo) throws SQLException {
        String adminOrgUnitID = entryRowSet.getString("FAdminOrgUnitID");
        if (!StringUtils.isEmpty((String)adminOrgUnitID)) {
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)adminOrgUnitID));
            snapshotInfo.setAdminOrgUnit(adminOrgUnitInfo);
        }
    }

    private void setCurrencyInfo(String currencyIdEntry, BudgetSnapshotInfo snapshotInfo) {
        if (!StringUtils.isEmpty((String)currencyIdEntry)) {
            CurrencyInfo currencyInfo = new CurrencyInfo();
            currencyInfo.setId(BOSUuid.read((String)currencyIdEntry));
            snapshotInfo.setCurrency(currencyInfo);
        }
    }

    private void setHrOrgInfo(IRowSet entryRowSet, BudgetSnapshotInfo snapshotInfo) throws SQLException {
        String hrOrgUnitId = entryRowSet.getString("FHROrgUnitID");
        HROrgUnitInfo hrOrgUnit = null;
        if (!StringUtils.isEmpty((String)hrOrgUnitId)) {
            hrOrgUnit = new HROrgUnitInfo();
            hrOrgUnit.setId(BOSUuid.read((String)hrOrgUnitId));
        }
        snapshotInfo.setHrOrgUnit(hrOrgUnit);
    }

    private void setBillInfo(String billId, BudgetSnapshotInfo snapshotInfo) {
        BatchSubmitShemeBillInfo submitSchemeBill = null;
        if (!StringUtils.isEmpty((String)billId)) {
            submitSchemeBill = new BatchSubmitShemeBillInfo();
            submitSchemeBill.setId(BOSUuid.read((String)billId));
        }
        snapshotInfo.setSubmitShemeBill(submitSchemeBill);
        snapshotInfo.setBill(submitSchemeBill);
    }

    private void setSubmitItemInfo(String submitItemId, BudgetSnapshotInfo snapshotInfo) {
        CalSubmitItemInfo calSubmitItemInfo = null;
        if (!StringUtils.isEmpty((String)submitItemId)) {
            calSubmitItemInfo = new CalSubmitItemInfo();
            calSubmitItemInfo.setId(BOSUuid.read((String)submitItemId));
        }
        snapshotInfo.setCalSubmitItem(calSubmitItemInfo);
        snapshotInfo.setItem(calSubmitItemInfo);
    }

    private void setSubmitSchemeInfo(BudgetSnapshotInfo snapshotInfo) {
        CalSubmitSchemeInfo calSubmitSchemeInfo = null;
        String submitSchemeId = this.deductionParam.getCalSchemeId();
        if (!StringUtils.isEmpty((String)submitSchemeId)) {
            calSubmitSchemeInfo = new CalSubmitSchemeInfo();
            calSubmitSchemeInfo.setId(BOSUuid.read((String)submitSchemeId));
        }
        snapshotInfo.setCalSubmitScheme(calSubmitSchemeInfo);
        snapshotInfo.setScheme(calSubmitSchemeInfo);
    }

    private void setBillEntryInfo(String entryId, BudgetSnapshotInfo snapshotInfo) {
        BatchSubmitShemeBillEntryInfo billEntryInfo = null;
        if (!StringUtils.isEmpty((String)entryId)) {
            billEntryInfo = new BatchSubmitShemeBillEntryInfo();
            billEntryInfo.setId(BOSUuid.read((String)entryId));
        }
        snapshotInfo.setSubmitShemeBillEntry(billEntryInfo);
        snapshotInfo.setBillEntry(billEntryInfo);
    }

    private void setPersonInfo(IRowSet entryRowSet, BudgetSnapshotInfo snapshotInfo) throws SQLException {
        String personId = entryRowSet.getString("FpersonId");
        if (!StringUtils.isEmpty((String)personId)) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personId));
            snapshotInfo.setPerson(personInfo);
        }
    }

    protected IRowSet getBillEntryData(String billId, String dynamicEntryTableName, StringBuilder snBuilder) throws BOSException {
        DeductionParamSubmitBill param = (DeductionParamSubmitBill)this.deductionParam;
        String billEntrySqlBuild = " select ceo.FPersonId, bill.FBudgetYear, entry.FID,entry.FAdminOrgUnitID,entry.FBILLID,entry.FPersonId,entry.FCURRENCYID, entry.FCmpEmpORelationId, bill.FHROrgUnitID,bill.FCostBearOrgID,bill.FCostTypeID, s.FSubmitSchemeType " + snBuilder + " FROM " + dynamicEntryTableName + " as entry left join T_HR_SBatchSubmitShemeBill bill on bill.FID = entry.FBILLID  left join T_HR_SCmpEmpORelation ceo on entry.FCmpEmpORelationID = ceo.Fid  left join T_HR_SCalSubmitScheme s on s.FID = bill.FSubmitSchemeID  where entry.FBillID = ?  and entry.FID in " + param.getEntryIdInSql();
        Object[] sqlParam = new Object[]{billId};
        return DbUtil.executeQuery((Context)this.ctx, (String)billEntrySqlBuild, (Object[])sqlParam);
    }

    protected String getExChangeTableId(String submitSchemeId) throws BOSException {
        String queryExchangeTbSql = "SELECT FExchangeTableId FROM T_HR_SCalSubmitScheme where FID = '" + submitSchemeId + "'";
        IRowSet exchangeRowSet = DbUtil.executeQuery((Context)this.ctx, (String)queryExchangeTbSql);
        String exchangeTableId = "";
        try {
            while (exchangeRowSet.next()) {
                exchangeTableId = exchangeRowSet.getString("FExchangeTableId");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return exchangeTableId;
    }

    @Override
    protected boolean loadDeduConfigInfo() throws BOSException {
        String deductOql = "select calSubmitItem.id, calSubmitItem.fieldSn, cmpBudgetItem.fieldSn, cmpBudgetItem.id, templateStbItem.standingBookItem.id, templateStbItem.standingBookItem.fieldSn, templateStbItem.balanceLedgerItem.fieldSn, templateStbItem.balanceLedgerItem.id where calSubmitScheme = '" + this.deductionParam.getCalSchemeId() + "' and deduNode = " + this.deductionParam.getDeductNodeEnum().getValue();
        this.deduConfigCollection = SchemeDeduConfigFactory.getLocalInstance(this.ctx).getSchemeDeduConfigCollection(deductOql);
        return this.deduConfigCollection != null && !this.deduConfigCollection.isEmpty();
    }

    @Override
    protected void loadOffSetConfigInfo() throws BOSException {
        String deductOql = "select calSubmitScheme.id, calSubmitItem.id, calSubmitItem.fieldSn, cmpBudgetItem.fieldSn, cmpBudgetItem.id, templateStbItem.cmpBudgetItem.id, templateStbItem.cmpBudgetItem.fieldSn, templateStbItem.standingBookItem.id, templateStbItem.standingBookItem.fieldSn, templateStbItem.balanceLedgerItem.fieldSn, templateStbItem.balanceLedgerItem.id where calSubmitScheme = '" + this.deductionParam.getCalSchemeId() + "' and offsetNode = " + this.deductionParam.getDeductNodeEnum().getValue();
        this.offsetConfigCollection = SchemeDeduConfigFactory.getLocalInstance(this.ctx).getSchemeDeduConfigCollection(deductOql);
    }

    @Override
    protected void checkAcross() throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)this.deductionParam.getCalSchemeId())) {
            return;
        }
        DeductionParamSubmitBill param = (DeductionParamSubmitBill)this.deductionParam;
        CmpInSql<String> inSqlObj = CmpInSqlFactory.getInstance();
        String inSql = inSqlObj.createInSqlBaseOnFId(this.ctx, param.getEntries());
        param.setEntryIdInSql(inSql);
        String sqlBuilder = " SELECT top 1 FID,FCreateTime, FSubBookTableId FROM T_HR_SBudgetSnapshot  where FDataState = 10 and FCreateTime is not null  and (FIsRollback=0 or FIsRollback is null)  and FBillEntryID in " + inSql + " order by FCreateTime desc ";
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuilder);
        String subBookTableIdOfSnapshot = null;
        try {
            while (rowSet.next()) {
                String lastBudgetSchemeId;
                java.util.Date snapShotDate;
                Map<String, String> snapshot;
                Date lastDeductDate = rowSet.getDate("FCreateTime");
                subBookTableIdOfSnapshot = rowSet.getString("FSubBookTableId");
                if (lastDeductDate == null || (snapshot = this.getBudgetSchemeIdAndCurrency(snapShotDate = new java.util.Date(lastDeductDate.getTime()), this.budgetTemplateId)) == null || StringUtils.isEmpty((String)snapshot.get("budgetSchemeId")) || this.budgetSchemeId.equals(lastBudgetSchemeId = snapshot.get("budgetSchemeId"))) continue;
                throw new EASBizException(new NumericExceptionSubItem("CMP_COMMON_INFO", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label12", (Locale)this.ctx.getLocale())));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        this.checkAcrossOfSub(subBookTableIdOfSnapshot);
    }

    @Override
    protected boolean checkBudgetData() throws EASBizException {
        String operateKsqlDate = this.getDeductDate();
        String sqlBuilder = " SELECT cbs.FBudgetYear, ssb.FCostBearOrgId, ssb.FCostTypeId, css.FBudgetTemplateID, cbs.fid budgetSchemeId, bm.fid budgetManageId FROM T_HR_SBatchSubmitShemeBill ssb left join T_HR_SCalSubmitScheme css on ssb.FSubmitSchemeID = css.FID  left join T_HR_SCmpBudgetScheme cbs on css.FBudgetTemplateID = cbs.FTemplateID    and cbs.FEffectDate <= " + operateKsqlDate + "    and cbs.FExpiryDate >= " + operateKsqlDate + " left join T_HR_SBudgetManage bm on cbs.Fid = bm.FBudgetSchemeID    and ssb.FCostBearOrgID = bm.FAdminOrgUnitID    and ssb.FCostTypeID = bm.FCostTypeID where ssb.FID = ? ";
        boolean havingBudget = false;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuilder, (Object[])new Object[]{this.deductionParam.getBillId()});
            while (rowSet.next()) {
                this.budgetTemplateId = rowSet.getString("FBudgetTemplateID");
                if (StringUtils.isEmpty((String)this.budgetTemplateId)) {
                    return false;
                }
                havingBudget = true;
                this.budgetSchemeId = rowSet.getString("budgetSchemeId");
                this.costBearOrgId = rowSet.getString("FCostBearOrgId");
                this.budgetYear = rowSet.getInt("FBudgetYear");
                this.costTypeId = rowSet.getString("FCostTypeId");
                if (StringUtils.isEmpty((String)this.budgetSchemeId)) {
                    throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label28", (Locale)this.ctx.getLocale())));
                }
                String budgetManageId = rowSet.getString("budgetManageId");
                if (!StringUtils.isEmpty((String)budgetManageId)) continue;
                throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label28", (Locale)this.ctx.getLocale())));
            }
        }
        catch (BOSException | SQLException e) {
            throw new RuntimeException(e);
        }
        return havingBudget;
    }

    @Override
    public String getCostTypeId() {
        return this.costTypeId;
    }

    @Override
    protected BigDecimal getTotalDeduction() {
        BigDecimal submitBigDecimalOfSum = BigDecimal.ZERO;
        String calSubmitItem = "S" + this.deduConfig.getCalSubmitItem().getFieldSn();
        for (Map<String, Object> entryDataMap : this.entryDataList) {
            BigDecimal submitData = entryDataMap.get(calSubmitItem) == null ? BigDecimal.ZERO : (BigDecimal)entryDataMap.get(calSubmitItem);
            submitBigDecimalOfSum = submitBigDecimalOfSum.add(submitData);
        }
        return submitBigDecimalOfSum;
    }

    @Override
    protected String getCostBearOrgId() {
        return this.costBearOrgId;
    }

    @Override
    protected String getCostBearOrgComparator() {
        return "=";
    }

    @Override
    protected String getCompareValue() {
        return "'" + this.costBearOrgId + "'";
    }

    @Override
    protected void deductSubmitData(List<BudgetAndUsedData> leftDataList, boolean hasDeduction) throws BOSException {
        CmpBudgetItemInfo cmpBudgetItem = this.deduConfig.getCmpBudgetItem();
        BudgetTemplateSTBItemInfo templateSTBItemInfo = this.deduConfig.getTemplateStbItem();
        String budgetSnCol = "T" + cmpBudgetItem.getFieldSn();
        String stbSnCol = "S" + templateSTBItemInfo.getStandingBookItem().getFieldSn();
        String leftSnCol = "S" + templateSTBItemInfo.getBalanceLedgerItem().getFieldSn();
        String submitSnCol = "S" + this.deduConfig.getCalSubmitItem().getFieldSn();
        String submitItemId = this.deduConfig.getCalSubmitItem().getId().toString();
        List<BudgetSnapshotInfo> snapshotInfoList = this.snapshotMap.get(submitSnCol);
        if (null == snapshotInfoList) {
            return;
        }
        Map<String, BudgetSnapshotInfo> entrySnapshotMap = this.getEntrySnapshotMap(snapshotInfoList);
        this.setLeftDataListId(leftDataList);
        if (hasDeduction) {
            for (BudgetAndUsedData leftDataMap : leftDataList) {
                BigDecimal balance = leftDataMap.getItemMap().get(leftSnCol) == null ? BigDecimal.ZERO : leftDataMap.getItemMap().get(leftSnCol);
                leftDataMap.getItemMap().put(budgetSnCol, balance);
            }
        }
        DeductionParamSubmitBill param = (DeductionParamSubmitBill)this.deductionParam;
        block1: for (Map<String, Object> entryDataMap : this.entryDataList) {
            Map<String, BigDecimal> itemMap;
            BigDecimal submitData = entryDataMap.get(submitSnCol) == null ? BigDecimal.ZERO : (BigDecimal)entryDataMap.get(submitSnCol);
            if (submitData.compareTo(BigDecimal.ZERO) == 0) continue;
            String entryId = (String)entryDataMap.get("entryId");
            List<BudgetSnapshotInfo> lastDeductionSnapshots = this.filterBySubmitEntryIdAndSubmitItem(this.lastDeductSnapshots, entryId, submitItemId);
            if (!lastDeductionSnapshots.isEmpty()) {
                List<BudgetSnapshotInfo> currentDeductionSnapshots = this.copySnapshots(lastDeductionSnapshots);
                for (BudgetSnapshotInfo info : currentDeductionSnapshots) {
                    info.setCreateTime(this.now);
                    info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                    info.setTemplateStbItem(templateSTBItemInfo);
                    info.setStandingBookItem(templateSTBItemInfo.getStandingBookItem());
                    info.setBalanceLedgerItem(templateSTBItemInfo.getBalanceLedgerItem());
                    info.setUpdateNode(param.getUpdateNodeEnum());
                }
                this.realSnapshotList.addAll(currentDeductionSnapshots);
                for (BudgetAndUsedData leftDataMap : leftDataList) {
                    itemMap = leftDataMap.getItemMap();
                    Optional<BudgetSnapshotInfo> optional = currentDeductionSnapshots.stream().filter(e -> leftDataMap.getTrueSubStandingBookId().equals(e.getSubBookTableId())).findAny();
                    if (!optional.isPresent()) continue;
                    BudgetSnapshotInfo snapshotInfo = optional.get();
                    BigDecimal val = snapshotInfo.getValue();
                    BigDecimal expense = itemMap.computeIfAbsent(stbSnCol, k -> BigDecimal.ZERO);
                    itemMap.put(stbSnCol, expense.add(val));
                    BigDecimal balance = itemMap.computeIfAbsent(budgetSnCol, k -> BigDecimal.ZERO);
                    itemMap.put(budgetSnCol, balance.subtract(val));
                    this.convertRow2Columns(stbSnCol, leftDataMap, snapshotInfo);
                }
                continue;
            }
            BudgetSnapshotInfo initSnapshotInfo = entrySnapshotMap.get(entryId);
            for (BudgetAndUsedData leftDataMap : leftDataList) {
                BigDecimal leftBudgetData;
                itemMap = leftDataMap.getItemMap();
                BigDecimal bigDecimal = leftBudgetData = itemMap.get(budgetSnCol) == null ? BigDecimal.ZERO : itemMap.get(budgetSnCol);
                if (BigDecimal.ZERO.compareTo(leftBudgetData) >= 0) continue;
                BigDecimal data = leftBudgetData.subtract(submitData);
                boolean isEnoughBudget = false;
                BigDecimal curUsedData = itemMap.get(stbSnCol) == null ? BigDecimal.ZERO : itemMap.get(stbSnCol);
                BudgetSnapshotInfo realSnapshot = this.copySnapshot(initSnapshotInfo);
                if (BigDecimal.ZERO.compareTo(data) > 0) {
                    curUsedData = curUsedData.add(leftBudgetData);
                    submitData = submitData.subtract(leftBudgetData);
                    BigDecimal val = leftBudgetData;
                    leftBudgetData = BigDecimal.ZERO;
                    realSnapshot.setValue(val);
                } else {
                    curUsedData = curUsedData.add(submitData);
                    leftBudgetData = leftBudgetData.subtract(submitData);
                    realSnapshot.setValue(submitData);
                    isEnoughBudget = true;
                }
                itemMap.put(stbSnCol, curUsedData);
                itemMap.put(budgetSnCol, leftBudgetData);
                realSnapshot.setSubBookTableId(leftDataMap.getTrueSubStandingBookId());
                realSnapshot.setBookTableId(leftDataMap.getStandingBookId());
                realSnapshot.setStandingBookItem(templateSTBItemInfo.getStandingBookItem());
                realSnapshot.setPeriod(leftDataMap.getBudgetPeriod());
                realSnapshot.setBalanceLedgerItem(templateSTBItemInfo.getBalanceLedgerItem());
                realSnapshot.setTemplateStbItem(templateSTBItemInfo);
                realSnapshot.setCmpBudgetItem(cmpBudgetItem);
                this.realSnapshotList.add(realSnapshot);
                this.convertRow2Columns(stbSnCol, leftDataMap, realSnapshot);
                if (!isEnoughBudget) continue;
                continue block1;
            }
        }
    }

    private List<BudgetSnapshotInfo> filterBySubmitEntryIdAndSubmitItem(BudgetSnapshotCollection lastDeductSnapshots, String entryId, String submitItemId) {
        ArrayList<BudgetSnapshotInfo> list = new ArrayList<BudgetSnapshotInfo>();
        if (null == lastDeductSnapshots || lastDeductSnapshots.isEmpty()) {
            return list;
        }
        for (int i = 0; i < lastDeductSnapshots.size(); ++i) {
            BudgetSnapshotInfo info = lastDeductSnapshots.get(i);
            if (!info.getBillEntry().getId().toString().equals(entryId) || !info.getCalSubmitItem().getId().toString().equals(submitItemId)) continue;
            list.add(info);
        }
        return list;
    }

    private void convertRow2Columns(String stbSnCol, BudgetAndUsedData leftDataMap, BudgetSnapshotInfo snapshot) throws BOSException {
        String subStandingBookId = leftDataMap.getTrueSubStandingBookId();
        Optional<ExpenseDetailsVO> optional = this.expenseList.stream().filter(e -> {
            SubmitBillExpenseDetailsVO vo = (SubmitBillExpenseDetailsVO)e;
            return vo.getEntryId().equals(snapshot.getBillEntry().getId().toString()) && subStandingBookId.equals(vo.getSubStandingBookId());
        }).findFirst();
        if (optional.isPresent()) {
            SubmitBillExpenseDetailsVO expense = (SubmitBillExpenseDetailsVO)optional.get();
            BigDecimal val = expense.getExpenseMap().get(stbSnCol);
            val = val == null ? BigDecimal.ZERO : val;
            expense.getExpenseMap().put(stbSnCol, val.add(snapshot.getValue()));
            return;
        }
        optional = this.expenseList.stream().filter(e -> {
            SubmitBillExpenseDetailsVO vo = (SubmitBillExpenseDetailsVO)e;
            return vo.getEntryId().equals(snapshot.getBillEntry().getId().toString()) && vo.getSubStandingBookId() == null;
        }).findFirst();
        if (optional.isPresent()) {
            SubmitBillExpenseDetailsVO expense = (SubmitBillExpenseDetailsVO)optional.get();
            expense.setSubStandingBookId(leftDataMap.getTrueSubStandingBookId());
            expense.setStandingBookId(leftDataMap.getStandingBookId());
            expense.setBudgetManageId(leftDataMap.getBudgetId());
            expense.setSubBudgetQueryId(leftDataMap.getSubBudgetQueryId());
            BigDecimal val = expense.getExpenseMap().get(stbSnCol);
            val = val == null ? BigDecimal.ZERO : val;
            expense.getExpenseMap().put(stbSnCol, val.add(snapshot.getValue()));
            return;
        }
        optional = this.expenseList.stream().filter(e -> {
            SubmitBillExpenseDetailsVO vo = (SubmitBillExpenseDetailsVO)e;
            return vo.getEntryId().equals(snapshot.getBillEntry().getId().toString());
        }).findFirst();
        if (optional.isPresent()) {
            SubmitBillExpenseDetailsVO expense = (SubmitBillExpenseDetailsVO)optional.get();
            SubmitBillExpenseDetailsVO newExpense = this.copyExpenseDetails(expense);
            newExpense.setExpenseMap(new HashMap<String, BigDecimal>());
            newExpense.setId(null);
            newExpense.getExpenseMap().put(stbSnCol, snapshot.getValue());
            newExpense.setSubStandingBookId(leftDataMap.getTrueSubStandingBookId());
            newExpense.setStandingBookId(leftDataMap.getStandingBookId());
            newExpense.setBudgetManageId(leftDataMap.getBudgetId());
            newExpense.setSubBudgetQueryId(leftDataMap.getSubBudgetQueryId());
            this.expenseList.add(newExpense);
        }
    }

    private BudgetSnapshotInfo copySnapshot(BudgetSnapshotInfo initSnapshot) throws BOSException {
        BudgetSnapshotInfo realSnapshot = new BudgetSnapshotInfo();
        try {
            BeanUtils.copyProperties((Object)realSnapshot, (Object)initSnapshot);
            realSnapshot.setId(BOSUuid.create((BOSObjectType)realSnapshot.getBOSType()));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return realSnapshot;
    }

    private List<BudgetSnapshotInfo> copySnapshots(List<BudgetSnapshotInfo> initSnapshots) throws BOSException {
        ArrayList<BudgetSnapshotInfo> currentSnapshots = new ArrayList<BudgetSnapshotInfo>();
        try {
            for (BudgetSnapshotInfo e : initSnapshots) {
                BudgetSnapshotInfo info = new BudgetSnapshotInfo();
                BeanUtils.copyProperties((Object)info, (Object)e);
                currentSnapshots.add(info);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return currentSnapshots;
    }

    protected Map<String, BudgetSnapshotInfo> getEntrySnapshotMap(List<BudgetSnapshotInfo> snapshotInfoList) {
        HashMap<String, BudgetSnapshotInfo> entrySnapshotMap = new HashMap<String, BudgetSnapshotInfo>();
        for (BudgetSnapshotInfo snapshotInfo : snapshotInfoList) {
            BatchSubmitShemeBillEntryInfo billEntryInfo = snapshotInfo.getBillEntry();
            if (billEntryInfo == null) continue;
            entrySnapshotMap.put(billEntryInfo.getId().toString(), snapshotInfo);
        }
        return entrySnapshotMap;
    }

    @Override
    protected String getDeductDate() {
        return BudgetUtil.getNowDateStr();
    }
}

