/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.timepiece;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class TimepieceCreateTableWithPartitionService {
    private static final Logger LOG = Logger.getLogger(TimepieceCreateTableWithPartitionService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTimepieceSchemeBillEntry(Context ctx, String tableName) {
        String selectSQL = "select 1 from KSQL_UserTables where KSQL_TabName = '" + tableName + "' ";
        Connection conn = null;
        Statement statement = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            if (rs.size() > 0) {
                return;
            }
            String pkKey = "PK_TimepieceBillEy";
            String pkKeyEXT = "PK_TimepieceBillExt";
            String index = "";
            if ("T_HR_TimepieceSumBillEntry".equals(tableName)) {
                pkKey = "PK_TimepieceSumBillEy";
                pkKeyEXT = "PK_TimepieceSumBillExt";
                index = "sum";
            }
            if ("T_HR_TimepieceBillBaseEntry".equals(tableName)) {
                pkKey = "PK_TimepieceBase";
                pkKeyEXT = "PK_TimepieceBaseExt";
                index = "base";
            }
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            DatabaseMetaData metaData = conn.getMetaData();
            String dbName = metaData.getDatabaseProductName();
            String createSQL = "Create Table " + tableName + " ( FBillID VARCHAR(44),FEffectDate DateTime,FLeffectDate DateTime,FOrgUnitID VARCHAR(44),FAdminOrgUnitID VARCHAR(44),FPositionID VARCHAR(44),FCmpEmpORelationID VARCHAR(44),FCurrencyID VARCHAR(44) DEFAULT '',FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255), FTransDateTime DateTime,FYear INT DEFAULT 0 NOT NULL,FUseDefault INT ,fentrycalstatus NVARCHAR(1)  DEFAULT '0'  ,FTransYear INT,FTransMonth INT,FTransTime INT,FSubmitElementID VARCHAR(44) DEFAULT '',FHrOrgUnitID VARCHAR(44) DEFAULT '',FCalState VARCHAR(100),FSalaryPeriod VARCHAR(20),FIsCal INT,FBillState INT,FForwarnContent VARCHAR(512),FDealStatus INT,FPersonID VARCHAR(44),FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,Fsum numeric(20,10),FControlUnitID VARCHAR(44),FID VARCHAR(44) DEFAULT '' NOT NULL ,FCalSchemeID VARCHAR(44),FPeriodType NVARCHAR(2),FIfsalaryshow NVARCHAR(1) DEFAULT '0'  ,FApplyDate DateTime,CONSTRAINT " + pkKey + " PRIMARY KEY (FID));";
            String tableNameExt = tableName + "Ext";
            String createSQLExt = "Create Table " + tableNameExt + " (FID VARCHAR(44) DEFAULT '' NOT NULL ,FYear INT DEFAULT 0 NOT NULL, CONSTRAINT " + pkKeyEXT + " PRIMARY KEY (FID));";
            boolean oracleFlag = true;
            if ("oracle".equalsIgnoreCase(dbName)) {
                try {
                    StringBuilder oracleSql = new StringBuilder(createSQL);
                    TimepieceCreateTableWithPartitionService.appendOraclePartition(oracleSql, tableName);
                    StringBuilder oracleSqlExt = new StringBuilder(createSQLExt);
                    TimepieceCreateTableWithPartitionService.appendOraclePartition(oracleSqlExt, tableNameExt);
                    statement.execute(oracleSql.toString());
                    statement.execute(oracleSqlExt.toString());
                    oracleFlag = false;
                }
                catch (Exception exception) {}
            } else if ("postgresql".equalsIgnoreCase(dbName)) {
                createSQL = createSQL.replace("PRIMARY KEY (FID)", "PRIMARY KEY (FID, FYear)").replace(" DateTime,", " timestamp,");
                createSQL = "/*dialect*/ " + createSQL;
                createSQL = TimepieceCreateTableWithPartitionService.appendPGPartition(createSQL, tableName);
                createSQLExt = createSQLExt.replace("PRIMARY KEY (FID)", "PRIMARY KEY (FID, FYear)").replace(" DateTime,", " timestamp,");
                createSQLExt = "/*dialect*/ " + createSQLExt;
                createSQLExt = TimepieceCreateTableWithPartitionService.appendPGPartition(createSQLExt, tableName);
            } else if ("dm".equalsIgnoreCase(dbName)) {
                createSQL = TimepieceCreateTableWithPartitionService.appendDMPartition(createSQL, tableName);
                createSQLExt = TimepieceCreateTableWithPartitionService.appendDMPartition(createSQLExt, tableName);
            }
            if (oracleFlag) {
                statement.execute(createSQL);
                statement.execute(createSQLExt);
            }
            DbUtil.execute((Context)ctx, (String)("create index IX_HR_TPBILL" + index + "_AER on " + tableName + "(FBillID)"));
            DbUtil.execute((Context)ctx, (String)("create index IX_HR_TPBILL" + index + "_CEOR on " + tableName + "(FCmpEmpORelationID)"));
            DbUtil.execute((Context)ctx, (String)("create index IX_HR_TPBILL" + index + "_PER on " + tableName + "(FPersonID)"));
            DbUtil.execute((Context)ctx, (String)("create index IX_HR_TPBILL" + index + "_FCal on " + tableName + "(FCalSchemeID)"));
        }
        catch (BOSException | SQLException e) {
            LOG.error((Object)"createTable error: ", e);
        }
        finally {
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"createTable error: ", (Throwable)e);
                }
            }
            if (null != statement) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"createTable error: ", (Throwable)e);
                }
            }
        }
    }

    private static String appendDMPartition(String createSQL, String tableName) {
        return createSQL + " partition by RANGE(FYear) (partition " + tableName + "2024 values EQU OR LESS THAN ('2024'),partition " + tableName + "2025 values EQU OR LESS THAN ('2025'),partition " + tableName + "2026 values EQU OR LESS THAN ('2026'),partition " + tableName + "2027 values EQU OR LESS THAN ('2027'),partition " + tableName + "2028 values EQU OR LESS THAN ('2028'),partition " + tableName + "2029 values EQU OR LESS THAN ('2029'),partition " + tableName + "2030 values EQU OR LESS THAN ('2030'),partition " + tableName + "2031 values EQU OR LESS THAN ('2031'),partition " + tableName + "2032 values EQU OR LESS THAN ('2032'),partition " + tableName + "2033 values EQU OR LESS THAN ('2033')partition " + tableName + "2023 values EQU OR LESS THAN ('2034'),)";
    }

    private static String appendPGPartition(String createSQL, String tableName) {
        return createSQL + " partition by range(FYear);CREATE TABLE " + tableName + "2023 PARTITION OF " + tableName + " for values from (2023) to (2024);CREATE TABLE " + tableName + "2024 PARTITION OF " + tableName + " for values from (2024) to (2025);CREATE TABLE " + tableName + "2025 PARTITION OF " + tableName + " for values from (2025) to (2026);CREATE TABLE " + tableName + "2026 PARTITION OF " + tableName + " for values from (2026) to (2027);CREATE TABLE " + tableName + "2027 PARTITION OF " + tableName + " for values from (2027) to (2028);CREATE TABLE " + tableName + "2028 PARTITION OF " + tableName + " for values from (2028) to (2029);CREATE TABLE " + tableName + "2029 PARTITION OF " + tableName + " for values from (2029) to (2030);CREATE TABLE " + tableName + "2030 PARTITION OF " + tableName + " for values from (2030) to (2031);CREATE TABLE " + tableName + "2031 PARTITION OF " + tableName + " for values from (2031) to (2032);CREATE TABLE " + tableName + "2032 PARTITION OF " + tableName + " for values from (2032) to (2033);CREATE TABLE " + tableName + "2033 PARTITION OF " + tableName + " for values from (2033) to (2034);";
    }

    private static void appendOraclePartition(StringBuilder createSQL, String tableName) {
        createSQL.append(" partition by list(FYear) (");
        createSQL.append("partition ").append(tableName).append("2024 values (2024),");
        createSQL.append("partition ").append(tableName).append("2025 values (2025),");
        createSQL.append("partition ").append(tableName).append("2026 values (2026),");
        createSQL.append("partition ").append(tableName).append("2027 values (2027),");
        createSQL.append("partition ").append(tableName).append("2028 values (2028),");
        createSQL.append("partition ").append(tableName).append("2029 values (2029),");
        createSQL.append("partition ").append(tableName).append("2030 values (2030),");
        createSQL.append("partition ").append(tableName).append("2031 values (2031),");
        createSQL.append("partition ").append(tableName).append("2032 values (2032),");
        createSQL.append("partition ").append(tableName).append("2033 values (2033)");
        createSQL.append("partition ").append(tableName).append("2033 values (2034)");
        createSQL.append(")");
    }
}

