/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.task.impl;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.vo.CancelUpdateResponseVO;
import com.kingdee.shr.compensation.app.taxCal.vo.UpdateDeclareData;
import com.kingdee.shr.compensation.app.taxCal.vo.UpdateDeclareResponseData;
import com.kingdee.shr.compensation.helper.CmpConstants;
import com.kingdee.shr.compensation.tax.task.impl.TaxDeclareUpdateService;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CancelTaxUpdateService
extends TaxDeclareUpdateService {
    private static final Logger LOG = Logger.getLogger(CancelTaxUpdateService.class);

    @Override
    public void onSuccess(Context ctx, TaxCalTaskInfo taskInfo, String response) throws BOSException {
        CancelUpdateResponseVO responseVO = (CancelUpdateResponseVO)JSON.parseObject((String)response, CancelUpdateResponseVO.class);
        String taskId = taskInfo.getId().toString();
        String sql = "select d.fid, d.fTbType, d.fBatchNo from t_hr_sIncomeTaxDeclar d, t_hr_sTaskIncomeTaxRelation r, t_hr_sTaxCalTask t where d.fid = r.fBizId and r.fTaskId = t.fid and t.fid = '" + taskId + "' and t.fCatalog='" + 130 + "'";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() == 0) {
                throw new BOSException("\u901a\u8fc7taskId[" + taskId + "]\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7533\u62a5\u6570\u636e");
            }
            String tbType = null;
            String batchNo = null;
            while (rowSet.next()) {
                tbType = rowSet.getString(2);
                batchNo = rowSet.getString(3);
            }
            UpdateDeclareResponseData data = responseVO.getData();
            UpdateDeclareData result = "1".equals(tbType) ? data.getYkyjsbjg() : ("2".equals(tbType) ? data.getFlsdsbjg() : data.getFjmsbjg());
            Integer sbbz = result.getSbbz();
            if (sbbz != 2) {
                LOG.error((Object)("_afterCancelUpdate sbbz=" + sbbz + ", \u7533\u62a5\u6807\u5fd7\u4e0d\u662f\u5df2\u7533\u62a5\uff0c\u4e0d\u80fd\u7ee7\u7eed\u5904\u7406"));
                return;
            }
            TaxCalTaskStateEnum taskState = TaxCalTaskStateEnum.FINISHED;
            String msg = result.getErrorinfo();
            msg = StringUtils.isEmpty((CharSequence)msg) ? "\u66f4\u6b63\u6210\u529f\uff01" : msg;
            this.restoreFromHis(ctx, batchNo);
            TaxCalTaskFactory.getLocalInstance(ctx).updateStateMsgById(taskId, taskState, msg);
            taskInfo.setState(taskState);
            this.sendMsg2Commander(ctx, taskInfo);
        }
        catch (Exception e) {
            LOG.error((Object)"_afterCancelUpdate error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    private void restoreFromHis(Context ctx, String batchNo) throws Exception {
        String selectSQL1 = "select * from t_hr_sIncomeTaxDeclareHis where FUpdateBatchNo = '" + batchNo + "' and fDataType = " + 2;
        String deleteSQL1 = "delete from t_hr_sIncomeTaxDeclar where FBatchNo = '" + batchNo + "'";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)selectSQL1);
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object[]> values1 = new ArrayList<Object[]>();
        IRowSetMetaData metaData1 = rowSet1.getRowSetMetaData();
        String tbType = "1";
        String oldBatchNo = null;
        String taxUnitId = null;
        Date period = null;
        int index = 0;
        if (rowSet1.size() == 0) {
            throw new BOSException("\u901a\u8fc7\u6279\u6b21\u53f7\uff1a" + batchNo + "\u67e5\u8be2\u4e0d\u5230\u7533\u62a5\u5907\u4efd\u8bb0\u5f55\uff01");
        }
        if (rowSet1.next()) {
            Object[] row = new Object[metaData1.getColumnCount() - 3];
            String originalId = null;
            for (int i = 1; i <= metaData1.getColumnCount(); ++i) {
                int columnType = metaData1.getColumnType(i);
                String columnName = metaData1.getColumnName(i);
                Object val = ImplUtils.getDataFromDr((int)columnType, (ResultSet)rowSet1, (int)i);
                if ("fYearMonthDate".equalsIgnoreCase(columnName)) {
                    period = (Date)val;
                }
                if ("fBatchNo".equalsIgnoreCase(columnName)) {
                    oldBatchNo = (String)val;
                }
                if ("fTaxUnitId".equalsIgnoreCase(columnName)) {
                    taxUnitId = (String)val;
                }
                if ("fTbType".equalsIgnoreCase(columnName)) {
                    tbType = (String)val;
                }
                if ("FUpdateBatchNo".equalsIgnoreCase(columnName) || "FDataType".equalsIgnoreCase(columnName) || "fid".equalsIgnoreCase(columnName)) continue;
                if ("FOriginalId".equalsIgnoreCase(columnName)) {
                    originalId = (String)val;
                    continue;
                }
                row[index] = val;
                columns.add(columnName);
                ++index;
            }
            row[row.length - 1] = originalId;
            values1.add(row);
        }
        columns.add("fid");
        String insertSQL1 = this.genInsertSQL("t_hr_sIncomeTaxDeclar", columns);
        DbUtil.execute((Context)ctx, (String)deleteSQL1);
        DbUtil.executeBatch((Context)ctx, (String)insertSQL1, values1);
        String payerType = CmpConstants.getPayerTypeByTbType(tbType);
        String selectSQL2 = "select * from t_hr_sTaxCalInitDetailHis where FBatchNo = '" + oldBatchNo + "'";
        String deleteSQL2 = "delete from t_hr_sTaxCalInitDetail t where t.fTaxUnitId = '" + taxUnitId + "' and t.fPeriodBegin = " + CmpDateUtil.toKSqlDate(period) + " and exists (select 1 from t_hr_sTaxPersonRecordEntry tpr where tpr.fTaxUnitId = t.fTaxUnitId and tpr.fPersonId = t.fPersonId and tpr.fPayerType = '" + payerType + "')";
        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)selectSQL2);
        if (rowSet2.size() == 0) {
            throw new BOSException("\u901a\u8fc7\u6279\u6b21\u53f7\uff1a" + oldBatchNo + "\u67e5\u8be2\u4e0d\u5230\u521d\u7b97\u6570\u636e\u5907\u4efd\u8bb0\u5f55\uff01");
        }
        ArrayList<String> columns2 = new ArrayList<String>();
        ArrayList<Object[]> values2 = new ArrayList<Object[]>();
        IRowSetMetaData metaData2 = rowSet2.getRowSetMetaData();
        this.setColumnAndValue4Init(rowSet2, columns2, values2, metaData2);
        String insertSQL2 = this.genInsertSQL("t_hr_sTaxCalInitDetail", columns2);
        DbUtil.execute((Context)ctx, (String)deleteSQL2);
        DbUtil.executeBatch((Context)ctx, (String)insertSQL2, values2);
        String deleteHisSQL = "delete from t_hr_sTaxCalInitDetailHis where FBatchNo = '" + oldBatchNo + "'";
        DbUtil.execute((Context)ctx, (String)deleteHisSQL);
        String selectSQL3 = "select * from t_hr_sTaxCalConfigDetailHis where fBatchNo = '" + oldBatchNo + "'";
        String deleteSQL3 = "delete from t_hr_sTaxCalConfigDetail where fBatchNo = '" + batchNo + "'";
        IRowSet rowSet3 = DbUtil.executeQuery((Context)ctx, (String)selectSQL3);
        if (rowSet3.size() == 0) {
            throw new BOSException("\u901a\u8fc7\u6279\u6b21\u53f7\uff1a" + oldBatchNo + "\u67e5\u8be2\u4e0d\u5230\u786e\u8ba4\u6570\u636e\u5907\u4efd\u8bb0\u5f55\uff01");
        }
        ArrayList<String> columns3 = new ArrayList<String>();
        ArrayList<Object[]> values3 = new ArrayList<Object[]>();
        IRowSetMetaData metaData3 = rowSet3.getRowSetMetaData();
        this.setColumnAndValue4Config(rowSet3, columns3, values3, metaData3);
        String insertSQL3 = this.genInsertSQL("t_hr_sTaxCalConfigDetail", columns3);
        DbUtil.execute((Context)ctx, (String)deleteSQL3);
        DbUtil.executeBatch((Context)ctx, (String)insertSQL3, values3);
        deleteHisSQL = "delete from t_hr_sTaxCalConfigDetailHis where fBatchNo = '" + oldBatchNo + "'";
        DbUtil.execute((Context)ctx, (String)deleteHisSQL);
    }

    private void setColumnAndValue4Init(IRowSet rowSet, List<String> columns, List<Object[]> values, IRowSetMetaData metaData) throws SQLException {
        int index = 1;
        while (rowSet.next()) {
            Object[] row = new Object[metaData.getColumnCount() - 2];
            int columnIndex = 0;
            Object originalId = null;
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                int columnType = metaData.getColumnType(i);
                String columnName = metaData.getColumnName(i);
                if ("FBatchNo".equalsIgnoreCase(columnName) || "fid".equalsIgnoreCase(columnName)) continue;
                Object val = ImplUtils.getDataFromDr((int)columnType, (ResultSet)rowSet, (int)i);
                if ("FOriginalId".equalsIgnoreCase(columnName)) {
                    originalId = val;
                    continue;
                }
                row[columnIndex] = val;
                ++columnIndex;
                if (index != 1) continue;
                columns.add(columnName);
            }
            row[row.length - 1] = originalId;
            values.add(row);
            ++index;
        }
        columns.add("fid");
    }

    private void setColumnAndValue4Config(IRowSet rowSet, List<String> columns, List<Object[]> values, IRowSetMetaData metaData) throws SQLException {
        int index = 1;
        while (rowSet.next()) {
            Object[] row = new Object[metaData.getColumnCount() - 1];
            int columnIndex = 0;
            Object originalId = null;
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                int columnType = metaData.getColumnType(i);
                String columnName = metaData.getColumnName(i);
                if ("fid".equalsIgnoreCase(columnName)) continue;
                Object val = ImplUtils.getDataFromDr((int)columnType, (ResultSet)rowSet, (int)i);
                if ("FOriginalId".equalsIgnoreCase(columnName)) {
                    originalId = val;
                    continue;
                }
                row[columnIndex] = val;
                ++columnIndex;
                if (index != 1) continue;
                columns.add(columnName);
            }
            row[row.length - 1] = originalId;
            values.add(row);
            ++index;
        }
        columns.add("fid");
    }

    @Override
    public void onFailure(Context ctx, TaxCalTaskInfo taskInfo, String errMsg) throws BOSException {
        String updateSql = "update T_HR_STaxCalTask Set fSTATE = ? , fMsg = ? where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param = new Object[]{30, StringUtils.isEmpty((CharSequence)errMsg) ? "\u64a4\u9500\u66f4\u6b63\u5931\u8d25" : errMsg, taskInfo.getId().toString()};
        paramList.add(param);
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
        this.sendMsg2Commander(ctx, taskInfo);
    }

    @Override
    public void sendMsg2Commander(Context ctx, TaxCalTaskInfo taxCalTaskInfo) {
        try {
            String msgTemplate;
            String title;
            String declareSQL = "select d.fTbType from t_hr_sIncomeTaxDeclar d, t_hr_sTaskIncomeTaxRelation r, t_hr_sTaxCalTask t where d.fid = r.fBizId and r.fTaskId = t.fid and t.fid = '" + taxCalTaskInfo.getId().toString() + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)declareSQL);
            String tbType = "1";
            while (rowSet.next()) {
                tbType = rowSet.getString(1);
            }
            String tbTypeStr = CmpConstants.getTbTypeDesc(tbType);
            String number = taxCalTaskInfo.getNumber();
            TaxCalTaskStateEnum state = taxCalTaskInfo.getState();
            String taxUnitName = taxCalTaskInfo.getTaxUnit().getName();
            String period = taxCalTaskInfo.getPeriod();
            String sendUserID = taxCalTaskInfo.getCreator().getId().toString();
            if (TaxCalTaskStateEnum.FINISHED.equals((Object)state)) {
                title = "\u64a4\u9500\u66f4\u6b63\u7684\u4efb\u52a1\u7f16\u7801[{0}]\u64a4\u9500\u66f4\u6b63\u6210\u529f\uff0c\u8be6\u60c5\u67e5\u770b\u4e2a\u7a0e\u7533\u62a5\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
                msgTemplate = "\u7eb3\u7a0e\u5355\u4f4d[{0}][{1}][{2}]\u64a4\u9500\u66f4\u6b63\u5b8c\u6210";
            } else {
                title = "\u64a4\u9500\u66f4\u6b63\u7684\u4efb\u52a1\u7f16\u7801[{0}]\u64a4\u9500\u66f4\u6b63\u5931\u8d25\uff0c\u8be6\u60c5\u67e5\u770b\u4e2a\u7a0e\u7533\u62a5\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
                msgTemplate = "\u7eb3\u7a0e\u5355\u4f4d[{0}][{1}][{2}]\u64a4\u9500\u66f4\u6b63\u5931\u8d25";
            }
            String category = "\u85aa\u916c\u4e2a\u7a0e";
            String titleStr = MessageFormat.format(title, number);
            String msg = MessageFormat.format(msgTemplate, taxUnitName, period, tbTypeStr);
            MessageUtil.setNeedSending(ctx);
            MessageUtil.sendMessage(ctx, sendUserID, titleStr, msg, category);
        }
        catch (Exception e) {
            LOG.error((Object)"FailureHandler130 error: ", (Throwable)e);
        }
    }
}

