/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.shr.compensation.app.formula.common.CommonMethod;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class CmpStrUtil {
    private static Pattern NUMBER_PATTERN = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){1,})?$");

    public static String getZeroIncomeInfo(String personId, String taxUnitId) {
        return personId + "_" + taxUnitId;
    }

    public static String converCollectionToSql(Collection<String> coll) {
        StringBuffer sb = new StringBuffer();
        if (null == coll || coll.size() < 1) {
            return "''";
        }
        for (String id : coll) {
            sb.append(",'").append(id).append("'");
        }
        return sb.substring(1);
    }

    public static String concatList(List<String> list, String separator, int maxCount) {
        if (null == list || list.isEmpty()) {
            return null;
        }
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (maxCount != 0 && i == maxCount) {
                content.append("...");
                break;
            }
            if (content.length() > 0) {
                content.append(separator);
            }
            content.append(list.get(i));
        }
        return content.toString();
    }

    public static String concatList(List<String> idList) {
        if (null == idList || idList.isEmpty()) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        str.append("(");
        for (String id : idList) {
            if (idList.indexOf(id) != 0) {
                str.append(",");
            }
            str.append("'").append(id).append("'");
        }
        str.append(")");
        return str.toString();
    }

    public static String convertListToString(List<String> list) {
        Object[] array = list.toArray();
        return CmpStrUtil.convertListToString(array);
    }

    public static String convertSetToSqlString(Set<String> personIdSet) {
        String result = "";
        StringBuilder sbr = new StringBuilder();
        if (personIdSet != null && personIdSet.size() > 0) {
            for (String personId : personIdSet) {
                sbr.append("'").append(personId).append("',");
            }
            result = sbr.toString();
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String convertListToString(Object[] array) {
        StringBuilder sb = new StringBuilder();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append((String)array[i]);
                sb.append("'");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append((String)array[i]);
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append((String)array[i]);
            sb.append("'");
        }
        return sb.toString();
    }

    public static String converMapToString(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            sb.append(",'").append(entry.getKey()).append("'");
        }
        String sqlId = sb.toString();
        return sqlId.replaceFirst(",", "");
    }

    public static String convertCollectionToSql(Collection<String> coll) {
        StringBuilder sb = new StringBuilder();
        if (null == coll || coll.size() < 1) {
            return "''";
        }
        for (String id : coll) {
            sb.append(",'").append(id).append("'");
        }
        return sb.substring(1);
    }

    public static String converStringToSqlString(String str, String splitKey) {
        String[] array;
        if (str.contains("'") || str.toLowerCase(Locale.ENGLISH).contains("select")) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        if (CmpStrUtil.isEmpty(str)) {
            return "''";
        }
        for (String s : array = str.split(splitKey)) {
            sb.append("'").append(s).append("',");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static boolean isInteger(Object obj) {
        boolean res = true;
        if (obj == null) {
            return false;
        }
        String value = obj.toString();
        if (!value.matches("[+-]?\\d*")) {
            res = false;
        }
        return res;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isNotEmpty(String s) {
        return !CmpStrUtil.isEmpty(s);
    }

    public static boolean isNullOrEmpty(Object ... objs) {
        boolean flag = false;
        if (null == objs || objs.length == 0) {
            return true;
        }
        for (Object o : objs) {
            if (null == o) {
                return true;
            }
            if (o instanceof String && ((String)o).trim().length() == 0) {
                return true;
            }
            if (o instanceof Integer && CmpStrUtil.toInt(o) == 0) {
                return true;
            }
            if (o instanceof BigDecimal && new BigDecimal(0).equals(CmpStrUtil.toBigDecimal(o))) {
                return true;
            }
            if (o instanceof Collection && ((Collection)o).size() == 0) {
                return true;
            }
            if (o instanceof Set && ((Set)o).size() == 0) {
                return true;
            }
            if (o instanceof List && ((List)o).size() == 0) {
                return true;
            }
            if (o instanceof IObjectCollection && ((IObjectCollection)o).size() == 0) {
                return true;
            }
            if (!(o instanceof Map) || ((Map)o).size() != 0) continue;
            return true;
        }
        return flag;
    }

    public static Integer toInt(Object obj) {
        int res = 0;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (!StringUtils.isEmpty((String)str)) {
            try {
                res = new BigDecimal(str).intValue();
            }
            catch (Exception e5) {
                res = 0;
            }
        }
        return res;
    }

    public static BigDecimal toBigDecimal(Object obj) {
        BigDecimal res = new BigDecimal(0);
        if (obj == null) {
            return null;
        }
        String str = String.valueOf(obj);
        if ("0E-10".equalsIgnoreCase(str)) {
            return res;
        }
        if (!StringUtils.isEmpty((String)str)) {
            try {
                res = new BigDecimal(str);
            }
            catch (Exception e) {
                res = new BigDecimal(0);
            }
        }
        return res;
    }

    public static Date toFirstDateFromMonthStr(String monthDataStr) {
        Calendar c = CmpStrUtil.toMonthDateFromMOnthStr(monthDataStr);
        if (c == null) {
            return null;
        }
        c.set(5, 1);
        return c.getTime();
    }

    public static Date toLastDateFromMonthStr(String monthDataStr) {
        Calendar c = CmpStrUtil.toMonthDateFromMOnthStr(monthDataStr);
        if (c == null) {
            return null;
        }
        c.set(5, c.getActualMaximum(5));
        return c.getTime();
    }

    public static Calendar toMonthDateFromMOnthStr(String monthDataStr) {
        String[] splitStr = monthDataStr.split(".");
        if (splitStr.length < 2 && (splitStr = monthDataStr.split("-")).length < 2 && (splitStr = monthDataStr.split("/")).length < 2 && (splitStr = monthDataStr.split(":")).length < 2) {
            return null;
        }
        String yearStr = splitStr[0];
        String monthStr = splitStr[1];
        if (monthStr.startsWith("0")) {
            monthStr = monthStr.replace("0", "");
        }
        Calendar instance = Calendar.getInstance();
        instance.set(1, Integer.parseInt(yearStr));
        instance.set(2, Integer.parseInt(monthStr) - 1);
        return instance;
    }

    public static Date toDate(Object obj) {
        Date res = null;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (!StringUtils.isEmpty((String)str)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                res = sdf.parse(str);
            }
            catch (ParseException e) {
                sdf = new SimpleDateFormat("yyyy/M/d");
                try {
                    res = sdf.parse(str);
                }
                catch (ParseException e1) {
                    sdf = new SimpleDateFormat("yyyy/MM/dd");
                    try {
                        res = sdf.parse(str);
                    }
                    catch (ParseException e2) {
                        sdf = new SimpleDateFormat("yyyy-M-d");
                        try {
                            res = sdf.parse(str);
                        }
                        catch (ParseException e3) {
                            sdf = new SimpleDateFormat("EEE MMM d H:m:s z y");
                            try {
                                res = sdf.parse(str);
                            }
                            catch (ParseException e4) {
                                sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyy", Locale.US);
                                try {
                                    res = sdf.parse(str);
                                }
                                catch (ParseException e5) {
                                    res = null;
                                }
                            }
                        }
                    }
                }
            }
        }
        return res;
    }

    public static String join(Object obj, String str, String key) {
        Object[] array = null;
        if (CmpStrUtil.isNullOrEmpty(obj)) {
            return "";
        }
        if (obj instanceof Map) {
            if (CmpStrUtil.isNullOrEmpty(key)) {
                return "";
            }
            Map map = (Map)obj;
            if (map.containsKey(key)) {
                return CmpStrUtil.toString(map.get(key));
            }
        }
        if (obj instanceof Object[]) {
            StringBuilder sb = new StringBuilder();
            for (Object arrObj : (Object[])obj) {
                String tempStr = "";
                if (arrObj instanceof Map) {
                    if (CmpStrUtil.isNullOrEmpty(key)) {
                        return "";
                    }
                    Map map = (Map)arrObj;
                    if (map.containsKey(key)) {
                        tempStr = CmpStrUtil.toString(map.get(key));
                    }
                } else {
                    tempStr = CmpStrUtil.toString(arrObj);
                }
                sb.append(str).append(tempStr);
            }
            return sb.toString().replaceFirst(str, "");
        }
        if (obj instanceof Collection) {
            array = ((Collection)obj).toArray();
        } else if (obj instanceof Set) {
            array = ((Set)obj).toArray();
        } else if (obj instanceof List) {
            array = ((List)obj).toArray();
        } else if (obj instanceof IObjectCollection) {
            array = ((IObjectCollection)obj).toArray();
        }
        if (CmpStrUtil.isNullOrEmpty(array)) {
            return CmpStrUtil.toString(obj);
        }
        return CmpStrUtil.join(array, str, key);
    }

    public static String toString(Object obj) {
        try {
            if (obj == null) {
                return "";
            }
            if (obj instanceof String) {
                return obj.toString();
            }
            if (obj instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                return sdf.format(obj);
            }
            return String.valueOf(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        SecureRandom random = CommonMethod.getRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String decodeSorter(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        String[] split = str.split(",");
        StringBuilder res = new StringBuilder();
        for (String s : split) {
            if (StringUtils.isEmpty((String)s) || s.trim().equals("")) continue;
            if (s.contains(".") && !s.contains("\"")) {
                res.append(",\"").append(s.trim().split("\\s")[0]).append("\"");
                if (s.trim().split("\\s").length <= 1) continue;
                res.append(" ").append(s.trim().split("\\s")[1]);
                continue;
            }
            res.append(",").append(s.trim());
        }
        return res.toString().startsWith(",") ? res.toString().substring(1) : res.toString();
    }

    public static String buildInSql(String ids) {
        if (ids.toLowerCase(Locale.ENGLISH).contains("select")) {
            return "(select \"cmp_ctb.id\" from (" + ids + ") as dynamicSql)";
        }
        ids = StringEscapeUtils.escapeSql((String)ids);
        return "('" + ids.replace(",", "','") + "')";
    }

    public static boolean isNumber(String str) {
        if (CmpStrUtil.isEmpty(str)) {
            return false;
        }
        Matcher match = NUMBER_PATTERN.matcher(str);
        return match.matches();
    }

    public static String MD5(String s) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            byte[] btInput = s.getBytes();
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (byte byte0 : md) {
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Boolean isDouble(Object obj) {
        if (null == obj) {
            return false;
        }
        try {
            String str = CmpStrUtil.toString(obj);
            if (null == str) {
                return false;
            }
            if (str.startsWith("0") && !str.startsWith("0.")) {
                return false;
            }
            if (str.split("\\.")[0].length() > 9) {
                return false;
            }
            double b = Double.parseDouble(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Double toDouble(Object obj) {
        if (null == obj) {
            return 0.0;
        }
        return CmpStrUtil.toBigDecimal(obj).doubleValue();
    }

    public static boolean isDate(Object obj) {
        if (obj == null) {
            return false;
        }
        String str = obj.toString();
        if (!(str.matches("\\d{4}/\\d{1,2}/\\d{1,2}") || str.matches("\\d{4}\\.\\d{1,2}\\.\\d{1,2}") || str.matches("\\d{4}-\\d{1,2}-\\d{1,2}"))) {
            return CmpStrUtil.toDate(str) != null;
        }
        return true;
    }

    public static String subZeroAndDot(String s) {
        if (CmpStrUtil.isEmpty(s)) {
            return s;
        }
        if (s.indexOf(".") > 0) {
            s = s.replaceAll("0+?$", "");
            s = s.replaceAll("[.]$", "");
        }
        return s;
    }

    public static String buildSelectSql(String billId) {
        String buildSelectSql = "";
        buildSelectSql = billId.toLowerCase(Locale.ENGLISH).contains("select") ? "(" + billId + ")" : "('" + billId.replace(",", "','") + "')";
        return buildSelectSql;
    }

    public static String convertSetToStringNew(Set<String> personIdSet) {
        String result = "";
        StringBuilder sbr = new StringBuilder();
        if (personIdSet != null && personIdSet.size() > 0) {
            for (String personId : personIdSet) {
                sbr.append(personId).append(",");
            }
            result = sbr.toString();
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

