/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.db;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.util.db.AbstractTempTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CmpInSql<T>
extends AbstractTempTable {
    private static final int DEFAULT_IN_CRITICAL_VALUE = 500;
    private static final int IN_CRITICAL_VALUE_LOWER = 0;
    private static final int IN_CRITICAL_VALUE_UPPER = 500;
    private static final String TMP_TABLE_BASE_ON = "T_HR_CMPITEM";
    private static final String TMP_FID_FIELD_BASE_ON = "FID";
    private static final String TMP_FNUMBER_FIELD_BASE_ON = "FNumber";
    private static final String COPY_TABLE_STRUCTURE_SQL = "SELECT %s tempColumn INTO %s FROM %s WHERE 1<>1";
    private static final String INSERT_SQL = "INSERT INTO %s(tempColumn) VALUES (?)";
    private static final String TEMP_SQL = "(SELECT tempColumn FROM %s)";
    private static Logger logger = Logger.getLogger(CmpInSql.class);
    private final int tranferCritical;

    public CmpInSql() {
        this.tranferCritical = 500;
    }

    public CmpInSql(int tranferCritical) {
        this.tranferCritical = tranferCritical <= 0 || tranferCritical > 500 ? 500 : tranferCritical;
    }

    public static <T> String createInSqlWithoutTmpTable(Context ctx, Collection<T> cols) {
        return CmpInSql.createInSqlWithoutTmpTable(ctx, cols.toArray(), "'");
    }

    private static String createInSqlWithoutTmpTable(Context ctx, Object[] objArray, String splitChar) {
        if (objArray == null) {
            return "(" + splitChar + splitChar + ")";
        }
        return "(" + splitChar + StringUtils.join((Object[])objArray, (String)(splitChar + "," + splitChar)) + splitChar + ")";
    }

    public String createInSqlBaseOnFId(Context ctx, Collection<T> cols) throws BOSException {
        return this.createInSql(ctx, cols, TMP_TABLE_BASE_ON, TMP_FID_FIELD_BASE_ON);
    }

    public String createInSqlOnFId(Context ctx, String selectSQL) throws BOSException {
        return this.createTable(ctx, selectSQL, TMP_TABLE_BASE_ON, TMP_FID_FIELD_BASE_ON);
    }

    public String createInSqlBaseOnFNumber(Context ctx, Collection<T> cols) throws BOSException {
        return this.createInSql(ctx, cols, TMP_TABLE_BASE_ON, TMP_FNUMBER_FIELD_BASE_ON);
    }

    public String createInSql(Context ctx, Collection<T> cols, String tableName, String fieldName) throws BOSException {
        return this.createInSql(ctx, cols.toArray(), "'", tableName, fieldName);
    }

    public String createInSqlNoQuotes(Context ctx, Collection<T> cols, String tableName, String fieldName) throws BOSException {
        return this.createInSql(ctx, cols.toArray(), "", tableName, fieldName);
    }

    public String createInSql(Context ctx, Object[] objArray, String splitChar, String tableName, String fieldName) throws BOSException {
        if (objArray == null) {
            return "(" + splitChar + splitChar + ")";
        }
        if (objArray.length <= this.tranferCritical) {
            return "(" + splitChar + StringUtils.join((Object[])objArray, (String)(splitChar + "," + splitChar)) + splitChar + ")";
        }
        return this.createTable(ctx, objArray, tableName, fieldName);
    }

    protected String createTable(Context ctx, Object[] objArray, String tableName, String fieldName) throws BOSException {
        String tempTableName = this.createTempTableName(ctx);
        String creatTableSql = String.format(COPY_TABLE_STRUCTURE_SQL, fieldName, tempTableName, tableName);
        DbUtil.execute((Context)ctx, (String)creatTableSql);
        ArrayList paramList = Lists.newArrayList();
        for (Object obj : objArray) {
            paramList.add(new Object[]{obj});
        }
        String insertSql = String.format(INSERT_SQL, tempTableName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)StringUtils.join((Object[])objArray, (String)","));
        }
        DbUtil.executeBatch((Context)ctx, (String)insertSql, (List)paramList);
        return String.format(TEMP_SQL, tempTableName);
    }

    protected String createTable(Context ctx, String selectSQL, String tableName, String fieldName) throws BOSException {
        String tempTableName = this.createTempTableName(ctx);
        String creatTableSql = String.format(COPY_TABLE_STRUCTURE_SQL, fieldName, tempTableName, tableName);
        DbUtil.execute((Context)ctx, (String)creatTableSql);
        String insertSql = "insert into " + tempTableName + " " + selectSQL;
        DbUtil.execute((Context)ctx, (String)insertSql);
        return String.format(TEMP_SQL, tempTableName);
    }
}

