/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.message;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.EASResource;
import com.kingdee.shr.compensation.app.config.GlobalConfigCollection;
import com.kingdee.shr.compensation.app.config.GlobalConfigFactory;
import java.util.Locale;

public class MessageUtil {
    public static final String MSG_SETTING_KEY = "tax.task.notice.switch";
    public static boolean needSending = true;

    public static void setNeedSending(Context ctx) {
        try {
            GlobalConfigCollection messageConfig = GlobalConfigFactory.getLocalInstance(ctx).getGlobalConfigCollection("where key = 'tax.task.notice.switch'");
            needSending = !messageConfig.isEmpty() ? "1".equals(messageConfig.get(0).getValue()) : true;
        }
        catch (BOSException e) {
            e.printStackTrace();
            needSending = true;
        }
    }

    public static void sendMessage(Context ctx, String userId, String title, String msg, String category) {
        if (!needSending) {
            return;
        }
        Locale locale = ctx.getLocale();
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Message message = MessageFactory.newMessage();
        message.setBooleanHeader("isSendCommon", Boolean.TRUE.booleanValue());
        message.setLocaleStringHeader("title", title, locale);
        message.setLocaleStringHeader("sender", EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label107", (Locale)ctx.getLocale()), locale);
        message.setLocaleStringHeader("body", msg, locale);
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("receiver", userId);
        message.setStringHeader("category", category);
        senderAgent.sendMessage(message);
    }

    public static void sendSscUrgeMessage(Context ctx, String userId, String title, String msg, String category) {
        MessageUtil.sendSscMessage(ctx, userId, title, msg, category, 10);
    }

    public static void sendSscDistributeMessage(Context ctx, String userId, String title, String msg, String category) {
        MessageUtil.sendSscMessage(ctx, userId, title, msg, category, 10);
    }

    private static void sendSscMessage(Context ctx, String userId, String title, String msg, String category, int msgBizType) {
        Locale locale = ctx.getLocale();
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Message message = MessageFactory.newMessage();
        message.setBooleanHeader("isSendCommon", Boolean.TRUE.booleanValue());
        message.setLocaleStringHeader("title", title, locale);
        message.setLocaleStringHeader("sender", category, locale);
        message.setLocaleStringHeader("body", msg, locale);
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", msgBizType);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("receiver", userId);
        message.setStringHeader("category", category);
        senderAgent.sendMessage(message);
    }
}

