/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.common.util;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.RuntimeErrorException;

public class MethodInvokeUtil {
    private static volatile Method serviceMethod;
    private static Map<String, Method> serviceMethodMap;

    private MethodInvokeUtil() {
    }

    public static Object invoke(Object service, String methodName, Object ... parameters) throws Exception {
        Method method = MethodInvokeUtil.reflectGetMethod(service.getClass(), methodName, parameters == null ? 0 : parameters.length);
        if (method == null && (method = MethodInvokeUtil.reflectGetMethod(service.getClass(), "invoke", parameters == null ? 0 : parameters.length)) == null) {
            throw new RuntimeErrorException(new Error(), "could not foud method " + methodName + " in " + service.getClass().getName());
        }
        return MethodInvokeUtil.reflectInvokeMethod(service, method, parameters);
    }

    private static Object reflectInvokeMethod(Object service, Method method, Object ... parameters) throws Exception {
        return method.invoke(service, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method reflectGetMethod(Class<?> clazz, String method, int paramterLength) {
        String key = clazz.getName() + '#' + method + '#' + paramterLength;
        serviceMethod = serviceMethodMap.get(key);
        if (serviceMethod == null) {
            Map<String, Method> map = serviceMethodMap;
            synchronized (map) {
                serviceMethod = serviceMethodMap.get(key);
                if (serviceMethod == null) {
                    for (Method m : clazz.getMethods()) {
                        if (!m.getName().equalsIgnoreCase(method) || m.getParameterTypes().length != paramterLength) continue;
                        serviceMethod = m;
                        serviceMethodMap.put(key, serviceMethod);
                        break;
                    }
                }
            }
        }
        return serviceMethod;
    }

    static {
        serviceMethodMap = new ConcurrentHashMap<String, Method>();
    }
}

