/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.db.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.data.domain.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.shr.data.model.designtime.AbstractSource;
import com.kingdee.shr.data.model.designtime.source.DBSource;
import com.kingdee.shr.data.model.vo.AbstractNode;
import com.kingdee.shr.data.model.vo.FolderNode;

public class OracleSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String URL_TEMPLATE_SID = "jdbc:oracle:thin:@%s:%s:%s";
    public static final String URL_TEMPLATE_ServerName = "jdbc:oracle:thin:@//%s:%s/%s";
    public static final String DRIVER = "oracle.jdbc.driver.OracleDriver";

    private OracleSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new OracleSourceJDBCAdapter();
    }

    @Override
    public String getLeftDelimiter() {
        return "\"";
    }

    @Override
    public String getRightDelimiter() {
        return "\"";
    }

    public String getSchemaPattern(DBSource dataBase) {
        return "%" + dataBase.getUserName().toUpperCase() + "%";
    }

    @Override
    public AbstractNode getUsableEntities(Context ctx, AbstractSource source) throws BOSException, EASBizException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String tableSql = "SELECT TABLE_NAME FROM USER_TABLES  ORDER BY TABLE_NAME";
        String viewSql = "SELECT VIEW_NAME FROM USER_VIEWS  ORDER BY VIEW_NAME";
        this.queryTableLeafNodes(ctx, root, dataBase, tableSql, null);
        this.queryTableLeafNodes(ctx, root, dataBase, viewSql, null);
        return root;
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) {
        String urlTemplate = "Server Name".equals(dataBase.getConnectType()) ? URL_TEMPLATE_ServerName : URL_TEMPLATE_SID;
        return String.format(urlTemplate, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName());
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }
}

