/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.common.response.ResponseSuccessWrap;
import com.kingdee.shr.common.util.StringUtils;
import com.kingdee.shr.data.domain.AbstractDataSourceDomain;
import com.kingdee.shr.data.domain.SourceDomainFactory;
import com.kingdee.shr.data.domain.imp.AbstractMetaSourceDomain;
import com.kingdee.shr.data.domain.imp.ShrDBCenterSourceDomain;
import com.kingdee.shr.data.domain.util.InitUtils;
import com.kingdee.shr.data.model.ModelDecoder;
import com.kingdee.shr.data.model.designtime.AbstractSource;
import com.kingdee.shr.data.model.runtime.FieldParam;
import com.kingdee.shr.data.model.runtime.Item;
import com.kingdee.shr.data.model.runtime.Table;
import com.kingdee.shr.data.model.vo.AbstractNode;
import com.kingdee.shr.data.model.vo.FuncNode;
import com.kingdee.shr.dataplatform.AbstractDataSetConfigExtInfo;
import com.kingdee.shr.dataplatform.CustomSQLFactory;
import com.kingdee.shr.dataplatform.DataSetConfigExtInfo;
import com.kingdee.shr.dataplatform.DataSetConfigFactory;
import com.kingdee.shr.dataplatform.DataSetConfigHisFactory;
import com.kingdee.shr.dataplatform.DataSetConfigHisInfo;
import com.kingdee.shr.dataplatform.DataSetConfigInfo;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataplatform.ICustomSQL;
import com.kingdee.shr.dataplatform.SetTypeEnum;
import com.kingdee.shr.dataplatform.cache.DataplatformCacheHelper;
import com.kingdee.shr.dataplatform.variable.VariableServiceFactory;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.SQLResult;
import com.kingdee.shr.dataset.service.DataPlatformServiceFactory;
import com.kingdee.shr.dataset.service.IDataPlatformService;
import com.kingdee.shr.dataset.service.IDataSetService;
import com.kingdee.shr.dataset.util.DataSetUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataSetService
implements IDataSetService {
    private static final String SOURCE = "source";

    @Override
    public ResponseSuccessWrap getUsableData(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        String jsonSource = (String)params.get(SOURCE);
        AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
        AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
        AbstractNode root = sourceDomain.getUsableEntities(ctx, source);
        return new ResponseSuccessWrap(root);
    }

    @Override
    public ResponseSuccessWrap getEntityPeer(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        String jsonSource = (String)params.get(SOURCE);
        String entityName = (String)params.get("entityName");
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"params [entityName] is empty."});
        }
        AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
        AbstractMetaSourceDomain sourceDomain = (AbstractMetaSourceDomain)SourceDomainFactory.getSourceDomain(source);
        Map<String, Object> entity = sourceDomain.getEntityPeer(ctx, entityName);
        return new ResponseSuccessWrap(entity);
    }

    @Override
    public ResponseSuccessWrap getDBPeer(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        String jsonSource = (String)params.get(SOURCE);
        String associateName = (String)params.get("associateName");
        AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
        this.setPermItem(source, params);
        ShrDBCenterSourceDomain sourceDomain = (ShrDBCenterSourceDomain)SourceDomainFactory.getSourceDomain(source);
        Table table = sourceDomain.getTablePeer(ctx, source, associateName);
        return new ResponseSuccessWrap(table);
    }

    @Override
    public List<Map<String, Object>> getCustomSQLData(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        String jsonSource = (String)params.get(SOURCE);
        AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
        this.setPermItem(source, params);
        ShrDBCenterSourceDomain sourceDomain = (ShrDBCenterSourceDomain)SourceDomainFactory.getSourceDomain(source);
        return sourceDomain.getCustomSQL(ctx, source);
    }

    @Override
    public List<Item> getDataByField(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        String jsonSource = (String)params.get(SOURCE);
        String jsonField = (String)params.get("fieldParam");
        AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
        FieldParam fieldParam = (FieldParam)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonField, FieldParam.class);
        fieldParam.setPermItem((String)params.get("permItemId"));
        AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
        return sourceDomain.getDataByField(ctx, source, fieldParam);
    }

    @Override
    public List<Map<String, Object>> preview(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        IDataPlatformService service = DataPlatformServiceFactory.getPlateformService("/dataplateform/datasetData.do");
        DataResult dataResult = (DataResult)service.execute(ctx, this.getSQLResult(ctx, params));
        if (null == dataResult) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"dataResult is null!"});
        }
        return dataResult.getRows();
    }

    @Override
    public List<FuncNode> getDBFunc(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        String jsonSource = (String)params.get(SOURCE);
        AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
        AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
        return sourceDomain.getDBFunc(ctx);
    }

    @Override
    public Map<String, Object> getInherentData(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        return InitUtils.init(ctx);
    }

    @Override
    public List<Map<String, String>> getVariableData(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("domain.name"));
        sorter.add(new SorterItemInfo("type"));
        SorterItemInfo sorterItem = new SorterItemInfo("number");
        sorterItem.setSortType(SortType.DESCEND);
        sorter.add(sorterItem);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("useType", (Object)10, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("useType", (Object)20, CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        viewInfo.setFilter(filter);
        viewInfo.setSorter(sorter);
        return VariableServiceFactory.getVariableListData(ctx, viewInfo);
    }

    @Override
    public void deleteCustomSQL(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        String customSQLID = (String)params.get("customSQLID");
        ICustomSQL iCustomSQL = CustomSQLFactory.getLocalInstance(ctx);
        if (!BOSUuid.isValid((String)customSQLID, (boolean)false) && !iCustomSQL.exists((IObjectPK)new ObjectUuidPK(customSQLID))) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"customSQLID is Nonexistent or illegal!"});
        }
        CustomSQLFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(customSQLID));
    }

    @Override
    public String removeCache(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        String key = (String)params.get("cacheKey");
        if ("table".equals(key)) {
            DataplatformCacheHelper.remove(ctx, 5, DataplatformCacheHelper.getRealKey(ctx, "DATAPLATFORM_DATASET_TABLE_TREE"));
        } else if ("customSQL".equals(key)) {
            DataplatformCacheHelper.remove(ctx, 5, DataplatformCacheHelper.getRealKey(ctx, "DATAPLATFORM_DATASET_CUSTOMSQL_TREE"));
        } else if ("entity".equals(key)) {
            DataplatformCacheHelper.remove(ctx, 4, DataplatformCacheHelper.getRealKey(ctx, "DATAPLATFORM_DATASET_ENTITY_TREE"));
        }
        return null;
    }

    public Map<String, String> getDataSetConfigHisById(Context ctx, Map<String, Object> params) throws EASBizException, BOSException {
        String hisId = (String)params.get("hisId");
        if (!BOSUuid.isValid((String)hisId, (boolean)false)) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"hisId is illegal!"});
        }
        DataSetConfigHisInfo model = DataSetConfigHisFactory.getLocalInstance(ctx).getDataSetConfigHisInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)hisId)));
        HashMap contentMap = JSONUtils.convertJsonToObject((Context)ctx, (String)model.getContent());
        DataSetConfigInfo dataSetConfigInfoHis = (DataSetConfigInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)((String)contentMap.get("DataSetConfigInfo")), DataSetConfigInfo.class);
        DataSetConfigInfo info = DataSetConfigFactory.getLocalInstance(ctx).getDataSetConfigInfo((IObjectPK)new ObjectUuidPK(dataSetConfigInfoHis.getId().toString()));
        HashMap<String, String> result = new HashMap<String, String>();
        AbstractDataSetConfigExtInfo dataSetConfigExtInfoHis = null;
        if (!StringUtils.isEmpty((CharSequence)contentMap.get("DataSetConfigExtInfo"))) {
            dataSetConfigExtInfoHis = (DataSetConfigExtInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)((String)contentMap.get("DataSetConfigExtInfo")), DataSetConfigExtInfo.class);
        }
        if (null == dataSetConfigExtInfoHis) {
            if (!StringUtils.isEmpty((CharSequence)info.getContent())) {
                result.put("currentContent", info.getContent());
            } else {
                result.put("currentContent", null);
            }
        } else {
            result.put("currentContent", dataSetConfigExtInfoHis.getContent());
        }
        result.put("selectContent", model.getContent());
        return result;
    }

    private Map<String, Object> getSQLResult(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        String datasetID = null;
        String datasetContent = null;
        SetTypeEnum datasetType = null;
        String datasourceID = null;
        if (params.get("datasetContent") instanceof Map && params.get("datasetType") instanceof String) {
            datasetContent = JSONUtils.convertObjectToJson((Context)ctx, (Object)((Map)params.get("datasetContent")));
            datasetType = SetTypeEnum.getEnum(Integer.parseInt((String)params.get("datasetType")));
        } else if (params.get("dataSetId") instanceof String) {
            datasetID = (String)params.get("dataSetId");
        } else {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"param error [dataSetId,datasetContent,datasetType]."});
        }
        SQLResult result = null;
        if (!StringUtils.isEmpty((CharSequence)datasetContent) && null != datasetType) {
            datasourceID = params.get("datasoruceID") instanceof String ? (String)params.get("datasoruceID") : "ILeTYP+2/kulvw58JCQfXiFEaFA=";
            result = DataSetUtils.getSQLResult(ctx, datasetContent, datasetType, datasourceID);
        } else if (!StringUtils.isEmpty((CharSequence)datasetID) && null == (result = (SQLResult)DataplatformCacheHelper.get(ctx, 2, datasetID))) {
            result = DataSetUtils.getSQLResultAndSaveSQLResult(ctx, datasetID);
        }
        List paramValues = null;
        if (null != params.get("runParam")) {
            paramValues = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)((String)params.get("runParam")), List.class);
        }
        params.put("sqlResult", result);
        params.putIfAbsent("isPreview", true);
        params.put("runParam", paramValues);
        return params;
    }

    private void setPermItem(AbstractSource source, Map<String, Object> params) {
        if (StringUtils.isEmpty((CharSequence)source.getPermItemId())) {
            source.setPermItemId((String)params.get("permItemId"));
        }
    }

    @Override
    public Object execute(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        return null;
    }
}

