/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.card.model.CardParams;
import com.kingdee.shr.dataplatform.DataSetConfigFactory;
import com.kingdee.shr.dataplatform.DataSetConfigInfo;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataplatform.SetTypeEnum;
import com.kingdee.shr.dataset.model.DataSourceItem;
import com.kingdee.shr.dataset.model.DesignDataSetCommon;
import com.kingdee.shr.dataset.model.SQLResult;
import com.kingdee.shr.dataset.service.IDataPlatformService;
import com.kingdee.shr.dataset.service.sql.CustomSqlParsingService;
import com.kingdee.shr.dataset.service.sql.EntitySqlParsingService;
import com.kingdee.shr.dataset.service.sql.JavaParsingService;
import com.kingdee.shr.dataset.service.sql.SqlParsingService;
import com.kingdee.shr.dataset.service.sql.TableSqlParsingService;
import com.kingdee.shr.dataset.util.DataSetUtils;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class SQLParsingEngineService
implements IDataPlatformService {
    @Override
    public SQLResult execute(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        Boolean isProductionMode;
        DataSetConfigInfo model;
        String datasetID = (String)param.get("datasetID");
        String datasetContent = (String)param.get("datasetContent");
        SetTypeEnum datasetType = (SetTypeEnum)((Object)param.get("datasetType"));
        CardParams cardParams = (CardParams)param.get("cardParams");
        DesignDataSetCommon designDataSetCommon = null;
        String datasourceID = null;
        if (!StringUtils.isEmpty((String)datasetContent) && null != datasetType) {
            designDataSetCommon = DataSetUtils.getDataSetModel(ctx, datasetContent, datasetType);
        } else if (!StringUtils.isEmpty((String)datasetID)) {
            model = DataSetConfigFactory.getLocalInstance(ctx).getDataSetConfigInfo((IObjectPK)new ObjectUuidPK(datasetID));
            datasetType = model.getSetType();
            isProductionMode = (Boolean)param.get("isProductionMode");
            model.put("isProductionMode", isProductionMode);
            designDataSetCommon = DataSetUtils.getDataSetModel(ctx, model);
            datasourceID = model.getDatasource().getId().toString();
        } else if (null != cardParams) {
            if (StringUtils.isEmpty((String)cardParams.getDataSetId())) {
                throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"CardParams.dataSetId is empty!"});
            }
            model = DataSetConfigFactory.getLocalInstance(ctx).getDataSetConfigInfo((IObjectPK)new ObjectUuidPK(cardParams.getDataSetId()));
            isProductionMode = (Boolean)param.get("isProductionMode");
            model.put("isProductionMode", isProductionMode);
            datasetType = model.getSetType();
            designDataSetCommon = DataSetUtils.getDataSetModel(ctx, model);
            datasourceID = model.getDatasource().getId().toString();
            HashMap<String, Object> initConfig = new HashMap<String, Object>(2);
            initConfig.put("dimension", cardParams.getDimension());
            initConfig.put("measure", cardParams.getMeasure());
            designDataSetCommon.setInitConfig(initConfig);
        } else {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"param missing!"});
        }
        SqlParsingService service = null;
        if (SetTypeEnum.META_ENTITY.equals((Object)datasetType)) {
            service = new EntitySqlParsingService();
        } else if (SetTypeEnum.DB_TABLE.equals((Object)datasetType)) {
            service = new TableSqlParsingService();
        } else if (SetTypeEnum.CUSTOM_SQL.equals((Object)datasetType)) {
            service = new CustomSqlParsingService();
        } else if (SetTypeEnum.JAVA_INTERFACE.equals((Object)datasetType)) {
            service = new JavaParsingService();
        }
        param.put("designDataSetCommon", designDataSetCommon);
        if (null != service) {
            SQLResult result = (SQLResult)service.execute(ctx, param);
            result.setSetType(datasetType.getValue());
            if (!StringUtils.isEmpty((String)datasourceID)) {
                DataSourceItem ds = new DataSourceItem();
                ds.setId(datasourceID);
                result.setDataSourceItem(ds);
            }
            return result;
        }
        return null;
    }
}

