/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service.sql;

import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.data.model.designtime.type.DataType;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataset.model.SQLResult;
import com.kingdee.shr.dataset.model.SelectorItem;
import com.kingdee.shr.dataset.service.IDataPlatformService;
import com.kingdee.shr.dataset.service.util.CheckHelper;
import com.kingdee.shr.dataset.service.util.SQLExcuteHelper;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public abstract class AbstractSqlParsingService
implements IDataPlatformService {
    protected static Logger logger = Logger.getLogger(AbstractSqlParsingService.class);

    protected String assembleSQL(String dimension, String groupBy, String measure, String from, String where, String orderBy) {
        boolean isgroup = false;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT").append(" ");
        if (StringUtils.isEmpty((String)dimension)) {
            if (!StringUtils.isEmpty((String)measure)) {
                sql.append(measure);
            }
        } else {
            sql.append(dimension);
            if (!StringUtils.isEmpty((String)measure)) {
                sql.append(", ").append(measure);
            }
        }
        sql.append(" ").append("FROM").append(" ").append(from).append(" ");
        if (!StringUtils.isEmpty((String)where)) {
            sql.append(" ").append("WHERE").append(" ").append(where);
        }
        if (!StringUtils.isEmpty((String)measure) && !StringUtils.isEmpty((String)groupBy)) {
            sql.append(" ").append("GROUP BY").append(" ").append(groupBy);
            isgroup = true;
        }
        if (!StringUtils.isEmpty((String)orderBy)) {
            if (isgroup) {
                StringBuilder sqlsuper = new StringBuilder();
                sqlsuper.append("SELECT * FROM (").append(sql.toString()).append(") AS TEMP_GROUP ").append("ORDER BY").append(" ").append(orderBy);
                return sqlsuper.toString();
            }
            sql.append(" ").append("ORDER BY").append(" ").append(orderBy);
            return sql.toString();
        }
        return sql.toString();
    }

    protected final String assembleVariableStr(String field, String symbol, String variableName) {
        StringBuilder sb = new StringBuilder();
        sb.append(field).append(" ").append(symbol).append(" ").append("{@").append(variableName).append("}").append(" ");
        return sb.toString();
    }

    protected final String assembleVariableStrWithBracket(String field, String symbol, String variableName) {
        StringBuilder sb = new StringBuilder();
        sb.append(field).append(" ").append(symbol).append(" (").append("{@").append(variableName).append("}").append(") ");
        return sb.toString();
    }

    protected final String assembleVariableStr(String field, String symbol, String variableName, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(field).append(" ").append(symbol).append(" ").append("{@").append(variableName).append(suffix).append("}").append(" ");
        return sb.toString();
    }

    protected final String assembleParamStr(String field, String symbol, String paramName, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(field).append(" ").append(symbol).append(" ").append("{").append(paramName).append(suffix).append("}").append(" ");
        return sb.toString();
    }

    protected final String assembleParamStr(String field, String symbol, String paramName) {
        StringBuilder sb = new StringBuilder();
        sb.append(field).append(" ").append(symbol).append(" ").append("{").append(paramName).append("}").append(" ");
        return sb.toString();
    }

    protected final String assembleParamStrWithBracket(String field, String symbol, String paramName) {
        StringBuilder sb = new StringBuilder();
        sb.append(field).append(" ").append(symbol).append(" (").append("{").append(paramName).append("}").append(") ");
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doCompareValue(Context ctx, String field, String dataType, String symbol, Object inputValue, SQLResult result, StringBuilder sb, String sourceRef) throws EASBizException {
        CheckHelper.checkCompareSymbolByDataType(dataType, symbol);
        String uuid = UUID.randomUUID().toString().replace("-", "");
        Object value = null;
        if (DataType.STRING.toString().equals(dataType)) {
            if ("=".equals(symbol) || "<>".equals(symbol)) {
                if (field.endsWith("{@i18n_langue}") && inputValue instanceof Map) {
                    Map mapValue = (Map)inputValue;
                    value = mapValue.get(ctx.getLocale().getDisplayName());
                } else if (inputValue instanceof Map) {
                    Map mapValue = (Map)inputValue;
                    value = mapValue.get(ctx.getLocale().getDisplayName());
                } else {
                    value = String.valueOf(inputValue);
                }
                sb.append(this.assembleVariableStr(field, symbol, uuid));
                result.getInnerParam().put(uuid, value);
                return;
            } else if ("is not null".equals(symbol)) {
                sb.append(field).append(" IS NOT NULL ");
                return;
            } else {
                if (!"is null".equals(symbol)) return;
                sb.append(field).append(" IS NULL ");
            }
            return;
        } else if (DataType.NUMBER.toString().equals(dataType) || DataType.INT.toString().equals(dataType)) {
            String[] css = symbol.split("\\|");
            if (inputValue instanceof Number && css.length == 1) {
                value = inputValue;
                sb.append(this.assembleVariableStr(field, symbol, uuid));
                result.getInnerParam().put(uuid, value);
                return;
            } else {
                if (!(inputValue instanceof List) || ((List)inputValue).size() != 2 || css.length != 2) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("Field:{0} ,Value:{1}, is not Number Type.", field, String.valueOf(inputValue))});
                List vv = (List)inputValue;
                if (!(((Map)vv.get(0)).get("v") instanceof Number) || !(((Map)vv.get(1)).get("v") instanceof Number)) {
                    throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("Field:{0} ,Value:{1}, is not Number Type.", field, String.valueOf(inputValue))});
                }
                sb.append(" (");
                sb.append(this.assembleVariableStr(field, css[0], uuid));
                result.getInnerParam().put(uuid, ((Map)vv.get(0)).get("v"));
                uuid = UUID.randomUUID().toString().replace("-", "");
                sb.append(" AND ");
                sb.append(this.assembleVariableStr(field, css[1], uuid));
                sb.append(") ");
                result.getInnerParam().put(uuid, ((Map)vv.get(1)).get("v"));
            }
            return;
        } else if (DataType.DATE.toString().equals(dataType) || DataType.TIMESTAMP.toString().equals(dataType) || DataType.TIME.toString().equals(dataType)) {
            String[] css = symbol.split("\\|");
            if ((inputValue instanceof Date || inputValue instanceof Timestamp) && css.length == 1) {
                value = inputValue;
                sb.append(this.assembleVariableStr(field, symbol, uuid));
                result.getInnerParam().put(uuid, value);
                return;
            } else if (inputValue instanceof String && css.length == 1) {
                try {
                    value = new Timestamp(DateTimeUtils.parseDate((String)((String)inputValue)).getTime());
                    sb.append(this.assembleVariableStr(field, symbol, uuid));
                    result.getInnerParam().put(uuid, value);
                    return;
                }
                catch (ParseException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("Field:{0} ,Value:{1}, is not Date Type.", field, String.valueOf(inputValue))});
                }
            } else {
                if (!(inputValue instanceof List) || ((List)inputValue).size() != 2 || css.length != 2) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("Field:{0} ,Value:{1}, is not Date Type.", field, String.valueOf(inputValue))});
                try {
                    List vv = (List)inputValue;
                    sb.append(" (");
                    sb.append(this.assembleVariableStr(field, css[0], uuid));
                    result.getInnerParam().put(uuid, new Timestamp(DateTimeUtils.parseDate((String)((String)((Map)vv.get(0)).get("v"))).getTime()));
                    uuid = UUID.randomUUID().toString().replace("-", "");
                    sb.append(" AND ");
                    sb.append(this.assembleVariableStr(field, css[1], uuid));
                    sb.append(") ");
                    result.getInnerParam().put(uuid, new Timestamp(DateTimeUtils.parseDate((String)((String)((Map)vv.get(1)).get("v"))).getTime()));
                    return;
                }
                catch (ParseException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("Field:{0} ,Value:{1}, is not Date Type.", field, String.valueOf(inputValue))});
                }
            }
        } else if (DataType.BOOLEAN.toString().equals(dataType)) {
            if (inputValue instanceof Boolean) {
                value = (Boolean)inputValue != false ? 1 : 0;
                sb.append(this.assembleVariableStr(field, symbol, uuid));
                result.getInnerParam().put(uuid, value);
                return;
            } else {
                if (!(inputValue instanceof String)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("Field:{0} ,Value:{1}, is not Boolean Type.", field, String.valueOf(inputValue))});
                String temp = String.valueOf(inputValue);
                value = 0;
                if ("1".equals(temp)) {
                    value = 1;
                } else {
                    if (!"0".equals(temp)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("Field:{0} ,Value:{1}, is not Boolean Type.", field, String.valueOf(inputValue))});
                    value = 0;
                }
                sb.append(this.assembleVariableStr(field, symbol, uuid));
                result.getInnerParam().put(uuid, value);
            }
            return;
        } else if (DataType.ENUM.toString().equals(dataType)) {
            if (!(inputValue instanceof List)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("Field:{0} ,Value:{1}, is not Enum Type.", field, String.valueOf(inputValue))});
            List tl = (List)inputValue;
            this.doCompareValueList(ctx, field, symbol, tl, uuid, sb, "ENUM", sourceRef);
            return;
        } else {
            if (!DataType.F7.toString().equals(dataType)) return;
            if (!(inputValue instanceof List)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("Field:{0} ,Value:{1}, is not F7 Type.", field, String.valueOf(inputValue))});
            List tl = (List)inputValue;
            this.doCompareValueList(ctx, field, symbol, tl, uuid, sb, "F7", sourceRef);
        }
    }

    private void doCompareValueList(Context ctx, String field, String symbol, List tl, String uuid, StringBuilder sb, String dataType, String sourceRef) {
        sb.append(field).append(" ").append(CheckHelper.getCompareSymbolForEnumOrF7(symbol)).append(" (").append(SQLExcuteHelper.doCompareValueList(ctx, dataType, sourceRef, tl)).append(") ");
    }

    protected final String getFieldAlias(SelectorItem selector) {
        return MessageFormat.format("\"{0}.{1}\"", selector.getTableId(), selector.getName());
    }

    protected final String getFieldAlias(String fieldName) {
        return MessageFormat.format("\"{0}\"", fieldName);
    }
}

