/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service.util;

import com.kingdee.shr.dataset.model.DesignDataSetCommon;
import com.kingdee.shr.dataset.model.DesignDataSetJava;
import com.kingdee.shr.dataset.model.DesignDataSetSql;
import com.kingdee.shr.dataset.model.SelectorItem;
import com.kingdee.shr.dataset.model.SelectorObjItem;
import com.kingdee.shr.pageset.model.SelectorItemUModeParent;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectorHelper {
    private Map<String, SelectorItem> selectFieldAliasMapping = new HashMap<String, SelectorItem>();
    private Map<String, SelectorItem> selectMapping = new HashMap<String, SelectorItem>();

    public SelectorHelper(DesignDataSetCommon designDataSetCommon) {
        this.init(designDataSetCommon);
    }

    private void init(DesignDataSetCommon designDataSetCommon) {
        String alias;
        int i;
        int total;
        if (null == designDataSetCommon || null == designDataSetCommon.getSelector()) {
            return;
        }
        SelectorObjItem soi = designDataSetCommon.getSelector();
        boolean isUseSourceSQLQuery = false;
        if (designDataSetCommon instanceof DesignDataSetSql && null != designDataSetCommon.getBizObject() && designDataSetCommon.getBizObject().isSql() && null != designDataSetCommon.getBizObject().getCustomSQL() && designDataSetCommon.getBizObject().getCustomSQL().isUseSourceSQLQuery()) {
            isUseSourceSQLQuery = true;
        }
        List<SelectorItem> dimension = soi.getDimension();
        List<SelectorItem> measure = soi.getMeasure();
        if (!dimension.isEmpty()) {
            total = dimension.size();
            for (i = 0; i < total; ++i) {
                SelectorItem dimensionEach = dimension.get(i);
                this.selectMapping.put(dimensionEach.getId(), dimensionEach);
                if (isUseSourceSQLQuery || designDataSetCommon instanceof DesignDataSetJava) {
                    alias = dimensionEach.getName();
                    if (StringUtils.isEmpty((String)alias)) {
                        alias = dimensionEach.getPhysicsName();
                    }
                    this.selectFieldAliasMapping.put(alias, dimensionEach);
                    continue;
                }
                this.selectFieldAliasMapping.put(MessageFormat.format("{0}.{1}", dimensionEach.getTableId(), dimensionEach.getName()), dimensionEach);
            }
        }
        if (!measure.isEmpty()) {
            total = measure.size();
            for (i = 0; i < total; ++i) {
                SelectorItem measureEach = measure.get(i);
                this.selectMapping.put(measureEach.getId(), measureEach);
                if (isUseSourceSQLQuery || designDataSetCommon instanceof DesignDataSetJava) {
                    alias = measureEach.getName();
                    if (StringUtils.isEmpty((String)alias)) {
                        alias = measureEach.getPhysicsName();
                    }
                    this.selectFieldAliasMapping.put(alias, measureEach);
                    continue;
                }
                this.selectFieldAliasMapping.put(MessageFormat.format("{0}.{1}", measureEach.getTableId(), measureEach.getName()), measureEach);
            }
        }
    }

    public Map<String, SelectorItem> getSelectMapping() {
        return this.selectMapping;
    }

    public List<SelectorItem> getDimensionSelector(List<SelectorItem> dimension, Map<String, Object> initConfig) {
        if (null == initConfig) {
            return dimension;
        }
        List cardDimension = (List)initConfig.get("dimension");
        return this.getCardSelector(cardDimension);
    }

    public List<SelectorItem> getMeasureSelector(List<SelectorItem> measure, Map<String, Object> initConfig) {
        if (null == initConfig) {
            return measure;
        }
        List cardMeasure = (List)initConfig.get("measure");
        return this.getCardSelector(cardMeasure);
    }

    private List<SelectorItem> getCardSelector(List<SelectorItemUModeParent> cardSelector) {
        ArrayList<SelectorItem> result = new ArrayList<SelectorItem>();
        for (SelectorItemUModeParent e : cardSelector) {
            if (!this.selectFieldAliasMapping.containsKey(e.getValue())) continue;
            SelectorItem selectorItem = this.getSelectorItemByFieldAlias(e.getValue());
            if (e.isDrillField()) {
                selectorItem.setDrillField(true);
                selectorItem.setDrill(e.getDrill());
            }
            result.add(selectorItem);
        }
        return result;
    }

    public SelectorItem getSelectorItemByFieldAlias(String fieldAlias) {
        return this.selectFieldAliasMapping.get(fieldAlias);
    }
}

