/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.econtractservice.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillEntryInfo;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillInfo;
import com.kingdee.shr.econtractservice.util.ElectronicContractTaskUtils;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.shr.shareservice.TaskMessageLogFactory;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfterTaskListGetDataThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AfterTaskListGetDataThread.class);
    private String threadName;
    private CountDownLatch latch;
    private Context ctx;
    private Map<String, Object> row;

    public AfterTaskListGetDataThread(CountDownLatch latch, Context ctx, Map<String, Object> row) {
        this.latch = latch;
        this.ctx = ctx;
        this.row = row;
        this.threadName = row.hashCode() + "";
    }

    @Override
    public void run() {
        try {
            this.processBillInfo();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        finally {
            this.latch.countDown();
        }
    }

    protected void processBillInfo() {
        SelectorItemCollection seletor = new SelectorItemCollection();
        seletor.add(new SelectorItemInfo("billState"));
        seletor.add(new SelectorItemInfo("entrys.signState"));
        seletor.add(new SelectorItemInfo("entrys.person.name"));
        seletor.add(new SelectorItemInfo("entrys.adminOrg.name"));
        seletor.add(new SelectorItemInfo("totalState"));
        String billId = (String)this.row.get("billID");
        BOSUuid bosUuid = BOSUuid.read((String)billId);
        String bosType = bosUuid.getType().toString();
        HRBillBaseInfo hrBillBaseInfo = null;
        HRBillBaseEntryInfo hrBillBaseEntryInfo = null;
        try {
            if ("CB88E0A5".equals(bosType)) {
                seletor.add(new SelectorItemInfo("entrys.preEntryPerson.name"));
                seletor.add(new SelectorItemInfo("isPreEntry"));
            }
            hrBillBaseInfo = ElectronicContractTaskUtils.getHRBillBaseInfo(this.ctx, billId, seletor);
            hrBillBaseEntryInfo = ElectronicContractTaskUtils.switchHrBillBaseEntryInfo(this.ctx, hrBillBaseInfo, bosUuid);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String personId = "";
        String personName = "";
        String adminName = "";
        if (hrBillBaseEntryInfo != null) {
            try {
                PreEntryPersonInfo personInfo;
                if ("9F4ECBD6".equals(bosType)) {
                    personInfo = (PreEntryPersonInfo)hrBillBaseEntryInfo.get("person");
                    personId = personInfo.getId().toString();
                    personName = personInfo.getName();
                } else if ("CB88E0A5".equals(bosType)) {
                    if (hrBillBaseEntryInfo instanceof OtherContractSignBizBillEntryInfo) {
                        OtherContractSignBizBillInfo otherBillInfo = (OtherContractSignBizBillInfo)hrBillBaseInfo;
                        OtherContractSignBizBillEntryInfo otherBillEntryInfo = (OtherContractSignBizBillEntryInfo)hrBillBaseEntryInfo;
                        if (otherBillInfo.isIsPreEntry()) {
                            PreEntryPersonInfo personInfo2 = otherBillEntryInfo.getPreEntryPerson();
                            personId = personInfo2.getId().toString();
                            personName = personInfo2.getName();
                        } else {
                            PersonInfo personInfo3 = otherBillEntryInfo.getPerson();
                            personId = personInfo3.getId().toString();
                            personName = personInfo3.getName();
                        }
                    }
                } else {
                    personInfo = (PersonInfo)hrBillBaseEntryInfo.get("person");
                    personId = personInfo.getId().toString();
                    personName = personInfo.getName();
                }
                AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)hrBillBaseEntryInfo.get("adminOrg");
                adminName = adminOrgUnitInfo.getName();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.row.put("personId", personId);
    }

    protected void isSengMessage() {
        String billId = (String)this.row.get("billID");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isSend", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("sendResult", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("businessId", (Object)billId));
        boolean isSend = false;
        try {
            if (TaskMessageLogFactory.getLocalInstance((Context)this.ctx).exists(filter)) {
                isSend = true;
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.row.put("isSendMessage", isSend);
    }

    public final String getThreadName() {
        return this.threadName;
    }

    public final CountDownLatch getLatch() {
        return this.latch;
    }

    public final Context getCtx() {
        return this.ctx;
    }

    public final Map<String, Object> getRow() {
        return this.row;
    }
}

