/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.SensitiveConfigCollection;
import com.kingdee.shr.base.permission.SensitiveConfigEntryCollection;
import com.kingdee.shr.base.permission.SensitiveConfigEntryFactory;
import com.kingdee.shr.base.permission.SensitiveConfigEntryInfo;
import com.kingdee.shr.base.permission.SensitiveConfigFactory;
import com.kingdee.shr.base.permission.SensitiveConfigInfo;
import com.kingdee.shr.base.permission.SensitiveRuleFactory;
import com.kingdee.shr.base.permission.SensitiveRuleInfo;
import com.kingdee.shr.base.syssetting.sensitive.rule.SensitiveRuleBuilderFactory;
import com.kingdee.shr.elecontract.vo.ETemplateDateFormat;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowSetUtils {
    private static final Logger logger = LoggerFactory.getLogger(RowSetUtils.class);

    public static Map<String, String> transformRowSetValue(Context ctx, Map<String, String> infoMap, JSONArray templateQueryField, IRowSet executeQuery, Map<String, Object> queryParam) throws SQLException, BOSException, EASBizException, UuidException {
        boolean moveAc = executeQuery.first();
        if (!moveAc) {
            String label51 = SHRServerResource.getString((String)"com.kingdee.shr.elecontract.EleContractResource_880", (String)"label0", (Context)ctx);
            throw new BOSException(label51);
        }
        boolean isLast = true;
        try {
            isLast = executeQuery.isLast();
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (!isLast) {
            String label51 = SHRServerResource.getString((String)"com.kingdee.shr.elecontract.EleContractResource_880", (String)"label0", (Context)ctx);
            throw new BOSException(label51);
        }
        SelectorInfo selector = (SelectorInfo)queryParam.get("selector");
        QueryExecuteOption option = (QueryExecuteOption)queryParam.get("option");
        Map fieldsMppingBusiness = (Map)queryParam.get("fieldsMppingBusiness");
        Map GDPR_KEY_MAP = (Map)queryParam.get("GDPR_MAPINF");
        DataType dataType = null;
        OwnPropertyInfo _p_ = null;
        Object metaFieldValue = null;
        String fieldName = "";
        String entityName = "";
        int selectorSize = selector.size();
        for (int i = 0; i < templateQueryField.size(); ++i) {
            metaFieldValue = "";
            JSONObject config = templateQueryField.getJSONObject(i);
            String key = config.getString("key");
            String metaField = config.getString("metafield");
            String isSensitive = config.getString("isSensitive");
            String metaFieldSqlKey = null;
            metaFieldSqlKey = ((String)fieldsMppingBusiness.get(metaField)).toLowerCase();
            if (GDPR_KEY_MAP.containsKey(metaFieldSqlKey)) {
                List keyList = (List)GDPR_KEY_MAP.get(metaFieldSqlKey);
                boolean isAllNull = true;
                for (int dexn = 0; dexn < keyList.size(); ++dexn) {
                    String tempkey = (String)keyList.get(dexn);
                    Object tempValue = executeQuery.getObject(tempkey);
                    if (tempValue == null) continue;
                    isAllNull = false;
                    metaFieldSqlKey = tempkey;
                }
                if (isAllNull) {
                    infoMap.put(key, "/");
                    continue;
                }
            }
            boolean isFind = false;
            for (int dex = 0; dex < selectorSize; ++dex) {
                QueryFieldInfo queryFieldInfo = selector.get(dex);
                if (!metaField.equalsIgnoreCase(queryFieldInfo.getName())) continue;
                isFind = true;
                PropertyRefInfo propertyRefInfo = queryFieldInfo.getPropertyRefs().get(0);
                if (propertyRefInfo != null) {
                    _p_ = (OwnPropertyInfo)propertyRefInfo.getRefProperty();
                    entityName = propertyRefInfo.getSubEntity().getEntityRef().getRealFullName();
                    fieldName = _p_.getName();
                    dataType = _p_.getDataType();
                }
                if (dataType != null && _p_ != null) {
                    if (DataType.ENUM.equals(dataType)) {
                        if (option.isAutoTranslateEnum) {
                            String enumClassName = _p_.getMetaDataRef();
                            if (!StringUtils.isEmpty((String)enumClassName)) {
                                try {
                                    Object enumByValue;
                                    metaFieldValue = executeQuery.getObject(metaFieldSqlKey);
                                    if (metaFieldValue != null && (enumByValue = RowSetUtils.findEnumByValue(enumClassName, metaFieldValue)) != null && enumByValue instanceof Enum) {
                                        Enum enumVa = (Enum)enumByValue;
                                        metaFieldValue = enumVa.getAlias();
                                    }
                                }
                                catch (Exception e) {
                                    logger.error(e.getMessage(), (Throwable)e);
                                }
                            }
                        } else {
                            metaFieldValue = executeQuery.getObject(metaFieldSqlKey);
                        }
                    }
                    if (DataType.BOOLEAN.equals(dataType)) {
                        boolean tempValue = executeQuery.getBoolean(metaFieldSqlKey);
                        metaFieldValue = option.isAutoTranslateBoolean ? (tempValue ? "\u662f" : "\u5426") : Boolean.valueOf(tempValue);
                    }
                    if (DataType.STRING.equals((Object)dataType) || DataType.CHAR.equals((Object)dataType)) {
                        metaFieldValue = executeQuery.getString(metaFieldSqlKey);
                    }
                    if (DataType.OBJECTPK.equals((Object)dataType) || DataType.BOSUUID.equals((Object)dataType) || DataType.UUID.equals((Object)dataType)) {
                        metaFieldValue = executeQuery.getString(metaFieldSqlKey);
                    }
                    if (DataType.SHORT.equals((Object)dataType)) {
                        metaFieldValue = executeQuery.getShort(metaFieldSqlKey);
                    }
                    if (DataType.INTEGER.equals((Object)dataType) && executeQuery.getObject(metaFieldSqlKey) != null) {
                        metaFieldValue = executeQuery.getInt(metaFieldSqlKey);
                    }
                    if (DataType.LONG.equals((Object)dataType) && executeQuery.getObject(metaFieldSqlKey) != null) {
                        metaFieldValue = executeQuery.getLong(metaFieldSqlKey);
                    }
                    if (DataType.FLOAT.equals((Object)dataType)) {
                        metaFieldValue = Float.valueOf(executeQuery.getFloat(metaFieldSqlKey));
                    }
                    if (DataType.DOUBLE.equals((Object)dataType) && executeQuery.getObject(metaFieldSqlKey) != null) {
                        metaFieldValue = executeQuery.getDouble(metaFieldSqlKey);
                    }
                    if (DataType.DECIMAL.equals((Object)dataType)) {
                        BigDecimal bigDecimal = executeQuery.getBigDecimal(metaFieldSqlKey);
                        if (bigDecimal != null) {
                            bigDecimal = bigDecimal.setScale(2, RoundingMode.HALF_UP);
                        }
                        metaFieldValue = bigDecimal;
                    }
                    if (DataType.DATE.equals((Object)dataType) || DataType.TIME.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType)) {
                        Object colVal = executeQuery.getObject(metaFieldSqlKey);
                        Date forDate = null;
                        if (colVal == null) {
                            metaFieldValue = "";
                        } else if (colVal instanceof Date) {
                            forDate = (Date)colVal;
                        } else if (colVal instanceof Time) {
                            forDate = (Time)colVal;
                        } else if (colVal instanceof Timestamp) {
                            forDate = (Timestamp)colVal;
                        } else {
                            metaFieldValue = "";
                        }
                        if (forDate != null) {
                            metaFieldValue = RowSetUtils.convertDateValue(ctx, config, forDate);
                        }
                    }
                } else {
                    metaFieldValue = "";
                }
                String endValue = "/";
                if (metaFieldValue != null) {
                    endValue = metaFieldValue.toString();
                    if ("true".equals(isSensitive)) {
                        endValue = RowSetUtils.getEncryFieldValue(ctx, fieldName, entityName, endValue);
                    }
                }
                if (StringUtils.isEmpty((String)endValue)) {
                    endValue = "/";
                }
                infoMap.put(key, endValue);
                break;
            }
            if (isFind) continue;
            String endValue = metaFieldValue.toString();
            if (StringUtils.isEmpty((String)endValue)) {
                endValue = "/";
            }
            infoMap.put(key, endValue);
        }
        return infoMap;
    }

    public static Object findEnumByValue(String enumSource, Object compareValue) {
        List enumList = EnumUtils.getEnumList((String)enumSource);
        int size = enumList.size();
        for (int i = 0; i < size; ++i) {
            Enum objEnum = (Enum)enumList.get(i);
            if (objEnum instanceof StringEnum) {
                String enumValue = ((StringEnum)objEnum).getValue();
                String compareValue0 = null;
                compareValue0 = compareValue instanceof String ? (String)compareValue : String.valueOf(compareValue);
                if (!compareValue0.equals(enumValue)) continue;
                return objEnum;
            }
            if (objEnum instanceof DynamicEnum) {
                String enumValue = ((DynamicEnum)objEnum).getValue();
                String compareValue0 = null;
                compareValue0 = compareValue instanceof String ? (String)compareValue : String.valueOf(compareValue);
                if (!compareValue0.equals(enumValue)) continue;
                return objEnum;
            }
            if (objEnum instanceof LongEnum) {
                long enumValue = ((LongEnum)objEnum).getValue();
                long inputValue = -99999L;
                inputValue = compareValue instanceof String ? Long.valueOf(compareValue.toString()) : (compareValue instanceof BigDecimal ? ((BigDecimal)compareValue).longValue() : (compareValue instanceof Long ? ((Long)compareValue).longValue() : Long.valueOf(compareValue.toString()).longValue()));
                if (enumValue != inputValue && !compareValue.equals(enumValue)) continue;
                return objEnum;
            }
            if (objEnum instanceof IntEnum) {
                int enumValue = ((IntEnum)objEnum).getValue();
                int inputValue = -99999;
                inputValue = compareValue instanceof String ? Integer.valueOf(compareValue.toString()) : (compareValue instanceof BigDecimal ? ((BigDecimal)compareValue).intValue() : (compareValue instanceof Integer ? ((Integer)compareValue).intValue() : Integer.valueOf(compareValue.toString()).intValue()));
                if (enumValue != inputValue && !compareValue.equals(enumValue)) continue;
                return objEnum;
            }
            if (objEnum instanceof FloatEnum) {
                float enumValue = ((FloatEnum)objEnum).getValue();
                float inputValue = -99999.99f;
                inputValue = compareValue instanceof String ? Float.valueOf(compareValue.toString()).floatValue() : (compareValue instanceof BigDecimal ? ((BigDecimal)compareValue).floatValue() : (compareValue instanceof Float ? ((Float)compareValue).floatValue() : Float.valueOf(compareValue.toString()).floatValue()));
                if (enumValue != inputValue && !compareValue.equals(Float.valueOf(enumValue))) continue;
                return objEnum;
            }
            if (objEnum instanceof DoubleEnum) {
                double enumValue = ((DoubleEnum)objEnum).getValue();
                double inputValue = -99999.0;
                inputValue = compareValue instanceof String ? Double.valueOf(compareValue.toString()) : (compareValue instanceof BigDecimal ? ((BigDecimal)compareValue).doubleValue() : (compareValue instanceof Double ? ((Double)compareValue).doubleValue() : Double.valueOf(compareValue.toString()).doubleValue()));
                if (enumValue != inputValue && !compareValue.equals(enumValue)) continue;
                return objEnum;
            }
            String enumValue = objEnum.getName();
            if (!compareValue.equals(enumValue)) continue;
            return objEnum;
        }
        return null;
    }

    public static String convertDateValue(Context ctx, JSONObject config, Date value) {
        String fieldValueStr = "";
        if (value == null) {
            return fieldValueStr;
        }
        String format = config.getString("format");
        ETemplateDateFormat formator = ETemplateDateFormat.getFormat(format);
        if (formator == null) {
            formator = ETemplateDateFormat.getDefaultFormat();
        }
        fieldValueStr = formator.format(value);
        return fieldValueStr;
    }

    public static String convertDateValue(Context ctx, Date value, String formate) {
        String fieldValueStr = "";
        if (value == null) {
            return fieldValueStr;
        }
        if (StringUtils.isEmpty((String)formate)) {
            try {
                ETemplateDateFormat defaultFormat = ETemplateDateFormat.getDefaultFormat();
                fieldValueStr = defaultFormat.format(value);
            }
            catch (Exception e) {
                fieldValueStr = value.toString();
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                ETemplateDateFormat format = ETemplateDateFormat.getFormat(formate);
                if (format == null) {
                    format = ETemplateDateFormat.getDefaultFormat();
                }
                fieldValueStr = format.format(value);
            }
            catch (Exception e) {
                fieldValueStr = value.toString();
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return fieldValueStr;
    }

    public static String convertFieldValue(Context ctx, JSONObject config, Object metaFieldValue) {
        String regex;
        String fieldValueStr = "";
        if (metaFieldValue == null) {
            return fieldValueStr;
        }
        fieldValueStr = metaFieldValue.toString();
        if (fieldValueStr.matches(regex = "(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)")) {
            try {
                SimpleDateFormat YYYY_MM_DD_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
                Date parse = YYYY_MM_DD_FORMATTER.parse(fieldValueStr);
                Calendar now = Calendar.getInstance();
                now.setTime(parse);
                String monthStr = "";
                String dayStr = "";
                int year = now.get(1);
                int month = now.get(2) + 1;
                int day = now.get(5);
                monthStr = month < 10 ? "0" + month : "" + month;
                dayStr = day < 10 ? "0" + day : "" + day;
                fieldValueStr = year + "\u5e74" + monthStr + "\u6708" + dayStr + "\u65e5";
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                fieldValueStr = metaFieldValue.toString();
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return fieldValueStr;
    }

    public static String getEncryFieldValue(Context ctx, String fieldName, String entityName, String metaFieldValue) throws EASBizException, BOSException, UuidException {
        SensitiveConfigCollection sensitiveConfigColl;
        String ruleName = "default";
        String newValue = "";
        SensitiveConfigInfo sensitiveConfigInfo = null;
        if (fieldName != null && entityName != null && (sensitiveConfigColl = SensitiveConfigFactory.getLocalInstance((Context)ctx).getSensitiveConfigCollection("where fullName = '" + entityName + "'")).size() > 0) {
            sensitiveConfigInfo = sensitiveConfigColl.get(0);
            SensitiveConfigEntryCollection sensitiveConfigEntryColl = SensitiveConfigEntryFactory.getLocalInstance((Context)ctx).getSensitiveConfigEntryCollection("where bill.id = '" + sensitiveConfigInfo.getId().toString() + "' and property = '" + fieldName + "'");
            if (sensitiveConfigEntryColl.size() > 0) {
                SensitiveConfigEntryInfo senConfigEntryInfo = sensitiveConfigEntryColl.get(0);
                SensitiveRuleInfo ruleInfo = SensitiveRuleFactory.getLocalInstance((Context)ctx).getSensitiveRuleInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)senConfigEntryInfo.getSRule().getId().toString())));
                ruleName = ruleInfo.getNumber();
            }
        }
        newValue = SensitiveRuleBuilderFactory.getRuleValue((Context)ctx, (String)ruleName, (Object)metaFieldValue);
        return newValue;
    }
}

