/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.weixin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.util.json.JSONObject;
import com.kingdee.lightapp.wx.HttpKit;
import com.kingdee.lightapp.wx.WXUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WXMessagePusher {
    private static final Logger logger = LoggerFactory.getLogger(WXMessagePusher.class);
    private String messageType;

    public WXMessagePusher(String messageType) {
        this.messageType = messageType;
    }

    public Map<String, Object> pushMessage(Context ctx, List<IMessageAdapter> list) {
        String wxurl = null;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String assignid = "";
        for (IMessageAdapter adapter : list) {
            Map content = adapter.getContent();
            assignid = (String)content.get("assignId");
        }
        try {
            wxurl = WXUtil.getSendMessageUrl((String)"");
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
            returnMap.put("assignId", assignid);
            returnMap.put("errorCode", "0");
            returnMap.put("errormsg", "getSendMessageUr:" + e.getMessage());
            return returnMap;
        }
        Iterator<IMessageAdapter> iter = list.iterator();
        while (iter.hasNext()) {
            String wxMsgJson = WXMessagePusher.createMsg(ctx, iter);
            if (StringUtils.isEmpty((CharSequence)wxMsgJson)) {
                logger.error("WXMessagePusher assign not fit wxuser == " + assignid);
                returnMap.put("success", "true");
                continue;
            }
            logger.error("11111111111111111wxMsgJson:" + wxMsgJson);
            returnMap.put("assignId", assignid);
            try {
                String re = HttpKit.post((String)wxurl, (String)wxMsgJson);
                logger.error("11111111111111111 re: " + re);
                JSONObject jb = new JSONObject(re);
                int errorcode = (Integer)jb.get("errcode");
                if (errorcode == 0) {
                    returnMap.put("sourceMsgId", assignid);
                    returnMap.put("success", "true");
                    continue;
                }
                returnMap.put("errorCode", String.valueOf(errorcode));
                returnMap.put("errormsg", String.valueOf(jb.get("errmsg")));
            }
            catch (Exception e) {
                returnMap.put("errorCode", "1");
                returnMap.put("errormsg", e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.savePushedMsg(ctx, assignid, "", returnMap);
        return returnMap;
    }

    private void savePushedMsg(Context ctx, String assignid, String userid, Map<?, ?> map) {
        try {
            String success = "";
            if (map.get("success") != null) {
                success = String.valueOf(map.get("success"));
            }
            String msg = (String)map.get("remessage");
            String msgId = (String)map.get("sourceMsgId");
            if (!StringUtils.isEmpty((CharSequence)msgId) && !"".equals(assignid) && "true".equals(success)) {
                String sql = " insert into t_assign_wxmsg(msgid,fassignid,fuserid) values(?,?,?)";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{msgId, assignid, userid});
            } else if (!"true".equals(success) && !"".equals(assignid)) {
                String errorcode = "";
                if (map.get("errorCode") != null) {
                    errorcode = String.valueOf(map.get("errorCode"));
                }
                if (StringUtils.isEmpty((CharSequence)msg)) {
                    msg = (String)map.get("errormsg");
                }
                String sql = " insert into t_assign_wxmsgerror(msgid,fassignid,fuserid,errorcode,errormsg,sendtime) values(?,?,?,?,?,getdate())";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{assignid, assignid, userid, errorcode, msg});
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static String createMsg(Context ctx, Iterator<IMessageAdapter> iter) {
        IMessageAdapter adapter = iter.next();
        List personIds = adapter.getUsers();
        String name = (String)adapter.getContent().get("title");
        List<String> wxids = WXMessagePusher.transferPersonIdToWxId(ctx, personIds);
        String[] config = WXUtil.getWXConfig();
        String touser = "";
        for (int i = 0; i < wxids.size(); ++i) {
            if (i > 0) {
                touser = touser + "|";
            }
            touser = touser + wxids.get(i);
        }
        if (StringUtils.isEmpty((CharSequence)touser)) {
            return null;
        }
        Map map = adapter.getContent();
        String text = (String)map.get("text");
        MessageTypeEnum a = adapter.getType();
        String description = null;
        int t = a.value();
        description = text;
        if (!StringUtils.isEmpty((CharSequence)name)) {
            description = description + "\n\u53d1\u8d77\u4eba: " + name;
        }
        String wxtitle = (String)map.get("wxtitle");
        String title = "\u60a8\u6709\u5f85\u5ba1\u6279\u6d41\u7a0b";
        if (!StringUtils.isEmpty((CharSequence)wxtitle)) {
            title = wxtitle;
        }
        if (t == 2) {
            HashMap<String, Object> msgMap = new HashMap<String, Object>();
            msgMap.put("touser", touser);
            msgMap.put("agentid", config[2]);
            HashMap<String, String> articleMap = new HashMap<String, String>();
            articleMap.put("content", description);
            msgMap.put("text", articleMap);
            msgMap.put("msgtype", "text");
            JSONObject json = new JSONObject(msgMap);
            return json.toString();
        }
        String url = (String)map.get("url");
        url = WXUtil.encodeWXGetCodeUrl((String)url);
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        msgMap.put("msgtype", "news");
        msgMap.put("touser", touser);
        msgMap.put("agentid", config[2]);
        HashMap<String, Object> articleMap = new HashMap<String, Object>();
        articleMap.put("title", title);
        articleMap.put("description", description);
        articleMap.put("url", url);
        Object WXMsgType = map.get("WXMsgType");
        if ("taskcard".equals(WXMsgType)) {
            ArrayList btnList = new ArrayList();
            HashMap<String, Object> btn1 = new HashMap<String, Object>();
            btn1.put("key", "1");
            btn1.put("name", "\u540c\u610f");
            btn1.put("replace_name", "\u5df2\u5ba1\u6279");
            btn1.put("is_bold", true);
            HashMap<String, String> btn2 = new HashMap<String, String>();
            btn2.put("key", "0");
            btn2.put("name", "\u62d2\u7edd");
            btn2.put("replace_name", "\u5df2\u5ba1\u6279");
            btnList.add(btn1);
            btnList.add(btn2);
            msgMap.put("msgtype", "taskcard");
            msgMap.put("taskcard", articleMap);
            articleMap.put("task_id", map.get("assignId"));
            articleMap.put("btn", btnList);
        } else {
            HashMap newsMap = new HashMap(1);
            ArrayList<HashMap<String, Object>> articlesList = new ArrayList<HashMap<String, Object>>(1);
            articlesList.add(articleMap);
            newsMap.put("articles", articlesList);
            msgMap.put("news", newsMap);
        }
        JSONObject json = new JSONObject(msgMap);
        return json.toString();
    }

    private static List<String> transferPersonIdToWxId(Context ctx, List<String> personIdList) {
        ArrayList<String> xtIdList = new ArrayList<String>();
        String ids = "";
        int index = 0;
        Iterator<String> iter = personIdList.iterator();
        while (iter.hasNext()) {
            if (index++ > 0) {
                ids = ids + ",";
            }
            String personId = iter.next();
            ids = ids + "'" + personId + "'";
        }
        String sql = "select FXtId from T_PM_easwxusermap where fuserid in (" + ids + ")";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String xtid = rs.getString("FXtId");
                if (xtid == null || xtIdList.contains(xtid)) continue;
                xtIdList.add(xtid);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return xtIdList;
    }

    public Map<String, Object> pushNoitceMessage(Context ctx, List<IMessageAdapter> messageList) {
        return this.pushMessage(ctx, messageList);
    }
}

