/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.bs.ml.IMLToolsFacade;
import com.kingdee.eas.bs.ml.MLToolsFacadeFactory;
import com.kingdee.eas.bs.ml.ResourceFacadeFactory;
import com.kingdee.eas.bs.ml.ResourceInfo;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.ml.ResourceType;
import com.kingdee.shr.ml.service.ISHRWebPageResourceParser;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractSHRWebPageResourceParser
implements ISHRWebPageResourceParser {
    private static Logger logger = Logger.getLogger(AbstractSHRWebPageResourceParser.class);
    private Context ctx;
    private Map params;
    private ResourceType resourceType;
    private Set<String> zhAttributesOthers;

    protected Context getContext() {
        return this.ctx;
    }

    protected Map getParams() {
        return this.params;
    }

    protected ResourceType getResourceType() {
        return this.resourceType;
    }

    protected Set<String> getZHAttributesOthers() {
        return this.zhAttributesOthers;
    }

    public AbstractSHRWebPageResourceParser(Context ctx, Map params, ResourceType resourceType) throws BOSException {
        this.ctx = ctx;
        this.params = params;
        this.resourceType = resourceType;
        this.zhAttributesOthers = new HashSet<String>();
    }

    protected final String getLanguage(boolean isUse) {
        String language = "en_US";
        if (isUse) {
            language = this.ctx.getLocale().getLanguage();
        }
        return language;
    }

    @Override
    public void parse() throws EASBizException, BOSException {
        String pkg = this.resourceType.getValue();
        List<String> fileNameList = this.getFileNames();
        if (StringUtils.isEmpty((String)pkg) || null == fileNameList || fileNameList.size() <= 0) {
            return;
        }
        Map existWords = null;
        List<ResourceInfo> pageUIList = null;
        IMLToolsFacade iMLToolsFacade = MLToolsFacadeFactory.getLocalInstance((Context)this.ctx);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("begin {0} fetch, total size:{1}", this.resourceType.getName(), fileNameList.size()));
        }
        int totalRecord = 0;
        for (String fileName : fileNameList) {
            pageUIList = this.dealResorces(fileName, existWords = iMLToolsFacade.getExistResource(pkg, fileName, "wbpage"));
            if (null == pageUIList || pageUIList.size() <= 0) continue;
            totalRecord += pageUIList.size();
            iMLToolsFacade.saveResource(pageUIList, "wbpage");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("end {0} fetch, total recored size:{1}", this.resourceType.getName(), totalRecord));
        }
        if (this.zhAttributesOthers.size() > 0) {
            StringBuffer s = new StringBuffer();
            for (String str : this.zhAttributesOthers) {
                s.append(str).append("\n");
            }
            this.outputInfo(s);
        }
        ResourceFacadeFactory.getLocalInstance((Context)this.ctx).clearResourceCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputInfo(StringBuffer sb) {
        File f = new File(SHRSyssettingUtil.getShrPropertiesPathByFileName((String)"uiview_zh_attributes.txt"));
        if (f.exists()) {
            f.delete();
        }
        FileOutputStream out = null;
        try {
            f.createNewFile();
            out = new FileOutputStream(f);
            out.write(sb.toString().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected final String getMD5Key(String realKey) {
        return MLUtils.md5HashCode((String)realKey);
    }

    protected abstract List<ResourceInfo> dealResorces(String var1, Map var2) throws EASBizException, BOSException;

    protected abstract List<String> getFileNames() throws BOSException;

    @Override
    public Object convert() throws EASBizException, BOSException {
        String pkg = this.resourceType.getValue();
        List<String> fileNameList = this.getFileNames();
        if (StringUtils.isEmpty((String)pkg) || null == fileNameList || fileNameList.size() <= 0) {
            return null;
        }
        String fileName = fileNameList.get(0);
        Map mlWords = SHRServerResource.getFileResource((Context)this.ctx, (String)pkg, (String)fileName);
        return this.dealMulConvert(fileName, mlWords);
    }

    protected abstract Object dealMulConvert(String var1, Map var2) throws EASBizException, BOSException;

    protected final List<String> getFilesFromSHRResource() throws BOSException {
        ArrayList<String> l = new ArrayList<String>();
        String sql = "SELECT DISTINCT FILENAME FROM T_SHR_SHRRESOURCE WHERE FPACKAGENAME = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{this.resourceType.getValue()});
            while (rs.next()) {
                l.add(rs.getString("FILENAME"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return l;
    }

    protected final ResourceInfo generateResourceInfo(String key, String fileName, String project, Map existWords, String zh_CN) {
        if (StringUtils.isEmpty((String)zh_CN)) {
            return null;
        }
        String md5 = MLUtils.md5HashCode((String)zh_CN);
        ResourceInfo resInfo = null;
        if (!existWords.containsKey(key)) {
            resInfo = new ResourceInfo();
            resInfo.setZh_CN(zh_CN.trim());
            resInfo.setPkg(this.resourceType.getValue());
            resInfo.setFileName(fileName);
            resInfo.setKey(key);
            resInfo.setPrj(project);
            resInfo.setMetaType("wbpage");
        } else if (!StringUtils.isEmpty((String)md5) && !md5.equals(existWords.get(key))) {
            resInfo = new ResourceInfo();
            resInfo.setZh_CN(zh_CN.trim());
            resInfo.setPkg(this.resourceType.getValue());
            resInfo.setFileName(fileName);
            resInfo.setKey(key);
            resInfo.setPrj(project);
            resInfo.setMetaType("wbpage");
            resInfo.setUpdate(true);
        }
        return resInfo;
    }

    protected final List<ResourceInfo> dealResorcesFromSHRResource(String fileName, Map existWords) throws BOSException {
        String sql = "SELECT FKEY, FPROJECT, FRES2 FROM T_SHR_SHRRESOURCE WHERE FPACKAGENAME = ? and FILENAME = ?";
        ArrayList<ResourceInfo> l = new ArrayList<ResourceInfo>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{this.resourceType.getValue(), fileName});
            while (rs.next()) {
                ResourceInfo r = this.generateResourceInfo(rs.getString("FKEY"), fileName, rs.getString("FPROJECT"), existWords, rs.getString("FRES2"));
                if (null == r) continue;
                l.add(r);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return l;
    }

    protected final Object dealMulConvertFromSHRResource(String fileName, Map mlWords) throws EASBizException, BOSException {
        return mlWords;
    }
}

