/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.api;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.shr.shareservice.AbstractActivityTypeInfo;
import com.kingdee.shr.shareservice.ActivityApplyEntryCollection;
import com.kingdee.shr.shareservice.ActivityApplyEntryFactory;
import com.kingdee.shr.shareservice.ActivityApplyEntryInfo;
import com.kingdee.shr.shareservice.ActivityFactory;
import com.kingdee.shr.shareservice.ActivityInfo;
import com.kingdee.shr.shareservice.ActivityTypeCollection;
import com.kingdee.shr.shareservice.ActivityTypeFactory;
import com.kingdee.shr.shareservice.JobSubjectSettingVariableFactory;
import com.kingdee.shr.shareservice.JobSubjectSettingVariableInfo;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityJobProcessExecuteLogic {
    public static final SimpleDateFormat FORMATOR_DATE = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat FORMATOR_DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String JOBSUBJECT_SETTING_PRESETVARIABLE_QUERY = "com.kingdee.shr.shareservice.app.JobSubjectSettingVariableGeneralQuery";
    private static final String JOBSUBJECT_SETTING_PRESETVARIABLE_MATCHER_REG = "\\#([^#]*)\\#";
    private static final String JOBSUBJECT_SETTING_BILLVARIABLE_MATCHER_REG = "\\{([^}]*)\\}";
    private static List<Map<String, String>> lml = BOSConfigUtil.getLanguageMapingList();
    private static final String BOSTYPE_EMPENROLLBIZBILL = "B41CAA3F";
    private static final Logger logger = LoggerFactory.getLogger(ActivityJobProcessExecuteLogic.class);
    private Context ctx;

    public ActivityJobProcessExecuteLogic(Context ctx) {
        this.ctx = ctx;
    }

    public String assembleJobSubjectBySettingRule(String activityId, String personId, String billId, Locale locale, Context ctx) throws EASBizException, BOSException {
        locale = locale == null ? ctx.getLocale() : locale;
        String jobSubjectcontent = "";
        ActivityInfo activityInfo = ActivityFactory.getLocalInstance(ctx).getActivityInfo((IObjectPK)new ObjectUuidPK(activityId));
        if (activityInfo != null) {
            Map<String, String> billVariablePlaceHolderValues;
            Map<String, String> commonVariablePlaceHolderValues = this.getCommonSettingVariablePlaceHolderData(activityInfo, JOBSUBJECT_SETTING_PRESETVARIABLE_QUERY, JOBSUBJECT_SETTING_PRESETVARIABLE_MATCHER_REG, personId, billId, locale, ctx);
            if (!commonVariablePlaceHolderValues.isEmpty()) {
                String commonVariablePatternString = "\\#(" + StringUtils.join(commonVariablePlaceHolderValues.keySet(), (String)"|") + ")\\#";
                jobSubjectcontent = this.generateJobSubjectContent(activityInfo.getJobSubject(locale), commonVariablePatternString, commonVariablePlaceHolderValues);
            }
            if (!(billVariablePlaceHolderValues = this.getBillSettingVariablePlaceHolderData(activityInfo, JOBSUBJECT_SETTING_BILLVARIABLE_MATCHER_REG, billId, locale, ctx)).isEmpty()) {
                String billVariablePatternString = "\\{(" + StringUtils.join(billVariablePlaceHolderValues.keySet(), (String)"|") + ")\\}";
                jobSubjectcontent = this.generateJobSubjectContent(jobSubjectcontent, billVariablePatternString, billVariablePlaceHolderValues);
            }
            jobSubjectcontent = jobSubjectcontent.replace("\n", "");
            logger.debug("============\u6700\u7ec8\u751f\u6210\u7684\u4efb\u52a1\u4e3b\u9898\u5185\u5bb9:" + jobSubjectcontent + "==============");
            jobSubjectcontent = StringUtils.isEmpty((CharSequence)jobSubjectcontent) ? activityInfo.getJobSubject(locale) : jobSubjectcontent;
        }
        return jobSubjectcontent;
    }

    private String generateJobSubjectContent(String jobSubjectSettingRule, String patternStr, Map<String, String> variablePlaceHolderValues) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(jobSubjectSettingRule == null ? "" : jobSubjectSettingRule);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, variablePlaceHolderValues.get(matcher.group(1)) == null ? "" : variablePlaceHolderValues.get(matcher.group(1)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private Map<String, String> getBillSettingVariablePlaceHolderData(ActivityInfo activityInfo, String matchPattern, String billId, Locale locale, Context ctx1) throws BOSException, EASBizException {
        ActivityApplyEntryInfo activityApplyEntryInfo = null;
        AbstractActivityTypeInfo activityTypeInfo = null;
        HashMap<String, String> variablePlaceholderMap = new HashMap<String, String>();
        HashMap<String, String> variableValueMap = new HashMap<String, String>();
        ArrayList<String> variableArray = new ArrayList<String>();
        ArrayList<String> holderVarArray = new ArrayList<String>();
        String jobSubjectSettingRule = activityInfo.getJobSubject(locale);
        Matcher mat = Pattern.compile(matchPattern).matcher(jobSubjectSettingRule == null ? "" : jobSubjectSettingRule);
        while (mat.find()) {
            holderVarArray.add(mat.group(1));
        }
        if (!holderVarArray.isEmpty()) {
            ActivityApplyEntryCollection coll = ActivityApplyEntryFactory.getLocalInstance(ctx1).getActivityApplyEntryCollection("where activity.id='" + activityInfo.getId().toString() + "'");
            if (coll.size() > 1) {
                return variablePlaceholderMap;
            }
            if (coll.size() > 0) {
                activityApplyEntryInfo = coll.get(0);
                ActivityTypeCollection activityTypeColl = ActivityTypeFactory.getLocalInstance(ctx1).getActivityTypeCollection("where id='" + activityApplyEntryInfo.getActivityType().getId().toString() + "'");
                if (activityTypeColl.size() > 0) {
                    activityTypeInfo = activityTypeColl.get(0);
                }
            }
            if (activityTypeInfo != null) {
                JobSubjectSettingVariableInfo jobSubjectSettingVariableInfo = JobSubjectSettingVariableFactory.getLocalInstance(ctx1).getJobSubjectSettingVariableInfo("where applyVoucherNumber='" + activityTypeInfo.getSscBillTypeNum() + "'");
                String queryName = jobSubjectSettingVariableInfo.getVoucherFieldQueryPath();
                SelectorInfo selectorRec = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)new MetaDataPK(queryName)).getSelector();
                ArrayList queryFields = selectorRec.getFields();
                for (String holderVar : holderVarArray) {
                    if (queryFields.size() <= 0) continue;
                    for (int i = 0; i < queryFields.size(); ++i) {
                        QueryFieldInfo queryFieldInfo = (QueryFieldInfo)queryFields.get(i);
                        Map<String, String> lang = null;
                        int total = lml.size();
                        for (int t = 0; t < total; ++t) {
                            lang = lml.get(t);
                            if (!holderVar.equals(queryFieldInfo.getDisplayName(LocaleUtils.getLocale((String)lang.get("lang"))))) continue;
                            variableArray.add(this.processFieldName(holderVar, queryFieldInfo.getName(), variablePlaceholderMap));
                        }
                    }
                }
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)billId, CompareType.EQUALS));
                try {
                    String shortCode = LocaleUtils.getShortCode((Locale)ctx1.getLocale());
                    IQueryExecutor exec = this.getQueryExecutor(ctx1, queryName);
                    EntityViewInfo entityViewInfo = this.getEntityViewInfo(filterInfo);
                    exec.setObjectView(entityViewInfo);
                    String execSQL = exec.getSQL().replaceAll("_" + shortCode + "\\b", "_" + LocaleUtils.getShortCode((Locale)locale));
                    logger.debug("===================QuerySQL:" + execSQL + "===================");
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx1, (String)execSQL);
                    while (rowSet.next()) {
                        Iterator iterator = variableArray.iterator();
                        while (iterator.hasNext()) {
                            String field;
                            variableValueMap.put(field, StringUtils.isEmpty((CharSequence)rowSet.getString(field = (String)iterator.next())) ? " " : this.processFieldValue(field, rowSet.getString(field)));
                        }
                    }
                }
                catch (ParserException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                for (Map.Entry entry : variablePlaceholderMap.entrySet()) {
                    entry.setValue(variableValueMap.get(entry.getValue()) == null ? " " : (String)variableValueMap.get(entry.getValue()));
                }
            }
        }
        return variablePlaceholderMap;
    }

    private EntityViewInfo getEntityViewInfo(FilterInfo filterItems) throws BOSException, ParserException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterItems);
        return entityViewInfo;
    }

    private IQueryExecutor getQueryExecutor(Context ctx, String query) throws EASBizException, BOSException, ParserException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)query));
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        exec.option().isMultiLanguage = true;
        exec.option().pageCount = 1;
        return exec;
    }

    private Map<String, String> getCommonSettingVariablePlaceHolderData(ActivityInfo activityInfo, String queryPath, String matchPattern, String personId, String billId, Locale locale, Context ctx1) throws BOSException, EASBizException {
        IRowSet rs;
        String bosType = BOSUuid.getBOSObjectType((String)billId, (boolean)true).toString();
        StringBuffer commonVariableSqlToken = new StringBuffer();
        ArrayList<String> variableArray = new ArrayList<String>();
        ArrayList<String> variableColumns = new ArrayList<String>();
        HashMap<String, String> specialPlaceholderMap = new HashMap<String, String>();
        HashMap<String, String> variablePlaceholderMap = new HashMap<String, String>();
        HashMap<String, String> variableValueMap = new HashMap<String, String>();
        StringBuffer variableQuerySQL = new StringBuffer("SELECT ");
        if (BOSTYPE_EMPENROLLBIZBILL.equals(bosType)) {
            queryPath = "com.kingdee.shr.shareservice.app.EmpEnrollBizBillCommonSettingVariableQuery";
            this.processFieldHit(queryPath, matchPattern, activityInfo, variableArray, variableColumns, specialPlaceholderMap, variablePlaceholderMap, locale);
            commonVariableSqlToken.append(" FROM T_HR_EmpEnrollBizBill AS EMPENROLLBIZBILL").append(" RIGHT OUTER JOIN T_HR_EmpEnrollBizBillEntry AS ENTRYS").append(" ON EMPENROLLBIZBILL.FID = ENTRYS.FBillID").append(" LEFT OUTER JOIN T_ORG_Admin AS COMPANY").append(" ON ENTRYS.FCompanyID = COMPANY.FID").append(" LEFT OUTER JOIN T_ORG_Position AS POSITION").append(" ON ENTRYS.FPositionID = POSITION.FID").append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORG").append(" ON ENTRYS.FAdminOrgID = ADMINORG.FID").append(" LEFT OUTER JOIN T_HR_JobGrade AS JOBGRADE").append(" ON ENTRYS.FJobGradeID = JOBGRADE.FID").append(" LEFT OUTER JOIN T_ORG_Job AS JOB").append(" ON ENTRYS.FJobID = JOB.FID").append(" LEFT OUTER JOIN T_HR_JobLevel AS JOBLEVEL").append(" ON ENTRYS.FJobLevelID = JOBLEVEL.FID").append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT").append(" ON POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID").append(" LEFT OUTER JOIN T_ORG_Admin AS DEPARTMENT").append(" ON ADMINORGUNIT.FDepartmentID = DEPARTMENT.FID WHERE EMPENROLLBIZBILL.FID = '").append(billId).append("';");
        } else {
            this.processFieldHit(queryPath, matchPattern, activityInfo, variableArray, variableColumns, specialPlaceholderMap, variablePlaceholderMap, locale);
            commonVariableSqlToken.append(" FROM T_BD_PERSON PERSON LEFT OUTER JOIN T_HR_EMPORGRELATION EMPORGRELATION ON (((EMPORGRELATION.FPersonID = PERSON.FID AND EMPORGRELATION.FIsSystem = 1)").append(" AND EMPORGRELATION.FAssignType = 1 AND PERSON.FID = '").append(personId).append("')").append(" AND EMPORGRELATION.FIsLatestInAday = 1) LEFT OUTER JOIN T_ORG_ADMIN ADMINORGUNIT").append(" ON ADMINORGUNIT.FID = EMPORGRELATION.FADMINORGID LEFT OUTER JOIN T_ORG_POSITION POSITION ON POSITION.FID = EMPORGRELATION.FPOSITIONID LEFT OUTER JOIN T_HR_EMPHRORELATIONHIS").append(" EMPHRORELATIONHIS ON EMPHRORELATIONHIS.FEmpOrgRelationID = EMPORGRELATION.FID LEFT OUTER JOIN T_ORG_HRO HRORG ON HRORG.FID = EMPHRORELATIONHIS.FHRORGUNITID LEFT OUTER").append(" JOIN T_ORG_ADMIN DEPARTMENT ON DEPARTMENT.FID = ADMINORGUNIT.FDEPARTMENTID LEFT OUTER JOIN T_HR_EMPLABORRELATION LABORRELA ON (LABORRELA.FPersonID = EMPORGRELATION.FPERSONID AND").append(" LABORRELA.FIsSystem = 1) LEFT OUTER JOIN T_ORG_ADMIN COMPANY ON COMPANY.FID = ADMINORGUNIT.FCOMPANYID LEFT OUTER JOIN T_HR_BDEMPLOYEETYPE EMPTYPE ON").append(" EMPTYPE.FID = LABORRELA.FLABORRELATIONSTATEID LEFT OUTER JOIN T_HR_EMPPOSTRANK RANK ON RANK.FPersonID = PERSON.FID").append(" LEFT OUTER JOIN T_HR_JobLevel JOBLEVEL ON JOBLEVEL.FID = RANK.FJobLevelID").append(" LEFT OUTER JOIN T_HR_JobGrade JOBGRADE ON JOBGRADE.FID = RANK.FJobGradeID").append(" LEFT OUTER JOIN T_ORG_Job JOB ON JOB.FID = POSITION.FJobID").append(" WHERE ((((EMPORGRELATION.FIsLatestInAday = 1 AND EMPHRORELATIONHIS.FState = 1) AND EMPORGRELATION.FLEFFDT = {ts'2199-12-31 00:00:00'}) AND").append(" (((EMPHRORELATIONHIS.FUseDefault = 1)) OR (EMPHRORELATIONHIS.FUseDefault = 0))));");
        }
        variableQuerySQL.append(StringUtils.join((Object[])variableArray.toArray(), (String)",")).append(commonVariableSqlToken.toString());
        logger.error("===================QuerySQL:" + variableQuerySQL.toString() + "===================");
        if (!variableArray.isEmpty()) {
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx1, (String)variableQuerySQL.toString());
                while (rs.next()) {
                    for (Object field : variableColumns.toArray()) {
                        logger.error("========= com.kingdee.shr.shareservice.api.ActivityJobProcessExecuteLogic.getCommonSettingVariablePlaceHolderData field\uff1a" + field + "; rs.getString((field.toString())):" + rs.getString(field.toString()));
                        variableValueMap.put(field.toString(), StringUtils.isEmpty((CharSequence)rs.getString(field.toString())) ? " " : this.processFieldValue(field.toString(), rs.getString(field.toString())));
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        rs = variablePlaceholderMap.entrySet().iterator();
        while (rs.hasNext()) {
            Map.Entry entry;
            entry.setValue(variableValueMap.get((entry = (Map.Entry)rs.next()).getValue()) == null ? " " : (String)variableValueMap.get(entry.getValue()));
        }
        variablePlaceholderMap.putAll(specialPlaceholderMap);
        if (variablePlaceholderMap.containsKey("ACT_FName")) {
            variablePlaceholderMap.put((String)variablePlaceholderMap.get("ACT_FName"), activityInfo.getName(ctx1.getLocale()));
            variablePlaceholderMap.remove("ACT_FName");
        }
        if (variablePlaceholderMap.containsKey("BILL_FNumber")) {
            String entityName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx1).getEntity(BOSUuid.getBOSObjectType((String)billId, (boolean)true)).getFullName();
            ICoreBase entityBizInterface = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx1, (IMetaDataPK)MetaDataPK.create((String)entityName));
            CoreBaseInfo coreBaseInfo = entityBizInterface.getValue((IObjectPK)new ObjectUuidPK(billId));
            variablePlaceholderMap.put((String)variablePlaceholderMap.get("BILL_FNumber"), coreBaseInfo.getString("number"));
            variablePlaceholderMap.remove("BILL_FNumber");
        }
        return variablePlaceholderMap;
    }

    private String processFieldValue(String field, String value) {
        if (field.contains("Date")) {
            try {
                Date date = FORMATOR_DATE.parse(value);
                value = FORMATOR_DATE.format(date);
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    private void processFieldHit(String queryPath, String matchPattern, ActivityInfo activityInfo, List<String> variableArray, List<String> variableColumns, Map<String, String> specialPlaceholderMap, Map<String, String> variablePlaceholderMap, Locale locale) {
        Matcher mat = Pattern.compile(matchPattern).matcher(activityInfo.getJobSubject(locale) == null ? "" : activityInfo.getJobSubject(locale));
        SelectorInfo selectorRec = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)new MetaDataPK(queryPath)).getSelector();
        ArrayList queryFields = selectorRec.getFields();
        while (mat.find()) {
            if (queryFields.size() <= 0) continue;
            for (int i = 0; i < queryFields.size(); ++i) {
                QueryFieldInfo queryFieldInfo = (QueryFieldInfo)queryFields.get(i);
                Map<String, String> lang = null;
                int total = lml.size();
                for (int t = 0; t < total; ++t) {
                    lang = lml.get(t);
                    if (!mat.group(1).equals(queryFieldInfo.getDisplayName(LocaleUtils.getLocale((String)lang.get("lang"))))) continue;
                    if (!"BILL.FNumber".equals(queryFieldInfo.getName()) && !"ACT.FName".equals(queryFieldInfo.getName())) {
                        variableArray.add(this.processFieldName(mat.group(1), queryFieldInfo.getName(), variableColumns, variablePlaceholderMap, locale));
                        continue;
                    }
                    specialPlaceholderMap.put(queryFieldInfo.getName().replace(".", "_"), mat.group(1));
                }
            }
        }
    }

    private String processFieldName(String placeholderName, String fieldName, List<String> commonVariableColumn, Map<String, String> variablePlaceholderMap, Locale locale) {
        String namecode = LocaleUtils.getShortCode((Locale)locale);
        if (fieldName.contains("Name")) {
            fieldName = fieldName + "_" + namecode;
        }
        commonVariableColumn.add(fieldName.replace(".", "_"));
        variablePlaceholderMap.put(placeholderName, fieldName.replace(".", "_"));
        return fieldName + " " + fieldName.replace(".", "_");
    }

    private String processFieldName(String placeholderName, String fieldName, Map<String, String> variablePlaceholderMap) {
        variablePlaceholderMap.put(placeholderName, fieldName);
        return fieldName;
    }
}

