/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.app;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.ActivityApplyEntryCollection;
import com.kingdee.shr.shareservice.ActivityApplyEntryFactory;
import com.kingdee.shr.shareservice.ActivityBussTypeFactory;
import com.kingdee.shr.shareservice.ActivityBussTypeInfo;
import com.kingdee.shr.shareservice.ActivityFactory;
import com.kingdee.shr.shareservice.ActivityFieldEntryCollection;
import com.kingdee.shr.shareservice.ActivityFieldFactory;
import com.kingdee.shr.shareservice.ActivityInfo;
import com.kingdee.shr.shareservice.ActivityRobotFactory;
import com.kingdee.shr.shareservice.ActivityRobotSettingEntryCollection;
import com.kingdee.shr.shareservice.ActivityTypeFactory;
import com.kingdee.shr.shareservice.ActivityTypeInfo;
import com.kingdee.shr.shareservice.BussAttrShrUipkFactory;
import com.kingdee.shr.shareservice.BussAttrShrUipkInfo;
import com.kingdee.shr.shareservice.IActivityType;
import com.kingdee.shr.shareservice.ISolutionActivityInfo;
import com.kingdee.shr.shareservice.Jobclassification;
import com.kingdee.shr.shareservice.SSCActivityException;
import com.kingdee.shr.shareservice.SolutionActivityInfoCollection;
import com.kingdee.shr.shareservice.SolutionActivityInfoFactory;
import com.kingdee.shr.shareservice.SolutionActivityInfoInfo;
import com.kingdee.shr.shareservice.app.AbstractActivityControllerBean;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityControllerBean
extends AbstractActivityControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(ActivityControllerBean.class);

    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        ActivityInfo activityInfo = ActivityFactory.getLocalInstance(ctx).getActivityInfo((IObjectPK)pk);
        this.checkCanEnable(ctx, activityInfo);
        if (activityInfo.isIsSSC()) {
            this.createBussType2ShareCenter(ctx, activityInfo, (IObjectPK)pk);
        }
        super._enable(ctx, id);
    }

    private void checkCanEnable(Context ctx, ActivityInfo activityInfo) throws EASBizException, BOSException {
        this.checkRobotEnable(ctx, activityInfo);
        this.checkFieldEnable(ctx, activityInfo);
    }

    private void checkRobotEnable(Context ctx, ActivityInfo activityInfo) throws EASBizException, BOSException {
        ActivityRobotSettingEntryCollection coll = activityInfo.getActivityRobotSettingEntrys();
        if (coll.size() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            if (coll.get(i).getRobotSettingInstance() == null) continue;
            if (i == 0) {
                sb.append("'" + coll.get(i).getRobotSettingInstance().getId().toString() + "'");
                continue;
            }
            sb.append(",'" + coll.get(i).getRobotSettingInstance().getId().toString() + "'");
        }
        if (ActivityRobotFactory.getLocalInstance(ctx).exists("where id in (" + sb + ") and state<>1")) {
            throw new SSCActivityException(SSCActivityException.NOT_ALL_ROBOT_ENABLE);
        }
    }

    private void checkFieldEnable(Context ctx, ActivityInfo activityInfo) throws EASBizException, BOSException {
        ActivityFieldEntryCollection coll = activityInfo.getEntrys();
        if (coll.size() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            if (coll.get(i).getField() == null) continue;
            if (i == 0) {
                sb.append("'" + coll.get(i).getField().getId().toString() + "'");
                continue;
            }
            sb.append(",'" + coll.get(i).getField().getId().toString() + "'");
        }
        if (ActivityFieldFactory.getLocalInstance(ctx).exists("where id in (" + sb + ") and state<>1")) {
            throw new SSCActivityException(SSCActivityException.NOT_ALL_FIELD_ENABLE);
        }
    }

    private void createBussType2ShareCenter(Context ctx, ActivityInfo activityInfo, IObjectPK pk) throws EASBizException, BOSException {
        ActivityApplyEntryCollection applyEntryColle = activityInfo.getApplyEntry();
        if (applyEntryColle.size() == 0) {
            return;
        }
        IActivityType iActivityType = ActivityTypeFactory.getLocalInstance(ctx);
        for (int i = 0; i < applyEntryColle.size(); ++i) {
            ActivityTypeInfo activityTypeInfo = iActivityType.getActivityTypeInfo((IObjectPK)new ObjectUuidPK(applyEntryColle.get(i).getActivityType().getId()));
            Map<String, String> bussMap = this.innerCreateBussType(ctx, activityInfo, activityTypeInfo, pk);
            if (null == bussMap) continue;
            String bussAttrId = bussMap.get("bussAttrId");
            String bussAttrNum = bussMap.get("bussAttrNum");
            String jobclassification = bussMap.get("jobclassification");
            this.createShrUipk(ctx, bussAttrId, bussAttrNum, activityTypeInfo, activityInfo.getId().toString());
            ActivityBussTypeInfo activityBussTypeInfo = new ActivityBussTypeInfo();
            activityBussTypeInfo.setActivity(activityInfo);
            activityBussTypeInfo.setActivityType(activityTypeInfo);
            activityBussTypeInfo.setBussAttrNum(bussAttrNum);
            activityBussTypeInfo.setBussAttrId(bussAttrId);
            activityBussTypeInfo.setJobclassification(Jobclassification.getEnum(Integer.parseInt(jobclassification)));
            ActivityBussTypeFactory.getLocalInstance(ctx).save((CoreBaseInfo)activityBussTypeInfo);
        }
    }

    private Map<String, String> innerCreateBussType(Context ctx, ActivityInfo activityInfo, ActivityTypeInfo activityTypeInfo, IObjectPK pk) throws EASBizException, BOSException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String number = activityInfo.getNumber();
        String name = activityInfo.getName();
        String sscBillTypeNum = activityTypeInfo.getSscBillTypeNum();
        Jobclassification jobclassificationEnum = activityInfo.getJobclassification();
        String jobclassification = "";
        jobclassification = jobclassificationEnum == null ? "3" : jobclassificationEnum.getValue() + "";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        String activityTypeId = activityTypeInfo.getId().toString();
        String shareNum = "";
        shareNum = "viEAAAQHYylqRQhv".equals(activityTypeId) ? "RESIGN_" + number : ("oC7KJzGHQsWudvqA4qzEsWpFCG8=".equals(activityTypeId) ? "EMP_" + number : activityTypeInfo.getBosType() + "_" + number);
        param.put("number", shareNum);
        param.put("name", name);
        param.put("billtype", sscBillTypeNum);
        param.put("jobclassification", jobclassification);
        if (!this.isCreateBussType(ctx, shareNum)) {
            Object result = OSFAppUtil.callService((Context)ctx, (String)"createBussattrService", param);
            Map resultMap = (Map)result;
            boolean success = (Boolean)resultMap.get("success");
            if (success) {
                HashMap<String, String> returnMap = new HashMap<String, String>();
                String bussAttrId = resultMap.get("data").toString();
                returnMap.put("bussAttrId", bussAttrId);
                returnMap.put("bussAttrNum", shareNum);
                returnMap.put("jobclassification", jobclassification);
                return returnMap;
            }
            throw new SSCActivityException(SSCActivityException.CUSTOM_EXCEPTION, new Object[]{resultMap.get("data").toString()});
        }
        return null;
    }

    private boolean isCreateBussType(Context ctx, String bussAttrNum) throws EASBizException, BOSException {
        return ActivityBussTypeFactory.getLocalInstance(ctx).exists("where bussAttrNum = '" + bussAttrNum + "'");
    }

    private void createShrUipk(Context ctx, String bussAttrId, String number, ActivityTypeInfo activityType, String activityId) throws EASBizException, BOSException {
        BussAttrShrUipkInfo info = new BussAttrShrUipkInfo();
        info.setUipk(activityType.getUipk());
        info.setBussAttrId(BOSUuid.read((String)bussAttrId));
        info.setBussAttrNum(number);
        info.setBillType(activityType.getSscBillTypeNum());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("activityId", activityId);
        info.setParam(JSON.toJSONString(paramMap));
        BussAttrShrUipkFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
    }

    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        ISolutionActivityInfo solutionActivityInfo = SolutionActivityInfoFactory.getLocalInstance(ctx);
        SolutionActivityInfoCollection solutionInfocol = solutionActivityInfo.getSolutionActivityInfoCollection("where activity.id = '" + id + "'");
        if (solutionInfocol != null && solutionInfocol.size() > 0) {
            SolutionActivityInfoInfo solutioninfo = solutionInfocol.get(0);
            int i = 0;
            ActivityApplyEntryCollection coll = ActivityApplyEntryFactory.getLocalInstance(ctx).getActivityApplyEntryCollection("where activity = '" + solutioninfo.getActivity().getId().toString() + "'");
            if (i < coll.size()) {
                String activityTypeId = coll.get(i).getActivityType().getId().toString();
                if ("oC7KJzGHQsWudvqA4qzEsWpFCG8=".equals(activityTypeId)) {
                    String label51 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label51", (Context)ctx);
                    throw new SSCActivityException(SSCActivityException.CUSTOM_EXCEPTION, new Object[]{label51});
                }
                if ("viEAAAQHYylqRQhv".equals(activityTypeId)) {
                    String label52 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label52", (Context)ctx);
                    throw new SSCActivityException(SSCActivityException.CUSTOM_EXCEPTION, new Object[]{label52});
                }
                String label53 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label53", (Context)ctx);
                throw new SSCActivityException(SSCActivityException.CUSTOM_EXCEPTION, new Object[]{label53});
            }
        }
        super._disable(ctx, id);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ActivityInfo activityInfo;
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo instanceof ActivityInfo && (activityInfo = (ActivityInfo)dataBaseInfo).getActivityType() != null) {
            filter.getFilterItems().add(new FilterItemInfo("activityType", (Object)activityInfo.getActivityType().getId().toString(), CompareType.EQUALS));
        }
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + " : " + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }
}

