/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.app;

import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.UIViewFactory;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.ActivityCollection;
import com.kingdee.shr.shareservice.ActivityFactory;
import com.kingdee.shr.shareservice.ActivityInfo;
import com.kingdee.shr.shareservice.ActivityJobInfoCollection;
import com.kingdee.shr.shareservice.ActivityJobInfoFactory;
import com.kingdee.shr.shareservice.ActivityJobInfoInfo;
import com.kingdee.shr.shareservice.ActivitySolutionCollection;
import com.kingdee.shr.shareservice.ActivitySolutionFactory;
import com.kingdee.shr.shareservice.ActivitySolutionInfo;
import com.kingdee.shr.shareservice.BizBillActivitySolutionRelFactory;
import com.kingdee.shr.shareservice.BizBillActivitySolutionRelInfo;
import com.kingdee.shr.shareservice.CoActivityException;
import com.kingdee.shr.shareservice.CoActivityJobCollection;
import com.kingdee.shr.shareservice.CoActivityJobFactory;
import com.kingdee.shr.shareservice.CoActivityJobInfo;
import com.kingdee.shr.shareservice.IActivity;
import com.kingdee.shr.shareservice.IActivityJobInfo;
import com.kingdee.shr.shareservice.ISHRJobPriority;
import com.kingdee.shr.shareservice.PreActivityRelCollection;
import com.kingdee.shr.shareservice.PreActivityRelFactory;
import com.kingdee.shr.shareservice.SHRJobPriorityCollection;
import com.kingdee.shr.shareservice.SHRJobPriorityFactory;
import com.kingdee.shr.shareservice.SHRJobPriorityInfo;
import com.kingdee.shr.shareservice.SSCActivityException;
import com.kingdee.shr.shareservice.ShareServiceException;
import com.kingdee.shr.shareservice.SolutionActivityInfoCollection;
import com.kingdee.shr.shareservice.SolutionActivityInfoFactory;
import com.kingdee.shr.shareservice.SolutionActivityInfoInfo;
import com.kingdee.shr.shareservice.WorkflowProceedFacadeFactory;
import com.kingdee.shr.shareservice.api.ActivityJobProcessExecuteLogic;
import com.kingdee.shr.shareservice.app.AbstractCoActivityJobOptFacadeControllerBean;
import com.kingdee.shr.shareservice.app.JobState;
import com.kingdee.shr.shareservice.strategy.ActivitySolutionOperation;
import com.kingdee.shr.shareservice.strategy.AssignUserOperation;
import com.kingdee.shr.shareservice.strategy.JobInnerOperation;
import com.kingdee.shr.shareservice.util.ActivityHelper;
import com.kingdee.shr.shareservice.util.AssembleConfigUtils;
import com.kingdee.shr.shareservice.util.CoActivityOptUtil;
import com.kingdee.shr.shareservice.util.JobUtils;
import com.kingdee.shr.shareservice.util.SHRWorkFlowOtherSysUtil;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoActivityJobOptFacadeControllerBean
extends AbstractCoActivityJobOptFacadeControllerBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.shareservice.app.CoActivityJobOptFacadeControllerBean");

    @Override
    protected void _pass(Context ctx, Map params) throws BOSException, EASBizException {
        CoActivityJobCollection coll;
        String operation = (String)params.get("operation");
        String jobId = (String)params.get("jobId");
        String billId = (String)params.get("billId");
        String activityId = (String)params.get("activityId");
        if (!StringUtils.isEmpty((String)jobId) && StringUtils.isEmpty((String)activityId) && (coll = CoActivityJobFactory.getLocalInstance(ctx).getCoActivityJobCollection("select bussAttrID.id where id = '" + jobId + "'")).size() > 0 && coll.get(0).getBussAttrID() != null) {
            activityId = coll.get(0).getBussAttrID().getId().toString();
            params.put("activityId", activityId);
        }
        CoActivityOptUtil.coJobPass(ctx, params);
        this.updateActivityState(ctx, params);
        ActivityHelper.dealWithBussActivityAfterPass(ctx, activityId, jobId, billId);
        boolean isCreateByActivity = this.isCreateByActivity(ctx, jobId);
        boolean isFinish = this.checkSolution(ctx, billId, jobId, isCreateByActivity);
        if (isCreateByActivity) {
            this.afterFinish(ctx, isCreateByActivity, params);
        } else if (isFinish) {
            this.afterFinish(ctx, isCreateByActivity, params);
        } else {
            ActivityHelper.createNextJob(ctx, jobId, billId, activityId, isCreateByActivity);
        }
    }

    protected void afterFinish(Context ctx, boolean isCreateByActivity, Map params) throws EASBizException, BOSException {
        boolean isCreateByWorkflow = this.checkWorkflow(ctx, params);
        if (isCreateByWorkflow) {
            this._dealNextProcess(ctx, params);
        }
        this.dealBussAfter(ctx, isCreateByActivity, params);
    }

    private void dealBussAfter(Context ctx, boolean isCreateByActivity, Map params) throws EASBizException, BOSException {
        ActivityJobInfoCollection coll;
        String activityId = (String)params.get("activityId");
        String billId = (String)params.get("billId");
        String jobId = (String)params.get("jobId");
        if (StringUtils.isEmpty((String)jobId)) {
            return;
        }
        if (!StringUtils.isEmpty((String)jobId) && StringUtils.isEmpty((String)activityId) && (coll = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection("select activity where jobId = '" + jobId + "'")).size() > 0) {
            String string = activityId = coll.get(0).getActivity() == null ? null : coll.get(0).getActivity();
        }
        if (StringUtils.isEmpty((String)activityId)) {
            return;
        }
        ActivityInfo activity = ActivityFactory.getLocalInstance(ctx).getActivityInfo("select relationView where id = '" + activityId + "'");
        if (activity.getRelationView() == null) {
            return;
        }
        ActivitySolutionInfo solutionInfo = this.getSolutionByBillId(ctx, jobId, isCreateByActivity);
        if (solutionInfo != null) {
            ActivityHelper.dealWithBussSolutionAfterPass(ctx, solutionInfo.getId().toString(), billId);
        }
    }

    private boolean checkWorkflow(Context ctx, Map params) throws BOSException {
        String jobId = (String)params.get("jobId");
        if (StringUtils.isEmpty((String)jobId)) {
            return false;
        }
        ActivityJobInfoCollection coll = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection("where jobId = '" + jobId + "'");
        if (coll.size() != 1) {
            return false;
        }
        return coll.get(0).isIsCreateByWorkflow();
    }

    protected boolean isCreateByActivity(Context ctx, String jobId) throws BOSException, EASBizException {
        return ActivityJobInfoFactory.getLocalInstance(ctx).exists("where jobId = '" + jobId + "' and isCreateByActivity = 1");
    }

    @Override
    protected void _dealNextProcess(Context ctx, Map params) throws BOSException, CoActivityException {
        String billId = (String)params.get("billId");
        this.dealWithWorkFlow(ctx, billId);
    }

    protected void dealWithWorkFlow(Context ctx, String billId) throws BOSException {
        try {
            boolean hasOtherSysInfo = SHRWorkFlowOtherSysUtil.hasOtherSysInfo(ctx, billId);
            if (hasOtherSysInfo) {
                SHRWorkFlowOtherSysUtil.continueWorkFlow(ctx, billId, "");
            } else {
                WorkflowProceedFacadeFactory.getLocalInstance(ctx).wfproceedTrigger(billId, true);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected AssignInfo getassignInfo(Context ctx, String billId) throws BOSException {
        AssignInfo assignInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizObjID", (Object)billId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizFunction", (Object)"MultiApproveUIFunction", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSendMsg", (Object)false, CompareType.EQUALS));
        view.setFilter(filter);
        AssignCollection coll = AssignFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        assignInfo = coll.get(0);
        if (assignInfo.getAssignID() == null) {
            return null;
        }
        return assignInfo;
    }

    protected boolean checkSolution(Context ctx, String billId, String jobId, boolean isCreateByActivity) throws BOSException, CoActivityException {
        boolean isFinish = false;
        ActivitySolutionInfo solutionInfo = this.getSolutionByBillId(ctx, jobId, isCreateByActivity);
        if (solutionInfo == null) {
            return true;
        }
        SolutionActivityInfoCollection solutionActivityColl = solutionInfo.getEntrys();
        HashSet<String> solutionActivityInfofilterSet = new HashSet<String>();
        for (int i = 0; i < solutionActivityColl.size(); ++i) {
            solutionActivityInfofilterSet.add(solutionActivityColl.get(i).getId().toString());
        }
        try {
            EntityViewInfo entity = new EntityViewInfo();
            FilterInfo solutionActivityInfofilter = new FilterInfo();
            entity.setFilter(solutionActivityInfofilter);
            solutionActivityInfofilter.getFilterItems().add(new FilterItemInfo("id", solutionActivityInfofilterSet, CompareType.INCLUDE));
            SolutionActivityInfoCollection coll = SolutionActivityInfoFactory.getLocalInstance(ctx).getSolutionActivityInfoCollection(entity);
            HashSet<String> filterSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                filterSet.add(coll.get(i).getActivity().getId().toString());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bill", (Object)billId));
            filter.getFilterItems().add(new FilterItemInfo("activity", filterSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("jobState", (Object)2, CompareType.NOTEQUALS));
            isFinish = !ActivityJobInfoFactory.getLocalInstance(ctx).exists(filter);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return isFinish;
    }

    protected ActivitySolutionInfo getSolutionByBillId(Context ctx, String jobId, boolean isCreateByActivity) throws BOSException, CoActivityException {
        ActivitySolutionInfo info = null;
        if (isCreateByActivity) {
            return info;
        }
        try {
            ActivityJobInfoCollection coll = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection("where jobId = '" + jobId + "'");
            if (coll.size() == 0) {
                throw new CoActivityException(CoActivityException.BILL_NOT_SOLUTION);
            }
            if (coll.size() != 1) {
                throw new CoActivityException(CoActivityException.BILL_MUL_SOLUTION);
            }
            info = ActivitySolutionFactory.getLocalInstance(ctx).getActivitySolutionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)coll.get(0).getScheme())));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    @Deprecated
    protected void createNextJob(Context ctx, String jobId, String billId, String activityId, boolean isCreateByActivity) throws BOSException, CoActivityException {
        if (isCreateByActivity) {
            return;
        }
        try {
            ActivitySolutionInfo solutionInfo = this.getSolutionByBillId(ctx, jobId, isCreateByActivity);
            SolutionActivityInfoCollection sacc = solutionInfo.getEntrys();
            if (logger.isDebugEnabled()) {
                logger.debug("sacc.size :" + sacc.size());
            }
            String solutionId = solutionInfo.getId().toString();
            IActivityJobInfo iActivityJobInfo = ActivityJobInfoFactory.getLocalInstance(ctx);
            HashSet<String> includeActivitySet = new HashSet<String>();
            ActivityJobInfoCollection includeColl = iActivityJobInfo.getActivityJobInfoCollection("where bill = '" + billId + "' and scheme = '" + solutionId + "'");
            for (int i = 0; i < includeColl.size(); ++i) {
                includeActivitySet.add(includeColl.get(i).getActivity());
            }
            ActivitySolutionOperation activitySolutionOperation = AssembleConfigUtils.getBillTypeInter(ctx, BOSUuid.read((String)billId).getType().toString());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("activityId", activityId);
            Map<String, Object> paramsMap = activitySolutionOperation.getOrgAndPerson(ctx, billId, params);
            String personName = (String)paramsMap.get("personName");
            HashMap<String, String> subjectAll = paramsMap.get("subjectAll") == null ? null : (HashMap<String, String>)paramsMap.get("subjectAll");
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            for (int i = 0; i < sacc.size(); ++i) {
                SolutionActivityInfoInfo solutionActivityInfo = sacc.get(i);
                if (!includeActivitySet.contains(solutionActivityInfo.getActivity().getId().toString())) continue;
                ActivityInfo activity = ActivityFactory.getLocalInstance(ctx).getActivityInfo((IObjectPK)new ObjectUuidPK(solutionActivityInfo.getActivity().getId()));
                boolean needCreateJob = this.needCreateJob(ctx, solutionActivityInfo, solutionInfo, billId, activityId);
                logger.debug("needCreateJob :" + needCreateJob);
                if (!needCreateJob) continue;
                String bussAttrNumber = ActivityHelper.getBussAttrNum(ctx, billId, activity.getId().toString());
                String realSubject = "";
                realSubject = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(activityId, paramsMap.get("personId").toString(), billId, null, ctx);
                if (StringUtils.isEmpty((String)realSubject)) {
                    String subject = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.CoActivityResource", (String)"subject", (Context)ctx);
                    realSubject = MessageFormat.format(subject, personName, activity.getName());
                }
                if (null == subjectAll) {
                    subjectAll = new HashMap<String, String>();
                    PersonInfo p = null;
                    if (!StringUtils.isEmpty((String)paramsMap.get("personId").toString())) {
                        p = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(paramsMap.get("personId").toString()));
                    }
                    String subjectL1 = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(activityId, paramsMap.get("personId").toString(), billId, LocaleUtils.getLocale((String)"l1"), ctx);
                    String label01 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label0", (Locale)LocaleUtils.getLocale((String)"l1"));
                    if (StringUtils.isEmpty((String)subjectL1)) {
                        subjectL1 = MessageFormat.format(label01, p == null ? personName : p.getName(LocaleUtils.getLocale((String)"l1")), activity.getName(LocaleUtils.getLocale((String)"l1")));
                    }
                    subjectAll.put("l1", subjectL1);
                    String subjectL2 = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(activityId, paramsMap.get("personId").toString(), billId, LocaleUtils.getLocale((String)"l2"), ctx);
                    String label02 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label0", (Locale)LocaleUtils.getLocale((String)"l2"));
                    if (StringUtils.isEmpty((String)subjectL2)) {
                        subjectL2 = MessageFormat.format(label02, p == null ? personName : p.getName(LocaleUtils.getLocale((String)"l2")), activity.getName(LocaleUtils.getLocale((String)"l2")));
                    }
                    subjectAll.put("l2", subjectL2);
                    String subjectL3 = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(activityId, paramsMap.get("personId").toString(), billId, LocaleUtils.getLocale((String)"l3"), ctx);
                    String label03 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label0", (Locale)LocaleUtils.getLocale((String)"l3"));
                    if (StringUtils.isEmpty((String)subjectL3)) {
                        subjectL3 = MessageFormat.format(label03, p == null ? personName : p.getName(LocaleUtils.getLocale((String)"l3")), activity.getName(LocaleUtils.getLocale((String)"l3")));
                    }
                    subjectAll.put("l3", subjectL3);
                }
                paramMap.put("subject", realSubject);
                paramMap.put("subjectAll", JSONUtils.convertObjectToJson((Context)ctx, subjectAll));
                paramMap.put("bussAttrNum", bussAttrNumber);
                paramMap.put("activityId", activity.getId().toString());
                paramMap.put("billId", billId);
                paramMap.put("personId", paramsMap.get("personId"));
                paramMap.put("personName", paramsMap.get("personName"));
                params.putAll(paramMap);
                String resultObj = CoActivityOptUtil.createJob(ctx, params, null);
                if (!StringUtils.isEmpty((String)resultObj)) {
                    if (!iActivityJobInfo.exists("where activity = '" + activity.getId().toString() + "' and bill = '" + billId + "' and scheme = '" + solutionId + "'")) {
                        logger.debug("======== com.kingdee.shr.shareservice.web.handler.BaseBillTaskEditHandler.createNextJob where activity = '" + activity.getId().toString() + "' and bill = '" + billId + "' and scheme = '" + solutionId + "' not exists!!!");
                        continue;
                    }
                    ActivityJobInfoInfo activityJobInfoInfo = iActivityJobInfo.getActivityJobInfoInfo("where activity = '" + activity.getId().toString() + "' and bill = '" + billId + "' and scheme = '" + solutionId + "'");
                    if (activityJobInfoInfo.isIsAutoJob()) {
                        activityJobInfoInfo.setJobState(JobState.finish);
                    } else {
                        activityJobInfoInfo.setJobState(JobState.process);
                    }
                    activityJobInfoInfo.setJobId(resultObj);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("jobState"));
                    selector.add(new SelectorItemInfo("jobId"));
                    iActivityJobInfo.updatePartial(activityJobInfoInfo, selector);
                    continue;
                }
                throw new CoActivityException(CoActivityException.COJOB_CREATE_FAIL);
            }
        }
        catch (CoActivityException e) {
            throw e;
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean needCreateJob(Context ctx, SolutionActivityInfoInfo solutionActivityInfo, ActivitySolutionInfo activitySolutionInfo, String billId, String passActivityId) throws BOSException, CoActivityException {
        try {
            ActivityInfo activityInfo = solutionActivityInfo.getActivity();
            String currentActId = solutionActivityInfo.getActivity().getId().toString();
            logger.debug("currentActId:" + currentActId + ",passActivityId:" + passActivityId);
            if (currentActId.equals(passActivityId)) {
                return false;
            }
            IActivityJobInfo iActivityJobInfo = ActivityJobInfoFactory.getLocalInstance(ctx);
            PreActivityRelCollection coll = PreActivityRelFactory.getLocalInstance(ctx).getPreActivityRelCollection("where activity = '" + activityInfo.getId().toString() + "' and solution = '" + activitySolutionInfo.getId().toString() + "'");
            logger.debug("PreActivityRelCollection:" + coll.size());
            if (coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    if (!iActivityJobInfo.exists("where bill = '" + billId + "' and activity in ('" + coll.get(i).getPreActivity().getId().toString() + "') and jobState <> 2")) continue;
                    logger.debug("current activity is\uff1a[" + coll.get(i).getPreActivity().getId().toString() + "] not completed!");
                    return false;
                }
            }
            String solutionId = activitySolutionInfo.getId().toString();
            if (iActivityJobInfo.exists("where activity = '" + currentActId + "' and jobState <> 0 and bill = '" + billId + "' and scheme = '" + solutionId + "'")) {
                if (logger.isDebugEnabled()) {
                    logger.debug("current activity is\uff1a[" + currentActId + "] is dealing or finished!");
                }
                return false;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CoActivityException(CoActivityException.COJOB_VERIFY_FAIL);
        }
        return true;
    }

    protected void updateActivityState(Context ctx, Map params) throws BOSException, CoActivityException {
        try {
            CoActivityJobCollection coll;
            String jobId = (String)params.get("jobId");
            String activityId = (String)params.get("activityId");
            String billId = (String)params.get("billId");
            String pasRea = (String)params.get("pasRea");
            if (!StringUtils.isEmpty((String)jobId) && StringUtils.isEmpty((String)activityId) && (coll = CoActivityJobFactory.getLocalInstance(ctx).getCoActivityJobCollection("select bussAttrID.id where id = '" + jobId + "'")).size() > 0 && coll.get(0).getBussAttrID() != null) {
                activityId = coll.get(0).getBussAttrID().getId().toString();
            }
            boolean isCreateByActivity = this.isCreateByActivity(ctx, jobId);
            ActivitySolutionInfo solutionInfo = this.getSolutionByBillId(ctx, jobId, isCreateByActivity);
            IActivityJobInfo iActivityJobInfo = ActivityJobInfoFactory.getLocalInstance(ctx);
            ActivityJobInfoCollection coll2 = null;
            coll2 = isCreateByActivity ? ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection("where bill ='" + billId + "' and activity ='" + activityId + "' and jobState = 1") : ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection("where bill ='" + billId + "' and activity ='" + activityId + "' and scheme='" + solutionInfo.getId().toString() + "'  and jobState = 1");
            if (logger.isDebugEnabled()) {
                logger.debug("updateActivityState: " + coll2.size() + ";coll:" + coll2.get(0));
            }
            if (coll2.size() == 1) {
                ActivityJobInfoInfo activityJobInfoInfo = coll2.get(0);
                activityJobInfoInfo.setJobState(JobState.finish);
                if (!StringUtils.isEmpty((String)pasRea)) {
                    activityJobInfoInfo.setOpinion(pasRea);
                }
                iActivityJobInfo.update((IObjectPK)new ObjectUuidPK(activityJobInfoInfo.getId()), activityJobInfoInfo);
            }
        }
        catch (CoActivityException e) {
            logger.error(e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _createJobBySolution(Context ctx, String id, String number, String billId, Map params) throws BOSException, EASBizException {
        ActivitySolutionCollection solutionColl;
        ActivitySolutionOperation activitySolutionOperation;
        if (null == params) {
            params = new HashMap<String, Object>();
        }
        boolean isCreateByWorkflow = false;
        if (null != params.get("workflow")) {
            isCreateByWorkflow = true;
        }
        if (null == (activitySolutionOperation = AssembleConfigUtils.getBillTypeInter(ctx, BOSUuid.read((String)billId).getType().toString()))) {
            logger.error("com.kingdee.shr.shareservice.app.CoActivityJobOptFacadeControllerBean._createJobBySolution activitySolutionOperation is null, param billId:" + billId);
            try {
                throw new ShareServiceException(ShareServiceException.OPERATION_NULL, new Object[]{billId});
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage());
            }
        }
        String bussAttrNumber = null;
        if (!StringUtils.isEmpty((String)id) && (solutionColl = ActivitySolutionFactory.getLocalInstance(ctx).getActivitySolutionCollection("select number where id = '" + id + "'")).size() == 1) {
            number = solutionColl.get(0).getNumber();
        }
        ActivitySolutionInfo activitySolutionInfo = ActivityHelper.checkSolution(ctx, number, billId);
        BizBillActivitySolutionRelInfo billActSoluRelInfo = new BizBillActivitySolutionRelInfo();
        billActSoluRelInfo.setBill(billId);
        billActSoluRelInfo.setSolution(activitySolutionInfo.getId().toString());
        BizBillActivitySolutionRelFactory.getLocalInstance(ctx).addnew(billActSoluRelInfo);
        Object priority = params.get("priority");
        if (priority != null) {
            SHRJobPriorityInfo shrJobPriorityInfo = new SHRJobPriorityInfo();
            shrJobPriorityInfo.setBillId(BOSUuid.read((String)billId));
            shrJobPriorityInfo.setJobPriority(priority.toString());
            shrJobPriorityInfo.setSolution(activitySolutionInfo.getId().toString());
            SHRJobPriorityFactory.getLocalInstance(ctx).addnew(shrJobPriorityInfo);
        }
        SolutionActivityInfoCollection sacc = activitySolutionInfo.getEntrys();
        String solutionId = activitySolutionInfo.getId().toString();
        IActivityJobInfo iActivityJobInfo = ActivityJobInfoFactory.getLocalInstance(ctx);
        boolean needCreateJob = false;
        HashMap<String, Boolean> autoMap = new HashMap<String, Boolean>();
        HashSet<String> autoSet = new HashSet<String>();
        HashSet<String> delaySet = new HashSet<String>();
        HashMap activityMap = new HashMap();
        int total = 0;
        params.put("total", sacc.size());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("scheme", (Object)solutionId));
        filterInfo.getFilterItems().add(new FilterItemInfo("bill", (Object)billId));
        filterInfo.getFilterItems().add(new FilterItemInfo("jobState", (Object)2, CompareType.NOTEQUALS));
        iActivityJobInfo.delete(filterInfo);
        HashMap<String, Boolean> activityUserCreate = new HashMap<String, Boolean>();
        for (int i = 0; i < sacc.size(); ++i) {
            UIViewInfo relationIdInfo;
            HashMap<String, String> subjectAll;
            PreActivityRelCollection coll;
            SolutionActivityInfoInfo solutionActivityInfo = sacc.get(i);
            ActivityInfo activity = ActivityFactory.getLocalInstance(ctx).getActivityInfo((IObjectPK)new ObjectUuidPK(solutionActivityInfo.getActivity().getId()));
            HashMap<String, String> param = new HashMap<String, String>();
            String activityId = activity.getId().toString();
            param.put("activityId", activityId);
            Map<String, Object> paramsMap = activitySolutionOperation.getOrgAndPerson(ctx, billId, param);
            Map<String, Object> needToCreateJobInfo = activitySolutionOperation.needCreateActivityJob(ctx, billId, activity, solutionId, param);
            Object isNeedCreate = needToCreateJobInfo.get("needCreate");
            if (!(isNeedCreate != null && ((Boolean)isNeedCreate).booleanValue() || (coll = PreActivityRelFactory.getLocalInstance(ctx).getPreActivityRelCollection("where activity = '" + activityId + "' and solution = '" + solutionId + "'")).size() <= 0)) {
                needToCreateJobInfo.put("needCreate", true);
            }
            HROrgUnitInfo hrOrgUnitInfo = (HROrgUnitInfo)paramsMap.get("hrOrgUnit");
            AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)paramsMap.get("adminOrgUnit");
            String personId = paramsMap.get("personId") == null ? "" : paramsMap.get("personId").toString();
            String talentId = paramsMap.get("talentId") == null ? "" : paramsMap.get("talentId").toString();
            String personName = paramsMap.get("personName") == null ? "" : paramsMap.get("personName").toString();
            String subject = paramsMap.get("subject") == null ? "" : paramsMap.get("subject").toString();
            HashMap<String, String> hashMap = subjectAll = paramsMap.get("subjectAll") == null ? null : (HashMap<String, String>)paramsMap.get("subjectAll");
            if (StringUtils.isEmpty((String)subject) && StringUtils.isEmpty((String)(subject = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(activityId, personId, billId, ctx.getLocale(), ctx)))) {
                String label0 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label0", (Context)ctx);
                subject = MessageFormat.format(label0, personName, activity.getName());
            }
            if (null == subjectAll) {
                subjectAll = new HashMap<String, String>();
                PersonInfo p = null;
                if (!StringUtils.isEmpty((String)personId)) {
                    p = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                }
                String subjectL1 = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(activityId, personId, billId, LocaleUtils.getLocale((String)"l1"), ctx);
                String label01 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label0", (Locale)LocaleUtils.getLocale((String)"l1"));
                if (StringUtils.isEmpty((String)subjectL1)) {
                    subjectL1 = MessageFormat.format(label01, p == null ? personName : p.getName(LocaleUtils.getLocale((String)"l1")), activity.getName(LocaleUtils.getLocale((String)"l1")));
                }
                subjectAll.put("l1", subjectL1);
                String subjectL2 = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(activityId, personId, billId, LocaleUtils.getLocale((String)"l2"), ctx);
                String label02 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label0", (Locale)LocaleUtils.getLocale((String)"l2"));
                if (StringUtils.isEmpty((String)subjectL2)) {
                    subjectL2 = MessageFormat.format(label02, p == null ? personName : p.getName(LocaleUtils.getLocale((String)"l2")), activity.getName(LocaleUtils.getLocale((String)"l2")));
                }
                subjectAll.put("l2", subjectL2);
                String subjectL3 = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(activityId, personId, billId, LocaleUtils.getLocale((String)"l3"), ctx);
                String label03 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label0", (Locale)LocaleUtils.getLocale((String)"l3"));
                if (StringUtils.isEmpty((String)subjectL3)) {
                    subjectL3 = MessageFormat.format(label03, p == null ? personName : p.getName(LocaleUtils.getLocale((String)"l3")), activity.getName(LocaleUtils.getLocale((String)"l3")));
                }
                subjectAll.put("l3", subjectL3);
            }
            HashMap<String, Object> innerActivityMap = new HashMap<String, Object>();
            innerActivityMap.put("hrOrgUnitInfo", hrOrgUnitInfo);
            innerActivityMap.put("adminOrgUnitInfo", adminOrgUnitInfo);
            innerActivityMap.put("personId", personId);
            innerActivityMap.put("personName", personName);
            innerActivityMap.put("subject", subject);
            innerActivityMap.put("subjectAll", JSONUtils.convertObjectToJson((Context)ctx, subjectAll));
            if (activity.isIsSSC()) {
                String orgNumber = ActivityHelper.getOrgNumber(ctx, hrOrgUnitInfo, adminOrgUnitInfo);
                innerActivityMap.put("orgNumber", orgNumber);
            }
            activityMap.put(activityId, innerActivityMap);
            if (needToCreateJobInfo.get("needCreate") == null || !((Boolean)needToCreateJobInfo.get("needCreate")).booleanValue()) continue;
            ++total;
            ActivityJobInfoInfo activityJobInfo = new ActivityJobInfoInfo();
            activityJobInfo.setActivity(activity.getId().toString());
            activityJobInfo.setBill(billId);
            activityJobInfo.setScheme(solutionId);
            activityJobInfo.setJobState(JobState.notCreate);
            boolean isAuto = (Boolean)needToCreateJobInfo.get("isAuto") == null ? false : (Boolean)needToCreateJobInfo.get("isAuto");
            autoMap.put(activity.getId().toString(), isAuto);
            activityJobInfo.setIsAutoJob(isAuto);
            activityJobInfo.setIsCreateByWorkflow(isCreateByWorkflow);
            activityJobInfo.setUipk(activity.getRelationView());
            if (needToCreateJobInfo.get("isDelay") != null && ((Boolean)needToCreateJobInfo.get("isDelay")).booleanValue()) {
                activityJobInfo.setIsDelay((Boolean)needToCreateJobInfo.get("isDelay"));
                activityJobInfo.setCreateDate((Date)needToCreateJobInfo.get("createDate"));
                String bussAttrNum = ActivityHelper.getBussAttrNum(ctx, billId, ActivityHelper.getBussAttrNum(ctx, billId, activity.getId().toString()));
                Map<String, Object> jobCreateParam = this.getJobCreateParam(ctx, personName, activity.getName(), billId, null, bussAttrNum, (Boolean)autoMap.get(activity.getId().toString()));
                jobCreateParam.put("subject", subject);
                jobCreateParam.put("subjectAll", JSONUtils.convertObjectToJson((Context)ctx, subjectAll));
                if (isAuto) {
                    jobCreateParam.put("isAuto", isAuto);
                }
                jobCreateParam.put("billId", billId);
                jobCreateParam.put("activityId", activity.getId().toString());
                String jobPriority = "";
                if (activity.isIsSSC()) {
                    jobPriority = priority != null ? priority.toString() : "20";
                    String orgNumber = ActivityHelper.getOrgNumber(ctx, hrOrgUnitInfo, adminOrgUnitInfo);
                    jobCreateParam.put("orgNumber", orgNumber);
                } else {
                    jobPriority = priority != null ? priority.toString() : "20";
                }
                jobCreateParam.put("jobPriority", jobPriority);
                activityJobInfo.setCreateArgs(JSONUtils.convertObjectToJson((Context)ctx, jobCreateParam));
                delaySet.add(activity.getId().toString());
            }
            if ((relationIdInfo = activity.getRelationView()) != null && relationIdInfo.getId() != null) {
                JobInnerOperation jobInnerOperation = null;
                UIViewInfo relationInfo = UIViewFactory.getLocalInstance((Context)ctx).getUIViewInfo((IObjectPK)new ObjectUuidPK(relationIdInfo.getId()));
                jobInnerOperation = JobUtils.getUserUrlImpl(ctx, relationIdInfo.getId().toString());
                if (null != jobInnerOperation) {
                    Map<String, Object> createRuleMap;
                    HashMap<String, String> createRuleParam = new HashMap<String, String>();
                    if (null != talentId) {
                        createRuleParam.put("talentId", talentId);
                    }
                    if ((createRuleMap = jobInnerOperation.checkCreateRule(ctx, billId, activityId, personId, createRuleParam)) == null || createRuleMap.size() == 0) {
                        activityUserCreate.put(activityId, true);
                    } else if (createRuleMap.get("success") != null && ((Boolean)createRuleMap.get("success")).booleanValue()) {
                        activityUserCreate.put(activityId, true);
                    } else {
                        activityJobInfo.setJobState(JobState.notCreate);
                        String label4 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label4", (Context)ctx);
                        activityJobInfo.setNotCreateRea(createRuleMap.get("data") == null ? label4 : createRuleMap.get("data").toString());
                        activityUserCreate.put(activityId, false);
                    }
                }
            }
            iActivityJobInfo.addnew(activityJobInfo);
            if (!isAuto) continue;
            autoSet.add(activity.getId().toString());
        }
        params.put("autoSet", autoSet);
        params.put("delaySet", delaySet);
        HashSet<String> jobIdSet = new HashSet<String>();
        for (int i = 0; i < sacc.size(); ++i) {
            ActivityJobInfoCollection activityJobColl;
            String jobId;
            Map<String, Object> paramMap;
            String activityId;
            SolutionActivityInfoInfo solutionActivityInfo = sacc.get(i);
            needCreateJob = ActivityHelper.needCreateJob(ctx, solutionActivityInfo, activitySolutionInfo, billId);
            if (!needCreateJob || solutionActivityInfo.getActivity() == null || solutionActivityInfo.getActivity().getId() == null || activityUserCreate.get(activityId = solutionActivityInfo.getActivity().getId().toString()) != null && !((Boolean)activityUserCreate.get(activityId)).booleanValue()) continue;
            ActivityInfo activity = ActivityFactory.getLocalInstance(ctx).getActivityInfo((IObjectPK)new ObjectUuidPK(activityId));
            bussAttrNumber = ActivityHelper.getBussAttrNum(ctx, billId, activity.getId().toString());
            boolean autoApprove = false;
            Map innerActivityMap = null;
            innerActivityMap = activityMap.get(activityId) == null ? new HashMap() : (Map)activityMap.get(activityId);
            if (activity.isIsSSC()) {
                paramMap = ActivityHelper.getParamMap(ctx);
                paramMap.put("subject", innerActivityMap.get("subject") == null ? "" : innerActivityMap.get("subject").toString());
                paramMap.put("billofDocumentID", billId);
                paramMap.put("orgNumber", innerActivityMap.get("orgNumber") == null ? "" : innerActivityMap.get("orgNumber").toString());
                paramMap.put("businessAttribute", bussAttrNumber);
                autoApprove = autoMap.get(activityId) == null ? false : (Boolean)autoMap.get(activityId);
                paramMap.put("autoApprove", autoApprove);
                ISHRJobPriority ishrJobPriority = SHRJobPriorityFactory.getLocalInstance(ctx);
                SHRJobPriorityCollection coll = ishrJobPriority.getSHRJobPriorityCollection("where billId = '" + billId + "' and businessAttribute = '" + bussAttrNumber + "' and solution is null");
                if (coll.size() > 0) {
                    paramMap.put("jobPriority", coll.get(0).getJobPriority());
                } else {
                    String jobPriority = priority != null ? priority.toString() : "20";
                    paramMap.put("jobPriority", jobPriority);
                }
                jobId = this.createJob(ctx, paramMap, iActivityJobInfo, activityId, solutionId);
                jobIdSet.add(jobId);
                ActivityHelper.dealWithBussActivityAfterCreate(ctx, activityId, jobId, billId, params);
            } else {
                paramMap = ActivityHelper.getParamMap(ctx);
                paramMap.put("subject", innerActivityMap.get("subject") == null ? "" : innerActivityMap.get("subject").toString());
                paramMap.put("subjectAll", innerActivityMap.get("subjectAll") == null ? null : (Object)innerActivityMap.get("subjectAll"));
                paramMap.put("activityId", activityId);
                paramMap.put("billId", billId);
                paramMap.put("personId", innerActivityMap.get("personId") == null ? "" : innerActivityMap.get("personId").toString());
                paramMap.put("personName", innerActivityMap.get("personName") == null ? "" : innerActivityMap.get("personName").toString());
                if (innerActivityMap.get("adminOrgUnitInfo") != null) {
                    AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)innerActivityMap.get("adminOrgUnitInfo");
                    paramMap.put("adminOrg", adminOrgUnitInfo.getId() == null ? "" : adminOrgUnitInfo.getId().toString());
                }
                Set<String> userSet = null;
                if (params.get("userSet") != null && params.get("userSet") instanceof Set) {
                    userSet = (Set<String>)params.get("userSet");
                }
                try {
                    AssignUserOperation assignUserOperation;
                    String bosType = BOSUuid.read((String)billId).getType().toString();
                    AssignUserOperation assignUserOperation2 = assignUserOperation = AssembleConfigUtils.getInter(ctx, bosType, "2") == null ? null : (AssignUserOperation)AssembleConfigUtils.getInter(ctx, bosType, "30");
                    if (assignUserOperation != null) {
                        userSet = assignUserOperation.getUserSet(ctx, billId, activityId, (String)paramMap.get("personId"), params);
                    }
                }
                catch (Exception e) {
                    logger.error("======com.kingdee.shr.shareservice.app.CoActivityJobOptFacadeControllerBean._createJobBySolution assignUserOperation:" + e.getMessage(), (Throwable)e);
                }
                String jobPriority = priority != null ? priority.toString() : "20";
                paramMap.put("jobPriority", jobPriority);
                params.putAll(paramMap);
                jobId = CoActivityOptUtil.createJob(ctx, params, userSet);
                ActivityJobInfoInfo activityJobInfoInfo = iActivityJobInfo.getActivityJobInfoInfo("where activity = '" + activityId + "' and bill = '" + billId + "' and scheme = '" + solutionId + "' and jobId is null");
                activityJobInfoInfo.setJobState(JobState.process);
                activityJobInfoInfo.setJobId(jobId);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("jobState"));
                selector.add(new SelectorItemInfo("jobId"));
                iActivityJobInfo.updatePartial(activityJobInfoInfo, selector);
                jobIdSet.add(jobId);
            }
            if (!autoApprove || (activityJobColl = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection("where bill = '" + billId + "' and activity = '" + activityId + "' and scheme ='" + solutionId + "'")).size() <= 0) continue;
            ActivityJobInfoInfo info = activityJobColl.get(0);
            info.setJobState(JobState.finish);
            String label59 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label59", (Context)ctx);
            info.setOpinion(label59);
            iActivityJobInfo.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
            ActivityHelper.dealWithBussActivityAfterPass(ctx, info.getActivity(), info.getJobId(), info.getBill());
            if (info.isIsCreateByActivity()) {
                HashMap afterPassMap = new HashMap();
                AssignInfo assignInfo = this.getassignInfo(ctx, info.getBill());
                WorkflowProceedFacadeFactory.getLocalInstance(ctx).submitMultipaprove(info.getBill(), assignInfo.getAssignID().toString(), afterPassMap);
                continue;
            }
            boolean isFinish = this.checkSolution(ctx, info.getBill(), info.getActivity(), info.getScheme());
            if (!isFinish) continue;
            this.dealWithWorkFlow(ctx, info.getBill());
            ActivityHelper.dealWithBussSolutionAfterPass(ctx, solutionId, billId);
        }
        HashMap param = new HashMap();
        activitySolutionOperation.afterCreateJob(ctx, activitySolutionInfo, billId, jobIdSet, param);
    }

    private Map<String, Object> getJobCreateParam(Context ctx, String personName, String activityName, String billId, String orgNumber, String bussAttrNumber, Boolean isAuto) {
        Map<String, Object> paramMap = ActivityHelper.getParamMap(ctx);
        paramMap.put("billofDocumentID", billId);
        paramMap.put("orgNumber", orgNumber);
        paramMap.put("businessAttribute", bussAttrNumber);
        paramMap.put("autoApprove", isAuto == null ? false : isAuto);
        return paramMap;
    }

    private boolean checkSolution(Context ctx, String billId, String activityId, String solutionId) throws EASBizException, BOSException {
        boolean isFinish = false;
        ActivitySolutionInfo solutionInfo = ActivitySolutionFactory.getLocalInstance(ctx).getActivitySolutionInfo((IObjectPK)new ObjectUuidPK(solutionId));
        SolutionActivityInfoCollection solutionActivityColl = solutionInfo.getEntrys();
        HashSet<String> solutionActivityInfofilterSet = new HashSet<String>();
        for (int i = 0; i < solutionActivityColl.size(); ++i) {
            solutionActivityInfofilterSet.add(solutionActivityColl.get(i).getId().toString());
        }
        try {
            EntityViewInfo entity = new EntityViewInfo();
            FilterInfo solutionActivityInfofilter = new FilterInfo();
            entity.setFilter(solutionActivityInfofilter);
            solutionActivityInfofilter.getFilterItems().add(new FilterItemInfo("id", solutionActivityInfofilterSet, CompareType.INCLUDE));
            SolutionActivityInfoCollection coll = SolutionActivityInfoFactory.getLocalInstance(ctx).getSolutionActivityInfoCollection(entity);
            HashSet<String> filterSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                filterSet.add(coll.get(i).getActivity().getId().toString());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bill", (Object)billId));
            filter.getFilterItems().add(new FilterItemInfo("activity", filterSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("jobState", (Object)2, CompareType.NOTEQUALS));
            isFinish = !ActivityJobInfoFactory.getLocalInstance(ctx).exists(filter);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return isFinish;
    }

    private String createJob(Context ctx, Map<String, Object> paramMap, IActivityJobInfo iActivityJobInfo, String activityId, String solutionId) throws EASBizException, BOSException {
        String createArgs = "";
        createArgs = JSONUtils.convertObjectToJson((Context)ctx, paramMap);
        logger.debug("\u521b\u5efa\u4efb\u52a1\u53c2\u6570:" + paramMap);
        HashMap<String, String> osfparam = new HashMap<String, String>();
        osfparam.put("createArgs", createArgs);
        JsonObject resultObj = new JsonObject();
        resultObj = (JsonObject)OSFAppUtil.callService((Context)ctx, (String)"createJobNewService", osfparam);
        logger.debug("\u4efb\u52a1\u521b\u5efa\u63a5\u53e3\u7ed3\u679c:" + String.valueOf(resultObj));
        String billId = (String)paramMap.get("billofDocumentID");
        String jobId = "";
        if (resultObj != null) {
            if (!resultObj.get("success").getAsBoolean()) {
                String label11 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label11", (Context)ctx);
                throw new BOSException(label11 + String.valueOf(resultObj));
            }
        } else {
            String label13 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label13", (Context)ctx);
            throw new BOSException(label13);
        }
        ActivityJobInfoInfo activityJobInfoInfo = iActivityJobInfo.getActivityJobInfoInfo("where activity = '" + activityId + "' and bill = '" + billId + "' and scheme = '" + solutionId + "' and jobId is null");
        activityJobInfoInfo.setJobState(JobState.process);
        jobId = resultObj.get("data").getAsString();
        activityJobInfoInfo.setJobId(jobId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("jobState"));
        selector.add(new SelectorItemInfo("jobId"));
        iActivityJobInfo.updatePartial(activityJobInfoInfo, selector);
        return jobId;
    }

    @Override
    protected Map _createJobByActivity(Context ctx, String id, String number, String billId, Map params) throws BOSException, EASBizException {
        ActivityCollection activityColl;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", false);
        resultMap.put("data", null);
        if (null == params) {
            params = new HashMap<String, Object>();
        }
        boolean isCreateByWorkflow = false;
        if (null != params.get("workflow")) {
            isCreateByWorkflow = true;
        }
        if (!StringUtils.isEmpty((String)id) && (activityColl = ActivityFactory.getLocalInstance(ctx).getActivityCollection("select number where id = '" + id + "'")).size() == 1) {
            number = activityColl.get(0).getNumber();
        }
        ActivitySolutionOperation activitySolutionOperation = AssembleConfigUtils.getBillTypeInter(ctx, BOSUuid.read((String)billId).getType().toString());
        String bussAttrNumber = null;
        ActivityInfo activityInfo = this.checkActivity(ctx, number, billId);
        String subject = null;
        HashMap<String, String> subjectAll = null;
        if (params.get("subject") != null) {
            subject = params.get("subject").toString();
        }
        if (params.get("subjectAll") != null && params.get("subjectAll") instanceof Map) {
            subjectAll = (HashMap<String, String>)params.get("subjectAll");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("activityId", activityInfo.getId().toString());
        Map<String, Object> paramsMap = activitySolutionOperation.getOrgAndPerson(ctx, billId, param);
        logger.debug("ActivityProcessExecuteFacadeControllerBean---paramsMap:" + paramsMap);
        HROrgUnitInfo hrOrgUnitInfo = (HROrgUnitInfo)paramsMap.get("hrOrgUnit");
        AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)paramsMap.get("adminOrgUnit");
        String personId = paramsMap.get("personId") == null ? "" : paramsMap.get("personId").toString();
        String personName = paramsMap.get("personName") == null ? "" : paramsMap.get("personName").toString();
        subject = paramsMap.get("subject") == null ? subject : paramsMap.get("subject").toString();
        Map<String, String> map = subjectAll = paramsMap.get("subjectAll") == null ? subjectAll : (Map)paramsMap.get("subjectAll");
        if (StringUtils.isEmpty((String)subject) && null == subjectAll) {
            subjectAll = new HashMap<String, String>();
            PersonInfo p = null;
            if (!StringUtils.isEmpty((String)personId)) {
                p = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
            }
            String subjectL1 = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(activityInfo.getId().toString(), paramsMap.get("personId").toString(), billId, LocaleUtils.getLocale((String)"l1"), ctx);
            String label01 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label0", (Locale)LocaleUtils.getLocale((String)"l1"));
            if (StringUtils.isEmpty((String)subjectL1)) {
                subjectL1 = MessageFormat.format(label01, p == null ? personName : p.getName(LocaleUtils.getLocale((String)"l1")), activityInfo.getName(LocaleUtils.getLocale((String)"l1")));
            }
            subjectAll.put("l1", subjectL1);
            String subjectL2 = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(activityInfo.getId().toString(), paramsMap.get("personId").toString(), billId, LocaleUtils.getLocale((String)"l2"), ctx);
            String label02 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label0", (Locale)LocaleUtils.getLocale((String)"l2"));
            if (StringUtils.isEmpty((String)subjectL2)) {
                subjectL2 = MessageFormat.format(label02, p == null ? personName : p.getName(LocaleUtils.getLocale((String)"l2")), activityInfo.getName(LocaleUtils.getLocale((String)"l2")));
            }
            subjectAll.put("l2", subjectL2);
            String subjectL3 = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(activityInfo.getId().toString(), paramsMap.get("personId").toString(), billId, LocaleUtils.getLocale((String)"l3"), ctx);
            String label03 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label0", (Locale)LocaleUtils.getLocale((String)"l3"));
            if (StringUtils.isEmpty((String)subjectL3)) {
                subjectL3 = MessageFormat.format(label03, p == null ? personName : p.getName(LocaleUtils.getLocale((String)"l3")), activityInfo.getName(LocaleUtils.getLocale((String)"l3")));
            }
            subjectAll.put("l3", subjectL3);
        }
        if (StringUtils.isEmpty((String)subject) && StringUtils.isEmpty((String)(subject = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(activityInfo.getId().toString(), paramsMap.get("personId").toString(), billId, ctx.getLocale(), ctx)))) {
            String label0 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label0", (Context)ctx);
            subject = MessageFormat.format(label0, personName, activityInfo.getName());
        }
        String orgNumber = ActivityHelper.getOrgNumber(ctx, hrOrgUnitInfo, adminOrgUnitInfo);
        Map<String, Object> needToCreateJobInfo = activitySolutionOperation.needCreateActivityJob(ctx, billId, activityInfo, null, param);
        boolean isSSC = activityInfo.isIsSSC();
        if (needToCreateJobInfo.get("needCreate") != null && ((Boolean)needToCreateJobInfo.get("needCreate")).booleanValue()) {
            HashMap<String, Map<String, Object>> afterCreateParam;
            Set<String> userSet;
            String jobId;
            HashMap createRuleParam;
            Map<String, Object> createRuleMap;
            IActivityJobInfo iActivityJobInfo = ActivityJobInfoFactory.getLocalInstance(ctx);
            HashSet<String> jobIdSet = new HashSet<String>();
            bussAttrNumber = ActivityHelper.getBussAttrNum(ctx, billId, activityInfo.getId().toString());
            String activityId = activityInfo.getId().toString();
            Map<String, Object> paramMap = ActivityHelper.getParamMap(ctx);
            paramMap.put("subject", subject);
            paramMap.put("subjectAll", JSONUtils.convertObjectToJson((Context)ctx, subjectAll));
            paramMap.put("billofDocumentID", billId);
            paramMap.put("orgNumber", orgNumber);
            paramMap.put("businessAttribute", bussAttrNumber);
            paramMap.put("autoApprove", needToCreateJobInfo.get("isAuto"));
            ISHRJobPriority ishrJobPriority = SHRJobPriorityFactory.getLocalInstance(ctx);
            SHRJobPriorityCollection coll = ishrJobPriority.getSHRJobPriorityCollection("where billId = '" + billId + "' and businessAttribute = '" + bussAttrNumber + "' and solution is null");
            if (coll.size() > 0) {
                paramMap.put("jobPriority", coll.get(0).getJobPriority());
            } else {
                Object priority = params.get("priority");
                String jobPriority = "";
                jobPriority = isSSC ? (priority != null ? priority.toString() : "20") : (priority != null ? priority.toString() : "20");
                paramMap.put("jobPriority", jobPriority);
            }
            if (!isSSC) {
                paramMap.put("billId", billId);
                paramMap.put("activityId", activityId);
            }
            paramMap.put("personId", personId);
            paramMap.put("personName", personName);
            paramMap.put("adminOrg", adminOrgUnitInfo == null ? null : adminOrgUnitInfo.getId().toString());
            String createArgs = JSONUtils.convertObjectToJson((Context)ctx, paramMap);
            HashMap<String, String> osfparam = new HashMap<String, String>();
            osfparam.put("createArgs", createArgs);
            ActivityJobInfoInfo activityJobInfo = new ActivityJobInfoInfo();
            activityJobInfo.setActivity(activityId);
            activityJobInfo.setBill(billId);
            activityJobInfo.setScheme(null);
            activityJobInfo.setIsCreateByActivity(true);
            activityJobInfo.setIsCreateByWorkflow(isCreateByWorkflow);
            activityJobInfo.setJobState(JobState.notCreate);
            activityJobInfo.setIsDelay(false);
            activityJobInfo.setCreateDate((Date)needToCreateJobInfo.get("createDate"));
            activityJobInfo.setCreateArgs(JSONUtils.convertObjectToJson((Context)ctx, paramMap));
            UIViewInfo relationIdInfo = activityInfo.getRelationView();
            JobInnerOperation jobInnerOperation = null;
            jobInnerOperation = JobUtils.getUserUrlImpl(ctx, relationIdInfo.getId().toString());
            if (!(null == jobInnerOperation || (createRuleMap = jobInnerOperation.checkCreateRule(ctx, billId, activityId, personId, createRuleParam = new HashMap())) == null || createRuleMap.get("success") != null && ((Boolean)createRuleMap.get("success")).booleanValue())) {
                activityJobInfo.setJobState(JobState.notCreate);
                String label4 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label4", (Context)ctx);
                activityJobInfo.setOpinion(createRuleMap.get("data") == null ? label4 : createRuleMap.get("data").toString());
            }
            if (needToCreateJobInfo.get("isDelay") != null && ((Boolean)needToCreateJobInfo.get("isDelay")).booleanValue()) {
                activityJobInfo.setIsDelay(true);
                if (!((Date)needToCreateJobInfo.get("createDate")).after(new Date())) {
                    jobId = null;
                    if (!isSSC) {
                        userSet = null;
                        if (params.get("userSet") instanceof Set) {
                            userSet = (Set)params.get("userSet");
                        }
                        params.putAll(paramMap);
                        jobId = CoActivityOptUtil.createJob(ctx, params, userSet);
                    } else {
                        jobId = this.createJob(ctx, activityJobInfo, osfparam);
                    }
                    activityJobInfo.setJobState(JobState.process);
                    activityJobInfo.setJobId(jobId);
                    resultMap.put("success", true);
                    resultMap.put("data", jobId);
                    jobIdSet.add(jobId);
                    afterCreateParam = new HashMap();
                    activitySolutionOperation.afterCreateJob(ctx, null, billId, jobIdSet, afterCreateParam);
                }
            } else {
                activityJobInfo.setIsDelay(false);
                jobId = null;
                if (!isSSC) {
                    userSet = null;
                    if (params.get("userSet") instanceof Set) {
                        userSet = (Set<String>)params.get("userSet");
                    }
                    try {
                        String bosType = BOSUuid.read((String)billId).getType().toString();
                        AssignUserOperation assignUserOperation = (AssignUserOperation)AssembleConfigUtils.getInter(ctx, bosType, "2");
                        if (assignUserOperation != null) {
                            userSet = assignUserOperation.getUserSet(ctx, billId, activityId, (String)paramMap.get("personId"), params);
                        }
                    }
                    catch (Exception e) {
                        logger.error("======com.kingdee.shr.shareservice.app.CoActivityJobOptFacadeControllerBean._createJobByActivity assignUserOperation:" + e.getMessage(), (Throwable)e);
                    }
                    params.putAll(paramMap);
                    jobId = CoActivityOptUtil.createJob(ctx, params, userSet);
                } else {
                    jobId = this.createJob(ctx, activityJobInfo, osfparam);
                }
                activityJobInfo.setJobState(JobState.process);
                activityJobInfo.setJobId(jobId);
                resultMap.put("success", true);
                resultMap.put("data", jobId);
                jobIdSet.add(jobId);
                afterCreateParam = new HashMap<String, Map<String, Object>>();
                afterCreateParam.put("paramMap", paramMap);
                afterCreateParam.put("params", params);
                activitySolutionOperation.afterCreateJob(ctx, null, billId, jobIdSet, afterCreateParam);
            }
            iActivityJobInfo.addnew(activityJobInfo);
        } else {
            HashSet<String> noActivity = new HashSet<String>();
            noActivity.add("No_Need_Create_Activity");
            params.put("noActivity", noActivity);
        }
        return resultMap;
    }

    private ActivityInfo checkActivity(Context ctx, String number, String billId) throws BOSException, EASBizException {
        ActivityInfo activityInfo = null;
        IActivity iActivity = ActivityFactory.getLocalInstance(ctx);
        String billBosType = BOSUuid.read((String)billId).getType().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        ActivityCollection activityCollection = iActivity.getActivityCollection(entityViewInfo);
        if (activityCollection.size() <= 0) {
            throw new SSCActivityException(SSCActivityException.ACTIVITY_NOEXIST_EXCEPTION, new Object[]{number});
        }
        activityInfo = iActivity.getActivityInfo((IObjectPK)new ObjectUuidPK(activityCollection.get(0).getId()));
        if (BaseItemStateEnum.NEW.equals((Object)activityInfo.getState())) {
            throw new SSCActivityException(SSCActivityException.ACTIVITY_NEW_EXCEPTION, new Object[]{number});
        }
        if (BaseItemStateEnum.DISABLE.equals((Object)activityInfo.getState())) {
            throw new SSCActivityException(SSCActivityException.ACTIVITY_DISABLE_EXCEPTION, new Object[]{number});
        }
        return activityInfo;
    }

    private String createJob(Context ctx, ActivityJobInfoInfo activityJobInfo, Map<String, String> osfparam) throws EASBizException, BOSException {
        activityJobInfo.setJobState(JobState.process);
        activityJobInfo.setIsDelay(false);
        activityJobInfo.setCreateDate(null);
        activityJobInfo.setCreateArgs(null);
        logger.debug("\u521b\u5efa\u4efb\u52a1\u53c2\u6570:" + osfparam);
        JsonObject resultObj = new JsonObject();
        resultObj = (JsonObject)OSFAppUtil.callService((Context)ctx, (String)"createJobNewService", osfparam);
        logger.debug("\u4efb\u52a1\u521b\u5efa\u63a5\u53e3\u7ed3\u679c:" + String.valueOf(resultObj));
        String jobId = "";
        if (resultObj != null && resultObj.get("success").getAsBoolean()) {
            jobId = resultObj.get("data").getAsString();
        }
        activityJobInfo.setJobId(jobId);
        return jobId;
    }

    @Override
    protected Map _reverseJob(Context ctx, Map params) throws BOSException, EASBizException {
        if (params.get("billId") != null || params.get("solutionId") != null) {
            return this.reverseCoJob(ctx, null, params);
        }
        String jobId = (String)params.get("jobId");
        if (StringUtils.isEmpty((String)jobId)) {
            return this.assemResult(false, "", "jobId is null");
        }
        String[] jobIds = jobId.split(",");
        String jobType = BOSUuid.read((String)jobIds[0]).getType().toString();
        if ("DC26015C".equals(jobType)) {
            return this.reverseCoJob(ctx, jobId, params);
        }
        if ("88451F0D".equals(jobType)) {
            return this.reverseSSCJob(ctx, jobId);
        }
        return this.assemResult(true, "not job is accepted", "");
    }

    private Map assemResult(boolean isSuccess, String msg, String errorMsg) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", isSuccess);
        resultMap.put("msg", msg);
        resultMap.put("errorMsg", errorMsg);
        return resultMap;
    }

    private Map reverseCoJob(Context ctx, String jobId, Map params) throws BOSException, EASBizException {
        ActivityJobInfoCollection infoColl;
        CharSequence[] jobIds = null;
        if (params.get("billId") != null && !StringUtils.isEmpty((String)((String)params.get("billId")))) {
            String billId = (String)params.get("billId");
            infoColl = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection("where bill ='" + params.get("billId") + "' and jobState  =1");
            if (infoColl.size() > 0) {
                int i;
                ArrayList<String> jobList = new ArrayList<String>();
                for (i = 0; i < infoColl.size(); ++i) {
                    if (infoColl.get(i).getJobId() == null) continue;
                    jobList.add(infoColl.get(i).getJobId());
                }
                if (jobList.size() > 0) {
                    jobIds = new String[jobList.size()];
                    for (i = 0; i < jobList.size(); ++i) {
                        jobIds[i] = (String)jobList.get(i);
                    }
                }
            }
        }
        if (jobIds == null && params.get("solutionId") != null) {
            String solutionId = (String)params.get("solutionId");
            infoColl = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection("where scheme ='" + params.get("billId") + "' and jobState  =1");
            if (infoColl.size() > 0) {
                jobIds = new String[infoColl.size()];
                for (int i = 0; i < infoColl.size(); ++i) {
                    jobIds[i] = infoColl.get(i).getJobId();
                }
            }
        }
        if (jobIds == null && !StringUtils.isEmpty((String)jobId)) {
            jobIds = jobId.split(",");
        }
        if (jobIds == null || jobIds.length == 0) {
            return this.assemResult(false, "", "jobId is null or can not get jobId");
        }
        jobId = String.join((CharSequence)",", jobIds);
        try {
            CoActivityOptUtil.deleteJob(ctx, jobId, params);
        }
        catch (EASBizException e) {
            logger.error("reverseCoJob " + e.getMessage(), (Throwable)e);
            return this.assemResult(false, "", e.getMessage());
        }
        ActivityJobInfoCollection actJobCol = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection("select id where jobId in " + HRUtilExtend.getStrFromArray((String[])jobIds));
        for (int i = 0; i < actJobCol.size(); ++i) {
            ActivityJobInfoInfo actInfo = actJobCol.get(i);
            actInfo.setJobState(JobState.finish);
        }
        SelectorItemCollection actSel = new SelectorItemCollection();
        actSel.add(new SelectorItemInfo("jobState"));
        try {
            ActivityJobInfoFactory.getLocalInstance(ctx).updatePartialBatchData((IObjectCollection)actJobCol, actSel);
        }
        catch (EASBizException e) {
            logger.error("reverseCoJob " + e.getMessage(), (Throwable)e);
            return this.assemResult(false, "", e.getMessage());
        }
        return this.assemResult(true, "success", "");
    }

    private Map reverseSSCJob(Context ctx, String jobId) throws BOSException {
        String dealerId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        HashMap<String, Object> taskOperate = new HashMap<String, Object>();
        taskOperate.put("jobId", jobId);
        taskOperate.put("userId", dealerId);
        taskOperate.put("joinAssign", false);
        try {
            ActivityJobInfoCollection actJobCol;
            JsonObject resultJson = SSCTaskAppUtil.operateTaskAll(ctx, "REALLOTPERSON", taskOperate);
            if (null != resultJson && !resultJson.isJsonNull()) {
                boolean isSuccess = resultJson.get("success").getAsBoolean();
                if (!isSuccess) {
                    String errMsg = resultJson.get("data").toString();
                    return this.assemResult(false, "", errMsg);
                }
                actJobCol = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection("select id where jobId in ('" + jobId.replaceAll(",", "','") + "')");
                for (int i = 0; i < actJobCol.size(); ++i) {
                    ActivityJobInfoInfo actInfo = actJobCol.get(i);
                    actInfo.setJobState(JobState.finish);
                }
            } else {
                return this.assemResult(false, "", "SSCTaskAppUtil access error!");
            }
            SelectorItemCollection actSel = new SelectorItemCollection();
            actSel.add(new SelectorItemInfo("jobState"));
            ActivityJobInfoFactory.getLocalInstance(ctx).updatePartialBatchData((IObjectCollection)actJobCol, actSel);
        }
        catch (EASBizException e) {
            logger.error("reverseCoJob " + e.getMessage(), (Throwable)e);
            return this.assemResult(false, "", e.getMessage());
        }
        return this.assemResult(true, "success", "");
    }

    @Override
    protected Map _allotPerson(Context ctx, String jobId, Set userSet, Map params) throws BOSException, EASBizException {
        CoActivityJobInfo info = CoActivityJobFactory.getLocalInstance(ctx).getCoActivityJobInfo((IObjectPK)new ObjectUuidPK(jobId));
        CoActivityOptUtil.assignUser(ctx, info, userSet, params);
        return null;
    }
}

