/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptEmpOrgRelationTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.shareservice.ReminderTimePoolFactory;
import com.kingdee.shr.shareservice.app.AbstractCoActivityReminderFacadeControllerBean;
import com.kingdee.shr.shareservice.workdate.WorkDateUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoActivityReminderFacadeControllerBean
extends AbstractCoActivityReminderFacadeControllerBean {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.shareservice.app.CoActivityReminderFacadeControllerBean");
    private static final int MAX_POOL_DATA = 8000;
    private static final long DURE_DEL = 1200000L;

    @Override
    protected void _calculateTime(Context ctx) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        int tempCount = ReminderTimePoolFactory.getLocalInstance(ctx).getCount(entityViewInfo);
        if (tempCount > 0) {
            String reConfirmSql = "SELECT TOP 1 FCREATETIME as createTime FROM T_HR_ReminderTimePool";
            IRowSet confirmData = DbUtil.executeQuery((Context)ctx, (String)reConfirmSql);
            try {
                while (confirmData.next()) {
                    Date createTimeDate;
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String createTime = confirmData.getString("createTime");
                    long nowTime = System.currentTimeMillis();
                    long dure = nowTime - (createTimeDate = simpleDateFormat.parse(createTime)).getTime() - 1200000L;
                    if (dure <= 0L) continue;
                    String deleteTempPoolSql = "delete from T_HR_ReminderTimePool";
                    DbUtil.execute((Context)ctx, (String)deleteTempPoolSql);
                }
            }
            catch (Exception e) {
                logger.error("reConfirm:" + e.getMessage(), (Throwable)e);
            }
            return;
        }
        String reminderTimePoolSql = "INSERT  INTO T_HR_ReminderTimePool(FCOACTIVITYJOB ,FREMIDERTIME ,FDEALER,FJOBCREATETIME ,FDEALRUNTIME ,FID,FExecutor,FCREATETIME  ) select coJob.fid,coJob.FACTREMINDERTIME,executor.FUSER,coJob.FCREATETIME,executor.FCREATETIME,newbosid('E065C1A1'),executor.fid,now()  from t_hr_coactivityexecutor executor  left outer join t_hr_coactivityjob coJob on executor.fcoactivity = coJob.fid  left join t_shr_activity activity on coJob.FBussAttrID = activity.fid  where coJob.FJobPoolingType = '2'  and activity.FNeedReminderTime = 1";
        DbUtil.execute((Context)ctx, (String)reminderTimePoolSql);
        try {
            int poolSearchIndex = 0;
            for (int poolCount = ReminderTimePoolFactory.getLocalInstance(ctx).getCount(entityViewInfo); poolCount > 0; poolCount -= 8000) {
                this.poolDataExecute(ctx, poolSearchIndex);
                poolSearchIndex += 8000;
            }
        }
        catch (Exception e) {
            logger.error("calculateTime:" + e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            String deleteTempPoolSql = "delete from T_HR_ReminderTimePool";
            DbUtil.execute((Context)ctx, (String)deleteTempPoolSql);
        }
    }

    protected void poolDataExecute(Context ctx, int poolSearchIndex) throws BOSException, EASBizException, SQLException {
        String poolDataSql = "select top 8000 ," + poolSearchIndex + " poolData.FCOACTIVITYJOB as coJob,poolData.FREMIDERTIME as reminderTime,pmUser.FPersonId as dealer,poolData.FJOBCREATETIME as jobCreateTime,poolData.FDEALRUNTIME as dealerTime,poolData.FExecutor as executor from T_HR_ReminderTimePool poolData left outer join t_pm_user pmUser on poolData.FDEALER = pmUser.fid order by poolData.FCOACTIVITYJOB desc";
        IRowSet poolData = DbUtil.executeQuery((Context)ctx, (String)poolDataSql);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        while (poolData.next()) {
            WorkDateUtil util;
            EmpPosOrgRelationInfo empPosInfo;
            String workDateOrgId;
            String dealer = poolData.getString("dealer");
            if (StringUtils.isEmpty((String)dealer) || StringUtils.isEmpty((String)(workDateOrgId = (empPosInfo = SHREmpOptEmpOrgRelationTool.getCurrntMainEmpOrgRelationInfo((Context)ctx, (String)dealer)).getAdminOrg() == null ? null : empPosInfo.getAdminOrg().getId().toString())) || (util = WorkDateUtil.getInstance(ctx, workDateOrgId, false)) == null) continue;
            double totalCost = util.getCalWorkTimes(poolData.getTimestamp("dealerTime"), new Date(System.currentTimeMillis()), 0);
            int limit = poolData.getInt("reminderTime");
            double reminderTime = (double)(limit * 3600 * 1000) - totalCost;
            int isExpire = 0;
            if (reminderTime < 0.0) {
                isExpire = 1;
            }
            Object[] param = new Object[]{reminderTime / 3600000.0, isExpire, poolData.getString("executor")};
            paramsList.add(param);
        }
        if (!paramsList.isEmpty()) {
            this.updateReminder(ctx, paramsList);
        }
    }

    protected void updateReminder(Context ctx, List<Object[]> paramsList) throws BOSException {
        String reminderUptSql = "update T_HR_CoActivityExecutor set FReminderTime = ?,FIsExpired = ? where fid = ?";
        DbUtil.executeBatch((Context)ctx, (String)reminderUptSql, paramsList);
    }
}

