/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.shr.shareservice.AssembleConfigCollection;
import com.kingdee.shr.shareservice.AssembleConfigFactory;
import com.kingdee.shr.shareservice.AssembleConfigInfo;
import com.kingdee.shr.shareservice.inter.AssembleInter;
import com.kingdee.shr.shareservice.strategy.ActivitySolutionOperation;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssembleConfigUtils {
    private static final Logger logger = LoggerFactory.getLogger(AssembleConfigUtils.class);
    private static final Map<String, Map<String, String>> pathCache = new ConcurrentHashMap<String, Map<String, String>>();

    public static AssembleInter getRuleAssemInter(Context ctx, String bosType) throws BOSException {
        return (AssembleInter)AssembleConfigUtils.getInter(ctx, bosType, "0");
    }

    public static ActivitySolutionOperation getBillTypeInter(Context ctx, String bosType) throws BOSException {
        return (ActivitySolutionOperation)AssembleConfigUtils.getInter(ctx, bosType, "1");
    }

    public static Object getInter(Context ctx, String bosType, String assembleType) throws BOSException {
        String assemblePath;
        Map<String, String> assConfig = pathCache.get(assembleType);
        if (null == assConfig || assConfig.isEmpty()) {
            EntityViewInfo viewinfo = new EntityViewInfo();
            FilterInfo filterinfo = new FilterInfo();
            filterinfo.getFilterItems().add(new FilterItemInfo("assembleType", (Object)assembleType, CompareType.EQUALS));
            viewinfo.setFilter(filterinfo);
            SelectorItemCollection selCol = new SelectorItemCollection();
            selCol.add(new SelectorItemInfo("assImplPath"));
            selCol.add(new SelectorItemInfo("assImplPathExt"));
            selCol.add(new SelectorItemInfo("bosType"));
            viewinfo.setSelector(selCol);
            AssembleConfigCollection assembleCol = AssembleConfigFactory.getLocalInstance(ctx).getAssembleConfigCollection(viewinfo);
            if (assembleCol != null && !assembleCol.isEmpty()) {
                if (null == assConfig) {
                    assConfig = new HashMap<String, String>();
                }
                for (int i = 0; i < assembleCol.size(); ++i) {
                    AssembleConfigInfo assembleInfo = assembleCol.get(i);
                    String assImpl = assembleInfo.getAssImplPathExt();
                    if (StringUtils.isEmpty((String)assImpl)) {
                        assImpl = assembleInfo.getAssImplPath();
                    }
                    assConfig.put(assembleInfo.getBosType(), assImpl);
                }
                pathCache.put(assembleType, assConfig);
            } else {
                return null;
            }
        }
        if (StringUtils.isEmpty((String)(assemblePath = AssembleConfigUtils.getConfigPath(ctx, bosType, assConfig)))) {
            return null;
        }
        try {
            return Class.forName(assemblePath).newInstance();
        }
        catch (Exception e) {
            logger.error("com.kingdee.shr.shareservice.util.AssembleConfigUtils.getInter:" + e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static String getConfigPath(Context ctx, String bosType, Map<String, String> assConfig) throws BOSException {
        String assemblePath = assConfig.get(bosType);
        if (StringUtils.isEmpty((String)assemblePath)) {
            String parentPath;
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)bosType));
            BusinessObjectInfo parent = entityInfo.getParent();
            while (true) {
                if (null == parent) {
                    return null;
                }
                BOSObjectType parentType = parent.getType();
                if (null == parentType) {
                    return null;
                }
                parentPath = assConfig.get(parentType.toString());
                if (!StringUtils.isEmpty((String)parentPath)) break;
                parent = parent.getParent();
            }
            return parentPath;
        }
        return assemblePath;
    }

    public static boolean clearCache() {
        pathCache.clear();
        if (null != pathCache && !pathCache.isEmpty()) {
            logger.error("clearCache pathCache:" + pathCache);
            return false;
        }
        return true;
    }
}

