/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.ActivityBussTypeFactory;
import com.kingdee.shr.shareservice.ActivityFactory;
import com.kingdee.shr.shareservice.ActivityInfo;
import com.kingdee.shr.shareservice.ActivityPriorityCollection;
import com.kingdee.shr.shareservice.ActivityPriorityFactory;
import com.kingdee.shr.shareservice.ActivityPriorityInfo;
import com.kingdee.shr.shareservice.CoActivityAssignRuleDetailCollection;
import com.kingdee.shr.shareservice.CoActivityAssignRuleDetailEntryCollection;
import com.kingdee.shr.shareservice.CoActivityAssignRuleDetailEntryInfo;
import com.kingdee.shr.shareservice.CoActivityAssignRuleDetailFactory;
import com.kingdee.shr.shareservice.CoActivityAssignRuleDetailInfo;
import com.kingdee.shr.shareservice.CoActivityAssignRuleType;
import com.kingdee.shr.shareservice.CoActivityAssignUserCollection;
import com.kingdee.shr.shareservice.CoActivityAssignUserFactory;
import com.kingdee.shr.shareservice.CoActivityException;
import com.kingdee.shr.shareservice.CoActivityExecutorCollection;
import com.kingdee.shr.shareservice.CoActivityExecutorFactory;
import com.kingdee.shr.shareservice.CoActivityExecutorInfo;
import com.kingdee.shr.shareservice.CoActivityJobCollection;
import com.kingdee.shr.shareservice.CoActivityJobFactory;
import com.kingdee.shr.shareservice.CoActivityJobInfo;
import com.kingdee.shr.shareservice.CoActivityState;
import com.kingdee.shr.shareservice.CoJobPoolingType;
import com.kingdee.shr.shareservice.CoJobPriorityCollection;
import com.kingdee.shr.shareservice.CoJobPriorityFactory;
import com.kingdee.shr.shareservice.CoJobPriorityInfo;
import com.kingdee.shr.shareservice.CoJobState;
import com.kingdee.shr.shareservice.IActivity;
import com.kingdee.shr.shareservice.ICoActivityExecutor;
import com.kingdee.shr.shareservice.ICoActivityJob;
import com.kingdee.shr.shareservice.RuleFieldEntryFactory;
import com.kingdee.shr.shareservice.RuleFieldEntryInfo;
import com.kingdee.shr.shareservice.RuleFieldFactory;
import com.kingdee.shr.shareservice.RuleFieldInfo;
import com.kingdee.shr.shareservice.RuleSourceType;
import com.kingdee.shr.shareservice.app.Operation;
import com.kingdee.shr.shareservice.util.ActivityHelper;
import com.kingdee.shr.shareservice.util.JobStateTimeUtils;
import com.kingdee.shr.shareservice.util.RuleEngine;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoActivityOptUtil {
    private static final Logger logger = LoggerFactory.getLogger(CoActivityOptUtil.class);

    public static String createJob(Context ctx, Map param, Set<String> userSet) throws EASBizException, BOSException {
        CoActivityOptUtil.checkParam(ctx, param);
        CoActivityJobInfo info = CoActivityOptUtil.innerCreateJob(ctx, param);
        param.put("newCreate", true);
        CoActivityOptUtil.assignUser(ctx, info, userSet, param);
        try {
            String message = null;
            String innerMsg = null;
            JobStateTimeUtils.addJobStateTime(ctx, info.getId().toString(), message, Operation.CreateTask, innerMsg, null);
        }
        catch (Exception e) {
            logger.error("com.kingdee.shr.shareservice.util.CoActivityOptUtil.createJob addJobStateTime error!! " + e.getMessage(), (Throwable)e);
        }
        return info.getId().toString();
    }

    private static void checkParam(Context ctx, Map param) throws BOSException, EASBizException {
        String activityId = param.get("activityId") == null ? "" : (String)param.get("activityId");
        String billId = param.get("billId") == null ? "" : (String)param.get("billId");
        IActivity iActivity = ActivityFactory.getLocalInstance(ctx);
        if (StringUtils.isEmpty((String)activityId)) {
            if (param.get("bussAttrNum") == null || StringUtils.isEmpty((String)((String)param.get("bussAttrNum")))) {
                throw new CoActivityException(CoActivityException.BUSSATTR_NOT_EXIST);
            }
            String bussAttrNum = (String)param.get("bussAttrNum");
            if (!ActivityBussTypeFactory.getLocalInstance(ctx).exists("where bussAttrNum='" + bussAttrNum + "'")) {
                throw new CoActivityException(CoActivityException.BUSSATTR_NOT_EXIST);
            }
        } else if (!iActivity.exists("where id = '" + activityId + "'")) {
            throw new CoActivityException(CoActivityException.BUSSATTR_NOT_EXIST);
        }
        if (StringUtils.isEmpty((String)billId)) {
            throw new CoActivityException(CoActivityException.BILL_NOT_EXIST);
        }
    }

    private static CoActivityJobInfo innerCreateJob(Context ctx, Map param) throws EASBizException, BOSException, UuidException {
        String subject = param.get("subject") == null ? "" : (String)param.get("subject");
        String subjectAll = param.get("subjectAll") == null ? "" : (String)param.get("subjectAll");
        String activityId = param.get("activityId") == null ? "" : (String)param.get("activityId");
        String billId = param.get("billId") == null ? "" : (String)param.get("billId");
        String priority = (String)param.get("jobPriority");
        CoActivityJobInfo info = new CoActivityJobInfo();
        CoActivityOptUtil.initPriority(ctx, activityId, priority, info);
        info.setBillID(BOSUuid.read((String)billId));
        CoActivityOptUtil.initSubject(ctx, subject, subjectAll, info);
        ActivityInfo activityInfo = new ActivityInfo();
        activityInfo.setId(BOSUuid.read((String)activityId));
        info.setBussAttrID(activityInfo);
        info.setJobPoolingType(CoJobPoolingType.NotAssign);
        info.setJobState(CoJobState.Normal);
        info.setReceiveTime(new Timestamp(System.currentTimeMillis()));
        info.setAssignCount(1);
        CoActivityOptUtil.initOtherField(ctx, param, info);
        IObjectPK jobIdPk = CoActivityJobFactory.getLocalInstance(ctx).addnew(info);
        info.setId(BOSUuid.read((String)jobIdPk.toString()));
        ActivityHelper.dealWithBussActivityAfterCreate(ctx, activityId, jobIdPk.toString(), billId, param);
        return info;
    }

    private static void initPriority(Context ctx, String activityId, String priority, CoActivityJobInfo info) throws BOSException, EASBizException {
        CoJobPriorityCollection coJobPriorityInfoCol;
        if (StringUtils.isEmpty((String)activityId) || StringUtils.isEmpty((String)priority)) {
            return;
        }
        ActivityInfo activityInfo = ActivityFactory.getLocalInstance(ctx).getActivityInfo("select needReminderTime where id = '" + activityId + "'");
        if (activityInfo.isNeedReminderTime() && null != (coJobPriorityInfoCol = CoJobPriorityFactory.getLocalInstance(ctx).getCoJobPriorityCollection("select id,priority where priority = " + priority + " and state = 1")) && !coJobPriorityInfoCol.isEmpty()) {
            CoJobPriorityInfo coJobPriorityInfo = coJobPriorityInfoCol.get(0);
            info.setCoJobPriority(coJobPriorityInfo);
            ActivityPriorityCollection activityPriorityCol = ActivityPriorityFactory.getLocalInstance(ctx).getActivityPriorityCollection("select reminderTime where activity = '" + activityId + "' and coJobPriority = '" + coJobPriorityInfo.getId().toString() + "'");
            if (activityPriorityCol != null && !activityPriorityCol.isEmpty()) {
                ActivityPriorityInfo activityPriority = activityPriorityCol.get(0);
                info.setActReminderTime(activityPriority.getReminderTime());
            }
        }
    }

    private static void initSubject(Context ctx, String subject, String subjectAll, CoActivityJobInfo info) {
        if (!StringUtils.isEmpty((String)subject)) {
            info.setSubject(subject);
        }
        if (!StringUtils.isEmpty((String)subjectAll)) {
            try {
                JSONObject subjectAllOjb = JSONObject.parseObject((String)subjectAll);
                info.setSubject(StringUtils.isEmpty((String)subjectAllOjb.getString("l1")) ? null : subjectAllOjb.getString("l1"), LocaleUtils.getLocale((String)"l1"));
                info.setSubject(StringUtils.isEmpty((String)subjectAllOjb.getString("l2")) ? null : subjectAllOjb.getString("l2"), LocaleUtils.getLocale((String)"l2"));
                info.setSubject(StringUtils.isEmpty((String)subjectAllOjb.getString("l3")) ? null : subjectAllOjb.getString("l3"), LocaleUtils.getLocale((String)"l3"));
            }
            catch (Exception e) {
                logger.error("JSONObject.parseObject(subjectAll) error :" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void initOtherField(Context ctx, Map param, CoActivityJobInfo info) throws EASBizException, BOSException, UuidException {
        if (param.get("adminOrg") != null) {
            AdminOrgUnitInfo admininfo = new AdminOrgUnitInfo();
            admininfo.setId(BOSUuid.read((String)param.get("adminOrg").toString()));
            info.setAdminOrg(admininfo);
        }
        if (param.get("personName") != null && !StringUtils.isEmpty((String)param.get("personName").toString())) {
            info.setEmpDealerName(param.get("personName").toString());
        }
        if (param.get("personId") != null && !StringUtils.isEmpty((String)param.get("personId").toString())) {
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)param.get("personId").toString())));
            info.setRelator(personInfo);
            info.setEmpDealerName(personInfo.getName());
        }
    }

    @Deprecated
    public static void assignUser(Context ctx, CoActivityJobInfo info, Set<String> userSet) throws EASBizException, BOSException {
        if (userSet != null && userSet.size() > 0) {
            CoActivityOptUtil.assignUserInner(ctx, info, userSet);
            try {
                String label6;
                String message = label6 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.CoActivityResource", (String)"label6", (Context)ctx);
                String innerMsg = label6;
                JobStateTimeUtils.addJobStateTime(ctx, info.getId().toString(), message, Operation.Assign, innerMsg, null);
            }
            catch (Exception e) {
                logger.error("com.kingdee.shr.shareservice.util.CoActivityOptUtil.createJob assignUserInner error!! " + e.getMessage(), (Throwable)e);
            }
        } else {
            String billId = info.getBillID().toString();
            ActivityInfo bussAttrID = info.getBussAttrID();
            ActivityInfo activityInfo = ActivityFactory.getLocalInstance(ctx).getActivityInfo((IObjectPK)new ObjectUuidPK(bussAttrID.getId()));
            CoActivityAssignRuleDetailCollection ruleColl = activityInfo.getCoActivityAssignRule();
            if (ruleColl.size() > 0) {
                HashSet<String> ids = new HashSet<String>();
                for (int i = 0; i < ruleColl.size(); ++i) {
                    ids.add(ruleColl.get(i).getId().toString());
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                view.setFilter(filter);
                SorterItemCollection sorterItemColl = new SorterItemCollection();
                sorterItemColl.add(new SorterItemInfo("priority"));
                view.setSorter(sorterItemColl);
                CoActivityAssignRuleDetailCollection coll = CoActivityAssignRuleDetailFactory.getLocalInstance(ctx).getCoActivityAssignRuleDetailCollection(view);
                for (int i = 0; i < coll.size(); ++i) {
                    CoActivityAssignRuleDetailInfo detailInfo = coll.get(i);
                    String conditionStr = detailInfo.getCondition();
                    ArrayList<String> structList = new ArrayList<String>();
                    HashMap<String, Object> structMap = new HashMap<String, Object>();
                    CoActivityAssignRuleDetailEntryCollection entryColl = detailInfo.getRuleEntrys();
                    boolean isEntryNull = false;
                    if (entryColl == null && entryColl.size() == 0) {
                        isEntryNull = true;
                    }
                    HashMap<String, Object> rules = new HashMap<String, Object>();
                    if (!StringUtils.isEmpty((String)conditionStr)) {
                        JSONArray conditionJsonArray = JSONObject.parseArray((String)conditionStr);
                        JSONObject conditionJsonOB = (JSONObject)conditionJsonArray.get(0);
                        ArrayList<Map<String, Object>> ruleList = new ArrayList<Map<String, Object>>();
                        rules.put("logicalRelationship", (String)conditionJsonOB.get((Object)"logicalRelationship"));
                        rules.put("relationship", (String)conditionJsonOB.get((Object)"relationship"));
                        rules.put("ruleList", ruleList);
                        for (int k = 0; k < entryColl.size(); ++k) {
                            CoActivityAssignRuleDetailEntryInfo detailEntryInfo = entryColl.get(k);
                            HashMap<String, Object> ruleMap = new HashMap<String, Object>();
                            ruleMap.put("fieldId", detailEntryInfo.getRuleField() == null ? null : detailEntryInfo.getRuleField().getId().toString());
                            ruleMap.put("ruleOpt", (Object)detailEntryInfo.getRuleOpt());
                            Object ruleVal = ActivityHelper.getRuleValOnRuleDetailEntry(ctx, detailEntryInfo);
                            ruleMap.put("ruleVal", ruleVal);
                            ruleMap.put("number", detailEntryInfo.getNumber());
                            ruleMap.put("taskType", 0);
                            RuleFieldEntryInfo ruleFieldEntryIdInfo = detailEntryInfo.getRuleField();
                            RuleFieldEntryInfo ruleFieldEntryInfo = RuleFieldEntryFactory.getLocalInstance(ctx).getRuleFieldEntryInfo((IObjectPK)new ObjectUuidPK(ruleFieldEntryIdInfo.getId()));
                            RuleFieldInfo ruleFieldIdInfo = ruleFieldEntryInfo.getParent();
                            RuleFieldInfo ruleFieldInfo = RuleFieldFactory.getLocalInstance(ctx).getRuleFieldInfo((IObjectPK)new ObjectUuidPK(ruleFieldIdInfo.getId()));
                            RuleSourceType ruleSourceType = ruleFieldInfo.getSourceType();
                            Object fieldValue = null;
                            if (ruleSourceType == RuleSourceType.ENTITY) {
                                try {
                                    fieldValue = CoActivityOptUtil.getFieldValueByEntity(ctx, detailEntryInfo, billId);
                                    ruleMap.put("fieldVal", fieldValue);
                                    ruleList.add(ruleMap);
                                }
                                catch (InterruptedException e) {
                                    logger.error(e.getMessage(), (Throwable)e);
                                    Thread.currentThread().interrupt();
                                }
                                continue;
                            }
                            if (ruleSourceType != RuleSourceType.STRUCTURE_CONFIG) continue;
                            structList.add(ruleFieldEntryInfo.getFieldKey());
                            ruleMap.put("structName", ruleFieldEntryInfo.getFieldKey());
                            ruleList.add(ruleMap);
                        }
                        try {
                            if (structList.size() > 0) {
                                String personId = info.getRelator().getId().toString();
                                CoActivityOptUtil.assembleStructMap(ctx, structList, personId, structMap, ruleList);
                            }
                        }
                        catch (SQLException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (isEntryNull || RuleEngine.judge(ctx, rules)) {
                        CoActivityAssignRuleType ruleType = detailInfo.getRuleType();
                        if (ruleType == CoActivityAssignRuleType.USER) {
                            Object user = null;
                            CoActivityAssignUserCollection userColl = CoActivityAssignUserFactory.getLocalInstance(ctx).getCoActivityAssignUserCollection("where assignRuleId = '" + detailInfo.getId().toString() + "'");
                            if (userColl.size() > 0) {
                                if (userSet == null) {
                                    userSet = new HashSet<String>();
                                }
                                for (int u = 0; u < userColl.size(); ++u) {
                                    userSet.add(userColl.get(u).getUser());
                                }
                            }
                        } else if (ruleType == CoActivityAssignRuleType.POSITION) {
                            PositionInfo positionInfo;
                            if (userSet == null) {
                                userSet = new HashSet<String>();
                            }
                            if ((positionInfo = detailInfo.getPosition()) != null) {
                                HashSet<String> personSet = new HashSet<String>();
                                EmpPosOrgRelationCollection relaColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection("select person where LEFFDT={ts'2199-12-31'} and isInner=1 and position = '" + positionInfo.getId().toString() + "'");
                                for (int k = 0; k < relaColl.size(); ++k) {
                                    personSet.add(relaColl.get(k).getPerson().getId().toString());
                                }
                                EntityViewInfo userView = new EntityViewInfo();
                                FilterInfo userFilter = new FilterInfo();
                                userFilter.getFilterItems().add(new FilterItemInfo("person", personSet, CompareType.INCLUDE));
                                userView.setFilter(userFilter);
                                UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection(userView);
                                for (int k = 0; k < userColl.size(); ++k) {
                                    userSet.add(userColl.get(k).getId().toString());
                                }
                            }
                        } else if (ruleType == CoActivityAssignRuleType.ROLE) {
                            RoleInfo roleInfo;
                            if (userSet == null) {
                                userSet = new HashSet<String>();
                            }
                            if ((roleInfo = detailInfo.getRole()) != null) {
                                String sql = "select FUserID from T_PM_UserRoleOrg where FRoleID = '" + roleInfo.getId().toString() + "'";
                                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                                try {
                                    while (rs.next()) {
                                        userSet.add(rs.getString("FUserID"));
                                    }
                                }
                                catch (SQLException e) {
                                    logger.error(e.getMessage(), (Throwable)e);
                                    throw new BOSException(e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                    }
                    CoActivityOptUtil.assignUserInner(ctx, info, userSet);
                    try {
                        String label5;
                        String message = label5 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.CoActivityResource", (String)"label5", (Context)ctx);
                        String innerMsg = label5;
                        JobStateTimeUtils.addJobStateTime(ctx, info.getId().toString(), message, Operation.AutoAssign, innerMsg, null);
                    }
                    catch (Exception e) {
                        logger.error("com.kingdee.shr.shareservice.util.CoActivityOptUtil.createJob assignUserInner error!! " + e.getMessage(), (Throwable)e);
                    }
                    if (userSet != null && userSet.size() > 0) break;
                }
            }
        }
    }

    public static void assignUser(Context ctx, CoActivityJobInfo info, Set<String> userSet, Map params) throws EASBizException, BOSException {
        ActivityInfo activityInfo;
        if (info == null) {
            return;
        }
        info = CoActivityJobFactory.getLocalInstance(ctx).getCoActivityJobInfo((IObjectPK)new ObjectUuidPK(info.getId()));
        Map<String, Object> activitySetMap = CoActivityOptUtil.getActivityUserSet(ctx, info);
        if (activitySetMap != null) {
            if (activitySetMap.get("success") != null && "false".equals(activitySetMap.get("success").toString().trim().toLowerCase())) {
                return;
            }
            if (activitySetMap.get("data") != null && activitySetMap.get("data") instanceof Set && ((Set)activitySetMap.get("data")).size() > 0 && (userSet == null || userSet.size() <= 0)) {
                userSet = (HashSet<String>)activitySetMap.get("data");
            }
        }
        if (userSet != null && userSet.size() > 0) {
            CoActivityOptUtil.assignUserInner(ctx, info, userSet);
            try {
                String label6;
                String message = label6 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.CoActivityResource", (String)"label6", (Context)ctx);
                String innerMsg = label6;
                JobStateTimeUtils.addJobStateTime(ctx, info.getId().toString(), message, Operation.Assign, innerMsg, null);
            }
            catch (Exception e) {
                logger.error("com.kingdee.shr.shareservice.util.CoActivityOptUtil.createJob assignUserInner error!! " + e.getMessage(), (Throwable)e);
            }
        } else {
            String billId = info.getBillID().toString();
            ActivityInfo bussAttrID = info.getBussAttrID();
            ActivityInfo activityInfo2 = ActivityFactory.getLocalInstance(ctx).getActivityInfo((IObjectPK)new ObjectUuidPK(bussAttrID.getId()));
            CoActivityAssignRuleDetailCollection ruleColl = activityInfo2.getCoActivityAssignRule();
            if (ruleColl.size() > 0) {
                HashSet<String> ids = new HashSet<String>();
                for (int i = 0; i < ruleColl.size(); ++i) {
                    ids.add(ruleColl.get(i).getId().toString());
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                view.setFilter(filter);
                SorterItemCollection sorterItemColl = new SorterItemCollection();
                sorterItemColl.add(new SorterItemInfo("priority"));
                view.setSorter(sorterItemColl);
                CoActivityAssignRuleDetailCollection coll = CoActivityAssignRuleDetailFactory.getLocalInstance(ctx).getCoActivityAssignRuleDetailCollection(view);
                for (int i = 0; i < coll.size(); ++i) {
                    CoActivityAssignRuleDetailInfo detailInfo = coll.get(i);
                    String conditionStr = detailInfo.getCondition();
                    ArrayList<String> structList = new ArrayList<String>();
                    HashMap<String, Object> structMap = new HashMap<String, Object>();
                    boolean isEntryNull = false;
                    CoActivityAssignRuleDetailEntryCollection entryColl = detailInfo.getRuleEntrys();
                    if (entryColl == null || entryColl.size() == 0) {
                        isEntryNull = true;
                    }
                    HashMap<String, Object> rules = new HashMap<String, Object>();
                    if (!StringUtils.isEmpty((String)conditionStr)) {
                        JSONArray conditionJsonArray = JSONObject.parseArray((String)conditionStr);
                        JSONObject conditionJsonOB = (JSONObject)conditionJsonArray.get(0);
                        ArrayList<Map<String, Object>> ruleList = new ArrayList<Map<String, Object>>();
                        rules.put("logicalRelationship", (String)conditionJsonOB.get((Object)"logicalRelationship"));
                        rules.put("relationship", (String)conditionJsonOB.get((Object)"relationship"));
                        rules.put("ruleList", ruleList);
                        for (int k = 0; k < entryColl.size(); ++k) {
                            CoActivityAssignRuleDetailEntryInfo detailEntryInfo = entryColl.get(k);
                            HashMap<String, Object> ruleMap = new HashMap<String, Object>();
                            ruleMap.put("fieldId", detailEntryInfo.getRuleField() == null ? null : detailEntryInfo.getRuleField().getId().toString());
                            ruleMap.put("ruleOpt", (Object)detailEntryInfo.getRuleOpt());
                            Object ruleVal = ActivityHelper.getRuleValOnRuleDetailEntry(ctx, detailEntryInfo);
                            ruleMap.put("ruleVal", ruleVal);
                            ruleMap.put("number", detailEntryInfo.getNumber());
                            ruleMap.put("taskType", 0);
                            RuleFieldEntryInfo ruleFieldEntryIdInfo = detailEntryInfo.getRuleField();
                            RuleFieldEntryInfo ruleFieldEntryInfo = RuleFieldEntryFactory.getLocalInstance(ctx).getRuleFieldEntryInfo((IObjectPK)new ObjectUuidPK(ruleFieldEntryIdInfo.getId()));
                            RuleFieldInfo ruleFieldIdInfo = ruleFieldEntryInfo.getParent();
                            RuleFieldInfo ruleFieldInfo = RuleFieldFactory.getLocalInstance(ctx).getRuleFieldInfo((IObjectPK)new ObjectUuidPK(ruleFieldIdInfo.getId()));
                            RuleSourceType ruleSourceType = ruleFieldInfo.getSourceType();
                            Object fieldValue = null;
                            if (ruleSourceType == RuleSourceType.ENTITY) {
                                try {
                                    fieldValue = CoActivityOptUtil.getFieldValueByEntity(ctx, detailEntryInfo, billId);
                                    ruleMap.put("fieldVal", fieldValue);
                                    ruleList.add(ruleMap);
                                    continue;
                                }
                                catch (InterruptedException e) {
                                    logger.error(e.getMessage(), (Throwable)e);
                                    Thread.currentThread().interrupt();
                                    continue;
                                }
                                catch (Exception e) {
                                    return;
                                }
                            }
                            if (ruleSourceType != RuleSourceType.STRUCTURE_CONFIG) continue;
                            structList.add(ruleFieldEntryInfo.getFieldKey());
                            ruleMap.put("structName", ruleFieldEntryInfo.getFieldKey());
                            ruleList.add(ruleMap);
                        }
                        try {
                            if (structList.size() > 0) {
                                String personId = info.getRelator().getId().toString();
                                CoActivityOptUtil.assembleStructMap(ctx, structList, personId, structMap, ruleList);
                            }
                        }
                        catch (SQLException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (isEntryNull || RuleEngine.judge(ctx, rules)) {
                        CoActivityAssignRuleType ruleType = detailInfo.getRuleType();
                        if (ruleType == CoActivityAssignRuleType.USER) {
                            Object user = null;
                            CoActivityAssignUserCollection userColl = CoActivityAssignUserFactory.getLocalInstance(ctx).getCoActivityAssignUserCollection("where assignRuleId = '" + detailInfo.getId().toString() + "'");
                            if (userColl.size() > 0) {
                                if (userSet == null) {
                                    userSet = new HashSet();
                                }
                                for (int u = 0; u < userColl.size(); ++u) {
                                    userSet.add(userColl.get(u).getUser());
                                }
                            }
                        } else if (ruleType == CoActivityAssignRuleType.POSITION) {
                            PositionInfo positionInfo;
                            if (userSet == null) {
                                userSet = new HashSet<String>();
                            }
                            if ((positionInfo = detailInfo.getPosition()) != null) {
                                HashSet<String> personSet = new HashSet<String>();
                                EmpPosOrgRelationCollection relaColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection("select person where LEFFDT={ts'2199-12-31'} and isInner=1 and position = '" + positionInfo.getId().toString() + "'");
                                for (int k = 0; k < relaColl.size(); ++k) {
                                    personSet.add(relaColl.get(k).getPerson().getId().toString());
                                }
                                EntityViewInfo userView = new EntityViewInfo();
                                FilterInfo userFilter = new FilterInfo();
                                userFilter.getFilterItems().add(new FilterItemInfo("person", personSet, CompareType.INCLUDE));
                                userView.setFilter(userFilter);
                                UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection(userView);
                                for (int k = 0; k < userColl.size(); ++k) {
                                    userSet.add(userColl.get(k).getId().toString());
                                }
                            }
                        } else if (ruleType == CoActivityAssignRuleType.ROLE) {
                            RoleInfo roleInfo;
                            if (userSet == null) {
                                userSet = new HashSet();
                            }
                            if ((roleInfo = detailInfo.getRole()) != null) {
                                String sql = "select FUserID from T_PM_UserRoleOrg where FRoleID = '" + roleInfo.getId().toString() + "'";
                                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                                try {
                                    while (rs.next()) {
                                        userSet.add(rs.getString("FUserID"));
                                    }
                                }
                                catch (SQLException e) {
                                    logger.error(e.getMessage(), (Throwable)e);
                                    throw new BOSException(e.getMessage(), (Throwable)e);
                                }
                            }
                        } else if (ruleType == CoActivityAssignRuleType.PERSONAL) {
                            String personId = null;
                            if (params.get("personId") != null) {
                                personId = params.get("personId") instanceof BOSUuid ? ((BOSUuid)params.get("personId")).toString() : (String)params.get("personId");
                            }
                            UserCollection userCol = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select id where person = '" + personId + "'");
                            if (userSet == null) {
                                userSet = new HashSet();
                            }
                            if (null != userCol && !userCol.isEmpty()) {
                                for (int k = 0; k < userCol.size(); ++k) {
                                    userSet.add(userCol.get(k).getId().toString());
                                }
                            }
                        }
                    }
                    if (params.get("defaultUser") != null && params.get("defaultUser") instanceof List) {
                        List defaultUserList = (List)params.get("defaultUser");
                        HashSet realUserSet = new HashSet();
                        for (int j = 0; j < defaultUserList.size(); ++j) {
                            if (!userSet.contains(defaultUserList.get(j))) continue;
                            realUserSet.add(defaultUserList.get(j));
                        }
                        if (!realUserSet.isEmpty()) {
                            userSet = realUserSet;
                            CoActivityOptUtil.assignUserInner(ctx, info, userSet);
                        }
                    } else {
                        CoActivityOptUtil.assignUserInner(ctx, info, (Set<String>)userSet);
                    }
                    try {
                        String label5;
                        String message = label5 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.CoActivityResource", (String)"label5", (Context)ctx);
                        String innerMsg = label5;
                        JobStateTimeUtils.addJobStateTime(ctx, info.getId().toString(), message, Operation.AutoAssign, innerMsg, null);
                    }
                    catch (Exception e) {
                        logger.error("com.kingdee.shr.shareservice.util.CoActivityOptUtil.createJob assignUserInner error!! " + e.getMessage(), (Throwable)e);
                    }
                    if (userSet != null && userSet.size() > 0) break;
                }
            }
        }
        if (userSet != null && userSet.size() > 0 && (activityInfo = info.getBussAttrID()) != null && info.getBillID() != null) {
            ActivityHelper.dealWithBussActivityAfterAssign(ctx, activityInfo.getId().toString(), info.getId().toString(), info.getBillID().toString(), userSet, params);
        }
    }

    private static Map<String, Object> getActivityUserSet(Context ctx, CoActivityJobInfo info) throws EASBizException, BOSException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", "true");
        info = CoActivityJobFactory.getLocalInstance(ctx).getCoActivityJobInfo((IObjectPK)new ObjectUuidPK(info.getId()));
        ActivityInfo activityInfo = info.getBussAttrID();
        if (activityInfo != null && info.getBillID() != null) {
            Map<String, Object> activitySetMap = ActivityHelper.dealWithBussActivityBeforeAssign(ctx, activityInfo.getId().toString(), info.getId().toString(), info.getBillID().toString());
            if (activitySetMap == null || activitySetMap.get("success") == null) {
                resultMap.put("data", null);
            } else if ("false".equals(activitySetMap.get("success").toString().trim().toLowerCase())) {
                String errorMsg = "";
                try {
                    String message = errorMsg = activitySetMap.get("data") == null ? "" : activitySetMap.get("data").toString();
                    String innerMsg = errorMsg;
                    JobStateTimeUtils.addJobStateTime(ctx, info.getId().toString(), message, Operation.Assign, innerMsg, null);
                }
                catch (Exception e) {
                    logger.error("com.kingdee.shr.shareservice.util.CoActivityOptUtil.createJob assignUserInner error!! " + e.getMessage(), (Throwable)e);
                }
                resultMap.put("success", "false");
                resultMap.put("data", errorMsg);
            } else if (activitySetMap.get("data") != null && activitySetMap.get("data") instanceof Set && ((Set)activitySetMap.get("data")).size() > 0) {
                resultMap.put("data", activitySetMap.get("data"));
            } else {
                resultMap.put("data", null);
            }
        }
        return resultMap;
    }

    private static void assignUserInner(Context ctx, CoActivityJobInfo info, Set<String> userSet) throws EASBizException, BOSException {
        String jobId = info.getId().toString();
        CoActivityOptUtil.jobCheck(ctx, jobId);
        CoActivityExecutorCollection coll = new CoActivityExecutorCollection();
        if (null == userSet) {
            return;
        }
        for (String userId : userSet) {
            CoActivityExecutorInfo executorInfo = new CoActivityExecutorInfo();
            executorInfo.setState(CoActivityState.DEALING);
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)userId));
            executorInfo.setUser(userInfo);
            executorInfo.setOverRead(false);
            executorInfo.setCoActivity(info);
            coll.add(executorInfo);
        }
        ICoActivityExecutor iCoActivityExecutor = CoActivityExecutorFactory.getLocalInstance(ctx);
        iCoActivityExecutor.delete("where coActivity = '" + jobId + "'");
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        coreBaseCollection.addObjectCollection((IObjectCollection)coll);
        iCoActivityExecutor.addnew(coreBaseCollection);
        info.setJobPoolingType(CoJobPoolingType.Operating);
        CoActivityJobFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), info);
        ActivityInfo activityInfo = ActivityFactory.getLocalInstance(ctx).getActivityInfo("select needReminderTime where id = '" + info.getBussAttrID().getId().toString() + "'");
        if (activityInfo.isNeedReminderTime()) {
            int initReminderTime = info.getActReminderTime();
            String uptSql = "update T_HR_CoActivityExecutor set FReminderTime = ? where FCoActivity = ?";
            DbUtil.execute((Context)ctx, (String)uptSql, (Object[])new Object[]{initReminderTime, info.getId().toString()});
        }
    }

    private static Object getFieldValueByEntity(Context ctx, CoActivityAssignRuleDetailEntryInfo detailEntryInfo, String billId) throws EASBizException, BOSException, InterruptedException {
        Object fieldValue = null;
        RuleFieldEntryInfo ruleFieldEntryIdInfo = detailEntryInfo.getRuleField();
        RuleFieldEntryInfo ruleFieldEntryInfo = RuleFieldEntryFactory.getLocalInstance(ctx).getRuleFieldEntryInfo((IObjectPK)new ObjectUuidPK(ruleFieldEntryIdInfo.getId()));
        RuleFieldInfo ruleFieldIdInfo = ruleFieldEntryInfo.getParent();
        RuleFieldInfo ruleFieldInfo = RuleFieldFactory.getLocalInstance(ctx).getRuleFieldInfo((IObjectPK)new ObjectUuidPK(ruleFieldIdInfo.getId()));
        String entityFullName = ruleFieldInfo.getEntity();
        String fieldKey = ruleFieldEntryInfo.getFieldKey();
        if ("Preset_Bill_Type_001.name".equals(fieldKey)) {
            return BOSUuid.read((String)billId).getType().toString();
        }
        String[] fieldKeys = fieldKey.split("\\.");
        LinkedBlockingQueue<String> fieldKeyQueue = new LinkedBlockingQueue<String>();
        for (int i = 0; i < fieldKeys.length; ++i) {
            fieldKeyQueue.put(fieldKeys[i]);
        }
        fieldValue = CoActivityOptUtil.getInnerFieldValueByEntity(ctx, entityFullName, fieldKeyQueue, billId);
        return fieldValue;
    }

    private static Object getInnerFieldValueByEntity(Context ctx, String entityFullName, LinkedBlockingQueue<String> fieldKeyQueue, String ruleFieldId) throws BOSException, EASBizException {
        Object fieldValue = null;
        int count = fieldKeyQueue.size();
        ICoreBase entityBizInterface = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityFullName));
        CoreBaseInfo entityInfo = entityBizInterface.getValue((IObjectPK)new ObjectUuidPK(ruleFieldId));
        String fieldName = fieldKeyQueue.poll();
        PropertyInfo propertyInfo = BaseMetaDataUtil.getPropertyInfo((Context)ctx, (String)entityFullName, (String)fieldName);
        if (count == 1) {
            if (propertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
                DataType dateType = ownPropertyInfo.getDataType();
                fieldValue = entityInfo.get(fieldName);
                if (fieldValue != null) {
                    fieldValue = CoActivityOptUtil.assembleValue(fieldValue, dateType);
                }
            } else if (propertyInfo instanceof LinkPropertyInfo) {
                fieldValue = entityInfo.get(fieldName);
            }
        } else if (propertyInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
            DataType dateType = ownPropertyInfo.getDataType();
            fieldValue = entityInfo.get(fieldName);
            if (fieldValue != null) {
                fieldValue = CoActivityOptUtil.assembleValue(fieldValue, dateType);
            }
        } else if (propertyInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            RelationshipInfo relationshipInfo = linkPropertyInfo.getRelationship();
            EntityObjectInfo supplierObject = relationshipInfo.getSupplierObject();
            String fullName = supplierObject.getRealFullName();
            RelationshipType relationshipType = relationshipInfo.getType();
            if (relationshipType == RelationshipType.ASSOCIATION) {
                CoreBaseInfo fieldId = (CoreBaseInfo)entityInfo.get(fieldName);
                if (fieldId == null) {
                    return null;
                }
                fieldValue = CoActivityOptUtil.getInnerFieldValueByEntity(ctx, fullName, fieldKeyQueue, fieldId.getId().toString());
            } else if (relationshipType == RelationshipType.COMPOSITION) {
                AbstractObjectCollection fieldColl = (AbstractObjectCollection)entityInfo.get(fieldName);
                if (fieldColl.size() > 0) {
                    IObjectValue objectValue = fieldColl.getObject(0);
                    BOSUuid id = (BOSUuid)objectValue.get("id");
                    fieldValue = CoActivityOptUtil.getInnerFieldValueByEntity(ctx, fullName, fieldKeyQueue, id.toString());
                } else {
                    return null;
                }
            }
        }
        return fieldValue;
    }

    private static Object assembleValue(Object fieldValue, DataType dateType) {
        Object realValue = null;
        if (DataType.DATE.equals((Object)dateType)) {
            logger.error("===== com.kingdee.shr.shareservice.strategy.impl.HRBizAffairActivitySolutionOperation.assembleValue date fieldValue : " + fieldValue.toString());
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            try {
                realValue = formatter.format((java.sql.Date)fieldValue);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                realValue = null;
            }
        } else if (DataType.TIME.equals((Object)dateType) || DataType.TIMESTAMP.equals((Object)dateType)) {
            logger.error("===== com.kingdee.shr.shareservice.strategy.impl.HRBizAffairActivitySolutionOperation.assembleValue time fieldValue : " + fieldValue.toString());
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                realValue = formatter.format((java.sql.Date)fieldValue);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                realValue = null;
            }
        } else {
            realValue = fieldValue;
        }
        return realValue;
    }

    private static void assembleStructMap(Context ctx, List<String> structList, String personId, Map<String, Object> structMap, List<Map<String, Object>> ruleList) throws BOSException, UuidException, EASBizException, SQLException {
        String querySql = null;
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSelectMapping(CoActivityOptUtil.assembleSelector(structList));
        sqlParam.setScheme("001");
        sqlParam.setNeedDistinct(false);
        sqlParam.setHistoryMode(false);
        sqlParam.setNewSearch(true);
        Date effectDate = DateTimeUtils.truncateDate((Date)new Date());
        sqlParam.setFilterDate(effectDate);
        FilterInfo filterInfo = CoActivityOptUtil.assembleFilterInfo(ctx, personId);
        FilterInfo effectDateFilter = CoActivityOptUtil.getEffectDateFilter(effectDate);
        filterInfo.mergeFilter(effectDateFilter, "AND");
        sqlParam.setFilterInfo(filterInfo);
        querySql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
        IRowSet queryRowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
        if (queryRowSet.next()) {
            String structName = null;
            for (int i = 0; i < structList.size(); ++i) {
                structName = structList.get(i);
                if (StringUtils.isEmpty((String)structName)) continue;
                structMap.put(structName, queryRowSet.getObject(structName));
            }
        }
        for (int i = 0; i < ruleList.size(); ++i) {
            if (ruleList.get(i).get("structName") == null) continue;
            ruleList.get(i).put("fieldVal", structMap.get(ruleList.get(i).get("structName")));
        }
    }

    private static Map assembleSelector(List<String> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            map.put(list.get(i), list.get(i));
        }
        map.put("person.id", "person.id");
        map.put("pp.id", "pp.id");
        map.put("empOrgRelation.id", "empOrgRelation.id");
        return map;
    }

    private static FilterInfo assembleFilterInfo(Context ctx, String personId) throws BOSException, UuidException {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo("person.id", (Object)personId);
        filterInfo.getFilterItems().add(item);
        return filterInfo;
    }

    protected static FilterInfo getEffectDateFilter(Date effectDate) {
        if (effectDate == null) {
            effectDate = DateTimeUtils.truncateDate((Date)new Date());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.effdt", (Object)effectDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.leffdt", (Object)effectDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("pp.effdt", (Object)effectDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("pp.leffdt", (Object)effectDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EMPORGRELATION.effdt", (Object)effectDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EMPORGRELATION.leffdt", (Object)effectDate, CompareType.GREATER_EQUALS));
        return filter;
    }

    public static void coJobPass(Context ctx, Map params) throws BOSException, EASBizException {
        String jobId = (String)params.get("jobId");
        if (StringUtils.isEmpty((String)jobId)) {
            // empty if block
        }
        CoActivityOptUtil.jobCheck(ctx, jobId);
        CoActivityJobCollection jobColl = CoActivityJobFactory.getLocalInstance(ctx).getCoActivityJobCollection("where id ='" + jobId + "'");
        if (jobColl.size() != 0) {
            if (jobColl.size() == 1) {
                if (jobColl.get(0).getJobPoolingType() != CoJobPoolingType.Operating) {
                    throw new CoActivityException(CoActivityException.COJOB_STATE_ERROR);
                }
            } else if (jobColl.size() > 1) {
                // empty if block
            }
        }
        UserInfo currentUser = null;
        if (params.get("realUser") == null || StringUtils.isEmpty((String)((String)params.get("realUser")))) {
            currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        } else {
            String userId = params.get("realUser").toString();
            try {
                currentUser = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
            }
            catch (Exception e) {
                logger.error("========com.kingdee.shr.shareservice.util.CoActivityOptUtil.coJobPass error, realUser :" + userId + e.getMessage(), (Throwable)e);
                currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
            }
        }
        String innerMsg = (String)params.get("innerMsg");
        String pasRea = (String)params.get("pasRea");
        CoActivityJobInfo coJobInfo = new CoActivityJobInfo();
        coJobInfo.setId(BOSUuid.read((String)jobId));
        coJobInfo.setJobState(CoJobState.ToVouchered);
        coJobInfo.setPersonId(currentUser);
        coJobInfo.setInnerMsg(innerMsg);
        coJobInfo.setPassRea(pasRea);
        coJobInfo.setJobPoolingType(CoJobPoolingType.Operated);
        coJobInfo.setCompleteTme(CoActivityOptUtil.getTime());
        SelectorItemCollection selCol = new SelectorItemCollection();
        selCol.add(new SelectorItemInfo("jobState"));
        selCol.add(new SelectorItemInfo("personId"));
        selCol.add(new SelectorItemInfo("passRea"));
        selCol.add(new SelectorItemInfo("innerMsg"));
        selCol.add(new SelectorItemInfo("jobPoolingType"));
        selCol.add(new SelectorItemInfo("completeTme"));
        try {
            CoActivityJobFactory.getLocalInstance(ctx).updatePartial(coJobInfo, selCol);
            ICoActivityExecutor iExecutor = CoActivityExecutorFactory.getLocalInstance(ctx);
            CoActivityExecutorCollection exeCol = iExecutor.getCoActivityExecutorCollection("select id,state where coActivity = '" + jobId + "'");
            for (int i = 0; i < exeCol.size(); ++i) {
                CoActivityExecutorInfo exeInfo = exeCol.get(i);
                exeInfo.setState(CoActivityState.FINISH);
            }
            SelectorItemCollection exeSel = new SelectorItemCollection();
            exeSel.add(new SelectorItemInfo("state"));
            iExecutor.updatePartialBatchData((IObjectCollection)exeCol, exeSel);
            iExecutor.delete("where  coActivity = '" + jobId + "' and user <> '" + currentUser.getId().toString() + "'");
            if (!iExecutor.exists("where  coActivity = '" + jobId + "'")) {
                CoActivityExecutorInfo executorInfo = new CoActivityExecutorInfo();
                CoActivityJobInfo jobInfo = new CoActivityJobInfo();
                jobInfo.setId(BOSUuid.read((String)jobId));
                executorInfo.setCoActivity(jobInfo);
                executorInfo.setUser(currentUser);
                executorInfo.setState(CoActivityState.FINISH);
                iExecutor.addnew(executorInfo);
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        try {
            JobStateTimeUtils.addJobStateTime(ctx, jobId, pasRea, Operation.ProcessPass, innerMsg, currentUser.getId().toString());
        }
        catch (Exception e) {
            logger.error("com.kingdee.shr.shareservice.util.CoActivityOptUtil.coJobPass error addJobStateTime:" + e.getMessage(), (Throwable)e);
        }
    }

    public static void deleteJob(Context ctx, String jobId, Map params) throws BOSException, EASBizException {
        String[] jobIds = null;
        if (!StringUtils.isEmpty((String)jobId)) {
            jobIds = jobId.split(",");
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ICoActivityExecutor iExecutor = CoActivityExecutorFactory.getLocalInstance(ctx);
        CoActivityJobCollection cojobCol = new CoActivityJobCollection();
        HashMap jobUserMap = new HashMap();
        for (String job : jobIds) {
            try {
                BOSUuid.read((String)job.trim());
            }
            catch (Exception e) {
                continue;
            }
            Map<String, Object> deleteMap = ActivityHelper.dealWithBussActivityBeforeDelete(ctx, null, job, null);
            if (deleteMap == null || deleteMap.get("success") == null || (deleteMap.get("success") instanceof Boolean ? (Boolean)deleteMap.get("success") == false : !(deleteMap.get("success") instanceof String) || !"success".equals(deleteMap.get("success")))) {
                // empty if block
            }
            CoActivityJobInfo jobInfo = new CoActivityJobInfo();
            jobInfo.setJobPoolingType(CoJobPoolingType.Delete);
            jobInfo.setJobState(CoJobState.Deleted);
            jobInfo.setPersonId(userInfo);
            jobInfo.setId(BOSUuid.read((String)job));
            cojobCol.add(jobInfo);
            String[] executors = iExecutor.getCoActivityExecutorCollection("where coActivity = '" + job + "'");
            ArrayList<String> userList = new ArrayList<String>();
            for (int i = 0; i < executors.size(); ++i) {
                if (executors.get(i).getUser() == null) continue;
                userList.add(executors.get(i).getUser().getId().toString());
            }
            HashMap param = new HashMap();
            jobUserMap.put(job, userList);
        }
        iExecutor.delete("where coActivity in " + HRUtilExtend.getStrFromArray((String[])jobIds) + " and user <> '" + userInfo.getId().toString() + "'");
        SelectorItemCollection executorSel = new SelectorItemCollection();
        executorSel.add(new SelectorItemInfo("state"));
        CoActivityExecutorCollection executorColl = iExecutor.getCoActivityExecutorCollection("where user = '" + userInfo.getId().toString() + "' and coActivity in " + HRUtilExtend.getStrFromArray((String[])jobIds) + "");
        for (int i = 0; i < executorColl.size(); ++i) {
            CoActivityExecutorInfo info = executorColl.get(i);
            info.setState(CoActivityState.FINISH);
            iExecutor.updatePartial(info, executorSel);
        }
        CoActivityExecutorFactory.getLocalInstance(ctx).delete("where coActivity in " + HRUtilExtend.getStrFromArray((String[])jobIds) + " and user <> '" + userInfo.getId().toString() + "'");
        SelectorItemCollection coSel = new SelectorItemCollection();
        coSel.add(new SelectorItemInfo("jobState"));
        coSel.add(new SelectorItemInfo("personId"));
        coSel.add(new SelectorItemInfo("jobPoolingType"));
        SelectorItemCollection actSel = new SelectorItemCollection();
        actSel.add(new SelectorItemInfo("jobState"));
        SelectorItemCollection exeSel = new SelectorItemCollection();
        exeSel.add(new SelectorItemInfo("state"));
        ICoActivityJob iCoActivityJob = CoActivityJobFactory.getLocalInstance(ctx);
        iCoActivityJob.updatePartialBatchData((IObjectCollection)cojobCol, coSel);
        for (String job : jobIds) {
            if (params == null) {
                params = new HashMap();
            }
            params.put("user", jobUserMap.get(job));
            CoActivityJobCollection coll = iCoActivityJob.getCoActivityJobCollection("select billID where id = '" + job + "'");
            if (coll.size() <= 0 || coll.get(0).getBillID() == null) continue;
            ActivityHelper.dealWithBussActivityAfterDelete(ctx, null, job, coll.get(0).getBillID().toString(), params);
        }
        try {
            String message = params.get("message") == null ? "deleteJob" : (String)params.get("message");
            String innerMsg = params.get("innerMsg") == null ? "deleteJob" : (String)params.get("innerMsg");
            JobStateTimeUtils.addJobStateTime(ctx, jobId, message, Operation.Delete, innerMsg, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        }
        catch (Exception e) {
            logger.error("com.kingdee.shr.shareservice.app.CoActivityJobOptFacadeControllerBean.reverseCoJob error addJobStateTime:" + e.getMessage(), (Throwable)e);
        }
    }

    private static Map assemResult(boolean isSuccess, String msg, String errorMsg) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", isSuccess);
        resultMap.put("msg", msg);
        resultMap.put("errorMsg", errorMsg);
        return resultMap;
    }

    public static void jobCheck(Context ctx, String jobId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)jobId)) {
            throw new CoActivityException(CoActivityException.COJOB_NOT_EXIST);
        }
        if (CoActivityJobFactory.getLocalInstance(ctx).exists("where id = '" + jobId + "' and jobPoolingType = '3'")) {
            throw new CoActivityException(CoActivityException.OPERATED_STATE_ERROR);
        }
        if (CoActivityJobFactory.getLocalInstance(ctx).exists("where id = '" + jobId + "' and jobPoolingType = '4'")) {
            throw new CoActivityException(CoActivityException.DELETE_STATE_ERROR);
        }
    }

    private static Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public static Map<String, String> checkJobByJob(Context ctx, String jobId) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        CoActivityJobCollection coll = CoActivityJobFactory.getLocalInstance(ctx).getCoActivityJobCollection("where id ='" + jobId + "'");
        if (coll.size() == 0) {
            map.put(jobId, null);
        } else {
            map.put(jobId, coll.get(0).getJobPoolingType().getValue());
        }
        return null;
    }

    public static Map<String, String> checkJobByBill(Context ctx, String billId) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        CoActivityJobCollection coll = CoActivityJobFactory.getLocalInstance(ctx).getCoActivityJobCollection("where billID ='" + billId + "'");
        if (coll.size() == 0) {
            return null;
        }
        for (int i = 0; i < coll.size(); ++i) {
            CoActivityJobInfo info = coll.get(0);
            map.put(info.getId().toString(), info.getJobPoolingType().getValue());
        }
        return null;
    }

    private static void checkId(Context ctx, String id) {
        BOSUuid.read((String)id);
    }
}

