/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.CoActivityJobCollection;
import com.kingdee.shr.shareservice.CoActivityJobFactory;
import com.kingdee.shr.shareservice.CoActivityJobInfo;
import com.kingdee.shr.shareservice.CoActivityJobStateTimeCollection;
import com.kingdee.shr.shareservice.CoActivityJobStateTimeFactory;
import com.kingdee.shr.shareservice.CoActivityJobStateTimeInfo;
import com.kingdee.shr.shareservice.CoJobState;
import com.kingdee.shr.shareservice.app.MessageState;
import com.kingdee.shr.shareservice.app.Operation;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobStateTimeUtils {
    private static Logger logger = LoggerFactory.getLogger(JobStateTimeUtils.class);

    public static void addJobStateTime(Context ctx, String jobID, String messages, Operation operation, String innerMsg, String userId) throws EASBizException, BOSException {
        CoActivityJobCollection coActivityJobCol = CoActivityJobFactory.getLocalInstance(ctx).getCoActivityJobCollection("select billID,bussAttrID.id where id in ('" + jobID.replaceAll(",", "','") + "')");
        if (!coActivityJobCol.isEmpty()) {
            CoreBaseCollection timeCol = new CoreBaseCollection();
            for (int i = 0; i < coActivityJobCol.size(); ++i) {
                CoActivityJobInfo coActivityJob = coActivityJobCol.get(i);
                if (coActivityJob == null) {
                    logger.error(SHRServerResource.getString((String)"com.kingdee.shr.shareservice.CoActivityResource", (String)"coActivityJobNotFound", (Context)ctx));
                    continue;
                }
                CoActivityJobStateTimeInfo jobStateTimeInfo = new CoActivityJobStateTimeInfo();
                CoJobState newJobState = JobStateTimeUtils.getNewJobStateByOperation(operation);
                CoJobState oldJobState = JobStateTimeUtils.getOldJobState(ctx, coActivityJob.getId().toString());
                UserInfo operator = JobStateTimeUtils.getOperator(ctx, userId);
                jobStateTimeInfo.setJobID(coActivityJob);
                jobStateTimeInfo.setNewJobState(newJobState);
                jobStateTimeInfo.setOldJobState(oldJobState);
                jobStateTimeInfo.setChangeTime(new Timestamp(new Date().getTime()));
                jobStateTimeInfo.setMessages(messages);
                jobStateTimeInfo.setMessageState(MessageState.NotReaded);
                jobStateTimeInfo.setOperation(operation);
                jobStateTimeInfo.setOperatorID(operator);
                jobStateTimeInfo.setInnerMsg(innerMsg);
                jobStateTimeInfo.setBillId(null == coActivityJob.getBillID() ? "" : coActivityJob.getBillID().toString());
                jobStateTimeInfo.setActivity(coActivityJob.getBussAttrID());
                timeCol.add((CoreBaseInfo)jobStateTimeInfo);
            }
            CoActivityJobStateTimeFactory.getLocalInstance(ctx).addnewBatchData(timeCol);
        }
    }

    public static List<Map<String, Object>> getBizJobStateTime(Context ctx, String billId) throws BOSException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String l = ctx.getLocale().toString();
        String sql = "SELECT cj.FBillId as fbillid,act.fname_" + l + (" as fname,cj.FChangeTime as fchangetime,cj.fid as cjfid,cj.FInnerMsg as finnermsg,job.fid as jobfid,job.fBillID as fjobbillid,cj.FMessageState as fmessagestate,cj.FMessages as fmessages,cj.FNewJobState as fnewjobstate,cj.FOldJobState as foldjobstate,cj.FOperation as foperation,u.fid as userfid,u.fname_" + l + " as fusername from T_HR_CoActivityJobStateTime cj inner join T_HR_CoActivityJob job on cj.FJobID = job.FID inner join T_SHR_Activity act on cj.FActivityID = act.FID inner join T_PM_User u on cj.FOperatorID = u.fid where cj.FBillId = '") + billId + "' and FOperation not in ('7','11') and act.FCooperationTypeId != 'SIFYwUkUTfacoenCfHzDa390aQ8=' group by cj.FBillId,act.fname_" + l + ",cj.FChangeTime,cj.fid,cj.FInnerMsg,job.fid,job.fBillID,cj.FMessageState,cj.FMessages,cj.FNewJobState,cj.FOldJobState,cj.FOperation,u.fid,u.fname_" + l;
        ArrayList rs = SQL.executeQuery((Context)ctx, (String)sql);
        int size = rs.size();
        for (int i = 0; i < size; ++i) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            Map map = (Map)rs.get(i);
            resultMap.put("billId", map.get("fbillid") != null ? map.get("fbillid") : "");
            resultMap.put("bussAttr.name", map.get("fname") != null ? map.get("fname") : "");
            resultMap.put("changeTime", map.get("fchangetime") != null ? map.get("fchangetime") : "");
            resultMap.put("id", map.get("cjfid") != null ? map.get("cjfid") : "");
            resultMap.put("innerMsg", map.get("finnermsg") != null ? map.get("finnermsg") : "");
            resultMap.put("jobID.billID", map.get("fjobbillid") != null ? map.get("fjobbillid") : "");
            resultMap.put("jobID.id", map.get("jobfid") != null ? map.get("jobfid") : "");
            resultMap.put("messageState", (Object)MessageState.getEnum(map.get("fmessagestate").toString()));
            resultMap.put("messages", map.get("fmessages") != null ? map.get("fmessages") : "");
            resultMap.put("newJobState", (Object)CoJobState.getEnum(map.get("fnewjobstate").toString()));
            resultMap.put("oldJobState", (Object)CoJobState.getEnum(map.get("foldjobstate").toString()));
            resultMap.put("operation", (Object)Operation.getEnum(Integer.parseInt(map.get("foperation").toString())));
            resultMap.put("operatorID.id", map.get("userfid") != null ? map.get("userfid") : "");
            resultMap.put("operatorID.name", map.get("fusername") != null ? map.get("fusername") : "");
            result.add(resultMap);
        }
        return result;
    }

    private static CoJobState getNewJobStateByOperation(Operation operation) {
        CoJobState jobState = CoJobState.Normal;
        switch (operation.getValue()) {
            case 6: {
                jobState = CoJobState.Normal;
                break;
            }
            case 7: {
                jobState = CoJobState.Normal;
                break;
            }
            case 8: {
                jobState = CoJobState.CallBack;
                break;
            }
            case 11: {
                jobState = CoJobState.Normal;
                break;
            }
            case 19: {
                jobState = CoJobState.ToVouchered;
                break;
            }
            case 3: {
                jobState = CoJobState.Pause;
                break;
            }
            case 16: {
                break;
            }
            case 4: {
                jobState = CoJobState.Normal;
                break;
            }
            case 1: {
                jobState = CoJobState.Passed;
                break;
            }
            case 2: {
                jobState = CoJobState.NotPassed;
                break;
            }
            default: {
                jobState = CoJobState.Normal;
            }
        }
        return jobState;
    }

    private static CoJobState getOldJobState(Context ctx, String jobID) throws BOSException {
        CoActivityJobStateTimeInfo latestJobStateTime = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo sorter = new SorterItemInfo("changeTime");
        sorter.setSortType(SortType.DESCEND);
        filter.getFilterItems().add(new FilterItemInfo("jobID.id", (Object)jobID, CompareType.EQUALS));
        sorters.add(sorter);
        view.setFilter(filter);
        view.setSorter(sorters);
        CoActivityJobStateTimeCollection coll = CoActivityJobStateTimeFactory.getLocalInstance(ctx).getCoActivityJobStateTimeCollection(view);
        if (!coll.isEmpty()) {
            latestJobStateTime = coll.get(0);
            return latestJobStateTime.getNewJobState();
        }
        return null;
    }

    private static UserInfo getOperator(Context ctx, String userId) throws EASBizException, BOSException {
        userId = StringUtils.isEmpty((String)userId) ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : userId;
        return UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
    }
}

