/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.IMSFEncryptKey;
import com.kingdee.shr.base.syssetting.MSFConfigExtCollection;
import com.kingdee.shr.base.syssetting.MSFConfigExtFactory;
import com.kingdee.shr.base.syssetting.MSFConfigExtInfo;
import com.kingdee.shr.base.syssetting.MSFConfigInfo;
import com.kingdee.shr.base.syssetting.MSFEncryptKeyFactory;
import com.kingdee.shr.base.syssetting.MSFEncryptKeyInfo;
import com.kingdee.shr.base.syssetting.ServiceBizException;
import com.kingdee.shr.base.syssetting.StateEnum;
import com.kingdee.shr.base.syssetting.app.AbstractMSFConfigControllerBean;
import com.kingdee.shr.base.syssetting.app.IHRRefresh;
import com.kingdee.shr.base.syssetting.app.osf.OSFCacheSynFactory;
import com.kingdee.shr.base.syssetting.secrity.AESUtils;
import com.kingdee.shr.osf.OSFCacheHelper;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class MSFConfigControllerBean
extends AbstractMSFConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.MSFConfigControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        MSFConfigInfo configInfo = (MSFConfigInfo)model;
        OSFCacheHelper.removeServiceInfo(ctx, configInfo.getServiceName());
        return pk;
    }

    @Override
    protected void _disable(Context ctx, String configID) throws BOSException, EASBizException {
        this.updateConfigState(ctx, configID, StateEnum.Disable);
        this.removeCacheByconfigID(ctx, configID);
    }

    @Override
    protected void _enable(Context ctx, String configID) throws BOSException, EASBizException {
        this.updateConfigState(ctx, configID, StateEnum.Enable);
        this.removeCacheByconfigID(ctx, configID);
    }

    private void removeCacheByconfigID(Context ctx, String configID) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("serviceName"));
        selector.add(new SelectorItemInfo("id"));
        MSFConfigInfo configInfo = this.getMSFConfigInfo(ctx, (IObjectPK)new ObjectUuidPK(configID), selector);
        OSFCacheHelper.removeServiceInfo(ctx, configInfo.getServiceName());
    }

    private void updateConfigState(Context ctx, String configID, StateEnum state) throws EASBizException, BOSException {
        MSFConfigInfo configInfo = this.getMSFConfigInfo(ctx, (IObjectPK)new ObjectUuidPK(configID));
        configInfo.setState(state);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(configID), (CoreBaseInfo)configInfo);
    }

    @Override
    protected void _restartService(Context ctx) throws BOSException, EASBizException {
        OSFCacheSynFactory.getInstance().restartService(ctx);
        try {
            IHRRefresh refresh = (IHRRefresh)MsfClassLoaderFactory.forName("com.kingdee.shr.base.syssetting.app.cache.ServiceMenuRefresh").newInstance();
            refresh.hrRrefresh(ctx);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _stopService(Context ctx) throws BOSException, EASBizException {
        OSFCacheSynFactory.getInstance().stopService(ctx);
    }

    @Override
    protected IObjectPK _extendSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MSFConfigInfo info = (MSFConfigInfo)model;
        ObjectUuidPK pk = null;
        if (info.getId() != null) {
            pk = new ObjectUuidPK(info.getId().toString());
        }
        MSFConfigExtInfo extInfo = this.assembleExtInfo(info);
        MSFConfigExtFactory.getLocalInstance(ctx).save((CoreBaseInfo)extInfo);
        OSFCacheHelper.removeServiceInfo(ctx, info.getServiceName());
        return pk;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    private void addEncryptKey(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MSFEncryptKeyInfo model = new MSFEncryptKeyInfo();
        model.setEncryptKey(AESUtils.generateKey(16));
        MSFConfigInfo item = new MSFConfigInfo();
        item.setId(BOSUuid.read((String)pk.toString()));
        model.setMsfconfig(item);
        MSFEncryptKeyFactory.getLocalInstance(ctx).save((CoreBaseInfo)model);
    }

    private MSFConfigExtInfo assembleExtInfo(MSFConfigInfo info) {
        MSFConfigExtInfo extInfo = new MSFConfigExtInfo();
        extInfo.setParent(info);
        extInfo.setConfig(info.getExtend());
        return extInfo;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MSFConfigInfo info = (MSFConfigInfo)super._getValue(ctx, pk);
        return this.mergeExtInfo(ctx, info);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        MSFConfigInfo info = (MSFConfigInfo)super._getValue(ctx, pk, selector);
        return this.mergeExtInfo(ctx, info);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        MSFConfigInfo info = (MSFConfigInfo)super._getValue(ctx, oql);
        return this.mergeExtInfo(ctx, info);
    }

    private MSFConfigInfo mergeExtInfo(Context ctx, MSFConfigInfo info) throws BOSException {
        if (info == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString()));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("config"));
        MSFConfigExtCollection collection = MSFConfigExtFactory.getLocalInstance(ctx).getMSFConfigExtCollection(viewInfo);
        if (collection != null && !collection.isEmpty()) {
            MSFConfigExtInfo extInfo = collection.get(0);
            info.setExtend(extInfo.getConfig());
        }
        return info;
    }

    @Override
    protected void _genEncryptKey(Context ctx, String billId) throws BOSException, EASBizException {
        IMSFEncryptKey iMSFEncryptKey = MSFEncryptKeyFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("msfconfig.id", (Object)billId));
        SelectorItemCollection selector0 = new SelectorItemCollection();
        selector0.add(new SelectorItemInfo("serviceName"));
        selector0.add(new SelectorItemInfo("id"));
        MSFConfigInfo msfInfo = this.getMSFConfigInfo(ctx, (IObjectPK)new ObjectUuidPK(billId), selector0);
        if (iMSFEncryptKey.exists(filter)) {
            String sql = "UPDATE T_SHR_MSFEncryptKey SET FEncryptKey=?,FLastUpdateUserID=?,FLastUpdateTime=? WHERE FMsfconfigID=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{AESUtils.generateKey(16), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), new Timestamp(System.currentTimeMillis()), billId});
        } else {
            this.addEncryptKey(ctx, (IObjectPK)new ObjectUuidPK(billId));
        }
        OSFCacheHelper.removeServiceInfo(ctx, msfInfo.getServiceName());
    }

    @Override
    protected String _getEncryptKey(Context ctx, String billId) throws BOSException, EASBizException {
        IMSFEncryptKey iMSFEncryptKey = MSFEncryptKeyFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("msfconfig.id", (Object)billId));
        if (iMSFEncryptKey.exists(filter)) {
            MSFEncryptKeyInfo model = iMSFEncryptKey.getMSFEncryptKeyInfo("where msfconfig.id='" + billId + "'");
            return model.getEncryptKey();
        }
        return null;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector0 = new SelectorItemCollection();
        selector0.add(new SelectorItemInfo("serviceName"));
        selector0.add(new SelectorItemInfo("id"));
        selector0.add(new SelectorItemInfo("isPreset"));
        selector0.add(new SelectorItemInfo("state"));
        MSFConfigInfo model = this.getMSFConfigInfo(ctx, pk, selector0);
        if (!StateEnum.New.equals((Object)model.getState())) {
            throw new ServiceBizException(ServiceBizException.PRESET_CANNOT_DELETE);
        }
        super._delete(ctx, pk);
    }
}

