/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.ServiceInfo;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.MsfWhiteListInfo;
import com.kingdee.shr.base.syssetting.SecrityWhiteListType;
import com.kingdee.shr.base.syssetting.ServiceBizException;
import com.kingdee.shr.base.syssetting.app.AbstractMsfWhiteListControllerBean;
import com.kingdee.shr.osf.OSFCacheHelper;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class MsfWhiteListControllerBean
extends AbstractMsfWhiteListControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.MsfWhiteListControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MsfWhiteListInfo info = (MsfWhiteListInfo)model;
        if (StringUtils.isEmpty((String)info.getServiceName())) {
            throw new ServiceBizException(ServiceBizException.SERVICE_NAME_CANTNULL);
        }
        if (null == info.getType()) {
            throw new ServiceBizException(ServiceBizException.WHITE_LIST_TYPE_CANT_NULL, new Object[]{info.getServiceName()});
        }
        ServiceInfo serviceInfo = OSFCacheHelper.getServiceInfo(ctx, info.getServiceName());
        if (null != serviceInfo && 0 != serviceInfo.getServiceType()) {
            if (info.getType().equals((Object)SecrityWhiteListType.INNER_LOG)) {
                throw new ServiceBizException(ServiceBizException.OUTER_API_NOT_ADD_LOG);
            }
            if (info.getType().equals((Object)SecrityWhiteListType.INNET_TO_OUTER)) {
                throw new ServiceBizException(ServiceBizException.OUTER_API_NOT_ADD_OUTER);
            }
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("serviceName", (Object)info.getServiceName()));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)info.getType(), CompareType.EQUALS));
        if (null != info.getId()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filterInfo)) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{info.getServiceName() + " "});
        }
        IObjectPK pk = super._save(ctx, model);
        OSFCacheHelper.removeServiceInfo(ctx, info.getServiceName());
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MsfWhiteListInfo info = this.getMsfWhiteListInfo(ctx, pk);
        super._delete(ctx, pk);
        OSFCacheHelper.removeServiceInfo(ctx, info.getServiceName());
    }

    protected IObjectPK[] _saveBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        IObjectPK[] pks = super._saveBatchData(ctx, colls);
        int total = colls.size();
        for (int i = 0; i < total; ++i) {
            OSFCacheHelper.removeServiceInfo(ctx, ((MsfWhiteListInfo)colls.getObject(i)).getServiceName());
        }
        return pks;
    }
}

