/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.DirectSenderAgent;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseInfoHRBUCollection;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.base.syssetting.BaseItemReviseFactory;
import com.kingdee.shr.base.syssetting.BaseItemReviseInfo;
import com.kingdee.shr.base.syssetting.BasicItemStateEnum;
import com.kingdee.shr.base.syssetting.BasicItemType;
import com.kingdee.shr.base.syssetting.ControlPolicyInfo;
import com.kingdee.shr.base.syssetting.CustomExtendToolsException;
import com.kingdee.shr.base.syssetting.IBaseItemRevise;
import com.kingdee.shr.base.syssetting.ISHRBaseItem;
import com.kingdee.shr.base.syssetting.ISHRBasicItem;
import com.kingdee.shr.base.syssetting.ManagerPolicyEnum;
import com.kingdee.shr.base.syssetting.SHRBaseItemInfo;
import com.kingdee.shr.base.syssetting.SHRBasicItemCollection;
import com.kingdee.shr.base.syssetting.SHRBasicItemFactory;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.UsePolicy;
import com.kingdee.shr.base.syssetting.app.AbstractSHRBasicItemControllerBean;
import com.kingdee.shr.base.syssetting.app.model.BizUnitInfo;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.BaseItemCustomLevelUpTools;
import com.kingdee.shr.base.syssetting.util.BaseItemRelationHRUtil;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.EasHrBaseItemLevelupUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingPermItemUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBaseItemUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBasicItemUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingUIViewUtil;
import com.kingdee.shr.base.syssetting.util.custom.SHRCustomizedUnitUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SHRBasicItemControllerBean
extends AbstractSHRBasicItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.SHRBasicItemControllerBean");
    private static final String URL = "/dynamic.do?method=initalize#uri=";
    private static String TableName0 = "CT_CUS_";

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + " : " + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + " : " + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SHRBasicItemInfo newModel = (SHRBasicItemInfo)model;
        this._checkNameDup(ctx, (IObjectValue)newModel);
        this._checkNumberDup(ctx, (IObjectValue)newModel);
        this.checkData(ctx, newModel);
        IObjectPK pk = null;
        if (null == newModel.getId()) {
            pk = super._save(ctx, model);
            return pk;
        }
        boolean isNeedChangePermission = Boolean.FALSE;
        SHRBasicItemInfo oldModel = this.getSHRBasicItemInfo(ctx, (IObjectPK)new ObjectUuidPK(newModel.getId()));
        if (newModel.isIsPreset() && !newModel.getType().equals((Object)oldModel.getType())) {
            throw new BaseItemException(BaseItemException.SYS_DEFAULT_NOT_MODIFY, new Object[]{newModel.getName(), newModel.getNumber()});
        }
        if (!newModel.isIsPreset() && !oldModel.getType().equals((Object)newModel.getType())) {
            if (BasicItemType.ADMIN_BIZ.equals((Object)newModel.getType()) || BasicItemType.ATSHOLIDAY.equals((Object)newModel.getType()) || BasicItemType.ATSBUSINESS.equals((Object)newModel.getType()) || BasicItemType.COMPENSATION_BIZ.equals((Object)newModel.getType()) || BasicItemType.PERFORMANCE_BIZ.equals((Object)newModel.getType()) || BasicItemType.RECRUIT_BIZ.equals((Object)newModel.getType()) || BasicItemType.BUDGET.equals((Object)newModel.getType())) {
                throw new BaseItemException(BaseItemException.SYS_DEFAULT_NOT_CHANGE, new Object[]{newModel.getName(), newModel.getNumber()});
            }
            isNeedChangePermission = true;
        }
        if (null == newModel.getCrHRBUAuth()) {
            newModel.put("crHRBUAuth", (Object)oldModel.getCrHRBUAuth());
        }
        if (newModel.getCrHRBUAuth().size() <= 0) {
            newModel.getCrHRBUAuth().addCollection(oldModel.getCrHRBUAuth());
        }
        if (null == oldModel.getManagePolicy()) {
            oldModel.setManagePolicy(ManagerPolicyEnum.ENABLED_CREATED);
        }
        SysSettingSHRBasicItemUtil.removeSHRBasicItemInfoFromCacheByEntityName(ctx, newModel.getEntityName());
        SysSettingSHRBasicItemUtil.removeSHRBasicItemInfoFromCacheByEntityName(ctx, newModel.getRealEntityName());
        if (null != newModel.getId()) {
            SysSettingSHRBasicItemUtil.removeSHRBasicItemInfoFromCacheById(ctx, newModel.getId().toString());
        }
        if (oldModel.getManagePolicy().equals((Object)newModel.getManagePolicy())) {
            pk = super._save(ctx, model);
            this.permissionHandler(ctx, oldModel, newModel, isNeedChangePermission);
            SysSettingSHRBasicItemUtil.removeSHRBasicItemInfoFromCacheById(ctx, pk.toString());
            return pk;
        }
        newModel.getCrHRBUAuth().clear();
        if (!BasicItemStateEnum.DISABLE.equals((Object)newModel.getState()) && ManagerPolicyEnum.ENABLED_CREATED.equals((Object)oldModel.getManagePolicy()) && ManagerPolicyEnum.DISABLED_CREATED.equals((Object)newModel.getManagePolicy())) {
            SysSettingSHRBasicItemUtil.addRootSHRBUAuth(ctx, newModel);
        }
        pk = super._save(ctx, (IObjectValue)newModel);
        this.permissionHandler(ctx, oldModel, newModel, isNeedChangePermission);
        SysSettingSHRBasicItemUtil.removeSHRBasicItemInfoFromCacheById(ctx, pk.toString());
        return pk;
    }

    private void permissionHandler(Context ctx, SHRBasicItemInfo oldModel, SHRBasicItemInfo newModel, boolean isNeedChangePermission) throws EASBizException, BOSException {
        if (isNeedChangePermission) {
            ArrayList<String> maintainUipks = new ArrayList<String>();
            maintainUipks.add(SysSettingUIViewUtil.generateURI(newModel.getEntityName(), ".maintain", ".list"));
            maintainUipks.add(SysSettingUIViewUtil.generateURI(newModel.getEntityName(), ".maintain", ".form"));
            maintainUipks.add(SysSettingUIViewUtil.generateURI(newModel.getEntityName(), ".maintain", ".viewDistribute"));
            ArrayList<String> availableUipks = new ArrayList<String>();
            availableUipks.add(SysSettingUIViewUtil.generateURI(newModel.getEntityName(), ".available", ".list"));
            availableUipks.add(SysSettingUIViewUtil.generateURI(newModel.getEntityName(), ".available", ".form"));
            SysSettingPermItemUtil.handlerPermItemUrlInfo(ctx, newModel, newModel.getName(), maintainUipks, availableUipks);
        }
    }

    private void checkData(Context ctx, SHRBasicItemInfo newModel) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)newModel.getEntityName())) {
            throw new BaseItemException(BaseItemException.ENTITY_NOT_BE_NULL);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entityName", (Object)newModel.getEntityName(), CompareType.EQUALS));
        if (null == newModel.getId() && this.exists(ctx, filter)) {
            throw new BaseItemException(BaseItemException.BASEITEM_ENTITY_EXIST, new Object[]{newModel.getNumber()});
        }
        SysSettingSHRBaseItemUtil.checkEntityNameValid(ctx, newModel.getEntityName());
        StringBuffer usePolicyText1 = new StringBuffer();
        StringBuffer usePolicyText2 = new StringBuffer();
        StringBuffer usePolicyText3 = new StringBuffer();
        boolean isDefPolicyInConPolicy = false;
        if (null == newModel.getConPolicy() || newModel.getConPolicy().size() <= 0) {
            throw new BaseItemException(BaseItemException.BASEITEM_CTRLSTRA_NOT_NULL, new Object[]{newModel.getNumber()});
        }
        int total = newModel.getConPolicy().size();
        for (int i = 0; i < total; ++i) {
            ControlPolicyInfo conPolicyInfo = newModel.getConPolicy().get(i);
            if (i > 0) {
                usePolicyText1.append(";");
                usePolicyText2.append(";");
                usePolicyText3.append(";");
            }
            usePolicyText1.append(conPolicyInfo.getUsePolicy().getAlias(LocaleUtils.locale_l1));
            usePolicyText2.append(conPolicyInfo.getUsePolicy().getAlias(LocaleUtils.locale_l2));
            usePolicyText3.append(conPolicyInfo.getUsePolicy().getAlias(LocaleUtils.locale_l3));
            if (!newModel.getDefPolicy().equals((Object)conPolicyInfo.getUsePolicy())) continue;
            isDefPolicyInConPolicy = true;
        }
        newModel.setUsePolicyText(usePolicyText1.toString(), LocaleUtils.locale_l1);
        newModel.setUsePolicyText(usePolicyText2.toString(), LocaleUtils.locale_l2);
        newModel.setUsePolicyText(usePolicyText3.toString(), LocaleUtils.locale_l3);
        if (!isDefPolicyInConPolicy) {
            throw new BaseItemException(BaseItemException.DEFULT_NOTIN_CTRLSTRA, new Object[]{newModel.getNumber(), newModel.getDefPolicy().getAlias()});
        }
        if (StringUtils.isEmpty((String)newModel.getUseUipk())) {
            throw new BaseItemException(BaseItemException.USEABLE_UIPK_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)newModel.getMaintainUipk())) {
            throw new BaseItemException(BaseItemException.MAINTAIN_UIPK_NOT_NULL);
        }
        SysSettingSHRBasicItemUtil.checkIsUIView(ctx, newModel.getEntityName(), newModel.getMaintainUipk());
        SysSettingSHRBasicItemUtil.checkIsUIView(ctx, newModel.getEntityName(), newModel.getUseUipk());
        if (StringUtils.isEmpty((String)newModel.getRelationHREntity())) {
            throw new BaseItemException(BaseItemException.BIZORG_ENTITY_NOT_NULL);
        }
        BaseItemRelationHRUtil.checkEntityNameValid(ctx, newModel.getRelationHREntity());
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SHRBasicItemInfo model = this.getSHRBasicItemInfo(ctx, pk);
        if (model.isIsPreset()) {
            throw new BaseItemException(BaseItemException.SYS_DEFAULT_NOT_DELETE, new Object[]{model.getNumber()});
        }
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, model.getEntityName());
        if (null != entityObjectInfo) {
            if (null == entityObjectInfo.getTable() || null == entityObjectInfo.getTable().getName()) {
                super._delete(ctx, pk);
                SysSettingSHRBasicItemUtil.removeSHRBasicItemInfoFromCacheById(ctx, pk.toString());
                return;
            }
            String tableName = entityObjectInfo.getTable().getName();
            if (!SysSettingSHRBaseItemUtil.isDeleteByBaseItemTable(ctx, tableName)) {
                throw new BaseItemException(BaseItemException.INCLUDE_DATA_NOT_DELETE, new Object[]{model.getNumber()});
            }
        } else {
            throw new BaseItemException(BaseItemException.META_NOTFOUND_NOT_DELETE, new Object[]{model.getNumber(), model.getEntityName()});
        }
        super._delete(ctx, pk);
        SysSettingSHRBasicItemUtil.removeSHRBasicItemInfoFromCacheById(ctx, pk.toString());
    }

    @Override
    protected String _enable(Context ctx, String shrBasicItemId) throws BOSException, EASBizException {
        return this.updateSHRBasicItemState(ctx, shrBasicItemId, BasicItemStateEnum.ENABLE);
    }

    @Override
    protected String _disable(Context ctx, String shrBasicItemId) throws BOSException, EASBizException {
        return this.updateSHRBasicItemState(ctx, shrBasicItemId, BasicItemStateEnum.DISABLE);
    }

    private String updateSHRBasicItemState(Context ctx, String shrBasicItemId, BasicItemStateEnum state) throws EASBizException, BOSException {
        String result = "";
        if (!this.exists(ctx, (IObjectPK)new ObjectUuidPK(shrBasicItemId))) {
            throw new BaseItemException(BaseItemException.ID_NOTEXSIT_NOT_DELETE, new Object[]{shrBasicItemId});
        }
        SHRBasicItemInfo model = this.getSHRBasicItemInfo(ctx, (IObjectPK)new ObjectUuidPK(shrBasicItemId));
        if (BasicItemStateEnum.DISABLE.equals((Object)model.getState()) && BasicItemStateEnum.DISABLE.equals((Object)state)) {
            throw new BaseItemException(BaseItemException.FORBID_ALREADY, new Object[]{model.getNumber()});
        }
        if (BasicItemStateEnum.ENABLE.equals((Object)model.getState()) && BasicItemStateEnum.ENABLE.equals((Object)state)) {
            throw new BaseItemException(BaseItemException.ENABLED_ALREADY, new Object[]{model.getNumber()});
        }
        if (model.isIsPreset() && BasicItemStateEnum.DISABLE.equals((Object)state)) {
            throw new BaseItemException(BaseItemException.SYS_DEFAULT_NOT_FORBID, new Object[]{model.getNumber()});
        }
        model.setState(state);
        if (BasicItemStateEnum.ENABLE.equals((Object)state) && model.isIsFirstEnable()) {
            if (ManagerPolicyEnum.DISABLED_CREATED.equals((Object)model.getManagePolicy())) {
                SysSettingSHRBasicItemUtil.addRootSHRBUAuth(ctx, model);
            }
            model.setIsFirstEnable(false);
        }
        this.update(ctx, (IObjectPK)new ObjectUuidPK(shrBasicItemId), (CoreBaseInfo)model);
        result = BasicItemStateEnum.DISABLE.equals((Object)state) ? SHRSysSettingResourceUtil.getResource("forbid_success", ctx, model.getNumber()) : SHRSysSettingResourceUtil.getResource("enable_success", ctx);
        return result;
    }

    @Override
    protected boolean _verifiHROrgIsCreation(Context ctx, String hrOrgUnitId, String entityName) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)hrOrgUnitId)) {
            throw new BaseItemException(BaseItemException.BIZORG_ID_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)entityName)) {
            throw new BaseItemException(BaseItemException.ENTITY_NOT_BE_NULL);
        }
        SHRBasicItemInfo model = this.getSHRBasicItemInfo(ctx, "where entityName = '" + entityName + "' or realEntityName = '" + entityName + "'");
        return this.verifiHROrgIsCreation(hrOrgUnitId, model);
    }

    @Override
    protected boolean _verifiHROrgIsCreationById(Context ctx, String hrOrgUnitId, String id) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)hrOrgUnitId)) {
            throw new BaseItemException(BaseItemException.BIZORG_ID_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)id)) {
            throw new BaseItemException(BaseItemException.BASEITEM_CTRLID_NOT_NULL);
        }
        SHRBasicItemInfo shrBasicItemInfo = this.getSHRBasicItemInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getBasicItemInfoSelector());
        return this.verifiHROrgIsCreation(hrOrgUnitId, shrBasicItemInfo);
    }

    private boolean verifiHROrgIsCreation(String hrOrgUnitId, SHRBasicItemInfo model) {
        if (ManagerPolicyEnum.ENABLED_CREATED.equals((Object)model.getManagePolicy())) {
            BaseInfoHRBUCollection coll = model.getCrHRBUAuth();
            if (null != coll && coll.size() > 0) {
                int total = coll.size();
                for (int i = 0; i < total; ++i) {
                    if (!hrOrgUnitId.equals(coll.get(i).getHrOrg().getId().toString()) || coll.get(i).isIsAllow()) continue;
                    return false;
                }
            }
            return true;
        }
        if (ManagerPolicyEnum.DISABLED_CREATED.equals((Object)model.getManagePolicy())) {
            BaseInfoHRBUCollection coll = model.getCrHRBUAuth();
            if (null != coll && coll.size() > 0) {
                int total = coll.size();
                for (int i = 0; i < total; ++i) {
                    if (!hrOrgUnitId.equals(coll.get(i).getHrOrg().getId().toString()) || !coll.get(i).isIsAllow()) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private SelectorItemCollection getBasicItemInfoSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("managePolicy"));
        selector.add(new SelectorItemInfo("entityName"));
        selector.add(new SelectorItemInfo("conPolicy.id"));
        selector.add(new SelectorItemInfo("conPolicy.usePolicy"));
        selector.add(new SelectorItemInfo("conPolicy.maintainPolicy"));
        selector.add(new SelectorItemInfo("conPolicy.id"));
        selector.add(new SelectorItemInfo("crHRBUAuth.id"));
        selector.add(new SelectorItemInfo("crHRBUAuth.hrOrg.id"));
        selector.add(new SelectorItemInfo("crHRBUAuth.isAllow"));
        return selector;
    }

    @Override
    protected boolean _verifiUsePolicyCreated(Context ctx, String id, UsePolicy usePolicy) throws BOSException, EASBizException {
        SHRBasicItemInfo shrBasicItemInfo = this.getSHRBasicItemInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getBasicItemInfoSelector());
        boolean existsPolicy = false;
        if (null != shrBasicItemInfo.getConPolicy() && shrBasicItemInfo.getConPolicy().size() > 0) {
            int total = shrBasicItemInfo.getConPolicy().size();
            for (int i = 0; i < total; ++i) {
                ControlPolicyInfo controlPolicyInfo = shrBasicItemInfo.getConPolicy().get(i);
                if (!controlPolicyInfo.getUsePolicy().equals((Object)usePolicy)) continue;
                existsPolicy = true;
                break;
            }
        }
        return existsPolicy;
    }

    @Override
    protected void _levelUpInit(Context ctx, String id) throws BOSException, EASBizException {
        SHRBasicItemCollection coll = null;
        if (StringUtils.isEmpty((String)id)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isPreset", (Object)Boolean.FALSE, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("useUipk", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("maintainUipk", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("relationHREntity", null, CompareType.EQUALS));
            filter.setMaskString("#0 and (#1 or #2 or #3)");
            view.setFilter(filter);
            coll = this.getSHRBasicItemCollection(ctx, view);
        } else {
            String[] ids = id.split(",");
            int total = ids.length;
            for (int i = 0; i < total; ++i) {
                SHRBasicItemInfo shrBasicItemInfo = this.getSHRBasicItemInfo(ctx, (IObjectPK)new ObjectUuidPK(ids[i]));
                if (shrBasicItemInfo.isIsPreset()) continue;
                coll = new SHRBasicItemCollection();
                coll.add(shrBasicItemInfo);
            }
        }
        BaseItemCustomLevelUpTools.levelUpInit(ctx, coll);
    }

    @Override
    protected void _coreLevelUpDep(Context ctx, CustomizedUnitInfo customizedUnitInfo, CustomizedSchemeInfo customizedSchemeInfo, EntityObjectInfo oldEntityObjectInfo, Map oldMdsMap) throws BOSException, EASBizException {
        try {
            SHRCustomizedUnitUtil.delete(ctx, customizedUnitInfo);
            SHRCustomizedUnitUtil.copyCrate(ctx, customizedSchemeInfo, customizedUnitInfo, oldEntityObjectInfo, oldMdsMap);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected List _exportDepBaseItem(Context ctx) throws BOSException, EASBizException {
        return EasHrBaseItemLevelupUtil.getEasHrDepBaseItem(ctx);
    }

    @Override
    protected void _importDepSHRBaseItem(Context ctx, List importData) throws BOSException, EASBizException {
        EasHrBaseItemLevelupUtil.importDepSHRBaseItem(ctx, importData);
    }

    @Override
    protected void _presetLevelUp(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isPreset", (Object)Boolean.TRUE, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        SHRBasicItemCollection coll = this.getSHRBasicItemCollection(ctx, entityViewInfo);
        int total = coll.size();
        for (int i = 0; i < total; ++i) {
            SHRBasicItemInfo shrBasicItemInfo = coll.get(i);
            SysSettingSHRBaseItemUtil.customBaseItemInit(ctx, shrBasicItemInfo);
            BaseItemRelationHRUtil.generateBaseItemToRelation(ctx, shrBasicItemInfo);
        }
    }

    @Override
    protected String _enableAll(Context ctx, String entityName) throws BOSException, EASBizException {
        String result = "";
        SHRBasicItemInfo shrBasicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, entityName);
        EntityObjectInfo entityObjectInfo = MetaDataUtil.getEntityObjectByEntityName(ctx, shrBasicItemInfo.getEntityName());
        String basicItemTable = entityObjectInfo.getTable().getName();
        try {
            if (this.getIdSet(ctx, basicItemTable, 1).next()) {
                this.updateAllSHRBasicItemStateEnable(ctx, basicItemTable);
                BaseItemRelationHRUtil.generateBaseItemToRelation(ctx, shrBasicItemInfo);
                BaseItemRelationHRUtil.updateRelation(ctx, shrBasicItemInfo, BasicItemStateEnum.ENABLE);
                result = SHRSysSettingResourceUtil.getResource("enableAll_success", ctx);
                return result;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        result = SHRSysSettingResourceUtil.getResource("enabledAll", ctx);
        return result;
    }

    @Override
    protected String _disableAll(Context ctx, String entityName) throws BOSException, EASBizException {
        String result = "";
        SHRBasicItemInfo shrBasicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, entityName);
        EntityObjectInfo entityObjectInfo = MetaDataUtil.getEntityObjectByEntityName(ctx, shrBasicItemInfo.getEntityName());
        String basicItemTable = entityObjectInfo.getTable().getName();
        try {
            if (this.getIdSet(ctx, basicItemTable, 2).next()) {
                this.updateAllSHRBasicItemStateDisable(ctx, basicItemTable);
                BaseItemRelationHRUtil.updateRelation(ctx, shrBasicItemInfo, BasicItemStateEnum.DISABLE);
                result = SHRSysSettingResourceUtil.getResource("disableAll_success", ctx);
                return result;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        result = SHRSysSettingResourceUtil.getResource("disabledAll", ctx);
        return result;
    }

    private IRowSet getIdSet(Context ctx, String basicItemTable, int state) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("select FID").append(" from ").append(basicItemTable).append(" where FSTATE =");
        if (state == 2) {
            buffer.append(1);
        } else {
            buffer.append(2).append(" or FSTATE = ").append(0);
        }
        return DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
    }

    private void updateAllSHRBasicItemStateEnable(Context ctx, String basicItemTable) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        IObjectPK pk = ctx.getCaller();
        buffer.append("update ").append(basicItemTable).append(" set FSTATE = 1").append(" ,FLASTUPDATEUSERID = '").append(pk.toString()).append("'").append(" ,FLASTUPDATETIME = now()").append("where FSTATE = 0 or FSTATE = 2");
        DbUtil.execute((Context)ctx, (String)buffer.toString());
    }

    private String updateAllSHRBasicItemStateDisable(Context ctx, String basicItemTable) throws BOSException {
        String result = null;
        StringBuffer buffer = new StringBuffer();
        IObjectPK pk = ctx.getCaller();
        buffer.append("update ").append(basicItemTable).append(" set FSTATE = 2").append(" ,FLASTUPDATEUSERID = '").append(pk.toString()).append("'").append(" ,FLASTUPDATETIME = now()").append(" where FSTATE = 1");
        DbUtil.execute((Context)ctx, (String)buffer.toString());
        return result;
    }

    @Override
    protected String _hrOrgUnitTrans(Context ctx, String sourceHrOrgId, String targetHrOrgId, String basicItemIds) throws BOSException, EASBizException {
        String userId = ctx.getCaller().toString();
        StringBuffer insertHRInitSql = new StringBuffer();
        insertHRInitSql.append("insert into T_HR_HRInit(fid, fkey, fcreatorid, fcreatetime, flastupdateuserid, flastupdatetime, fisfinish)").append("values (newbosid('4C6F2005'),'BasicItemTrans','").append(userId).append("',now(),'").append(userId).append("',now(),0)");
        DbUtil.execute((Context)ctx, (String)insertHRInitSql.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        String result = "";
        String l = LocaleUtils.getShortCode(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("useUipk", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("maintainUipk", null, CompareType.NOTEQUALS));
        if (!StringUtils.isEmpty((String)basicItemIds)) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)basicItemIds, CompareType.INCLUDE));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entityName"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("relationHREntity"));
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filter);
        ISHRBasicItem sHRBasicItem = SHRBasicItemFactory.getLocalInstance(ctx);
        SHRBasicItemCollection shrBasicItemCollection = sHRBasicItem.getSHRBasicItemCollection(viewInfo);
        for (int i = 0; i < shrBasicItemCollection.size(); ++i) {
            SHRBasicItemInfo shrBasicItemInfo = shrBasicItemCollection.get(i);
            String entityName = shrBasicItemInfo.getEntityName();
            String name = shrBasicItemInfo.getName(ctx.getLocale());
            if (!SysSettingSHRBaseItemUtil.isSHRBaseItem(ctx, entityName)) continue;
            try {
                this.hrOrgUnitTransSingle(ctx, sourceHrOrgId, targetHrOrgId, shrBasicItemInfo);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("hrOrgUnitTrans fail:" + name));
                result = StringUtils.isEmpty((String)result) ? result + name : result + "\u3001" + name;
                map.put(name, e.getMessage());
            }
        }
        StringBuffer updateHRInitSql = new StringBuffer();
        updateHRInitSql.append("update T_HR_HRInit set FIsFinish=1,FLastUpdateTime=now() where FKey='BasicItemTrans' and FIsFinish=0");
        DbUtil.execute((Context)ctx, (String)updateHRInitSql.toString());
        this.writeMessage(ctx, map);
        return result;
    }

    @Override
    protected void _hrOrgUnitTransSingle(Context ctx, String sourceHrOrgId, String targetHrOrgId, IObjectValue shrBasicItemModel) throws BOSException, EASBizException {
        SHRBasicItemInfo shrBasicItemInfo = (SHRBasicItemInfo)shrBasicItemModel;
        String basicItemId = String.valueOf(shrBasicItemInfo.getId());
        String entityName = shrBasicItemInfo.getEntityName();
        EntityObjectInfo enetiyInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, entityName);
        String tableName = enetiyInfo.getTable().getName();
        if (shrBasicItemInfo.getRelationHREntity() == null) {
            return;
        }
        EntityObjectInfo baseItemRelationEntity = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, shrBasicItemInfo.getRelationHREntity());
        String relationTable = baseItemRelationEntity.getTable().getName();
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from ").append(tableName).append(" where fhrorgunitid = ? and fusepolicy = ").append(200);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{sourceHrOrgId});
        StringBuffer fpSb = new StringBuffer();
        fpSb.append("select fid from ").append(tableName).append(" where fhrorgunitid = ? and fusepolicy = ").append(300);
        IRowSet fpRs = DbUtil.executeQuery((Context)ctx, (String)fpSb.toString(), (Object[])new Object[]{sourceHrOrgId});
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)sourceHrOrgId));
        viewInfo.setFilter(filter);
        ISHRBaseItem sHRBaseItem = (ISHRBaseItem)BaseMetaDataUtil.getBizInterface(ctx, entityName);
        IBaseItemRevise baseItemRevise = BaseItemReviseFactory.getLocalInstance(ctx);
        int maxRecords = 2000;
        int totalCount = sHRBaseItem.getCount(viewInfo);
        int pageCount = totalCount / maxRecords;
        if (totalCount % maxRecords > 0) {
            ++pageCount;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        for (int i = 0; i < pageCount; ++i) {
            List list = new ArrayList();
            list = totalCount > (i + 1) * maxRecords ? sHRBaseItem.getPagingList(viewInfo, i * maxRecords, maxRecords) : sHRBaseItem.getPagingList(viewInfo, i * maxRecords, totalCount - i * maxRecords);
            CoreBaseCollection reviseCollection = new CoreBaseCollection();
            for (int j = 0; j < list.size(); ++j) {
                CoreBaseInfo shrBaseItemModel = (CoreBaseInfo)list.get(j);
                ((SHRBaseItemInfo)shrBaseItemModel).getHrOrgUnit().setId(BOSUuid.read((String)targetHrOrgId));
                ((SHRBaseItemInfo)shrBaseItemModel).setLastUpdateUser(userInfo);
                ((SHRBaseItemInfo)shrBaseItemModel).setLastUpdateTime(now);
                String content = sHRBaseItem.fillReviseLogContentNew(shrBaseItemModel, shrBasicItemInfo);
                BaseItemReviseInfo newModel = new BaseItemReviseInfo();
                newModel.setShrBaseItemId(shrBaseItemModel.get("id").toString());
                newModel.setContent(content);
                reviseCollection.add((CoreBaseInfo)newModel);
            }
            Result j = baseItemRevise.save(reviseCollection);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tableName).append(" set fhrorgunitid  ='").append(targetHrOrgId).append("',FLastUpdateUserID='").append(userInfo.getId().toString()).append("',FLastUpdateTime=now() where fhrorgunitid  = '").append(sourceHrOrgId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        String distributeIds = "";
        String fpIds = "";
        try {
            String fid;
            while (rs.next()) {
                fid = rs.getString("fid");
                distributeIds = distributeIds + "'" + fid + "',";
            }
            while (fpRs.next()) {
                fid = fpRs.getString("fid");
                fpIds = fpIds + "'" + fid + "',";
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        distributeIds = !StringUtils.isEmpty((String)distributeIds) ? distributeIds.substring(0, distributeIds.length() - 1) : "''";
        fpIds = !StringUtils.isEmpty((String)fpIds) ? fpIds.substring(0, fpIds.length() - 1) : "''";
        StringBuffer relationSql = new StringBuffer();
        relationSql.append("update ").append(relationTable).append(" set FState  ='").append(200).append("'").append(" where FState  = '").append(100).append("'").append(" and FBaseInfoId in (").append(distributeIds).append(")");
        DbUtil.execute((Context)ctx, (String)relationSql.toString());
        DbUtil.execute((Context)ctx, (String)SHRBasicItemControllerBean.getRelationInsertSql(tableName, enetiyInfo.getType().toString(), relationTable, baseItemRelationEntity.getType().toString(), distributeIds));
        DbUtil.execute((Context)ctx, (String)SHRBasicItemControllerBean.getRelationUpdateSql(tableName, relationTable, distributeIds));
        StringBuffer updateRelationSql = new StringBuffer();
        updateRelationSql.append("update ").append(relationTable).append(" set FState  ='").append(200).append("'").append(" where FState  = '").append(100).append("'").append(" and FBaseInfoId in (").append(fpIds).append(")").append(" and FHrOrgUseId = '").append(sourceHrOrgId).append("'");
        DbUtil.execute((Context)ctx, (String)updateRelationSql.toString());
        DbUtil.execute((Context)ctx, (String)SHRBasicItemControllerBean.getFPRelationUpdateSql(relationTable, fpIds, targetHrOrgId));
        DbUtil.execute((Context)ctx, (String)SHRBasicItemControllerBean.getFPRelationInsertSql(tableName, enetiyInfo.getType().toString(), relationTable, baseItemRelationEntity.getType().toString(), fpIds, targetHrOrgId));
        StringBuffer updateAuthSql = new StringBuffer();
        updateAuthSql.append("update T_HR_BaseInfoHRBU").append(" set FHrOrgId  ='").append(targetHrOrgId).append("'").append(" where FHrOrgId  = '").append(sourceHrOrgId).append("'").append(" and FSHRBASICITEMID  = '").append(basicItemId).append("'");
        DbUtil.execute((Context)ctx, (String)updateAuthSql.toString());
    }

    private static String getRelationInsertSql(String baseItemTableName, String baseItemBosType, String baseItemRelationTableName, String baseItemRelationBosType, String distributeIds) {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(baseItemRelationTableName).append("(FIsDefaultValue, FBaseInfoId, FHrOrgUseId, FIsComUse, FIndex, FState, FChangeType, FBosTypeId, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FID)");
        sb.append(" SELECT 0 FIsDefaultValue,baseItem.fid FBaseInfoId, hr.fid FHrOrgUseId, 1 FIsComUse,'0' FIndex,").append(100).append(" FState, ").append(100).append(" FChangeType,");
        sb.append(" '").append(baseItemBosType).append("' FBosTypeId,baseItem.FCreatorID FCreatorID,now() FCreateTime,baseItem.FLastUpdateUserID FLastUpdateUserID,now() FLastUpdateTime,baseItem.FControlUnitID FControlUnitID,");
        sb.append(" newbosid('").append(baseItemRelationBosType).append("') fid");
        sb.append(" FROM ").append(baseItemTableName).append(" baseItem ");
        sb.append(" inner join t_org_hro hr on 1=1 ");
        sb.append(" where baseItem.fstate = ").append(1).append(" and baseItem.fusepolicy = ").append(200).append(" and hr.FISSEALUP = 0");
        sb.append(" and not exists(SELECT 1 FROM ").append(baseItemRelationTableName).append(" relation where relation.FBaseInfoId = baseItem.fid and relation.FHrOrgUseId = hr.fid)");
        sb.append("and baseItem.fid in (").append(distributeIds).append(")");
        sb.append("and hr.flongNumber like (SELECT hr1.flongNumber||'%' FROM t_org_hro hr1 where hr1.fid = baseItem.fhrorgunitid and hr1.FISSEALUP = 0)");
        return sb.toString();
    }

    private static String getRelationUpdateSql(String baseItemTableName, String baseItemRelationTableName, String distributeIds) {
        StringBuffer sb = new StringBuffer();
        sb.append("update ").append(baseItemRelationTableName).append(" set FState = ").append(100).append(" where FState = ").append(200).append(" and exists");
        sb.append("(SELECT 1 FROM ").append(baseItemTableName).append(" baseItem inner join t_org_hro t0 on baseItem.fhrorgunitid=t0.fid inner join ").append(baseItemRelationTableName).append(" t1 on t1.FBaseInfoId= baseItem.fid and baseItem.fstate =").append(1).append(" and baseItem.fusepolicy = ").append(200).append(" and t1.FState = ").append(200).append(" inner join t_org_hro t2 on t1.FHrOrgUseId = t2.FID where ").append(baseItemRelationTableName).append(".fid = t1.fid and CHARINDEX(t0.FLONGNUMBER,t2.flongNumber) >= 1 and baseItem.fid in (").append(distributeIds).append("))");
        return sb.toString();
    }

    private static String getFPRelationUpdateSql(String baseItemRelationTableName, String fpIds, String targetHrOrgId) {
        StringBuffer sb = new StringBuffer();
        sb.append("update ").append(baseItemRelationTableName).append(" set FState = ").append(100).append(" where FState = ").append(200).append(" and FBaseInfoId in (").append(fpIds).append(")").append(" and FHrOrgUseId = '").append(targetHrOrgId).append("'");
        return sb.toString();
    }

    private static String getFPRelationInsertSql(String baseItemTableName, String baseItemBosType, String baseItemRelationTableName, String baseItemRelationBosType, String fpIds, String targetHrOrgId) {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(baseItemRelationTableName).append("(FIsDefaultValue, FBaseInfoId, FHrOrgUseId, FIsComUse, FIndex, FState, FChangeType, FBosTypeId, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FID)");
        sb.append(" SELECT 0 FIsDefaultValue,baseItem.fid FBaseInfoId, '").append(targetHrOrgId).append("' FHrOrgUseId, 1 FIsComUse,'0' FIndex,").append(100).append(" FState, ").append(100).append(" FChangeType,");
        sb.append(" '").append(baseItemBosType).append("' FBosTypeId,baseItem.FCreatorID FCreatorID,now() FCreateTime,baseItem.FLastUpdateUserID FLastUpdateUserID,now() FLastUpdateTime,baseItem.FControlUnitID FControlUnitID,");
        sb.append(" newbosid('").append(baseItemRelationBosType).append("') fid");
        sb.append(" FROM ").append(baseItemTableName).append(" baseItem ");
        sb.append(" where baseItem.fstate = ").append(1).append(" and baseItem.fusepolicy = ").append(300);
        sb.append(" and not exists (SELECT 1 FROM ").append(baseItemRelationTableName).append(" relation where relation.FBaseInfoId = baseItem.fid and relation.FHrOrgUseId = '").append(targetHrOrgId).append("')");
        sb.append(" and baseItem.fid in (").append(fpIds).append(")");
        return sb.toString();
    }

    private void writeMessage(Context ctx, Map<String, Object> map) {
        String userId = ctx.getCaller().toString();
        Message message = MessageFactory.newMessage();
        message.setBooleanHeader("isSendCommon", Boolean.TRUE.booleanValue());
        String title = "";
        StringBuffer body = new StringBuffer();
        if (map.isEmpty()) {
            title = SHRServerResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "batchAdjustOrgSuccess", ctx);
            body.append(SHRServerResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "batchAdjustOrgSuccess", ctx));
        } else {
            title = SHRServerResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "batchAdjustOrgFail", ctx);
            body.append(SHRServerResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "batchAdjustOrgFail", ctx)).append("\n");
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                body.append(SHRServerResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "adjustFailDetail", ctx, entry.getKey(), entry.getValue())).append("\n");
            }
        }
        message.setLocaleStringHeader("title", title, LocaleUtils.locale_l1);
        message.setLocaleStringHeader("title", title, LocaleUtils.locale_l2);
        message.setLocaleStringHeader("title", title, LocaleUtils.locale_l3);
        message.setLocaleStringHeader("body", body.toString(), LocaleUtils.locale_l1);
        message.setLocaleStringHeader("body", body.toString(), LocaleUtils.locale_l2);
        message.setLocaleStringHeader("body", body.toString(), LocaleUtils.locale_l3);
        message.setLocaleStringHeader("sender", SHRServerResource.getString("com.kingdee.shr.base.syssetting.CommonserviceResource", "sys_auto_send", LocaleUtils.locale_l1), LocaleUtils.locale_l1);
        message.setLocaleStringHeader("sender", SHRServerResource.getString("com.kingdee.shr.base.syssetting.CommonserviceResource", "sys_auto_send", LocaleUtils.locale_l2), LocaleUtils.locale_l2);
        message.setLocaleStringHeader("sender", SHRServerResource.getString("com.kingdee.shr.base.syssetting.CommonserviceResource", "sys_auto_send", LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        message.setLocaleStringHeader("initiatorName", SHRServerResource.getString("com.kingdee.shr.base.syssetting.CommonserviceResource", "sys_auto_send", LocaleUtils.locale_l1), LocaleUtils.locale_l1);
        message.setLocaleStringHeader("initiatorName", SHRServerResource.getString("com.kingdee.shr.base.syssetting.CommonserviceResource", "sys_auto_send", LocaleUtils.locale_l2), LocaleUtils.locale_l2);
        message.setLocaleStringHeader("initiatorName", SHRServerResource.getString("com.kingdee.shr.base.syssetting.CommonserviceResource", "sys_auto_send", LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 70);
        message.setIntHeader("priority", 20);
        message.setIntHeader("sourceStatus", 0);
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("receiver", userId);
        message.setStringHeader("senderId", userId);
        DirectSenderAgent.getSenderAgent().sendMessage(message);
    }

    @Override
    protected boolean _clear(Context ctx, String bizUnitId) throws BOSException, EASBizException {
        ICustomizedUnit iCustomizedUnit = CustomizedUnitFactory.getLocalInstance((Context)ctx);
        if (!iCustomizedUnit.exists("where id='" + bizUnitId + "'")) {
            String msg = new CustomExtendToolsException(CustomExtendToolsException.UNIT_NOTEXSIT, new Object[]{"[" + bizUnitId + "]"}).getMessage();
            throw new BOSException(msg);
        }
        CustomizedUnitInfo customizedUnitInfo = iCustomizedUnit.getCustomizedUnitInfo("where id='" + bizUnitId + "'");
        String customizedUnitObject = customizedUnitInfo.getCustomizedUnitObject();
        BizUnitInfo info = MetaDataUtil.processCustomizedUnitObject(customizedUnitObject);
        List<String> entityFullNameList = info.getEntityFullNameList();
        ISHRBasicItem iSHRBasicItem = SHRBasicItemFactory.getLocalInstance(ctx);
        for (int i = 0; i < entityFullNameList.size(); ++i) {
            String entityName = entityFullNameList.get(i);
            String oql = " where entityName = '" + entityName + "'";
            if (!iSHRBasicItem.exists(oql)) {
                logger.error((Object)("biz unit id\uff1a" + bizUnitId + " entity full path\uff1a" + entityName));
                continue;
            }
            SHRBasicItemInfo shrBasicItemInfo = iSHRBasicItem.getSHRBasicItemInfo(oql);
            String entityNa = entityName.substring(entityName.lastIndexOf(".") + 1);
            String tableName = TableName0 + entityNa;
            String dropRealSql = " drop table " + tableName + "";
            String delBaseInfoHRBUSql = "delete from T_HR_BaseInfoHRBU where FSHRBASICITEMID in  (select fid from T_BS_SHRBasicItem where FENTITYNAME =?)";
            String delControlPolicySql = "delete from T_HR_ControlPolicy where FSHRBASICITEMID in  (select fid from T_BS_SHRBasicItem where FENTITYNAME =?)";
            String useUrlSql = "delete from T_PM_PermItemURL where FUrl like '%" + entityName + "%'";
            String delUIViewExtSql = "delete from S_BS_UIViewExt where fparentid in (select fid from S_BS_UIView where fmodel = ?)";
            String delUIViewSql = "delete from S_BS_UIView where fmodel = ?";
            String delSHRFileTemplateFieldsSql = "delete FROM T_BS_SHRFileTemplateFields where FCmpImportTempID in  ( select fid FROM T_BS_SHRFileTemplate where FEntityFullName = ?)";
            String delSHRFileTemplateSql = "delete FROM T_BS_SHRFileTemplate where FEntityFullName = ?";
            String delSHRBasicItemSql = "delete FROM T_BS_SHRBasicItem where FENTITYNAME = ?";
            DbUtil.execute((Context)ctx, (String)delBaseInfoHRBUSql, (Object[])new Object[]{entityName});
            DbUtil.execute((Context)ctx, (String)delControlPolicySql, (Object[])new Object[]{entityName});
            DbUtil.execute((Context)ctx, (String)useUrlSql);
            DbUtil.execute((Context)ctx, (String)delUIViewExtSql, (Object[])new Object[]{entityName});
            DbUtil.execute((Context)ctx, (String)delUIViewSql, (Object[])new Object[]{entityName});
            DbUtil.execute((Context)ctx, (String)delSHRFileTemplateFieldsSql, (Object[])new Object[]{entityName});
            DbUtil.execute((Context)ctx, (String)delSHRFileTemplateSql, (Object[])new Object[]{entityName});
            DbUtil.execute((Context)ctx, (String)delSHRBasicItemSql, (Object[])new Object[]{entityName});
            SysSettingSHRBasicItemUtil.removeSHRBasicItemInfoFromCacheById(ctx, entityName);
        }
        return true;
    }
}

