/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.UIViewExtCollection;
import com.kingdee.shr.base.syssetting.UIViewExtInfo;
import com.kingdee.shr.base.syssetting.app.AbstractUIViewExtControllerBean;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.util.HTMLUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class UIViewExtControllerBean
extends AbstractUIViewExtControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.UIViewExtControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UIViewExtInfo info = (UIViewExtInfo)model;
        this.checkData(ctx, info);
        UIViewExtInfo dbInfo = this.getValue(ctx, info);
        if (dbInfo != null) {
            dbInfo.setContent(info.getContent());
            info = dbInfo;
        }
        return super._save(ctx, (IObjectValue)info);
    }

    private void checkData(Context ctx, UIViewExtInfo info) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)info.getContent())) {
            try {
                XMLUtil.parseXML(info.getContent());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                String message = HTMLUtil.escape(e.getMessage());
                throw new SyssettinException(SyssettinException.CONFIG_INCORRECT, new Object[]{"<br>" + message});
            }
        }
    }

    private UIViewExtInfo getValue(Context ctx, UIViewExtInfo info) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getParent().getId().toString()));
        viewInfo.setFilter(filterInfo);
        UIViewExtCollection collection = this.getUIViewExtCollection(ctx, viewInfo);
        if (collection != null && !collection.isEmpty()) {
            return collection.get(0);
        }
        return null;
    }
}

