/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.builder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.shr.base.syssetting.DomainFilterFacadeFactory;
import com.kingdee.shr.base.syssetting.app.builder.ITreeBuilder;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommonTreeBuilder
implements ITreeBuilder {
    private static Logger logger = Logger.getLogger(CommonTreeBuilder.class);
    private static final String ROOTID = "rootId";

    @Override
    public Object getRootNode(Context ctx, Map<String, String> params) throws EASBizException, BOSException {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("id", ROOTID);
        root.put("name", params.get("rootAlias"));
        root.put("isLeaf", false);
        return root;
    }

    @Override
    public Object getChildren(Context ctx, Map<String, String> params) throws EASBizException, BOSException {
        String treeModel = params.get("treeModel");
        if (StringUtils.isEmpty((String)treeModel)) {
            return null;
        }
        String nodeId = params.get("nodeId");
        String domain = params.get("domain");
        FilterInfo domainFilter = this.getDomainFilter(ctx, treeModel, domain);
        FilterInfo filterInfo = new FilterInfo();
        if (ROOTID.equalsIgnoreCase(nodeId)) {
            nodeId = null;
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)nodeId));
        filterInfo.mergeFilter(domainFilter, "AND");
        long t0 = System.currentTimeMillis();
        List<Map<String, Object>> result = this.getTreeCollection(ctx, treeModel, filterInfo);
        long t1 = System.currentTimeMillis();
        return result;
    }

    private FilterInfo getDomainFilter(Context ctx, String treeModel, String domain) throws BOSException {
        if (StringUtils.isEmpty((String)treeModel) || StringUtils.isEmpty((String)domain)) {
            return null;
        }
        return DomainFilterFacadeFactory.getLocalInstance(ctx).getDomainFilter(treeModel, domain, null);
    }

    private List<Map<String, Object>> getTreeCollection(Context ctx, String treeModel, FilterInfo filterInfo) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        SorterItemCollection sortCollection = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("longnumber");
        sortInfo.setSortType(SortType.ASCEND);
        sortCollection.add(sortInfo);
        viewInfo.setSorter(sortCollection);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("alias"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("longNumber"));
        viewInfo.setSelector(sic);
        long t0 = System.currentTimeMillis();
        CoreBaseCollection collection = CommonTreeBuilder.getBizInterface(ctx, treeModel).getCollection(viewInfo);
        long t1 = System.currentTimeMillis();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        TreeBaseInfo treeBaseInfo = null;
        HashMap<String, Object> item = null;
        CoreBaseInfo obj = null;
        for (int i = 0; i < collection.size(); ++i) {
            obj = collection.get(i);
            if (!(obj instanceof TreeBaseInfo)) continue;
            treeBaseInfo = (TreeBaseInfo)obj;
            item = new HashMap<String, Object>();
            item.put("id", treeBaseInfo.getId().toString());
            item.put("name", treeBaseInfo.getName());
            item.put("isLeaf", treeBaseInfo.isIsLeaf());
            item.put("longNumber", treeBaseInfo.getLongNumber());
            item.put("number", treeBaseInfo.getNumber());
            item.put("level", String.valueOf(treeBaseInfo.getLevel()));
            result.add(item);
        }
        return result;
    }

    private static ICoreBase getBizInterface(Context ctx, String entityName) throws BOSException {
        return (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)new MetaDataPK(entityName));
    }

    @Override
    public Object getAllNodes(Context ctx, Map<String, String> params) throws EASBizException, BOSException {
        return null;
    }
}

