/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.json.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.BillEntryCustomCollection;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.BaseMultiLangUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BosObjectTypeAdapter
implements JsonSerializer<IObjectValue>,
JsonDeserializer<IObjectValue> {
    private static Logger logger = Logger.getLogger(BosObjectTypeAdapter.class);
    private static Pattern p = Pattern.compile("^[1-9]\\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])\\s(20|21|22|23|[0-1]\\d):[0-5]\\d$");
    private static final String ENTITY_NAME = "_entityName";
    private Context ctx;
    private Locale locale;
    private HashMap<String, Map<String, Object>> typeMap = new HashMap();
    private HashMap<String, Class> classMap = new HashMap();
    private HashMap<String, Type> typeMap1 = new HashMap();
    private HashMap<String, String> linkEntityNameMap = new HashMap();
    private HashMap<String, Type> entryValueTypeMap = new HashMap();
    private HashMap<String, Object> intEnumObjMap = new HashMap();
    private HashMap<String, Object> enumStrMap = new HashMap();
    private HashMap<String, Object> enumFloatMap = new HashMap();
    private HashMap<String, Boolean> mulitLangMap = new HashMap();

    public BosObjectTypeAdapter(Context ctx) {
        this.ctx = ctx;
        this.locale = null == this.ctx ? LocaleUtils.locale_l2 : this.ctx.getLocale();
    }

    public IObjectValue deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        Map.Entry entry2 = null;
        JsonElement element = null;
        Type returnType = null;
        Class dataType = null;
        try {
            String typeString = type.toString().substring(type.toString().indexOf(" ") + 1);
            Class clazz = null;
            clazz = this.getClazz(typeString);
            JsonElement entityNameElement = jsonObject.get(ENTITY_NAME);
            String entityName = null;
            if (entityNameElement != null && !entityNameElement.isJsonNull()) {
                entityName = entityNameElement.getAsString();
            }
            IObjectValue objectInfo = null;
            objectInfo = BaseMetaDataUtil.newInstance(this.ctx, clazz, entityName);
            if (objectInfo == null) {
                return null;
            }
            for (Map.Entry entry2 : jsonObject.entrySet()) {
                Object result;
                String num;
                String entryKey = (String)entry2.getKey();
                element = jsonObject.get(entryKey);
                returnType = this.getReturnType(objectInfo, entryKey);
                if (returnType == null) continue;
                dataType = this.getDataType1(returnType);
                if (element.isJsonNull()) continue;
                if (element.toString().equals("") || element.toString().equals("\"\"") || element.toString().equals("\"null\"") || element.toString().equals("\"undefined\"")) {
                    if (this.asSubClass(dataType, String.class) && BaseMultiLangUtils.isMultiLangEntityProperty(this.ctx, objectInfo.getBOSType(), entryKey)) {
                        objectInfo.put(entryKey, null, this.locale);
                    }
                    objectInfo.put(entryKey.toString(), null);
                    continue;
                }
                if (this.asSubClass(dataType, String.class)) {
                    if (this.isMultiLang(objectInfo.getBOSType(), entryKey)) {
                        JsonObject jsonValue = null;
                        if (element.isJsonObject()) {
                            jsonValue = element.getAsJsonObject();
                            for (Map.Entry entity : jsonValue.entrySet()) {
                                String key = (String)entity.getKey();
                                Object value = entity.getValue();
                                value = !(value instanceof JsonNull) ? ((JsonPrimitive)value).getAsString() : null;
                                Locale locale0 = LocaleUtils.getLocale(key);
                                if (this.locale.equals(locale0)) {
                                    objectInfo.put(entryKey, value);
                                }
                                objectInfo.put(entryKey, value, locale0);
                            }
                            continue;
                        }
                        String strMultiLangValue = element.getAsString();
                        if (BaseMultiLangUtils.isMultiLangValueFormat(strMultiLangValue)) {
                            HashMap multiLangPartValue = JSONUtils.convertJsonToObject(this.ctx, strMultiLangValue);
                            for (String key : multiLangPartValue.keySet()) {
                                Object value = multiLangPartValue.get(key);
                                if (value != null) {
                                    objectInfo.put(entryKey, value, LocaleUtils.getLocale(key));
                                    continue;
                                }
                                objectInfo.put(entryKey, null, LocaleUtils.getLocale(key));
                            }
                            continue;
                        }
                        objectInfo.put(entryKey, (Object)strMultiLangValue);
                        objectInfo.put(entryKey, (Object)strMultiLangValue, this.locale);
                        continue;
                    }
                    if (!(element instanceof JsonPrimitive)) continue;
                    objectInfo.put(entryKey, (Object)element.getAsString());
                    continue;
                }
                if (this.asSubClass(dataType, Boolean.class)) {
                    try {
                        if (element.getAsInt() != 0) {
                            objectInfo.put(entryKey, (Object)true);
                            continue;
                        }
                        objectInfo.put(entryKey, (Object)false);
                    }
                    catch (NumberFormatException exception) {
                        objectInfo.put(entryKey, (Object)element.getAsBoolean());
                    }
                    continue;
                }
                if (this.asSubClass(dataType, Integer.class)) {
                    num = element.getAsString();
                    if (num.indexOf(".") >= 0) {
                        num = num.substring(0, num.indexOf("."));
                    }
                    objectInfo.put(entryKey, (Object)num);
                    continue;
                }
                if (this.asSubClass(dataType, Long.class)) {
                    num = element.getAsString();
                    if (num.indexOf(".") >= 0) {
                        num = num.substring(0, num.indexOf("."));
                    }
                    objectInfo.put(entryKey, (Object)num);
                    continue;
                }
                if (this.asSubClass(dataType, Float.class)) {
                    objectInfo.put(entryKey, (Object)Float.valueOf(element.getAsFloat()));
                    continue;
                }
                if (this.asSubClass(dataType, Double.class)) {
                    objectInfo.put(entryKey, (Object)element.getAsDouble());
                    continue;
                }
                if (this.asSubClass(dataType, BigDecimal.class)) {
                    objectInfo.put(entryKey, (Object)element.getAsBigDecimal());
                    continue;
                }
                if (this.asSubClass(dataType, Date.class)) {
                    objectInfo.put(entryKey, (Object)this.parseDate(element.getAsString(), DataType.DATE));
                    continue;
                }
                if (this.asSubClass(dataType, Timestamp.class)) {
                    Date date = this.parseDate(element.getAsString(), DataType.TIMESTAMP);
                    objectInfo.put(entryKey, (Object)date.getTime());
                    continue;
                }
                if (this.asSubClass(dataType, BOSUuid.class)) {
                    if (element.getAsString() == null || element.getAsString().equals("")) continue;
                    objectInfo.put(entryKey, (Object)BOSUuid.read((String)element.getAsString()));
                    continue;
                }
                if (this.asSubClass(dataType, BillEntryCustomCollection.class)) {
                    JsonArray jsonArray = element.getAsJsonArray();
                    if (jsonArray == null) continue;
                    BillEntryCustomCollection objectCollection = new BillEntryCustomCollection();
                    EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(this.ctx, entityName);
                    PropertyInfo simpleProperty = entityObjectInfo.getPropertyByNameRuntime(entryKey);
                    String fullName = ((LinkPropertyInfo)simpleProperty).getRelationship().getSupplierObject().getFullName();
                    objectInfo.put(entryKey, (Object)objectCollection);
                    JsonElement newElement = null;
                    for (int nIndex = 0; nIndex < jsonArray.size(); ++nIndex) {
                        newElement = jsonArray.get(nIndex);
                        this.setLinkEntityName(newElement, fullName);
                        objectCollection.addObject(this.deserialize(newElement, this.getEntryValueType((IObjectCollection)objectCollection), context));
                    }
                    continue;
                }
                if (this.asSubClass(dataType, AbstractObjectCollection.class)) {
                    String fieldName = entryKey;
                    String mapKey = entityName + fieldName;
                    String linkEntityName = this.getLinkEntityName(entityName, fieldName, mapKey);
                    IObjectCollection objectCollection = (IObjectCollection)objectInfo.get(fieldName);
                    if (objectCollection == null) continue;
                    String mapKey2 = objectCollection.getClass().getName();
                    Type entryValueType = this.getEntryValueType(objectCollection, mapKey2);
                    if (element.isJsonArray()) {
                        JsonArray jsonArray = element.getAsJsonArray();
                        JsonElement newElement = null;
                        for (int nIndex = 0; nIndex < jsonArray.size(); ++nIndex) {
                            newElement = jsonArray.get(nIndex);
                            this.setLinkEntityName(newElement, linkEntityName);
                            objectCollection.addObject(this.deserialize(jsonArray.get(nIndex), entryValueType, context));
                        }
                        continue;
                    }
                    this.setLinkEntityName(element, linkEntityName);
                    objectCollection.addObject(this.deserialize(element, entryValueType, context));
                    continue;
                }
                if (this.asSubClass(dataType, IObjectValue.class)) {
                    JsonElement newElement = null;
                    if (element.isJsonPrimitive()) {
                        JsonObject obj = new JsonObject();
                        obj.add("id", element);
                        newElement = obj;
                    } else {
                        newElement = element;
                    }
                    String fieldName = entryKey;
                    String mapKey = entityName + fieldName;
                    String linkEntityName = this.getLinkEntityName(entityName, fieldName, mapKey);
                    this.setLinkEntityName(newElement, linkEntityName);
                    objectInfo.put(fieldName, (Object)this.deserialize(newElement, returnType, context));
                    continue;
                }
                if (this.asSubClass(dataType, IntEnum.class)) {
                    result = null;
                    String num2 = null;
                    if (element.isJsonObject()) {
                        num2 = element.getAsJsonObject().get("value").getAsString();
                        if (num2.indexOf(".") >= 0) {
                            num2 = num2.substring(0, num2.indexOf("."));
                        }
                    } else {
                        num2 = element.getAsString();
                        if (num2.indexOf(".") >= 0) {
                            num2 = num2.substring(0, num2.indexOf("."));
                        }
                    }
                    result = this.getIntEnumObj(dataType, num2);
                    objectInfo.put(entryKey, result);
                    continue;
                }
                if (this.asSubClass(dataType, StringEnum.class)) {
                    result = null;
                    String eleString = null;
                    eleString = element.isJsonObject() ? element.getAsJsonObject().get("value").getAsString() : element.getAsString();
                    result = this.getStrEnumObj(dataType, eleString);
                    objectInfo.put(entryKey, result);
                    continue;
                }
                if (this.asSubClass(dataType, FloatEnum.class)) {
                    result = null;
                    float eleFloat = 0.0f;
                    eleFloat = element.isJsonObject() ? element.getAsJsonObject().get("value").getAsFloat() : element.getAsFloat();
                    String key = dataType.toString() + eleFloat;
                    Object enumFloatObj = this.enumFloatMap.get(key);
                    if (enumFloatObj != null) {
                        result = enumFloatObj;
                    } else {
                        Method method = dataType.getMethod("getEnum", Float.TYPE);
                        result = method.invoke((Object)dataType, Float.valueOf(eleFloat));
                        this.enumFloatMap.put(key, result);
                    }
                    objectInfo.put(entryKey, result);
                    continue;
                }
                if (!this.asSubClass(dataType, DoubleEnum.class)) continue;
                Method method = dataType.getMethod("getEnum", Double.TYPE);
                Object result2 = null;
                result2 = element.isJsonObject() ? method.invoke((Object)dataType, Float.valueOf(element.getAsJsonObject().get("value").getAsFloat())) : method.invoke((Object)dataType, element.getAsDouble());
                objectInfo.put(entryKey, result2);
            }
            return objectInfo;
        }
        catch (Exception ex) {
            String message = "";
            if (null != entry2) {
                message = MessageFormat.format("BosObjectTypeAdapter.deserialize property={0},value={1},classType={2},detailErrorMessage={3}", entry2.getKey(), element, dataType, ex.getMessage());
            }
            logger.info((Object)message, (Throwable)ex);
            throw new JsonParseException(message);
        }
    }

    private Class getClazz(String typeString) throws ClassNotFoundException {
        Class clazz;
        if (this.classMap.get(typeString) != null) {
            clazz = this.classMap.get(typeString);
        } else {
            clazz = Class.forName(typeString);
            this.classMap.put(typeString, clazz);
        }
        return clazz;
    }

    private Type getReturnType(IObjectValue objectInfo, String entryKey) throws EASBizException, BOSException {
        Type returnType;
        String key = objectInfo.getClass() + entryKey;
        if (this.typeMap1.get(key) != null) {
            returnType = this.typeMap1.get(key);
        } else {
            returnType = BaseMetaDataUtil.getMetadataValueType(this.ctx, objectInfo, entryKey);
            this.typeMap1.put(key, returnType);
        }
        return returnType;
    }

    private Class getDataType1(Type returnType) throws ClassNotFoundException {
        Class dataType;
        if (this.classMap.get(returnType.toString()) != null) {
            dataType = this.classMap.get(returnType.toString());
        } else {
            dataType = this.getDataType(returnType);
            this.classMap.put(returnType.toString(), dataType);
        }
        return dataType;
    }

    private Object getStrEnumObj(Class dataType, String eleString) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object result;
        String key = dataType.toString() + eleString;
        Object enumObj = this.enumStrMap.get(key);
        if (enumObj != null) {
            result = enumObj;
        } else {
            Method method = dataType.getMethod("getEnum", String.class);
            result = method.invoke((Object)dataType, eleString);
            this.enumStrMap.put(key, result);
        }
        return result;
    }

    private Object getIntEnumObj(Class dataType, String num) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object result;
        String key = dataType.toString() + num;
        Object enumObj = this.intEnumObjMap.get(key);
        if (enumObj != null) {
            result = enumObj;
        } else {
            Method method = dataType.getMethod("getEnum", Integer.TYPE);
            result = method.invoke((Object)dataType, Integer.parseInt(num));
            this.intEnumObjMap.put(key, result);
        }
        return result;
    }

    private Type getEntryValueType(IObjectCollection objectCollection, String mapKey2) {
        Type entryValueType = null;
        if (this.entryValueTypeMap.get(mapKey2) != null) {
            entryValueType = this.entryValueTypeMap.get(mapKey2);
        } else {
            entryValueType = this.getEntryValueType(objectCollection);
            this.entryValueTypeMap.put(mapKey2, entryValueType);
        }
        return entryValueType;
    }

    private String getLinkEntityName(String entityName, String fieldName, String mapKey) {
        String linkEntityName = null;
        if (this.linkEntityNameMap.get(mapKey) != null) {
            linkEntityName = this.linkEntityNameMap.get(mapKey);
        } else {
            linkEntityName = BaseMetaDataUtil.getEntityNameByFieldName(this.ctx, entityName, fieldName);
            this.linkEntityNameMap.put(mapKey, linkEntityName);
        }
        return linkEntityName;
    }

    private boolean isMultiLang(BOSObjectType bosType, String entryKey) {
        Boolean isMul = false;
        String key = bosType.toString() + entryKey;
        if (this.mulitLangMap.get(key) != null) {
            isMul = this.mulitLangMap.get(key);
        } else {
            isMul = BaseMultiLangUtils.isMultiLangEntityProperty(this.ctx, bosType, entryKey);
            this.mulitLangMap.put(key, isMul);
        }
        return isMul;
    }

    private void setLinkEntityName(JsonElement element, String entityName) {
        element.getAsJsonObject().addProperty(ENTITY_NAME, entityName);
    }

    private Class getDataType(Type returnType) throws ClassNotFoundException {
        String typeStr = returnType.toString().substring(returnType.toString().indexOf(" ") + 1);
        return this.getDataType(typeStr);
    }

    private Class getDataType(String typeStr) throws ClassNotFoundException {
        Class<?> dataType = null;
        if (typeStr.equals("int")) {
            typeStr = "java.lang.Integer";
        } else if (typeStr.equals("float")) {
            typeStr = "java.lang.Float";
        } else if (typeStr.equals("double")) {
            typeStr = "java.lang.Double";
        } else if (typeStr.equals("boolean")) {
            typeStr = "java.lang.Boolean";
        } else if (typeStr.equals("String")) {
            typeStr = "java.lang.String";
        }
        dataType = Class.forName(typeStr);
        return dataType;
    }

    private Date parseDate(String s, DataType dataType) throws ParseException {
        try {
            Matcher m = p.matcher(s);
            if (m.matches()) {
                return DateTimeUtils.parseDate((String)s, (String)"yyyy-MM-dd HH:mm");
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageFormat.format(" BosObjectTypeAdapter parseDate warning , value is: {0} ,foramt is :{1}", s, "yyyy-MM-dd HH:mm"));
        }
        return DateTimeUtils.parseDate((String)s);
    }

    private boolean asSubClass(Class source, Class desc) {
        try {
            Class result = source.asSubclass(desc);
            if (result == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private Type getValueType(Class clazz, String property) {
        if (clazz == null) {
            return null;
        }
        try {
            String strMethod = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            String strMethodByBoolean = "is" + property.substring(0, 1).toUpperCase() + property.substring(1);
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equalsIgnoreCase(strMethod) && !method.getName().equalsIgnoreCase(strMethodByBoolean)) continue;
                return method.getGenericReturnType();
            }
            return this.getValueType(clazz.getSuperclass(), property);
        }
        catch (SecurityException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Type getEntryValueType(IObjectCollection collection) {
        Class<?> returnType = null;
        String collectionClassName = collection.getClass().getName();
        String entryInfoClassName = collectionClassName.substring(0, collectionClassName.indexOf("Collection"));
        entryInfoClassName = entryInfoClassName + "Info";
        try {
            returnType = Class.forName(entryInfoClassName);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return returnType;
    }

    private Object getObjectValue(Object object, Class objectClass, String property) {
        if (object == null) {
            return null;
        }
        try {
            String strMethod = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            String strMethodByBoolean = "is" + property.substring(0, 1).toUpperCase() + property.substring(1);
            for (Method method : objectClass.getMethods()) {
                if (!method.getName().equalsIgnoreCase(strMethod) && !method.getName().equalsIgnoreCase(strMethodByBoolean)) continue;
                return method.invoke(object, null);
            }
            return this.getObjectValue(object, objectClass.getSuperclass(), property);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JsonElement serialize(IObjectValue objectValue, Type type, JsonSerializationContext context) {
        JsonPrimitive jsonElement = null;
        if (objectValue == null) {
            return null;
        }
        try {
            jsonElement = new JsonPrimitive(this.convertInfoToJson(objectValue));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jsonElement;
    }

    private String convertInfoToJson(IObjectValue objectValue) {
        try {
            StringBuilder jsonBuffer = new StringBuilder("");
            String jsonBufferNew = "";
            jsonBuffer.append("${leftbracket_2312415321232}");
            Enumeration enumeration = objectValue.keys();
            BOSObjectType bosType = objectValue.getBOSType();
            String fkey = "";
            if (bosType != null) {
                fkey = bosType.toString();
            }
            while (enumeration.hasMoreElements()) {
                SimpleDateFormat format;
                String key = (String)enumeration.nextElement();
                Map<String, Object> map = this.typeMap.get(fkey + key);
                Object value = objectValue.get(key);
                if (value == null) continue;
                Class dataType = null;
                String realKey = null;
                if (map != null) {
                    dataType = (Class)map.get("t");
                    realKey = (String)map.get("r");
                } else {
                    realKey = this.getRealByMetaData(objectValue.getBOSType(), key);
                    if (realKey == null && (realKey = this.getRealByEntity(objectValue.getClass(), key)) == null) {
                        realKey = key;
                    }
                    realKey = "${quote_2312415321232}" + realKey + "${quote_2312415321232}";
                    Type returnType = this.getValueType(objectValue.getClass(), key);
                    String returnTypeString = null;
                    returnTypeString = returnType != null ? returnType.toString() : value.getClass().toString();
                    String typeStr = returnTypeString.substring(returnTypeString.indexOf(" ") + 1);
                    dataType = this.getDataType(typeStr);
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("t", dataType);
                    m.put("r", realKey);
                    this.typeMap.put(fkey + key, m);
                }
                if (this.asSubClass(dataType, String.class)) {
                    jsonBuffer.append(realKey);
                    jsonBuffer.append(":");
                    jsonBuffer.append("${quote_2312415321232}");
                    jsonBuffer.append(value.toString());
                    jsonBuffer.append("${quote_2312415321232}");
                } else if (this.asSubClass(dataType, Number.class)) {
                    jsonBuffer.append(realKey);
                    jsonBuffer.append(":");
                    jsonBuffer.append(value.toString());
                } else if (this.asSubClass(dataType, IObjectValue.class)) {
                    String jsonStr;
                    jsonBuffer.append(realKey);
                    jsonBuffer.append(":");
                    IObjectValue objectVal = (IObjectValue)value;
                    Object id = objectVal.get("id");
                    String idStr = null;
                    if (id != null) {
                        idStr = ((BOSUuid)id).toString();
                        jsonStr = this.convertInfoToJson((IObjectValue)value);
                        jsonBuffer.append(jsonStr);
                    } else {
                        jsonStr = this.convertInfoToJson((IObjectValue)value);
                        jsonBuffer.append(jsonStr);
                    }
                } else if (this.asSubClass(dataType, Boolean.class)) {
                    jsonBuffer.append(realKey);
                    jsonBuffer.append(":");
                    jsonBuffer.append(value);
                } else if (this.asSubClass(dataType, IObjectCollection.class)) {
                    IObjectCollection objectCollection = (IObjectCollection)value;
                    jsonBuffer.append(realKey);
                    jsonBuffer.append(":[");
                    for (int nIndex = 0; nIndex < objectCollection.size(); ++nIndex) {
                        IObjectValue entryObject = objectCollection.getObject(nIndex);
                        jsonBuffer.append(this.convertInfoToJson(entryObject));
                        if (nIndex >= objectCollection.size() - 1) continue;
                        jsonBuffer.append(",");
                    }
                    jsonBuffer.append("]");
                } else if (this.asSubClass(dataType, Enum.class)) {
                    String strAlias;
                    IntEnum result = null;
                    if (IntEnum.class.isAssignableFrom(dataType)) {
                        result = EnumUtils.getEnum((Class)dataType, (int)TypeConversionUtils.objToInt((Object)value));
                    } else if (StringEnum.class.isAssignableFrom(dataType) || DynamicEnum.class.isAssignableFrom(dataType)) {
                        result = EnumUtils.getEnumByValue((Class)dataType, (String)TypeConversionUtils.objToString((Object)value));
                    } else if (FloatEnum.class.isAssignableFrom(dataType)) {
                        result = EnumUtils.getEnum((Class)dataType, (float)TypeConversionUtils.objToFloat((Object)value));
                    } else if (DoubleEnum.class.isAssignableFrom(dataType)) {
                        result = EnumUtils.getEnum((Class)dataType, (double)TypeConversionUtils.objToDouble((Object)value));
                    } else if (LongEnum.class.isAssignableFrom(dataType)) {
                        result = EnumUtils.getEnum((Class)dataType, (long)TypeConversionUtils.objToLong((Object)value));
                    }
                    if (result == null) {
                        result = (Enum)this.getObjectValue(objectValue, objectValue.getClass(), key);
                    }
                    if (result == null && value instanceof Enum) {
                        result = (Enum)value;
                    }
                    if (result == null) continue;
                    jsonBuffer.append(realKey);
                    jsonBuffer.append(":");
                    jsonBuffer.append("{");
                    jsonBuffer.append("${quote_2312415321232}");
                    jsonBuffer.append("isenum");
                    jsonBuffer.append("${quote_2312415321232}");
                    jsonBuffer.append(":true,");
                    if (this.asSubClass(dataType, IntEnum.class)) {
                        strAlias = result.getAlias(this.locale);
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append("alias");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(":");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(strAlias);
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(",");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append("value");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(":");
                        jsonBuffer.append(result.getValue());
                    } else if (this.asSubClass(dataType, FloatEnum.class)) {
                        strAlias = ((FloatEnum)result).getAlias(this.locale);
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append("alias");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(":");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(strAlias);
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(",");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append("value");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(":");
                        jsonBuffer.append(((FloatEnum)result).getValue());
                    } else if (this.asSubClass(dataType, DoubleEnum.class)) {
                        strAlias = ((DoubleEnum)result).getAlias(this.locale);
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append("alias");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(":");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(strAlias);
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(",");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append("value");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(":");
                        jsonBuffer.append(((DoubleEnum)result).getValue());
                    } else if (this.asSubClass(dataType, StringEnum.class)) {
                        strAlias = ((StringEnum)result).getAlias(this.locale);
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append("alias");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(":");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(strAlias);
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(",");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append("value");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(":");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(((StringEnum)result).getValue());
                        jsonBuffer.append("${quote_2312415321232}");
                    } else if (this.asSubClass(dataType, DynamicEnum.class)) {
                        strAlias = ((DynamicEnum)result).getAlias(this.locale);
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append("alias");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(":");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(strAlias);
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(",");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append("value");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(":");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(((DynamicEnum)result).getValue());
                        jsonBuffer.append("${quote_2312415321232}");
                    } else {
                        strAlias = result.getAlias(this.locale);
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append("alias");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(":");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(strAlias);
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(",");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append("value");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(":");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(result.toString());
                        jsonBuffer.append("${quote_2312415321232}");
                    }
                    jsonBuffer.append("}");
                } else if (this.asSubClass(dataType, BOSUuid.class)) {
                    jsonBuffer.append(realKey);
                    jsonBuffer.append(":");
                    jsonBuffer.append("${quote_2312415321232}");
                    jsonBuffer.append(value.toString());
                    jsonBuffer.append("${quote_2312415321232}");
                } else if (this.asSubClass(dataType, Timestamp.class)) {
                    format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    if (value instanceof String) {
                        jsonBuffer.append(realKey);
                        jsonBuffer.append(":");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(value);
                        jsonBuffer.append("${quote_2312415321232}");
                    } else {
                        jsonBuffer.append(realKey);
                        jsonBuffer.append(":");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(format.format((Date)value));
                        jsonBuffer.append("${quote_2312415321232}");
                    }
                } else if (this.asSubClass(dataType, Date.class)) {
                    format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    if (value instanceof String) {
                        jsonBuffer.append(realKey);
                        jsonBuffer.append(":");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(value);
                        jsonBuffer.append("${quote_2312415321232}");
                    } else {
                        jsonBuffer.append(realKey);
                        jsonBuffer.append(":");
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(format.format((Date)value));
                        jsonBuffer.append("${quote_2312415321232}");
                    }
                } else if (this.asSubClass(dataType, String[].class)) {
                    String[] arry = (String[])value;
                    jsonBuffer.append(realKey);
                    jsonBuffer.append(":[");
                    for (int nIndex = 0; nIndex < arry.length; ++nIndex) {
                        String str = arry[nIndex];
                        if (nIndex != 0) {
                            jsonBuffer.append(", ");
                        }
                        jsonBuffer.append("${quote_2312415321232}");
                        jsonBuffer.append(str);
                        jsonBuffer.append("${quote_2312415321232}");
                    }
                    jsonBuffer.append("]");
                } else {
                    jsonBuffer.append(realKey);
                    jsonBuffer.append(":");
                    jsonBuffer.append("${quote_2312415321232}");
                    jsonBuffer.append(value.toString());
                    jsonBuffer.append("${quote_2312415321232}");
                }
                if (!enumeration.hasMoreElements()) continue;
                jsonBuffer.append(",");
            }
            if (jsonBuffer.toString().trim().endsWith(",")) {
                jsonBufferNew = jsonBuffer.toString().substring(0, jsonBuffer.length() - 1);
            }
            if (StringUtils.isEmpty((String)jsonBufferNew)) {
                jsonBufferNew = jsonBuffer.toString();
            }
            jsonBufferNew = jsonBufferNew + "${rightbracket_2312415321232}";
            return jsonBufferNew;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getRealByMetaData(BOSObjectType bosType, String key) {
        block4: {
            try {
                EntityObjectInfo entityObjectInfo;
                if (!StringUtils.isEmpty((String)key) && (entityObjectInfo = BaseMetaDataUtil.getEntityObjectInfo(this.ctx, bosType)) != null) {
                    PropertyCollection propertyCollection = entityObjectInfo.getDuplicatedEntityProperties();
                    int size = propertyCollection.size();
                    for (int i = 0; i < size; ++i) {
                        if (!key.equalsIgnoreCase(propertyCollection.get(i).getName())) continue;
                        return propertyCollection.get(i).getName();
                    }
                }
            }
            catch (MetaDataNotFoundException e) {
                logger.error((Object)e.getMessage());
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private String getRealByEntity(Class clazz, String property) {
        if (clazz == null || property == null || property.equals("")) {
            return null;
        }
        Method[] methods = clazz.getDeclaredMethods();
        String strOldKey = "get" + property;
        String strOldKeyByBoolean = "is" + property;
        for (Method method : methods) {
            if (method.getName().equalsIgnoreCase(strOldKey)) {
                String fieldName = method.getName().substring(3);
                return fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
            }
            if (!method.getName().equalsIgnoreCase(strOldKeyByBoolean)) continue;
            String fieldName = method.getName().substring(2);
            return fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
        }
        return this.getRealByEntity(clazz.getSuperclass(), property);
    }
}

