/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.query;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.QueryHelper;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.query.ISHRSQLDataAccess;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SHRSQLDataAccess
extends AbstractBOSObject
implements ISHRSQLDataAccess {
    QueryExecuteOption option = new QueryExecuteOption();
    Map<String, BizEnumValueInfo> cache = new HashMap<String, BizEnumValueInfo>();
    Map<String, Boolean> enumPkCache = new HashMap<String, Boolean>();
    SelectorInfo selector = null;
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"SQLQ");
    private static final Logger logger = Logger.getLogger(SHRSQLDataAccess.class);

    public SHRSQLDataAccess() {
        this.registerInterface(ISHRSQLDataAccess.class, this);
    }

    public SHRSQLDataAccess(Context ctx) {
        super(ctx);
        this.registerInterface(ISHRSQLDataAccess.class, this);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    @Override
    public QueryExecuteOption getOption() {
        return this.option;
    }

    @Override
    public void setOption(QueryExecuteOption option) {
        this.option = option;
    }

    public Map<String, BizEnumValueInfo> getCache() {
        return this.cache;
    }

    public void setCache(Map<String, BizEnumValueInfo> cache) {
        this.cache = cache;
    }

    public Map<String, Boolean> getEnumPkCache() {
        return this.enumPkCache;
    }

    public void setEnumPkCache(Map<String, Boolean> enumPkCache) {
        this.enumPkCache = enumPkCache;
    }

    @Override
    public SelectorInfo getSelector() {
        return this.selector;
    }

    @Override
    public void setSelector(SelectorInfo selector) {
        this.selector = selector;
    }

    protected void populateRowSetCell(DynamicRowSet rowset, ResultSet rs, int col) throws SQLException {
        block122: {
            try {
                Map map = rowset.getRowSetMetaData().getExtendedProperties(col);
                if (map.get("FieldInfo") == null) {
                    this.toBeRowSetCell(rowset, rs, col);
                    return;
                }
                QueryFieldInfo fieldInfo = (QueryFieldInfo)map.get("FieldInfo");
                ConstDataType tp = null;
                String datatype = "";
                if (fieldInfo.getPropertyRefs().get(0) != null) {
                    datatype = fieldInfo.getPropertyRefs().get(0).getRefProperty().get("dataType").toString();
                }
                if ((tp = ConstDataType.getEnum((String)datatype) != null ? ConstDataType.getEnum((String)datatype) : ("Timestamp".equalsIgnoreCase(datatype) ? ConstDataType.getEnum((String)"Timestamp") : ("BigDecimal".equalsIgnoreCase(datatype) ? ConstDataType.getEnum((String)"Number") : ConstDataType.getEnum((String)"String")))).equals((Object)ConstDataType.ENUM)) {
                    tp = ConstDataType.getEnum((String)fieldInfo.getReturnType().toString());
                }
                String fldName = fieldInfo.getName();
                if (tp.equals((Object)ConstDataType.STRING)) {
                    String colVal = rs.getString(col);
                    if (colVal == null) {
                        rowset.updateNull(col);
                    } else if (this.option.isAutoTranslateEnum) {
                        Boolean isAliableEnum = this.enumPkCache.get(fldName);
                        BizEnumInfo bizEnumInfo = this.getEnum(fieldInfo);
                        if (isAliableEnum == null) {
                            isAliableEnum = null == bizEnumInfo ? Boolean.valueOf(false) : Boolean.valueOf(true);
                            this.enumPkCache.put(fldName, isAliableEnum);
                        }
                        if (isAliableEnum.booleanValue()) {
                            String key = fieldInfo.getName() + colVal.toString();
                            BizEnumValueInfo value = this.cache.get(key);
                            if (value == null) {
                                if (null == bizEnumInfo) {
                                    bizEnumInfo = this.getEnum(fieldInfo);
                                }
                                if ((value = QueryHelper.getAliasFromEnumValue((BizEnumInfo)bizEnumInfo, (String)colVal)) != null) {
                                    this.cache.put(key, value);
                                }
                            }
                            rowset.updateObject(col, (Object)value);
                        } else {
                            rowset.updateString(col, colVal.intern());
                        }
                    } else {
                        rowset.updateString(col, colVal.intern());
                    }
                    break block122;
                }
                if (tp.equals((Object)ConstDataType.BOOLEAN)) {
                    int i;
                    Object colVal = rs.getObject(col);
                    if (colVal == null) {
                        rowset.updateNull(col);
                        break block122;
                    }
                    try {
                        i = TypeConversionUtils.objToInt((Object)colVal);
                    }
                    catch (IllegalConversionException e) {
                        throw new BOSException("Field ReturnType Conversion error. Field:" + fldName, (Throwable)e);
                    }
                    if (this.option.isAutoTranslateBoolean) {
                        rowset.updateObject(col, (Object)(i != 0 ? Boolean.TRUE : Boolean.FALSE));
                    } else {
                        rowset.updateInt(col, i);
                    }
                    break block122;
                }
                if (tp.equals((Object)ConstDataType.INT)) {
                    Object colVal = rs.getObject(col);
                    if (colVal instanceof BigDecimal) {
                        colVal = ((BigDecimal)colVal).intValue();
                    }
                    if (colVal instanceof Integer) {
                        int i = (Integer)colVal;
                        if (this.option.isAutoTranslateEnum) {
                            Boolean isAliableEnum = this.enumPkCache.get(fldName);
                            BizEnumInfo bizEnumInfo = this.getEnum(fieldInfo);
                            if (isAliableEnum == null) {
                                isAliableEnum = null == bizEnumInfo ? Boolean.valueOf(false) : Boolean.valueOf(true);
                                this.enumPkCache.put(fldName, isAliableEnum);
                            }
                            if (isAliableEnum.booleanValue()) {
                                String key = fieldInfo.getName() + colVal.toString();
                                BizEnumValueInfo value = this.cache.get(key);
                                if (value == null) {
                                    if (null == bizEnumInfo) {
                                        bizEnumInfo = this.getEnum(fieldInfo);
                                    }
                                    if ((value = QueryHelper.getAliasFromEnumValue((BizEnumInfo)bizEnumInfo, (int)i)) != null) {
                                        this.cache.put(key, value);
                                    }
                                }
                                rowset.updateObject(col, (Object)value);
                            } else if (this.option.isAutoIgnoreZero && i == 0) {
                                rowset.updateNull(col);
                            } else {
                                rowset.updateInt(col, i);
                            }
                        } else if (this.option.isAutoIgnoreZero && i == 0) {
                            rowset.updateNull(col);
                        } else {
                            rowset.updateInt(col, i);
                        }
                        break block122;
                    }
                    if (colVal instanceof Byte) {
                        byte b = (Byte)colVal;
                        if (this.option.isAutoIgnoreZero && b == 0) {
                            rowset.updateNull(col);
                        } else {
                            rowset.updateByte(col, b);
                        }
                        break block122;
                    }
                    if (colVal instanceof Long) {
                        long l = (Long)colVal;
                        if (this.option.isAutoTranslateEnum) {
                            Boolean isAliableEnum = this.enumPkCache.get(fldName);
                            BizEnumInfo bizEnumInfo = this.getEnum(fieldInfo);
                            if (isAliableEnum == null) {
                                isAliableEnum = null == bizEnumInfo ? Boolean.valueOf(false) : Boolean.valueOf(true);
                                this.enumPkCache.put(fldName, isAliableEnum);
                            }
                            if (isAliableEnum.booleanValue()) {
                                String key = fieldInfo.getName() + colVal.toString();
                                BizEnumValueInfo value = this.cache.get(key);
                                if (value == null) {
                                    if (null == bizEnumInfo) {
                                        bizEnumInfo = this.getEnum(fieldInfo);
                                    }
                                    if ((value = QueryHelper.getAliasFromEnumValue((BizEnumInfo)bizEnumInfo, (long)l)) != null) {
                                        this.cache.put(key, value);
                                    }
                                }
                                rowset.updateObject(col, (Object)value);
                            } else if (this.option.isAutoIgnoreZero && l == 0L) {
                                rowset.updateNull(col);
                            } else {
                                rowset.updateLong(col, l);
                            }
                        } else if (this.option.isAutoIgnoreZero && l == 0L) {
                            rowset.updateNull(col);
                        } else {
                            rowset.updateLong(col, l);
                        }
                        break block122;
                    }
                    if (colVal instanceof String) {
                        if (this.option.isAutoTranslateEnum) {
                            Boolean isAliableEnum = this.enumPkCache.get(fldName);
                            BizEnumInfo bizEnumInfo = this.getEnum(fieldInfo);
                            if (isAliableEnum == null) {
                                isAliableEnum = null == bizEnumInfo ? Boolean.valueOf(false) : Boolean.valueOf(true);
                                this.enumPkCache.put(fldName, isAliableEnum);
                            }
                            if (isAliableEnum.booleanValue()) {
                                String key = fieldInfo.getName() + colVal.toString();
                                BizEnumValueInfo value = this.cache.get(key);
                                if (value == null) {
                                    try {
                                        int intValue = Integer.parseInt(colVal.toString());
                                        if (null == bizEnumInfo) {
                                            bizEnumInfo = this.getEnum(fieldInfo);
                                        }
                                        value = QueryHelper.getAliasFromEnumValue((BizEnumInfo)bizEnumInfo, (int)intValue);
                                    }
                                    catch (NumberFormatException intValue) {
                                        // empty catch block
                                    }
                                    if (value != null) {
                                        this.cache.put(key, value);
                                    }
                                }
                                rowset.updateObject(col, value == null ? colVal : value);
                                break block122;
                            }
                            rowset.updateObject(col, colVal);
                            break block122;
                        }
                        rowset.updateObject(col, colVal);
                        break block122;
                    }
                    rowset.updateObject(col, colVal);
                    break block122;
                }
                if (tp.equals((Object)ConstDataType.NUMBER)) {
                    Object colVal = rs.getObject(col);
                    if (colVal == null) {
                        rowset.updateNull(col);
                    } else if (colVal instanceof Float) {
                        float f = ((Float)colVal).floatValue();
                        if (this.option.isAutoTranslateEnum) {
                            Boolean isAliableEnum = this.enumPkCache.get(fldName);
                            BizEnumInfo bizEnumInfo = this.getEnum(fieldInfo);
                            if (isAliableEnum == null) {
                                isAliableEnum = null == bizEnumInfo ? Boolean.valueOf(false) : Boolean.valueOf(true);
                                this.enumPkCache.put(fldName, isAliableEnum);
                            }
                            if (isAliableEnum.booleanValue()) {
                                String key = fieldInfo.getName() + colVal.toString();
                                BizEnumValueInfo value = this.cache.get(key);
                                if (value == null) {
                                    if (null == bizEnumInfo) {
                                        bizEnumInfo = this.getEnum(fieldInfo);
                                    }
                                    if ((value = QueryHelper.getAliasFromEnumValue((BizEnumInfo)bizEnumInfo, (float)f)) != null) {
                                        this.cache.put(key, value);
                                    }
                                }
                                rowset.updateObject(col, (Object)value);
                            } else if (this.option.isAutoIgnoreZero && f == 0.0f) {
                                rowset.updateNull(col);
                            } else {
                                rowset.updateFloat(col, f);
                            }
                        } else if (this.option.isAutoIgnoreZero && f == 0.0f) {
                            rowset.updateNull(col);
                        } else {
                            rowset.updateFloat(col, f);
                        }
                    } else if (colVal instanceof Double) {
                        double d = (Double)colVal;
                        if (this.option.isAutoTranslateEnum) {
                            Boolean isAliableEnum = this.enumPkCache.get(fldName);
                            BizEnumInfo bizEnumInfo = this.getEnum(fieldInfo);
                            if (isAliableEnum == null) {
                                isAliableEnum = null == bizEnumInfo ? Boolean.valueOf(false) : Boolean.valueOf(true);
                                this.enumPkCache.put(fldName, isAliableEnum);
                            }
                            if (isAliableEnum.booleanValue()) {
                                String key = fieldInfo.getName() + colVal.toString();
                                BizEnumValueInfo value = this.cache.get(key);
                                if (this.cache.get(colVal) == null) {
                                    if (null == bizEnumInfo) {
                                        bizEnumInfo = this.getEnum(fieldInfo);
                                    }
                                    if ((value = QueryHelper.getAliasFromEnumValue((BizEnumInfo)bizEnumInfo, (double)d)) != null) {
                                        this.cache.put(key, value);
                                    }
                                }
                                rowset.updateObject(col, (Object)value);
                            } else if (this.option.isAutoIgnoreZero && d == 0.0) {
                                rowset.updateNull(col);
                            } else {
                                rowset.updateDouble(col, d);
                            }
                        } else if (this.option.isAutoIgnoreZero && d == 0.0) {
                            rowset.updateNull(col);
                        } else {
                            rowset.updateDouble(col, d);
                        }
                    } else if (colVal instanceof BigDecimal) {
                        BigDecimal bd = (BigDecimal)colVal;
                        if (this.option.isAutoIgnoreZero && bd.compareTo(BigDecimal.valueOf(0.0)) == 0) {
                            rowset.updateNull(col);
                        } else {
                            rowset.updateBigDecimal(col, bd);
                        }
                    } else {
                        rowset.updateObject(col, colVal);
                    }
                } else if (tp.equals((Object)ConstDataType.DATE)) {
                    Object colVal = rs.getObject(col);
                    if (colVal == null) {
                        rowset.updateNull(col);
                    } else if (colVal instanceof Date) {
                        Date da = (Date)colVal;
                        rowset.updateDate(col, da);
                    } else if (colVal instanceof Time) {
                        Time ti = (Time)colVal;
                        rowset.updateTime(col, ti);
                    } else if (colVal instanceof Timestamp) {
                        Timestamp ts = (Timestamp)colVal;
                        rowset.updateTimestamp(col, ts);
                    } else {
                        rowset.updateObject(col, colVal);
                    }
                } else if (tp.equals((Object)ConstDataType.TIME)) {
                    Object colVal = rs.getObject(col);
                    if (colVal == null) {
                        rowset.updateNull(col);
                    } else if (colVal instanceof Time) {
                        Time ti = (Time)colVal;
                        rowset.updateTime(col, ti);
                    } else if (colVal instanceof Timestamp) {
                        Timestamp ts = (Timestamp)colVal;
                        rowset.updateTimestamp(col, ts);
                    } else {
                        rowset.updateObject(col, colVal);
                    }
                } else if (tp.equals((Object)ConstDataType.TIMESTAMP)) {
                    Object colVal = rs.getObject(col);
                    if (colVal == null) {
                        rowset.updateNull(col);
                    } else if (colVal instanceof Timestamp) {
                        Timestamp ts = (Timestamp)colVal;
                        rowset.updateTimestamp(col, ts);
                    } else {
                        rowset.updateObject(col, colVal);
                    }
                } else {
                    rowset.updateObject(col, rs.getObject(col));
                }
            }
            catch (BOSException e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    protected void toBeRowSetCell(DynamicRowSet drs, ResultSet rs, int i) throws SQLException {
        int type = rs.getMetaData().getColumnType(i);
        Object colValue = rs.getObject(i);
        if (colValue == null) {
            drs.updateNull(i);
        } else {
            switch (type) {
                case -7: {
                    drs.updateByte(i, rs.getByte(i));
                    break;
                }
                case 91: {
                    drs.updateDate(i, rs.getDate(i));
                    break;
                }
                case 92: {
                    drs.updateTime(i, rs.getTime(i));
                    break;
                }
                case 93: {
                    drs.updateTimestamp(i, rs.getTimestamp(i));
                    break;
                }
                case 4: {
                    drs.updateInt(i, rs.getInt(i));
                    break;
                }
                case 6: {
                    drs.updateFloat(i, rs.getFloat(i));
                    break;
                }
                case 3: {
                    drs.updateBigDecimal(i, rs.getBigDecimal(i));
                    break;
                }
                case 8: {
                    drs.updateDouble(i, rs.getDouble(i));
                    break;
                }
                case 5: {
                    drs.updateShort(i, rs.getShort(i));
                    break;
                }
                case -5: {
                    drs.updateLong(i, rs.getLong(i));
                    break;
                }
                default: {
                    drs.updateObject(i, colValue);
                }
            }
        }
    }

    private BizEnumInfo getEnum(QueryFieldInfo fld) throws BOSException {
        BizEnumInfo bizEnum = null;
        String metadataRef = SHRSQLDataAccess.getEnumClass(fld);
        if (StringUtils.isEmpty((String)metadataRef)) {
            return null;
        }
        String className = MetaDataUtils.getClassName((String)metadataRef);
        String packageName = MetaDataUtils.getPackageName((String)metadataRef);
        try {
            bizEnum = this.getBizEnum(MetaDataPK.create((String)packageName, (String)className));
        }
        catch (Exception be) {
            throw new BOSException((Throwable)be);
        }
        if (bizEnum != null) {
            return bizEnum;
        }
        throw new BOSException("Get BizEnumInfo message failed!");
    }

    protected BizEnumInfo getBizEnum(MetaDataPK pk) {
        return MetaDataLoader.getEnum((Context)this.getContext(), (IMetaDataPK)pk);
    }

    public IRowSet getRowSet(String sql) throws BOSException {
        return this.getRowSet(sql, null);
    }

    @Override
    public IRowSet getRowSet(String sql, Map<String, String> fieldsMpping) throws BOSException {
        DynamicRowSet dynamicRowSet;
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection();
            stmt = cn.prepareStatement(sql);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getRowSet()'s sql:\n" + sql));
            }
            int rowCount = 0;
            int idListSize = this.getCriticalIDSize();
            rs = this.excuteSQL(stmt);
            DynamicRowSet drs = this.createRowSet(rs, fieldsMpping);
            while (rs.next()) {
                drs.moveToInsertRow();
                for (int i = 1; i <= drs.getMetaData().getColumnCount(); ++i) {
                    this.populateRowSetCell(drs, rs, i);
                }
                drs.insertRow();
                if (idListSize == 0 || ++rowCount <= idListSize) continue;
                try {
                    throw new FetchedTooMuchRowsException("fetched too much rows:" + rowCount + " SQL: " + sql);
                }
                catch (SQLException sqle) {
                    logger.warn((Object)sqle.getMessage(), (Throwable)sqle);
                    throw sqle;
                }
            }
            drs.beforeFirst();
            dynamicRowSet = drs;
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("getRowSet(sql) sql " + sql));
                logger.error((Object)"getRowSet(sql) occur error ", (Throwable)sqle);
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return dynamicRowSet;
    }

    private DynamicRowSet createRowSet(ResultSet rs, Map<String, String> fieldsMpping) throws SQLException {
        if (this.getSelector() != null) {
            SelectorInfo selector = this.getSelector();
            ResultSetMetaData meta = rs.getMetaData();
            int colCount = meta.getColumnCount();
            DynamicRowSet drs = new DynamicRowSet(colCount);
            for (int ii = 1; ii <= colCount; ++ii) {
                String columnName;
                String realMetaFiledName = columnName = meta.getColumnName(ii);
                if (null != fieldsMpping && fieldsMpping.size() > 0 && fieldsMpping.containsKey(columnName)) {
                    realMetaFiledName = fieldsMpping.get(columnName);
                }
                ColInfo col = null;
                for (int i = 0; i < selector.size(); ++i) {
                    if (!realMetaFiledName.equalsIgnoreCase(selector.get(i).getName())) continue;
                    col = new ColInfo();
                    col.columnName = selector.get(i).getName();
                    col.columnLabel = selector.get(i).getDisplayName();
                    String datatype = "";
                    PropertyInfo _p_ = null;
                    if (selector.get(i).getPropertyRefs().get(0) != null) {
                        _p_ = selector.get(i).getPropertyRefs().get(0).getRefProperty();
                        datatype = selector.get(i).getPropertyRefs().get(0).getRefProperty().get("dataType").toString();
                    }
                    if (this.option.isAutoTranslateEnum && datatype.toLowerCase().contains("enum")) {
                        OwnPropertyInfo __p__ = (OwnPropertyInfo)_p_;
                        if (__p__ != null && !StringUtils.isEmpty((String)__p__.getMetaDataRef())) {
                            Enum objEnum;
                            List enumList2 = MetaDataUtil.getEnumList(__p__.getMetaDataRef());
                            col.colType = enumList2 != null && enumList2.size() > 0 ? ((objEnum = (Enum)enumList2.get(0)) instanceof StringEnum ? QueryUtil.getColumnType((ConstDataType)ConstDataType.getEnum((String)"String")) : (objEnum instanceof DynamicEnum ? 2000 : (objEnum instanceof LongEnum ? QueryUtil.getColumnType((ConstDataType)ConstDataType.getEnum((String)"Number")) : (objEnum instanceof IntEnum ? QueryUtil.getColumnType((ConstDataType)ConstDataType.getEnum((String)"Number")) : (objEnum instanceof FloatEnum ? QueryUtil.getColumnType((ConstDataType)ConstDataType.getEnum((String)"Number")) : (objEnum instanceof DoubleEnum ? QueryUtil.getColumnType((ConstDataType)ConstDataType.getEnum((String)"Number")) : 2000)))))) : 2000;
                        }
                    } else {
                        col.colType = ConstDataType.getEnum((String)datatype) != null ? QueryUtil.getColumnType((ConstDataType)ConstDataType.getEnum((String)datatype)) : ("Timestamp".equalsIgnoreCase(datatype) ? QueryUtil.getColumnType((ConstDataType)ConstDataType.getEnum((String)"Timestamp")) : ("BigDecimal".equalsIgnoreCase(datatype) ? QueryUtil.getColumnType((ConstDataType)ConstDataType.getEnum((String)"Number")) : QueryUtil.getColumnType((ConstDataType)ConstDataType.getEnum((String)"String"))));
                    }
                    col.extendedProperties().put("FieldInfo", selector.get(i));
                    break;
                }
                if (col == null) {
                    col = new ColInfo(meta.getColumnName(ii), meta.getColumnLabel(ii), meta.getColumnType(ii), null);
                }
                drs.setColInfo(ii, col);
            }
            return drs;
        }
        ResultSetMetaData meta = rs.getMetaData();
        int colCount = meta.getColumnCount();
        DynamicRowSet drs = new DynamicRowSet(colCount);
        for (int i = 1; i < colCount + 1; ++i) {
            ColInfo col = new ColInfo(meta.getColumnName(i), meta.getColumnLabel(i), meta.getColumnType(i), null);
            drs.setColInfo(i, col);
        }
        return drs;
    }

    private ResultSet excuteSQL(PreparedStatement stmt) throws SQLException {
        return stmt.executeQuery();
    }

    protected SolutionInfo getSolution() {
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext()).getSolution();
    }

    protected Connection getConnection() throws SQLException {
        return EJBFactory.getQueryConnection((Context)this.getContext());
    }

    protected int getCriticalIDSize() {
        IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
        return manager.getCriticalIDList();
    }

    public static boolean isAliableEnum(QueryFieldInfo fieldInfo) {
        return !StringUtils.isEmpty((String)SHRSQLDataAccess.getEnumClass(fieldInfo));
    }

    private static String getEnumClass(QueryFieldInfo fieldInfo) {
        if (fieldInfo.getPropertyRefs().size() <= 0) {
            return null;
        }
        if (StringUtils.isEmpty((String)fieldInfo.getName())) {
            return null;
        }
        String realFieldName = "";
        realFieldName = fieldInfo.getName().indexOf(".") > 0 ? fieldInfo.getName().split("\\.")[1] : fieldInfo.getName();
        int total = fieldInfo.getPropertyRefs().size();
        for (int i = 0; i < total; ++i) {
            OwnPropertyInfo ownPropertyInfo;
            PropertyRefInfo ref = fieldInfo.getPropertyRefs().get(i);
            if (null == ref || null == ref.getSubEntity() || null == ref.getRefProperty() || !(ref.getRefProperty() instanceof OwnPropertyInfo) || !(ownPropertyInfo = (OwnPropertyInfo)ref.getRefProperty()).getName().equals(realFieldName) || !ownPropertyInfo.getDataType().equals((Object)DataType.ENUM)) continue;
            return ownPropertyInfo.getMetaDataRef();
        }
        return null;
    }
}

