/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inte.cq.util;

import com.kingdee.shr.inte.cq.ex.APIException;
import com.kingdee.shr.inte.cq.msg.ResultCode;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class SignUtils {
    private static final String SIGNATURE_TIME_RANGE_MINUTES = "signature_time_range_minutes";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private static final String SHA256 = "HmacSHA256";
    public static String SIGNATUR_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static String SIGNATUR_PARAMS = "signature";
    private static Logger logger = Logger.getLogger(SignUtils.class);

    public static String genHmacSHA1(String data, String key) {
        try {
            if (!StringUtils.isEmpty((String)data) && !StringUtils.isEmpty((String)key)) {
                SecretKeySpec signKey = new SecretKeySpec(key.getBytes("UTF-8"), HMAC_SHA1_ALGORITHM);
                Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
                mac.init(signKey);
                byte[] rawHmac = mac.doFinal(data.getBytes("UTF-8"));
                byte[] result = Base64.encodeBase64((byte[])rawHmac);
                return null != result ? new String(result, "UTF-8") : null;
            }
            return null;
        }
        catch (Exception var6) {
            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)var6));
            throw APIException.of(ResultCode.BUSINESS_ERROR_CODE_EXCEPTION, var6.getMessage());
        }
    }

    public static String genSHA256(String data, String key) {
        try {
            if (!StringUtils.isEmpty((String)data) && !StringUtils.isEmpty((String)key)) {
                SecretKeySpec signKey = new SecretKeySpec(key.getBytes("UTF-8"), SHA256);
                Mac mac = Mac.getInstance(SHA256);
                mac.init(signKey);
                byte[] rawHmac = mac.doFinal(data.getBytes("UTF-8"));
                byte[] result = Base64.encodeBase64((byte[])rawHmac);
                return null != result ? new String(result, "UTF-8") : null;
            }
            return null;
        }
        catch (Exception var6) {
            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)var6));
            throw APIException.of(ResultCode.BUSINESS_ERROR_CODE_EXCEPTION, var6.getMessage());
        }
    }

    public static String genSHA256(String data) {
        try {
            if (StringUtils.isEmpty((String)data)) {
                return null;
            }
            Mac mac = Mac.getInstance(SHA256);
            byte[] rawHmac = mac.doFinal(data.getBytes("UTF-8"));
            byte[] result = Base64.encodeBase64((byte[])rawHmac);
            return null != result ? new String(result, "UTF-8") : null;
        }
        catch (Exception var4) {
            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)var4));
            throw APIException.of(ResultCode.BUSINESS_ERROR_CODE_EXCEPTION, var4.getMessage());
        }
    }

    public static String getSHA256StrJava1(String str) {
        String encodeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodeStr = SignUtils.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException var4) {
            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)var4));
        }
        catch (UnsupportedEncodingException var5) {
            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)var5));
        }
        return encodeStr;
    }

    public static String HMACSHA256StrByKey(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance(SHA256);
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), SHA256);
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        byte[] var6 = array;
        int var7 = array.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            byte item = var6[var8];
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

    public static String genSign(String signKey, String openId, String sourceType, List<String> sourceIds) throws Exception {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(openId);
        vals.add(sourceType);
        vals.addAll(sourceIds);
        Collections.sort(vals, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        String sortedVal = SignUtils.join(vals, "&");
        return SignUtils.genHmacSHA1(sortedVal, signKey);
    }

    private static String join(List<String> list, String sign) {
        StringBuilder returnValue = new StringBuilder();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (i != 0) {
                    returnValue.append(sign);
                }
                returnValue.append(list.get(i));
            }
        }
        return returnValue.toString();
    }

    public static int getSignRangeMinutes(String tenantId) {
        int returnValue = 10;
        String signRangeMinuteString = System.getProperty(tenantId + "_signature_time_range_minutes");
        if (StringUtils.isEmpty((String)signRangeMinuteString)) {
            signRangeMinuteString = System.getProperty(SIGNATURE_TIME_RANGE_MINUTES);
            return returnValue;
        }
        try {
            returnValue = Integer.parseInt(signRangeMinuteString);
        }
        catch (Exception var4) {
            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)var4));
        }
        return returnValue;
    }
}

