/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.message.client.impl;

import com.kingdee.bos.message.client.BizInterface;
import com.kingdee.bos.message.client.ConnectMonitor;
import com.kingdee.bos.message.client.KDMsgError;
import com.kingdee.bos.message.client.KDMsgListener;
import com.kingdee.bos.message.common.IllegalStreamException;
import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.message.common.KDMessageConverter;
import com.kingdee.bos.message.common.KDMessageConverterFactory;
import com.kingdee.bos.message.common.KDMessageTookit;
import com.kingdee.bos.message.common.KDMessageType;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class DefaultBizInterface
implements BizInterface {
    private boolean isLog = false;
    private static final int BEATHEART_INTERVAL = 10000;
    private String bizName;
    private String password;
    private String host;
    private int port;
    private Socket socket = null;
    private Thread beatHeart;
    private Thread receive;
    private Object beatHeartMutex = new Object();
    private Object reConnectMutex = new Object();
    private boolean waitTestResp;
    private boolean isConnected;
    private boolean isStopped;
    private Vector msgListeners;
    private ConnectMonitor monitor;
    private KDMessageConverter convert = KDMessageConverterFactory.createConvert();
    private boolean isReconnected;
    private Vector reConnectGroups;
    private Hashtable sendMsgs = new Hashtable();

    public DefaultBizInterface() {
        this.reConnectGroups = new Vector();
        this.msgListeners = new Vector();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public synchronized boolean connect(String host, int port, String bizName, String password) {
        if (bizName == null || bizName.trim().equals("")) {
            KDMsgError error = new KDMsgError(2, "please enter the loginName ");
            this.broadCast(error);
            return false;
        }
        this.disConnect();
        this.host = host;
        this.port = port;
        try {
            this.newConnect();
        }
        catch (UnknownHostException e1) {
            this.logger("\u9519\u8bef\u7684\u670d\u52a1\u5668\u5730\u5740\u548c\u7aef\u53e3" + host + ":" + port);
            KDMsgError error = new KDMsgError(7, e1);
            this.broadCast(error);
            return false;
        }
        catch (IOException e1) {
            this.logger("Login Io Error " + e1.getMessage() + host + ":" + port);
            KDMsgError error = new KDMsgError(2, e1);
            this.broadCast(error);
            return false;
        }
        this.bizName = bizName;
        this.password = password;
        boolean success = false;
        try {
            success = this.login();
        }
        catch (IOException e) {
            this.logger("Login IO Error " + e.getMessage() + host + ":" + port);
            KDMsgError error = new KDMsgError(2, e);
            this.broadCast(error);
            return false;
        }
        if (success) {
            this.startThreads();
        }
        return success;
    }

    private void startThreads() {
        this.isStopped = false;
        this.isConnected = true;
        this.notifyConnect();
        this.receive = new Thread((Runnable)new Receive(), "receive");
        this.beatHeart = new Thread((Runnable)new BeatHeart(), "beatHeart");
        this.receive.start();
        this.beatHeart.start();
    }

    private void notifyConnect() {
        DefaultBizInterface ins = this;
        if (this.monitor != null) {
            new Thread(new Runnable(){

                public void run() {
                    DefaultBizInterface.this.monitor.onConnect();
                }
            }).start();
        }
    }

    private void stopThreads() {
        if (this.receive != null) {
            this.receive.interrupt();
            try {
                this.receive.join();
            }
            catch (InterruptedException e) {
                this.logger("receive Thread been interrupted");
            }
            this.logger("receive Thread has stoped!");
            this.receive = null;
        }
        if (this.beatHeart != null) {
            this.beatHeart.interrupt();
            try {
                this.beatHeart.join();
            }
            catch (InterruptedException e) {
                this.logger("beat Thread Heart interrupted!");
            }
            this.logger("beatHeart Thread has stoped!");
            this.beatHeart = null;
        }
    }

    public synchronized void disConnect() {
        this.isStopped = true;
        this.closeIO();
        for (int i = 0; i < this.reConnectGroups.size(); ++i) {
            ((Thread)this.reConnectGroups.elementAt(i)).interrupt();
            try {
                ((Thread)this.reConnectGroups.elementAt(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.reConnectGroups.removeAllElements();
        this.stopThreads();
        this.isConnected = false;
        this.logger("DisConnect OK!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(KDMessage msg) {
        boolean success = false;
        if (this.isConnected) {
            try {
                String msgId = msg.getId();
                if (msgId != null) {
                    this.sendMsgs.put(msgId, msgId);
                }
                this.sendMsg(msg);
                for (int count = 0; this.sendMsgs.containsKey(msgId) && count < 5; ++count) {
                    Hashtable hashtable = this.sendMsgs;
                    synchronized (hashtable) {
                        try {
                            this.sendMsgs.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return false;
                        }
                    }
                }
                if (!this.sendMsgs.containsKey(msgId)) {
                    success = true;
                }
                this.sendMsgs.remove(msgId);
                this.logger("Send Msg OK!");
            }
            catch (SocketException ex) {
                this.isConnected = false;
            }
            catch (IOException e) {
                KDMsgError error = new KDMsgError(5, e);
                this.broadCast(error);
                success = false;
            }
        }
        return success;
    }

    public void addMsgListener(KDMsgListener listener) {
        this.msgListeners.addElement(listener);
    }

    public void addConnectMonitor(ConnectMonitor monitor) {
        this.monitor = monitor;
    }

    private boolean sendMsg(KDMessage msg) throws SocketException, IOException {
        if (this.socket == null) {
            this.logger("socket is null");
            throw new SocketException();
        }
        OutputStream out = this.socket.getOutputStream();
        if (out == null) {
            this.logger("OutputStream is null");
            throw new SocketException();
        }
        msg = this.formatSendAddr(msg);
        this.convert.exportMessage(msg, this.socket.getOutputStream());
        return true;
    }

    private void broadCast(final KDMsgError error) {
        new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < DefaultBizInterface.this.msgListeners.size(); ++i) {
                    KDMsgListener listener = (KDMsgListener)DefaultBizInterface.this.msgListeners.elementAt(i);
                    listener.onError(error);
                }
            }
        }).start();
    }

    private void closeIO() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.isConnected = false;
        }
        this.socket = null;
    }

    private void broadCast(final KDMessage msg) {
        new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < DefaultBizInterface.this.msgListeners.size(); ++i) {
                    KDMsgListener listener = (KDMsgListener)DefaultBizInterface.this.msgListeners.elementAt(i);
                    listener.onMessage(msg);
                }
            }
        }).start();
    }

    private KDMessage formatSendAddr(KDMessage msg) {
        if (msg.getSender() == null) {
            KDMessageAddress address = new KDMessageAddress(this.bizName, this.bizName);
            msg.setSender(address);
        }
        return msg;
    }

    private boolean login() throws IOException {
        boolean success = false;
        KDMessage request = KDMessageTookit.getMsgForStart(this.bizName, this.password);
        this.sendMsg(request);
        KDMessage response = null;
        response = this.recieve();
        KDMsgError error = null;
        if (response == null) {
            error = new KDMsgError(9, "connot receive the response");
            return false;
        }
        KDMessageType type = response.getType();
        if (type == null) {
            return false;
        }
        switch (type.getIntValue()) {
            case 20: {
                this.logger("Login Failure\uff0cCause:\u8bbe\u5907[" + this.bizName + "] \u4e0e\u5bc6\u7801 '" + this.password + "' \u4e0d\u5339\u914d!");
                error = new KDMsgError(8, "\u8bbe\u5907[" + this.bizName + "] \u4e0e\u5bc6\u7801 '" + this.password + "' \u4e0d\u5339\u914d!");
                break;
            }
            case 25: {
                this.logger("Login Failure\uff0cCause:\u8bbe\u5907[" + this.bizName + "] \u6ca1\u6709\u5728\u901a\u8baf\u5e73\u53f0\u4e2d\u6ce8\u518c.\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb");
                error = new KDMsgError(8, "\u8bbe\u5907[" + this.bizName + "] \u6ca1\u6709\u5728\u901a\u8baf\u5e73\u53f0\u4e2d\u6ce8\u518c.\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb");
                break;
            }
            case 21: {
                this.logger("Login Failure\uff0cCause:\u5ba2\u6237\u7aef\u8fde\u63a5\u6570\u592a\u591a,\u8bf7\u7a0d\u5019\u91cd\u8fde");
                error = new KDMsgError(10, "\u5ba2\u6237\u7aef\u8fde\u63a5\u6570\u592a\u591a,\u8bf7\u7a0d\u5019\u91cd\u8fde");
                break;
            }
            case 22: {
                this.logger("Login Failure\uff0cCause:License\u68c0\u67e5\u5931\u8d25");
                error = new KDMsgError(11, "License\u68c0\u67e5\u5931\u8d25");
                break;
            }
            case 24: {
                this.logger("Login Failure\uff0cCause:\u505c\u6b62\u542f\u52a8\u8bbe\u5907\u5931\u8d25");
                error = new KDMsgError(2, "\u505c\u6b62\u542f\u52a8\u8bbe\u5907\u5931\u8d25");
                break;
            }
            case 23: {
                this.logger("Login Failure\uff0cCause:\u670d\u52a1\u5668\u7aef\u5df2\u7ecf\u5b58\u5728\u4e00\u4e2a\u540c\u540d\u7684\u8bbe\u5907\u5b9e\u4f8b");
                error = new KDMsgError(2, "\u670d\u52a1\u5668\u7aef\u5df2\u7ecf\u5b58\u5728\u4e00\u4e2a\u540c\u540d\u7684\u8bbe\u5907\u5b9e\u4f8b");
                break;
            }
            case 256: {
                success = true;
                this.logger("Login OK!");
                break;
            }
            default: {
                this.logger("Login Failure\uff0cCause" + response.getTitle());
                error = new KDMsgError(2, "\u5176\u4ed6\u9519\u8bef");
            }
        }
        if (error != null) {
            this.broadCast(error);
            this.closeIO();
        }
        return success;
    }

    private KDMessage recieve() throws IOException {
        KDMessage msg = null;
        try {
            msg = this.convert.importMessage(this.socket.getInputStream());
        }
        catch (IllegalStreamException e) {
            e.printStackTrace();
        }
        return msg;
    }

    private boolean reConnectServer() throws IOException {
        if (this.isStopped) {
            return false;
        }
        try {
            this.newConnect();
        }
        catch (UnknownHostException e) {
            this.logger("UnknowHost And Port" + this.host + " :" + this.port);
            return false;
        }
        catch (IOException e) {
            this.logger("Create Socket is Error " + e.getMessage());
            return false;
        }
        return this.login();
    }

    private void newConnect() throws UnknownHostException, IOException {
        this.closeIO();
        this.socket = new Socket(this.host, this.port);
    }

    private long getRandomInterval() {
        long interval = (long)Math.random() * 10000L;
        return 10000L + interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReConnect() {
        Object object = this.reConnectMutex;
        synchronized (object) {
            this.closeIO();
            this.notifyClose();
            if (!this.isReconnected) {
                this.isReconnected = true;
                Thread temp = new Thread((Runnable)new ReConnect(), "Reconnect_" + System.currentTimeMillis());
                this.reConnectGroups.addElement(temp);
                temp.start();
            }
        }
    }

    private void notifyClose() {
        DefaultBizInterface ins = this;
        if (this.monitor != null) {
            new Thread(new Runnable(){

                public void run() {
                    DefaultBizInterface.this.monitor.onClose();
                }
            }).start();
        }
    }

    private void logger(String content) {
        if (this.isLog) {
            Date d = new Date();
            System.out.print(d.toString());
            System.out.print("  [" + Thread.currentThread().getName() + "] ");
            System.out.print(content);
            System.out.print("\r\n");
        }
    }

    private class ReConnect
    implements Runnable {
        private ReConnect() {
        }

        public void run() {
            DefaultBizInterface.this.isConnected = false;
            DefaultBizInterface.this.stopThreads();
            while (!DefaultBizInterface.this.isStopped) {
                try {
                    if (DefaultBizInterface.this.reConnectServer()) {
                        DefaultBizInterface.this.startThreads();
                        break;
                    }
                    Thread.sleep(DefaultBizInterface.this.getRandomInterval());
                }
                catch (IOException e) {
                    DefaultBizInterface.this.logger("Reconnect the Serve " + DefaultBizInterface.this.host + ":" + DefaultBizInterface.this.port + " error!");
                }
                catch (InterruptedException ex) {
                    DefaultBizInterface.this.logger("ReConnect has been interrupted!");
                    break;
                }
                catch (Exception ex) {
                    // empty catch block
                    break;
                }
            }
            DefaultBizInterface.this.isReconnected = false;
        }
    }

    private class BeatHeart
    implements Runnable {
        private BeatHeart() {
        }

        public void run() {
            int failCount = 0;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                return;
            }
            while (!DefaultBizInterface.this.isStopped && DefaultBizInterface.this.isConnected) {
                try {
                    this.sendBeartHeart();
                    if (DefaultBizInterface.this.waitTestResp) {
                        if (failCount++ < 2) continue;
                        DefaultBizInterface.this.isConnected = false;
                        break;
                    }
                    failCount = 0;
                    Thread.sleep(10000L);
                }
                catch (SocketException ex) {
                    DefaultBizInterface.this.logger(ex.getMessage());
                    DefaultBizInterface.this.isConnected = false;
                    break;
                }
                catch (IOException ex) {
                    DefaultBizInterface.this.logger(ex.getMessage());
                    break;
                }
                catch (InterruptedException e) {
                    DefaultBizInterface.this.logger("BeatHeart has been interrupted!");
                    break;
                }
                catch (Exception ex) {
                    DefaultBizInterface.this.logger(ex.getMessage());
                }
            }
            if (!DefaultBizInterface.this.isConnected) {
                DefaultBizInterface.this.onReConnect();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendBeartHeart() throws IOException, InterruptedException {
            KDMessage msg = new KDMessage();
            msg.setType(KDMessageType.BEATHEART);
            Object object = DefaultBizInterface.this.beatHeartMutex;
            synchronized (object) {
                DefaultBizInterface.this.waitTestResp = true;
                DefaultBizInterface.this.logger("send Beat Heart Msg ok !");
                DefaultBizInterface.this.sendMsg(msg);
                DefaultBizInterface.this.beatHeartMutex.wait(10000L);
            }
        }
    }

    private class Receive
    implements Runnable {
        private Receive() {
        }

        public void run() {
            while (!DefaultBizInterface.this.isStopped && DefaultBizInterface.this.isConnected) {
                KDMessage msg = null;
                try {
                    msg = DefaultBizInterface.this.recieve();
                    if (msg == null) continue;
                    this.onreceiveMsg(msg);
                }
                catch (IOException ex) {
                    DefaultBizInterface.this.isConnected = false;
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (!DefaultBizInterface.this.isConnected) {
                DefaultBizInterface.this.onReConnect();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onreceiveMsg(KDMessage msg) {
            switch (msg.getType().getIntValue()) {
                case 32: {
                    DefaultBizInterface.this.logger("Receive KickOut Msg  from Server");
                    DefaultBizInterface.this.disConnect();
                    break;
                }
                case 128: {
                    this.onBeatHeartResp();
                    break;
                }
                case 1024: {
                    this.onBeatHeartResp();
                    DefaultBizInterface.this.sendMsgs.remove(msg.getId());
                    Hashtable hashtable = DefaultBizInterface.this.sendMsgs;
                    synchronized (hashtable) {
                        DefaultBizInterface.this.sendMsgs.notifyAll();
                        break;
                    }
                }
                default: {
                    this.onBeatHeartResp();
                    DefaultBizInterface.this.broadCast(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onBeatHeartResp() {
            Object object = DefaultBizInterface.this.beatHeartMutex;
            synchronized (object) {
                DefaultBizInterface.this.waitTestResp = false;
                DefaultBizInterface.this.beatHeartMutex.notifyAll();
            }
        }
    }
}

