/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.message.common;

import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.message.common.KDMessageType;
import com.kingdee.bos.message.common.KDMimeType;
import com.kingdee.bos.message.common.util.Uuid;
import java.io.Serializable;

public class KDMessage
implements Serializable {
    private String id;
    private String title;
    private String content;
    private String relativeId;
    private String customId;
    private KDMessageType type;
    private KDMimeType mimeType = KDMimeType.TEXT;
    private KDMessageAddress sender;
    private KDMessageAddress[] receivers;
    private KDMessageAttachment[] attachments;
    private int priority = 0;
    private int repeatTimes = 0;
    private boolean mixAddress = false;
    private boolean responsed = false;
    private String bizName = "";
    private int notSended = 0;

    public KDMessage() {
        this.id = Uuid.create().toString();
        this.type = KDMessageType.COMMON;
    }

    public KDMessageAttachment[] getAttachments() {
        return this.attachments;
    }

    public String getContent() {
        if (this.content == null) {
            this.content = "";
        }
        return this.content;
    }

    public String getId() {
        if (this.id == null) {
            this.id = "";
        }
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public KDMessageAddress[] getReceivers() {
        return this.receivers;
    }

    public String getRelativeId() {
        return this.relativeId;
    }

    public KDMessageAddress getSender() {
        return this.sender;
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = "";
        }
        return this.title;
    }

    public KDMessageType getType() {
        return this.type;
    }

    public void setAttachments(KDMessageAttachment[] attachments) {
        this.attachments = attachments;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setPriority(int i) {
        this.priority = i;
    }

    public void setReceivers(KDMessageAddress[] addresses) {
        this.receivers = addresses;
        if (addresses != null && addresses.length > 1) {
            String tempType = addresses[0].getDeviceName();
            for (int i = 1; i < addresses.length; ++i) {
                if (tempType.equalsIgnoreCase(addresses[i].getDeviceName())) continue;
                this.mixAddress = true;
                break;
            }
        }
        if (this.receivers != null) {
            this.notSended = this.receivers.length;
        }
    }

    public void setOnlyReceivers(KDMessageAddress[] addresses) {
        this.receivers = addresses;
        if (this.receivers != null) {
            this.notSended = this.receivers.length;
        }
    }

    public void setRelativeId(String string) {
        this.relativeId = string;
    }

    public void setSender(KDMessageAddress address) {
        this.sender = address;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setType(KDMessageType type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        KDMessage msg;
        if (obj instanceof KDMessage && (msg = (KDMessage)obj).getId().equals(this.id)) {
            return true;
        }
        return true;
    }

    public String getCustomId() {
        return this.customId;
    }

    public void setCustomId(String cid) {
        this.customId = cid;
    }

    public int getRepeatTimes() {
        return this.repeatTimes;
    }

    public int reSend() {
        ++this.repeatTimes;
        return this.repeatTimes;
    }

    public boolean isMixAddress() {
        return this.mixAddress;
    }

    public boolean isResponsed() {
        return this.responsed;
    }

    public void setRepeatTimes(int i) {
        this.repeatTimes = i;
    }

    public void setResponsed(boolean b) {
        this.responsed = b;
    }

    public boolean isRevertible() {
        return KDMessageType.REVERTIBLE.equals(this.type);
    }

    public boolean isSystem() {
        return KDMessageType.SYSTEM.equals(this.type);
    }

    public boolean isResponse() {
        return KDMessageType.RESPONSE.equals(this.type) && this.relativeId != null;
    }

    public boolean isNotify() {
        return KDMessageType.NOTIFY.equals(this.type);
    }

    public String getBizName() {
        return this.bizName;
    }

    public void setBizName(String bizName) {
        this.bizName = bizName;
    }

    public int getNotSended() {
        return this.notSended;
    }

    public void setNotSended(int notSended) {
        this.notSended = notSended;
    }

    public KDMimeType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(KDMimeType mimeType) {
        this.mimeType = mimeType;
    }
}

