/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.command;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.cloud.bean.AppManager;
import com.kingdee.bos.cloud.command.ICommand;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.tools.BizMetadataUtil;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.configure.IServerMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.eas.base.uict.CloudMainMenuFacadeFactory;
import com.kingdee.eas.base.uict.ICloudMainMenuFacade;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public abstract class AbstractCommand
implements ICommand {
    protected static final Logger logger = Logger.getLogger(AbstractCommand.class);
    private static final String SESSION_KEY_PROJECTNAME = "projectname";
    private static final String SESSION_KEY_USERNAME = "username";
    private static final String SESSION_KEY_MD_STORER_SERVER = "metadata_store_server";
    private static final String SESSION_KEY_MM_FACADE = "mainmenufacade";
    private static final String SESSION_KEY_BIZ_CTRL = "bizUnitCtrl";
    protected static final Project DEFAULT_PROJECT = new Project("always_on");
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    private boolean needLogin = true;

    @Override
    public void setContext(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public final boolean checkValidate() throws IOException, ServletException {
        if (this.isNeedLogin() && !this.checkLogin()) {
            return false;
        }
        return this.doCheckValidate();
    }

    public boolean doCheckValidate() throws IOException, ServletException {
        return true;
    }

    protected boolean isNeedLogin() {
        return this.needLogin;
    }

    protected void setNeedLogin(boolean flag) {
        this.needLogin = flag;
    }

    protected boolean checkLogin() throws IOException {
        boolean flag = StringUtils.isEmpty((String)this.getUserName());
        if (flag) {
            String ip = (String)this.request.getSession().getAttribute("kick_out");
            if (!StringUtils.isEmpty((String)ip)) {
                this.response.sendError(-10005, "<IP>" + ip + "</IP>");
            } else {
                this.response.sendError(-10004, "user hasn't login! please login first");
            }
            return false;
        }
        return true;
    }

    protected String getUserName() {
        return (String)this.request.getSession().getAttribute(SESSION_KEY_USERNAME);
    }

    protected String getProjectName() {
        return (String)this.request.getSession().getAttribute(SESSION_KEY_PROJECTNAME);
    }

    protected IServerMetadataStore getServerMetadataStore() throws IOException {
        HttpSession session = this.request.getSession();
        IServerMetadataStore store = (IServerMetadataStore)session.getAttribute(SESSION_KEY_MD_STORER_SERVER);
        if (store == null) {
            String projectName = (String)session.getAttribute(SESSION_KEY_PROJECTNAME);
            Context ctx = AppManager.getContext(projectName);
            store = MetadataStoreFactory.getServerMetadataStore((Context)ctx);
        }
        return store;
    }

    protected IMetaDataLoader getMetaDataLoader() throws IOException {
        HttpSession session = this.request.getSession();
        IMetaDataLoader loader = (IMetaDataLoader)session.getAttribute(SESSION_KEY_BIZ_CTRL);
        if (loader == null) {
            String projectName = (String)session.getAttribute(SESSION_KEY_PROJECTNAME);
            Context ctx = AppManager.getContext(projectName);
            loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        }
        return loader;
    }

    protected ICloudMainMenuFacade getCloudFacade() throws IOException {
        HttpSession session = this.request.getSession();
        ICloudMainMenuFacade facade = (ICloudMainMenuFacade)session.getAttribute(SESSION_KEY_MM_FACADE);
        if (facade == null) {
            String projectName = (String)session.getAttribute(SESSION_KEY_PROJECTNAME);
            Context ctx = AppManager.getContext(projectName);
            if ("zh_CN".equalsIgnoreCase(ctx.getLocale().getLanguage())) {
                ctx.setLocale(new Locale("l2"));
            }
            try {
                facade = CloudMainMenuFacadeFactory.getLocalInstance((Context)ctx);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return facade;
    }

    protected String[] getRelationMetas(String[] paths) throws Exception {
        IMDProject project = AppManager.getAppInfo(this.getProjectName()).getProject();
        IMDFolder root = project.getRoot();
        ArrayList list = new ArrayList();
        for (int i = 0; i < paths.length; ++i) {
            IMDFile file = root.getChildFile(paths[i]);
            BizMetadataUtil.getBizRelateMetas((IMDFile)file, list, (boolean)false);
        }
        String[] result = new String[list.size()];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = ((IMDFile)list.get(i)).getPath();
        }
        return result;
    }

    protected Connection getConnection() throws ClassNotFoundException, SQLException {
        return EJBFactory.getConnection((Context)AppManager.getContext(this.getProjectName()));
    }

    protected String getTrace(Exception ex) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        PrintStream print = new PrintStream(out);
        ex.printStackTrace(print);
        return new String(out.toByteArray());
    }

    @Override
    public void executeCommand() throws IOException, ServletException {
        if (!this.checkValidate()) {
            return;
        }
    }

    protected abstract void execute() throws IOException, ServletException;
}

