/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.command.impl;

import com.kingdee.bos.cloud.bean.AppInfo;
import com.kingdee.bos.cloud.bean.AppManager;
import com.kingdee.bos.cloud.command.AbstractCommand;
import com.kingdee.bos.cloud.utils.ResourceUtil;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.configure.IServerMetadataStore;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.bos.tool.utils.MD5;
import com.kingdee.bos.tool.utils.StringZipper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.uict.ICloudMainMenuFacade;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.servlet.ServletException;

public class StoreDynamicMetadataCommand
extends AbstractCommand {
    public static final String SQL_UPDATE_VIEW = "UPDATE T_BIM_MDVIEW SET fLastModifyUser=?, fLastModifyTime=? WHERE fProjectName=? AND fPath=? ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException, ServletException {
        IMDFile file;
        String pk = this.request.getParameter("metadatapk");
        if (StringUtils.isEmpty((String)pk)) {
            this.response.sendError(401, "metadatapk can't be empty");
            return;
        }
        AppInfo info = AppManager.getAppInfo(this.getProjectName());
        String md5 = this.request.getParameter("md5");
        String content = this.request.getParameter("content");
        String iszipped = this.request.getParameter("zipped");
        if ("1".equalsIgnoreCase(iszipped)) {
            byte[] contentbytes = Base64.decode((String)content);
            content = StringZipper.unzipStringFromBytes((byte[])contentbytes);
        }
        if (pk.endsWith("Resource.resource") && info.isSave2Disk() && (file = info.getProject().getRoot().getChildFile(pk)).toFile().exists()) {
            try {
                content = ResourceUtil.getMergedResource(content, file.toFile());
                MD5 md = new MD5();
                md.update(content.getBytes("UTF-8"));
                md5 = md.asHex();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (pk.equals("FnMenuTree.xml")) {
            ICloudMainMenuFacade facade = this.getCloudFacade();
            Connection conn = null;
            try {
                facade.storeMainMenuInfo(content);
                String projectName = this.getProjectName();
                String userName = this.getUserName();
                conn = this.getConnection();
                conn.setAutoCommit(true);
                PreparedStatement pstmt = conn.prepareStatement(SQL_UPDATE_VIEW);
                pstmt.setString(1, userName);
                pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(3, projectName);
                pstmt.setString(4, "FnMenuTree.xml");
                pstmt.executeUpdate();
                pstmt.close();
            }
            catch (Exception e) {
                this.response.sendError(401, "fail to store metadata:" + this.getTrace(e));
                return;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            return;
        }
        String alias = this.request.getParameter("alias");
        if (info.isSave2Disk()) {
            File file2 = new File(info.getProject().getSrcMetadataDir(), pk);
            if (!file2.exists()) {
                file2.getParentFile().mkdirs();
                file2.createNewFile();
            }
            try (FileOutputStream out = null;){
                out = new FileOutputStream(file2);
                out.write(content.getBytes("UTF-8"));
                out.flush();
            }
        }
        if (pk.endsWith(".log") || pk.endsWith(".permission")) {
            IServerMetadataStore store = this.getServerMetadataStore();
            MetaDataPK2 mpk = this.getMetadataPK(pk);
            try {
                store.saveXml(DEFAULT_PROJECT, (IMetaDataPK)mpk, BOSObjectType.create((String)mpk.getType()), content);
            }
            catch (Exception e) {
                this.response.sendError(401, "fail to store metadata:" + this.getTrace(e));
                return;
            }
        }
        try {
            this.storeMetadata(pk, md5, alias);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.response.sendError(601, "get connection error, pk: " + pk + ", alias: " + alias + ", md5:" + md5 + ", the track is:" + this.getTrace(ex));
            return;
        }
    }

    private MetaDataPK2 getMetadataPK(String path) {
        int index = path.lastIndexOf(46);
        String type = "";
        String fullName = null;
        if (index != -1) {
            fullName = StringUtils.replace((String)path.substring(0, index), (String)"/", (String)".");
            type = Utils.getBOSTypeBySuffix((String)path.substring(index + 1));
        } else {
            fullName = StringUtils.replace((String)path, (String)"/", (String)".");
        }
        return new MetaDataPK2(fullName, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMetadata(String path, String md5, String alias) throws Exception {
        Connection conn = null;
        String querySql = "SELECT fCheckOutUser FROM T_BIM_MDVIEW WHERE fProjectName=? AND fPath=?";
        String updateSql = "UPDATE T_BIM_MDVIEW SET fMD5=?, fAlias=?, fLastModifyUser=?, fLastModifyTime=? WHERE fProjectName=? AND fPath=? ";
        String insertSql = "INSERT T_BIM_MDVIEW (fProjectName, fPath, fMD5, fAlias, fCreator, fCreateTime) VALUES(?,?,?,?,?,?)";
        String projectName = this.getProjectName();
        String userName = this.getUserName();
        try {
            conn = this.getConnection();
            conn.setAutoCommit(true);
            PreparedStatement pstmt = conn.prepareStatement(querySql);
            pstmt.setString(1, projectName);
            pstmt.setString(2, path);
            ResultSet rs = pstmt.executeQuery();
            boolean isInsert = true;
            if (rs.next()) {
                isInsert = false;
                String user = rs.getString(1);
                if (!(StringUtils.isEmpty((String)user) || userName.equals(user) || "FnMenuTree.xml".equals(path))) {
                    throw new Exception("metadata [" + path + "] is check out by [" + user + "]");
                }
            }
            if (isInsert) {
                pstmt = conn.prepareStatement(insertSql);
                pstmt.setString(1, projectName);
                pstmt.setString(2, path);
                pstmt.setString(3, md5);
                if (alias != null && alias.length() > 40) {
                    alias = alias.substring(0, 40);
                }
                pstmt.setString(4, alias);
                pstmt.setString(5, userName);
                pstmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                pstmt.executeUpdate();
                pstmt.close();
            } else {
                pstmt = conn.prepareStatement(updateSql);
                pstmt.setString(1, md5);
                pstmt.setString(2, alias);
                if (alias != null && alias.length() > 40) {
                    alias = alias.substring(0, 40);
                }
                pstmt.setString(3, userName);
                pstmt.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(5, projectName);
                pstmt.setString(6, path);
                pstmt.executeUpdate();
                pstmt.close();
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

