/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.definition;

import com.kingdee.bos.eventbus.IEventBus;
import com.kingdee.bos.eventbus.KDEvent;
import com.kingdee.bos.eventbus.definition.Condition;
import com.kingdee.bos.eventbus.definition.Event;
import com.kingdee.bos.eventbus.definition.IDefinition;
import com.kingdee.bos.eventbus.definition.IDefinitionVisitor;
import com.kingdee.bos.eventbus.definition.IMetaMerge;
import com.kingdee.util.StringUtils;

public final class ActionDefinition
implements IDefinition,
Cloneable {
    private String actionName;
    private Event event;
    private String methodName;
    private String batchActionName;
    private String source;
    private Condition preCondition;

    private ActionDefinition(String actionName) {
        this.actionName = actionName;
    }

    ActionDefinition(String actionName, Event event, String methodName, String batchActionName) {
        this(actionName);
        this.event = event;
        this.methodName = methodName;
        this.batchActionName = batchActionName;
    }

    public static ActionDefinition createActionDefinition(String actionName, Event event, String methodName, String batchActionName) {
        return new ActionDefinition(actionName, event, methodName, batchActionName);
    }

    public Condition getPreCondition() {
        return this.preCondition;
    }

    void setPreCondition(Condition preCondition) {
        this.preCondition = preCondition;
    }

    public String getActionName() {
        return this.actionName;
    }

    public Event getEvent() {
        return this.event;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getBatchActionName() {
        return this.batchActionName;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void fireEvent(IEventBus eventBus, KDEvent event) {
        if (StringUtils.isEmpty((String)this.source)) {
            eventBus.fireEvent(event);
        } else {
            eventBus.fireEventFromSource(event, this.source);
        }
    }

    @Override
    public boolean isIntegral() {
        return this.actionName != null && this.event != null;
    }

    @Override
    public void mergeFrom(IMetaMerge from) {
        if (from == null || !(from instanceof ActionDefinition)) {
            return;
        }
        ActionDefinition fromAction = (ActionDefinition)from;
        if (this.event == null) {
            this.event = fromAction.event;
        }
        if (StringUtils.isEmpty((String)this.methodName)) {
            this.methodName = fromAction.methodName;
        }
        if (StringUtils.isEmpty((String)this.batchActionName)) {
            this.batchActionName = fromAction.batchActionName;
        }
        if (StringUtils.isEmpty((String)this.source)) {
            this.source = fromAction.source;
        }
        if (this.preCondition == null) {
            this.preCondition = fromAction.preCondition;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void accept(IDefinitionVisitor visitor) {
        visitor.visit(this);
    }

    public String getSource() {
        return this.source;
    }
}

