/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.definition;

import com.kingdee.bos.eventbus.IEventBus;
import com.kingdee.bos.eventbus.application.IApplication;
import com.kingdee.bos.eventbus.application.IApplicationInitilize;
import com.kingdee.bos.eventbus.application.IViewComponent;
import com.kingdee.bos.eventbus.definition.AbstractComponentMeta;
import com.kingdee.bos.eventbus.definition.ComponentType;
import com.kingdee.bos.eventbus.definition.IDefinitionVisitor;
import com.kingdee.bos.eventbus.definition.Reference;
import com.kingdee.bos.eventbus.definition.UIConfig;
import com.kingdee.bos.eventbus.exception.ComponentInstanceCreateException;
import com.kingdee.bos.eventbus.expression.ValueExpressionEvaluator;
import com.kingdee.bos.meta.MetaDTO;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Constructor;
import java.util.Collection;

public final class ApplicationDefinition
extends AbstractComponentMeta {
    private Collection<Reference> initializeServices;

    public void setInitializeServices(Collection<Reference> initializeServices) {
        this.initializeServices = initializeServices;
    }

    public ApplicationDefinition(String name) {
        super(name);
        this.type = ComponentType.APPLICATION;
    }

    @Override
    public boolean isIntegral() {
        return false;
    }

    public IApplication createApplication(IViewComponent view, UIConfig uiConfig, MetaDTO dto) {
        if (StringUtils.isEmpty((String)this.getName())) {
            return null;
        }
        Class clazz = this.findClass();
        try {
            Constructor constructor = this.findConstructor(clazz, new Class[]{view.getClass(), UIConfig.class, MetaDTO.class});
            IApplication application = (IApplication)constructor.newInstance(view, uiConfig, dto);
            this.afterCreateApplication(application);
            return application;
        }
        catch (Exception e) {
            throw new ComponentInstanceCreateException(String.format("The creation of application %s failed!", this.getName()), e);
        }
    }

    private Constructor findConstructor(Class clazz, Class[] classTypes) {
        Constructor<?>[] cons;
        for (Constructor<?> con : cons = clazz.getConstructors()) {
            Class<?>[] types = con.getParameterTypes();
            if (types.length != classTypes.length) continue;
            for (int i = 0; i < types.length; ++i) {
                if (classTypes[i].isAssignableFrom(types[i])) continue;
            }
            return con;
        }
        throw new ComponentInstanceCreateException(String.format("The creation of application %s failed, cannot find matched creator.", this.getName()));
    }

    private void afterCreateApplication(IApplication application) throws Exception {
        this.executePropertySetter(application, application);
        this.executeInitMethod(application);
        this.executeInitializeServices(application);
    }

    public IApplication createApplication(IEventBus eventBus, IViewComponent view, UIConfig uiConfig) {
        if (StringUtils.isEmpty((String)this.getName())) {
            return null;
        }
        Class clazz = this.findClass();
        try {
            Constructor constructor = this.findConstructor(clazz, new Class[]{IEventBus.class, IViewComponent.class, UIConfig.class});
            IApplication application = (IApplication)constructor.newInstance(eventBus, view, uiConfig);
            this.afterCreateApplication(application);
            return application;
        }
        catch (Exception e) {
            throw new ComponentInstanceCreateException(String.format("The creation of application %s failed!", this.getName()), e);
        }
    }

    public IApplication createApplication(UIConfig uiConfig) {
        if (StringUtils.isEmpty((String)this.getName())) {
            return null;
        }
        Class clazz = this.findClass();
        try {
            Constructor constructor = clazz.getConstructor(UIConfig.class);
            IApplication application = (IApplication)constructor.newInstance(uiConfig);
            this.afterCreateApplication(application);
            return application;
        }
        catch (Exception e) {
            throw new ComponentInstanceCreateException(String.format("The creation of application %s failed!", this.getName()), e);
        }
    }

    private void executeInitializeServices(IApplication application) {
        if (this.initializeServices == null) {
            return;
        }
        for (Reference reference : this.initializeServices) {
            ValueExpressionEvaluator evaluator = new ValueExpressionEvaluator(application.getServicesAccess(), reference);
            IApplicationInitilize pi = (IApplicationInitilize)evaluator.evaluate();
            pi.afterInitilized(application);
        }
    }

    @Override
    public void accept(IDefinitionVisitor visitor) {
        visitor.visit(this);
    }
}

