/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.definition;

import com.kingdee.bos.eventbus.HandlerType;
import com.kingdee.bos.eventbus.IServerEventHandler;
import com.kingdee.bos.eventbus.annotation.EventHandler;
import com.kingdee.bos.eventbus.annotation.Level;
import com.kingdee.bos.eventbus.annotation.OnEvent;
import com.kingdee.bos.eventbus.definition.AbstractComponentMeta;
import com.kingdee.bos.eventbus.definition.ComponentType;
import com.kingdee.bos.eventbus.definition.IDefinitionVisitor;
import com.kingdee.bos.eventbus.expression.ExpressionParser;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;

public final class Handler
extends AbstractComponentMeta
implements Serializable,
Cloneable {
    private Object source;
    private transient Method annotationMethod;
    private HandlerType handlerType = HandlerType.NORMAL;

    public Handler(String name) {
        super(name);
        this.type = ComponentType.PLUGIN;
        this.parseHandlerType();
    }

    public Handler(String name, HandlerType handlerType) {
        super(name);
        this.type = ComponentType.PLUGIN;
        this.handlerType = handlerType;
    }

    public HandlerType getHandlerType() {
        return this.handlerType;
    }

    private void parseHandlerType() {
        Class handlerClass = this.findClass();
        boolean isAnnotation = handlerClass.isAnnotationPresent(EventHandler.class);
        if (isAnnotation) {
            EventHandler eh = handlerClass.getAnnotation(EventHandler.class);
            this.handlerType = eh.type();
        } else if (IServerEventHandler.class.isAssignableFrom(handlerClass)) {
            this.handlerType = HandlerType.SERVER;
        }
    }

    public boolean isAnnotation() {
        Class handlerClass = this.findClass();
        boolean isAnnotation = handlerClass.isAnnotationPresent(EventHandler.class);
        if (isAnnotation) {
            isAnnotation = this.hasOnEventMethod(handlerClass);
        }
        return isAnnotation;
    }

    private boolean hasOnEventMethod(Class handlerClass) {
        Method[] methods;
        boolean result = false;
        for (Method method : methods = handlerClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(OnEvent.class)) continue;
            result = true;
            break;
        }
        return result;
    }

    public Object getSource() {
        return this.source;
    }

    void setSource(Object source) {
        this.source = source;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Method getAnnotationMethod() {
        return this.annotationMethod;
    }

    void setAnnotationMethod(Method annotationMethod) {
        this.annotationMethod = annotationMethod;
    }

    public Object getExactSource() {
        if (!(this.source instanceof String)) {
            return this.source;
        }
        String key = (String)this.source;
        int idx = key.indexOf(40);
        if (idx < 0) {
            return key;
        }
        return key.substring(0, idx).trim();
    }

    public Map<String, String> getParamsMap() {
        if (!(this.source instanceof String)) {
            return new HashMap<String, String>(0);
        }
        Matcher matcher = ExpressionParser.BRACKET_PATTERN.matcher((String)this.source);
        if (!matcher.find()) {
            return new HashMap<String, String>(0);
        }
        String strParams = matcher.group(1);
        if (StringUtils.isEmpty((String)strParams)) {
            return new HashMap<String, String>(0);
        }
        String[] params = strParams.split("\\s*;\\s*");
        HashMap<String, String> paramsMap = new HashMap<String, String>(params.length);
        for (String param : params) {
            String[] aParam = param.split("\\s*=\\s*");
            if (aParam.length < 2) continue;
            paramsMap.put(aParam[0].toUpperCase(), aParam[1]);
        }
        return paramsMap;
    }

    @Override
    public void accept(IDefinitionVisitor visitor) {
        visitor.visit(this);
    }

    public int getHandlerLevel() {
        return Handler.getHandlerLevel(this.findClass());
    }

    public static int getHandlerLevel(Class handlerClass) {
        if (!handlerClass.isAnnotationPresent(Level.class)) {
            return 0;
        }
        Level level = handlerClass.getAnnotation(Level.class);
        return level.value();
    }
}

