/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.definition;

import com.kingdee.bos.eventbus.definition.AbstractComponentMeta;
import com.kingdee.bos.eventbus.definition.ActionDefinition;
import com.kingdee.bos.eventbus.definition.ApplicationDefinition;
import com.kingdee.bos.eventbus.definition.Event;
import com.kingdee.bos.eventbus.definition.Handler;
import com.kingdee.bos.eventbus.definition.IDefinitionVisitor;
import com.kingdee.bos.eventbus.definition.Property;
import com.kingdee.bos.eventbus.definition.Service;
import com.kingdee.bos.eventbus.definition.UIConfig;

public final class XMLWriteVisitor
implements IDefinitionVisitor {
    private static final String NEWLINE = "\n";
    private static final String ENTER = "\r";
    private StringBuilder sb = new StringBuilder();

    @Override
    public void visit(UIConfig uiConfig) {
        this.sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(ENTER).append(NEWLINE);
        this.sb.append("<uic>").append(NEWLINE);
        if (uiConfig.getParent() != null) {
            this.sb.append("\t<parent>").append(uiConfig.getParent().getName()).append("</parent>").append(NEWLINE);
        }
        if (uiConfig.getServices() != null) {
            this.sb.append("\t<services>").append(NEWLINE);
            for (Service service : uiConfig.getServices().values()) {
                service.accept(this);
            }
            this.sb.append("\t</services>").append(NEWLINE);
        }
        if (uiConfig.getActions() != null) {
            this.sb.append("\t<actions>").append(NEWLINE);
            for (ActionDefinition action : uiConfig.getActions().values()) {
                action.accept(this);
            }
            this.sb.append("\t</actions>").append(NEWLINE);
        }
        this.sb.append("</uic>").append(ENTER).append(NEWLINE);
    }

    @Override
    public void visit(Service service) {
        this.sb.append("\t\t<service>").append(NEWLINE);
        this.sb.append("\t\t\t<name>").append(service.getId()).append("</name>").append(NEWLINE);
        this.visitComponent(service);
        this.sb.append("\t\t</service>").append(NEWLINE);
    }

    private void visitComponent(AbstractComponentMeta component) {
        if (component.getProperties() != null) {
            this.sb.append("\t\t\t<properties>").append(NEWLINE);
            for (Property property : component.getProperties()) {
                property.accept(this);
            }
            this.sb.append("\t\t\t</properties>").append(NEWLINE);
        }
    }

    @Override
    public void visit(Property property) {
        this.sb.append("\t\t\t\t<property name=\"");
        this.sb.append(property.getName());
        this.sb.append("\" value=\"");
        this.sb.append(property.getValue());
        this.sb.append("\" />");
        this.sb.append(NEWLINE);
    }

    @Override
    public void visit(ApplicationDefinition applicationDefinition) {
    }

    @Override
    public void visit(Event event) {
        if (event.isSimple()) {
            this.sb.append("\t\t\t<event>").append(event.getName()).append("</event>").append(NEWLINE);
        }
    }

    @Override
    public void visit(Handler handler) {
    }

    @Override
    public Object finish() {
        return this.sb.toString();
    }

    @Override
    public void visit(ActionDefinition actionDefinition) {
        this.sb.append("\t\t<action>").append(NEWLINE);
        this.sb.append("\t\t\t<name>").append(actionDefinition.getActionName()).append("</name>").append(NEWLINE);
        actionDefinition.getEvent().accept(this);
        this.sb.append("\t\t</action>").append(NEWLINE);
    }
}

