/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.expression;

import com.kingdee.bos.eventbus.application.IServicesAccess;
import com.kingdee.bos.eventbus.definition.Reference;
import com.kingdee.bos.eventbus.expression.ExpressionParser;
import com.kingdee.bos.expression.ExpressionEvaluator;

public final class ValueExpressionEvaluator {
    private IServicesAccess servicesAccess;
    private Object value;

    public ValueExpressionEvaluator(IServicesAccess servicesAccess, Object value) {
        this.servicesAccess = servicesAccess;
        this.value = value;
    }

    public Object evaluate() {
        Object result = this.value;
        if (this.value instanceof String) {
            String strValue = ((String)this.value).trim();
            result = this.evaluateStringValue(strValue);
        } else if (this.servicesAccess != null && this.value instanceof Reference) {
            Reference ref = (Reference)this.value;
            result = this.servicesAccess.getService(ref.getRefName());
        }
        return result;
    }

    private Object evaluateStringValue(String expression) {
        ExpressionParser parser = ExpressionParser.getInstance();
        Object value = parser.isJSONArray(expression) ? parser.splitJSONArray(expression) : (parser.isFunction(expression) ? ExpressionEvaluator.evaluate(expression) : expression);
        return value;
    }
}

