/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.eventbus.application.IApplication;
import com.kingdee.bos.eventbus.model.IModelService;
import com.kingdee.bos.eventbus.model.ModelCreateException;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.meta.entity.IEntityMetadata;
import com.kingdee.bos.meta.entity.MetaProperty;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public abstract class AbstractModelService
implements IModelService {
    private String entryName;
    private IEntityMetadata entityMetadata;
    private BOSObjectType bosType;
    private String sourceBillEntryName = "entries.sourceBillEntryId";
    private String mainOrgProperty;
    private BOSObjectType entryBosType;
    private String state;
    private String[] selector;
    private SelectorItemCollection dynSelector;

    protected abstract IApplication getApplication();

    protected void setSourceBillEntryName(String sourceBillEntryName) {
        this.sourceBillEntryName = sourceBillEntryName;
    }

    @Override
    public String getEntryPKName() {
        return this.getEntryName() + ".id";
    }

    @Override
    public SelectorItemCollection getModelLoadSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (this.selector == null) {
            return sic;
        }
        for (String sel : this.selector) {
            sic.add(sel);
        }
        return sic;
    }

    public void setEntryName(String entriesName) {
        this.entryName = entriesName;
    }

    @Override
    public String getEntryName() {
        if (this.entryName == null && this.getEntityMetadata() != null) {
            List<MetaProperty> properties = this.getEntityMetadata().getCompositionProperties();
            this.entryName = properties != null ? properties.get(0).getName() : "entries";
        }
        return this.entryName;
    }

    @Override
    public IObjectValue createEntryModel(String entryKey) {
        EntityObjectInfo eo = this.getEntityInfo(this.getApplication().getMainOrgContext(), this.getBosType());
        PropertyInfo property = eo.getPropertyByNameRuntime(entryKey);
        if (property != null && property instanceof LinkPropertyInfo) {
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            EntityObjectInfo entryEntity = relation.getSupplierObject();
            return this.createModel(entryEntity);
        }
        return null;
    }

    @Override
    public SelectorItemCollection getDynSelector() {
        if (this.dynSelector == null) {
            this.dynSelector = new SelectorItemCollection();
        }
        return this.dynSelector;
    }

    @Override
    public String getSourceBillEntryName() {
        return this.sourceBillEntryName;
    }

    @Override
    public final IBizCtrl getEntryBizInterface(Context mainOrgCtx, String entryKey) throws BOSException {
        if (mainOrgCtx == null) {
            return this.getEntryBizInterface(entryKey);
        }
        return this.getEntryBizInterfaceWithObjectContext(mainOrgCtx, entryKey);
    }

    @Override
    public IEntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    @Override
    public void setEntityMetadata(IEntityMetadata entityMetadata) {
        if (entityMetadata == null) {
            return;
        }
        this.entityMetadata = entityMetadata;
        this.bosType = entityMetadata.getBosType();
    }

    @Override
    public BOSObjectType getBosType() {
        return this.bosType;
    }

    public void setBosType(BOSObjectType bosType) {
        this.bosType = bosType;
    }

    @Override
    public String getPropertyOfMainBizOrg() {
        if (this.mainOrgProperty == null) {
            IObjectValue ov = this.createModel();
            if (ov instanceof CoreBillBaseInfo) {
                String bizOrgPropertyName = ((CoreBillBaseInfo)ov).getBizOrgPropertyName();
                this.setMainOrgProperty(bizOrgPropertyName);
                return bizOrgPropertyName;
            }
            return null;
        }
        return this.mainOrgProperty;
    }

    @Override
    public OrgUnitInfo getMainBizOrg(CoreBillBaseInfo info) {
        String propertyOfMainBizOrg = this.getPropertyOfMainBizOrg();
        if (propertyOfMainBizOrg == null) {
            return null;
        }
        return (OrgUnitInfo)info.get(propertyOfMainBizOrg);
    }

    public void setMainOrgProperty(String mainOrgProperty) {
        this.mainOrgProperty = mainOrgProperty;
    }

    @Override
    public IObjectValue createModel() {
        EntityObjectInfo eo = this.getEntityInfo(this.getApplication().getMainOrgContext(), this.getBosType());
        IObjectValue ov = this.createModel(eo);
        return ov;
    }

    private IObjectValue createModel(EntityObjectInfo eo) {
        String objectValueClassName = eo.getObjectValueClass();
        Class<?> objectValueClass = null;
        IObjectValue objectValue = null;
        try {
            objectValueClass = Class.forName(objectValueClassName);
            objectValue = (IObjectValue)objectValueClass.newInstance();
            BOSObjectType type = null;
            if (eo.isDynamic()) {
                type = BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)new MetaDataPK(eo.getFullName())).getType();
                ((ICommonBOSType)objectValue).setBOSType(type);
            }
            objectValue.put("id", (Object)BOSUuid.create((BOSObjectType)objectValue.getBOSType()));
        }
        catch (ClassNotFoundException e) {
            throw new ModelCreateException(e);
        }
        catch (IllegalAccessException e) {
            throw new ModelCreateException(e);
        }
        catch (Exception e) {
            throw new ModelCreateException(e);
        }
        return objectValue;
    }

    private IBizCtrl getBizInterface2(Context ctx) throws BOSException {
        EntityObjectInfo mainEO = this.getEntityInfo(ctx, this.getBosType());
        return this.getBizInteface(ctx, (BusinessObjectInfo)mainEO, null);
    }

    protected IBizCtrl getBizInterfaceWithObjectContext(Context mainOrgCtx) throws BOSException {
        EntityObjectInfo mainEO = this.getEntityInfo(null, this.getBosType());
        return this.getBizInteface(null, (BusinessObjectInfo)mainEO, null);
    }

    @Override
    public OrgType getMainBizOrgType() {
        EntityObjectInfo mainEO = this.getEntityInfo(this.getApplication().getMainOrgContext(), this.getBosType());
        String orgType = mainEO.getExtendedProperty("OrgType");
        if (StringUtils.isEmpty((String)orgType) || orgType.equals(OrgType.NONE.getName())) {
            return OrgType.ControlUnit;
        }
        return OrgType.getEnum((String)orgType);
    }

    protected final EntityObjectInfo getEntityInfo(Context ctx, BOSObjectType bosType) {
        EntityObjectInfo mainEO = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        return mainEO;
    }

    private IBizCtrl getBizInteface(Context ctx, BusinessObjectInfo mainEO, Context mainOrgCtx) throws BOSException {
        if (mainEO.isDynamic()) {
            return (IBizCtrl)BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)new MetaDataPK(mainEO.getFullName()));
        }
        String clzFactoryName = mainEO.getBusinessImplFactory();
        try {
            Class<?> clzFactory = Class.forName(clzFactoryName);
            IBizCtrl iBiz = this.getBizInterface(ctx, clzFactory, mainOrgCtx);
            return iBiz;
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private IBizCtrl getBizInterface(Context ctx, Class clzFactory, Context mainOrgCtx) throws BOSException {
        boolean isLocal = ctx != null;
        IBizCtrl iBiz = null;
        try {
            if (isLocal) {
                Class[] parameterTypes = new Class[]{Context.class};
                Method mGetInstance = clzFactory.getMethod("getLocalInstance", parameterTypes);
                iBiz = (IBizCtrl)mGetInstance.invoke(null, ctx);
            } else {
                iBiz = this.getRemoteBizInterface(clzFactory, mainOrgCtx);
            }
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return iBiz;
    }

    private IBizCtrl getRemoteBizInterface(Class clzFactory, Context mainOrgCtx) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        IBizCtrl iBiz;
        if (mainOrgCtx != null) {
            Method mGetInstance = clzFactory.getMethod("getRemoteInstanceWithObjectContext", Context.class);
            iBiz = (IBizCtrl)mGetInstance.invoke(null, mainOrgCtx);
        } else {
            Method mGetInstance = clzFactory.getMethod("getRemoteInstance", null);
            iBiz = (IBizCtrl)mGetInstance.invoke(null, null);
        }
        return iBiz;
    }

    protected IBizCtrl getEntryBizInterface(String entryKey) throws BOSException {
        this.initMainEntryBosType();
        EntityObjectInfo mainEO = this.getEntityInfo(this.getApplication().getMainOrgContext(), this.entryBosType);
        return this.getBizInteface(this.getApplication().getMainOrgContext(), (BusinessObjectInfo)mainEO, null);
    }

    protected IBizCtrl getEntryBizInterfaceWithObjectContext(Context mainOrgCtx, String entryKey) throws BOSException {
        EntityObjectInfo mainEO = this.getEntityInfo(this.getApplication().getMainOrgContext(), this.entryBosType);
        return this.getBizInteface(this.getApplication().getMainOrgContext(), (BusinessObjectInfo)mainEO, mainOrgCtx);
    }

    protected Context getMainOrgContext() {
        return this.getApplication().getMainOrgContext();
    }

    private void initMainEntryBosType() {
        if (this.entryBosType != null) {
            return;
        }
        this.entryBosType = this.getEntityMetadata().getEntryBosType(this.getEntryName());
    }

    @Override
    public final IBizCtrl getBizInterface(Context ctx) throws BOSException {
        Context mainOrgCtx = this.getMainOrgContext();
        if (mainOrgCtx == null) {
            return this.getBizInterface2(ctx);
        }
        return this.getBizInterfaceWithObjectContext(mainOrgCtx);
    }

    protected IObjectValue getModel(String[] selectors, String id) throws BOSException, EASBizException {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        for (String selector : selectors) {
            sb.append(selector).append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(" where id='").append(id).append("'");
        IObjectValue vo = null;
        try {
            vo = this.getValueObject(id, this.selector.toString());
        }
        catch (BOSException exception) {
            throw new ModelCreateException(exception);
        }
        return vo;
    }

    @Override
    public String getPropertyNameOfState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setSelector(String[] selector) {
        this.selector = selector;
    }

    public IObjectValue getValueObject(String id, String selector) throws BOSException, EASBizException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        if (selector != null) {
            String[] properties;
            for (String property : properties = selector.split(",")) {
                SelectorItemInfo selectorItemInfo = new SelectorItemInfo(property);
                selectorItemCollection.add(selectorItemInfo);
            }
        }
        Context ctx = BOSObjectFactory.getContextFromThread();
        ICoreBase iCoreBase = (ICoreBase)this.getBizInterface(ctx);
        CoreBaseInfo objectValue = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(id), selectorItemCollection);
        return objectValue;
    }
}

