/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.parse;

import com.kingdee.bos.eventbus.parse.ConfigurationParseException;
import com.kingdee.bos.eventbus.parse.ParserContext;
import com.kingdee.bos.eventbus.parse.ResourceNotFoundException;
import com.kingdee.bos.util.XMLParser;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class XmlFileReader {
    public Element read(ParserContext parserContext) throws ConfigurationParseException {
        Element root = null;
        String resource = parserContext.getAbsoluteResourceLocation();
        InputStream is = null;
        try {
            is = this.readFile(parserContext, parserContext.isClassPath());
            if (is == null) {
                throw new ResourceNotFoundException("Reading resource file " + resource + " failed.");
            }
            root = XMLParser.parseXML((InputStream)is).getRootElement();
        }
        catch (JDOMException e) {
            throw new ConfigurationParseException(e);
        }
        catch (IOException e) {
            throw new ConfigurationParseException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return root;
    }

    private InputStream readFile(ParserContext parserContext, boolean isClassPath) {
        String resource = parserContext.getAbsoluteResourceLocation();
        try {
            if (!isClassPath) {
                return new FileInputStream(FilenameUtils.normalize((String)resource));
            }
            return this.getClassLoader(parserContext).getResourceAsStream(resource);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException("Resource file" + resource + "cannot be found.");
        }
    }

    private ClassLoader getClassLoader(ParserContext parserContext) {
        if (parserContext.getResourceClassLoader() != null) {
            return parserContext.getResourceClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    public Element read(String xmlString) {
        InputStream is = this.getInputStreamFromString(xmlString);
        try {
            return XMLParser.parseXML((InputStream)is).getRootElement();
        }
        catch (JDOMException e) {
            throw new ConfigurationParseException(e);
        }
        catch (IOException e) {
            throw new ConfigurationParseException(e);
        }
    }

    private InputStream getInputStreamFromString(String str) {
        return new ByteArrayInputStream(str.getBytes());
    }
}

