/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.support;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.eventbus.IEventFilter;
import com.kingdee.bos.eventbus.KDEvent;
import com.kingdee.bos.eventbus.application.IApplication;
import com.kingdee.bos.eventbus.definition.ActionDefinition;
import com.kingdee.bos.eventbus.definition.RuleDefinition;
import com.kingdee.bos.eventbus.definition.UIConfig;
import com.kingdee.bos.eventbus.event.action.KDActionEvent;
import com.kingdee.bos.expression.datameta.Variable;
import com.kingdee.bos.meta.ui.IDynamicAction;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtilsBean;

public abstract class ActionPreConditionFilter
implements IEventFilter {
    private String actionName;

    public ActionPreConditionFilter(String actionName) {
        this.actionName = actionName;
    }

    protected abstract IApplication getApplication();

    @Override
    public boolean accept(KDEvent event) {
        KDActionEvent evt = (KDActionEvent)event;
        if (!this.actionName.equals(evt.getActionName())) {
            return true;
        }
        UIConfig uiConfig = this.getApplication().getUIConfig();
        ActionDefinition actionDefinition = uiConfig.getActionDefinition(this.actionName);
        if (actionDefinition.getPreCondition() == null) {
            return true;
        }
        IObjectValue model = null;
        RuleDefinition rule = actionDefinition.getPreCondition().getRuleDefinition(this.getApplication(), uiConfig);
        if (rule == null) {
            return true;
        }
        String state = this.getApplication().getModelService().getPropertyNameOfState();
        if (rule.hasVariableWithPrefix("m.")) {
            Set<String> variables = this.parsePropertiesOfModel(rule, state);
            model = this.getModel(variables);
        }
        List context = this.prepareContext(rule, state, model);
        context.add(Variable.createVariable("p", this.getApplication()));
        boolean accept = actionDefinition.getPreCondition().booleanValue(context);
        try {
            this.showErrorIfNotAccept(state, model, accept);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return accept;
    }

    private List prepareContext(RuleDefinition rule, String state, IObjectValue model) {
        String var;
        ArrayList<Variable> context = new ArrayList<Variable>();
        if (rule.hasVariableWithPrefix("m.")) {
            var = this.getVariableForParentObject("m.");
            context.add(Variable.createVariable(var, model));
        }
        if (rule.hasVariableWithPrefix("p.")) {
            var = this.getVariableForParentObject("p.");
            context.add(Variable.createVariable(var, this.getApplication()));
        }
        return context;
    }

    private String getVariableForParentObject(String prefix) {
        return prefix.substring(0, prefix.length() - 1);
    }

    private void showErrorIfNotAccept(String state, IObjectValue model, boolean accept) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (accept) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (model != null && !StringUtils.isEmpty((String)state)) {
            Object value = new PropertyUtilsBean().getProperty((Object)model, state);
            sb.append(value).append("\u72b6\u6001\u951f\u65a4\u62f7");
        } else {
            sb.append("\u951f\u65a4\u62f7\u524d");
        }
        sb.append(this.getApplication().getModelService().getEntityMetadata().getAlias());
        sb.append("\u951f\u65a4\u62f7\u951f\u65a4\u62f7");
        IDynamicAction action = this.getApplication().getActionAccess().getActionByKey(this.actionName);
        sb.append(action.getShortDescription());
        this.outputError(sb.toString());
    }

    protected abstract void outputError(String var1);

    protected abstract void handleException(Exception var1);

    private IObjectValue getModel(Set<String> variables) {
        IObjectValue model = null;
        int size = variables.size();
        if (size == 0) {
            return null;
        }
        try {
            IObjectValue dataObject;
            model = dataObject = this.getApplication().getModelService().getModel(variables.toArray(new String[size]));
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return model;
    }

    private Set<String> parsePropertiesOfModel(RuleDefinition rule, String state) {
        Set<String> variables = rule.getVariableWithPrefix("m.");
        if (!variables.contains("m." + state) && !StringUtils.isEmpty((String)state)) {
            variables.add(state);
        }
        return variables;
    }
}

