/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.expression.datameta;

import com.kingdee.bos.expression.datameta.Reference;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public abstract class BaseDataMeta {
    DataType dataType;
    Object dataValue;
    private boolean isReference;

    public BaseDataMeta(DataType dataType, Object dataValue) {
        this.dataType = dataType;
        this.dataValue = dataValue;
        this.verifyDataMeta();
    }

    public DataType getDataType() {
        if (this.isReference) {
            return this.getReference().getDataType();
        }
        return this.dataType;
    }

    public Object getDataValue() {
        return this.dataValue;
    }

    public String getDataValueText() {
        if (this.dataValue == null) {
            return null;
        }
        if (DataType.DATATYPE_DATE.equals((Object)this.dataType)) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)this.dataValue);
        }
        if (DataType.DATATYPE_LIST.equals((Object)this.dataType)) {
            StringBuffer buff = new StringBuffer("[");
            List col = (List)this.dataValue;
            for (Object o : col) {
                if (o == null) {
                    buff.append("null, ");
                    continue;
                }
                if (o instanceof Date) {
                    buff.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)o)).append(", ");
                    continue;
                }
                buff.append(o.toString()).append(", ");
            }
            buff.append("]");
            if (buff.length() > 2) {
                buff.delete(buff.length() - 3, buff.length() - 1);
            }
            return buff.toString();
        }
        return this.dataValue.toString();
    }

    public String getStringValue() {
        return this.getDataValueText();
    }

    public Boolean getBooleanValue() {
        if (!DataType.DATATYPE_BOOLEAN.equals((Object)this.dataType)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        return (Boolean)this.dataValue;
    }

    public Integer getIntegerValue() {
        if (DataType.DATATYPE_INT.equals((Object)this.dataType)) {
            return (Integer)this.dataValue;
        }
        if (DataType.DATATYPE_INTENUM.equals((Object)this.dataType)) {
            return ((IntEnum)this.dataValue).getValue();
        }
        throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
    }

    public Long getLongValue() {
        if (!DataType.DATATYPE_INT.equals((Object)this.dataType) && !DataType.DATATYPE_LONG.equals((Object)this.dataType)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        if (this.dataValue == null) {
            return null;
        }
        return Long.valueOf(this.dataValue.toString());
    }

    public Float getFloatValue() {
        if (!(DataType.DATATYPE_INT.equals((Object)this.dataType) || DataType.DATATYPE_FLOAT.equals((Object)this.dataType) || DataType.DATATYPE_LONG.equals((Object)this.dataType))) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        if (this.dataValue == null) {
            return null;
        }
        return Float.valueOf(this.dataValue.toString());
    }

    public Double getDoubleValue() {
        if (!(DataType.DATATYPE_INT.equals((Object)this.dataType) || DataType.DATATYPE_LONG.equals((Object)this.dataType) || DataType.DATATYPE_FLOAT.equals((Object)this.dataType) || DataType.DATATYPE_DOUBLE.equals((Object)this.dataType))) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        if (this.dataValue == null) {
            return null;
        }
        return Double.valueOf(this.dataValue.toString());
    }

    public BigDecimal getBigDecimalValue() {
        if (!(DataType.DATATYPE_INT.equals((Object)this.dataType) || DataType.DATATYPE_LONG.equals((Object)this.dataType) || DataType.DATATYPE_FLOAT.equals((Object)this.dataType) || DataType.DATATYPE_DOUBLE.equals((Object)this.dataType) || DataType.DATATYPE_BIGDECIMAL.equals((Object)this.dataType))) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        if (this.dataValue == null) {
            return null;
        }
        if (this.dataValue instanceof BigDecimal) {
            return (BigDecimal)this.dataValue;
        }
        return BigDecimal.valueOf(Long.valueOf(this.dataValue.toString()));
    }

    public IntEnum getIntEnumValue() {
        if (!DataType.DATATYPE_INTENUM.equals((Object)this.dataType)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        if (this.dataValue == null) {
            return null;
        }
        if (this.dataValue instanceof IntEnum) {
            return (IntEnum)this.dataValue;
        }
        return null;
    }

    public Date getDateValue() {
        if (!DataType.DATATYPE_DATE.equals((Object)this.dataType)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        return (Date)this.dataValue;
    }

    public List<Object> getCollection() {
        if (!DataType.DATATYPE_LIST.equals((Object)this.dataType)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        return (List)this.dataValue;
    }

    public Reference getReference() {
        if (!this.isReference) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        return (Reference)this.dataValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BaseDataMeta) {
            BaseDataMeta bdo = (BaseDataMeta)o;
            if (this.isReference() && bdo.isReference) {
                return this.getReference().equals(bdo.getReference());
            }
            if (bdo.dataType.equals((Object)this.dataType)) {
                if (bdo.dataValue != null && bdo.dataValue.equals(this.dataValue)) {
                    return true;
                }
                return bdo.dataValue == null && this.dataValue == null;
            }
            return false;
        }
        return false;
    }

    protected void verifyDataMeta() {
        if (this.dataType != null && this.dataValue != null) {
            if (DataType.DATATYPE_NULL.equals((Object)this.dataType) && this.dataValue != null) {
                throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + (Object)((Object)this.dataType) + ",\u503c\u4e0d\u4e3a\u7a7a");
            }
            if (DataType.DATATYPE_BOOLEAN.equals((Object)this.dataType)) {
                try {
                    this.getBooleanValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + (Object)((Object)this.dataType) + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_DATE.equals((Object)this.dataType)) {
                try {
                    this.getDateValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + (Object)((Object)this.dataType) + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_BIGDECIMAL.equals((Object)this.dataType)) {
                try {
                    this.getBigDecimalValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + (Object)((Object)this.dataType) + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_INT.equals((Object)this.dataType)) {
                try {
                    this.getIntegerValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + (Object)((Object)this.dataType) + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_LONG.equals((Object)this.dataType)) {
                try {
                    this.getLongValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + (Object)((Object)this.dataType) + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_STRING.equals((Object)this.dataType)) {
                try {
                    this.getStringValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + (Object)((Object)this.dataType) + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_INTENUM.equals((Object)this.dataType)) {
                try {
                    this.getIntEnumValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + (Object)((Object)this.dataType) + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_LIST.equals((Object)this.dataType)) {
                try {
                    this.getCollection();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + (Object)((Object)this.dataType) + ",\u503c:" + this.dataValue);
                }
            }
            if (this.isReference) {
                try {
                    this.getReference();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + (Object)((Object)this.dataType) + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_OBJECT.equals((Object)this.dataType)) {
                try {
                    this.getDataValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + (Object)((Object)this.dataType) + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_DOUBLE.equals((Object)this.dataType)) {
                try {
                    this.getDoubleValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + (Object)((Object)this.dataType) + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_FLOAT.equals((Object)this.dataType)) {
                try {
                    this.getFloatValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + (Object)((Object)this.dataType) + ",\u503c:" + this.dataValue);
                }
            }
        }
    }

    public Class mapTypeToJavaClass() {
        if (DataType.DATATYPE_BOOLEAN.equals((Object)this.getDataType())) {
            return Boolean.TYPE;
        }
        if (DataType.DATATYPE_DATE.equals((Object)this.getDataType())) {
            return Date.class;
        }
        if (DataType.DATATYPE_BIGDECIMAL.equals((Object)this.getDataType())) {
            return BigDecimal.class;
        }
        if (DataType.DATATYPE_INT.equals((Object)this.getDataType())) {
            return Integer.TYPE;
        }
        if (DataType.DATATYPE_LONG.equals((Object)this.getDataType())) {
            return Long.TYPE;
        }
        if (DataType.DATATYPE_STRING.equals((Object)this.getDataType())) {
            return String.class;
        }
        if (DataType.DATATYPE_INTENUM.equals((Object)this.getDataType())) {
            return IntEnum.class;
        }
        if (DataType.DATATYPE_LIST.equals((Object)this.getDataType())) {
            return List.class;
        }
        if (DataType.DATATYPE_OBJECT.equals((Object)this.getDataType())) {
            return Object.class;
        }
        if (DataType.DATATYPE_DOUBLE.equals((Object)this.getDataType())) {
            return Double.TYPE;
        }
        if (DataType.DATATYPE_FLOAT.equals((Object)this.getDataType())) {
            return Float.TYPE;
        }
        if (DataType.DATATYPE_NULL.equals((Object)this.getDataType())) {
            return null;
        }
        throw new RuntimeException("\u6620\u5c04Java\u7c7b\u578b\u5931\u8d25\uff1a\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u7c7b\u578b");
    }

    private boolean isCompatibleType(BaseDataMeta another) {
        if (DataType.DATATYPE_NULL.equals((Object)this.getDataType()) || DataType.DATATYPE_NULL.equals((Object)another.getDataType())) {
            return true;
        }
        if (this.getDataType().equals((Object)another.getDataType())) {
            return true;
        }
        if (!(DataType.DATATYPE_INT.equals((Object)this.getDataType()) || DataType.DATATYPE_LONG.equals((Object)this.getDataType()) || DataType.DATATYPE_FLOAT.equals((Object)this.getDataType()) || DataType.DATATYPE_DOUBLE.equals((Object)this.getDataType()) || DataType.DATATYPE_BIGDECIMAL.equals((Object)this.getDataType()) || DataType.DATATYPE_INTENUM.equals((Object)this.getDataType()))) {
            return false;
        }
        return DataType.DATATYPE_INT.equals((Object)another.getDataType()) || DataType.DATATYPE_LONG.equals((Object)another.getDataType()) || DataType.DATATYPE_FLOAT.equals((Object)another.getDataType()) || DataType.DATATYPE_DOUBLE.equals((Object)another.getDataType()) || DataType.DATATYPE_BIGDECIMAL.equals((Object)another.getDataType()) || DataType.DATATYPE_INTENUM.equals((Object)another.getDataType());
    }

    public DataType getCompatibleType(BaseDataMeta another) {
        if (this.isCompatibleType(another)) {
            if (DataType.DATATYPE_NULL.equals((Object)this.getDataType())) {
                return another.getDataType();
            }
            if (DataType.DATATYPE_NULL.equals((Object)another.getDataType())) {
                return this.getDataType();
            }
            if (this.getDataType().equals((Object)another.getDataType())) {
                return this.getDataType();
            }
            if (DataType.DATATYPE_DOUBLE.equals((Object)this.getDataType()) || DataType.DATATYPE_DOUBLE.equals((Object)another.getDataType())) {
                return DataType.DATATYPE_DOUBLE;
            }
            if (DataType.DATATYPE_FLOAT.equals((Object)this.getDataType()) || DataType.DATATYPE_FLOAT.equals((Object)another.getDataType())) {
                return DataType.DATATYPE_FLOAT;
            }
            if (DataType.DATATYPE_LONG.equals((Object)this.getDataType()) || DataType.DATATYPE_LONG.equals((Object)another.getDataType())) {
                return DataType.DATATYPE_LONG;
            }
            if (DataType.DATATYPE_BIGDECIMAL.equals((Object)this.getDataType()) || DataType.DATATYPE_BIGDECIMAL.equals((Object)another.getDataType())) {
                return DataType.DATATYPE_BIGDECIMAL;
            }
            return DataType.DATATYPE_INT;
        }
        return null;
    }

    public Object toJavaObject() throws ParseException {
        if (null == this.dataValue) {
            return null;
        }
        if (DataType.DATATYPE_BOOLEAN.equals((Object)this.getDataType())) {
            return this.getBooleanValue();
        }
        if (DataType.DATATYPE_DATE.equals((Object)this.getDataType())) {
            return this.getDateValue();
        }
        if (DataType.DATATYPE_BIGDECIMAL.equals((Object)this.getDataType())) {
            return this.getBigDecimalValue();
        }
        if (DataType.DATATYPE_INT.equals((Object)this.getDataType())) {
            return this.getIntegerValue();
        }
        if (DataType.DATATYPE_LONG.equals((Object)this.getDataType())) {
            return this.getLongValue();
        }
        if (DataType.DATATYPE_STRING.equals((Object)this.getDataType())) {
            return this.getStringValue();
        }
        if (DataType.DATATYPE_INTENUM.equals((Object)this.getDataType())) {
            return this.getIntEnumValue();
        }
        if (DataType.DATATYPE_LIST.equals((Object)this.getDataType())) {
            return this.getCollection();
        }
        if (DataType.DATATYPE_OBJECT.equals((Object)this.getDataType())) {
            return this.getDataValue();
        }
        if (DataType.DATATYPE_DOUBLE.equals((Object)this.getDataType())) {
            return this.getDoubleValue();
        }
        if (DataType.DATATYPE_FLOAT.equals((Object)this.getDataType())) {
            return this.getFloatValue();
        }
        throw new RuntimeException("\u6620\u5c04Java\u7c7b\u578b\u5931\u8d25\uff1a\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u7c7b\u578b");
    }

    public boolean isReference() {
        return this.isReference;
    }

    void setReference(boolean isReference) {
        this.isReference = isReference;
    }

    public static enum DataType {
        DATATYPE_NULL,
        DATATYPE_STRING,
        DATATYPE_BOOLEAN,
        DATATYPE_INT,
        DATATYPE_LONG,
        DATATYPE_FLOAT,
        DATATYPE_DOUBLE,
        DATATYPE_DATE,
        DATATYPE_BIGDECIMAL,
        DATATYPE_LIST,
        DATATYPE_OBJECT,
        DATATYPE_INTENUM;

    }
}

