/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.expression.op.define;

import com.kingdee.bos.expression.IllegalExpressionException;
import com.kingdee.bos.expression.datameta.BaseDataMeta;
import com.kingdee.bos.expression.datameta.Constant;
import com.kingdee.bos.expression.datameta.Reference;
import com.kingdee.bos.expression.op.IOperatorExecution;
import com.kingdee.bos.expression.op.Operator;
import java.math.BigDecimal;

public abstract class Op_Arithmetic
implements IOperatorExecution {
    public static final BigDecimal ZERO = new BigDecimal("0.00");

    protected abstract Operator getThisOperator();

    protected abstract BigDecimal executeAsBigDecimal(BigDecimal var1, BigDecimal var2);

    protected abstract double executeAsDouble(double var1, double var3);

    protected abstract float executeAsFloat(float var1, float var2);

    protected abstract long executeAsLong(long var1, long var3);

    protected abstract int executeAsInt(int var1, int var2);

    @Override
    public Constant execute(Constant[] args) throws IllegalExpressionException {
        Number result;
        if (args == null || args.length != 2) {
            throw new IllegalArgumentException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d");
        }
        Constant first = args[1];
        Constant second = args[0];
        this.verifyOperateValue(first, second);
        if (first.isReference()) {
            Reference firstRef = (Reference)first.getDataValue();
            first = firstRef.execute();
        }
        if (second.isReference()) {
            Reference secondRef = (Reference)second.getDataValue();
            second = secondRef.execute();
        }
        if (BaseDataMeta.DataType.DATATYPE_STRING == first.getDataType() || BaseDataMeta.DataType.DATATYPE_STRING == second.getDataType() || BaseDataMeta.DataType.DATATYPE_NULL.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_NULL.equals((Object)second.getDataType()) || BaseDataMeta.DataType.DATATYPE_BOOLEAN.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_BOOLEAN.equals((Object)second.getDataType()) || BaseDataMeta.DataType.DATATYPE_DATE.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_DATE.equals((Object)second.getDataType())) {
            return this.executeAsStringCompatibleType(first, second);
        }
        if (BaseDataMeta.DataType.DATATYPE_LIST.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_LIST.equals((Object)second.getDataType())) {
            return this.executeAsListType(first, second);
        }
        if (null == first.getDataValue() || null == second.getDataValue()) {
            throw new NullPointerException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u4e3a\u7a7a");
        }
        if (BaseDataMeta.DataType.DATATYPE_BIGDECIMAL == first.getDataType() || BaseDataMeta.DataType.DATATYPE_BIGDECIMAL == second.getDataType()) {
            result = this.executeAsBigDecimal(first.getBigDecimalValue(), second.getBigDecimalValue());
            return new Constant(BaseDataMeta.DataType.DATATYPE_BIGDECIMAL, result);
        }
        if (BaseDataMeta.DataType.DATATYPE_DOUBLE.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_DOUBLE.equals((Object)second.getDataType())) {
            result = this.executeAsDouble(first.getDoubleValue(), second.getDoubleValue());
            return new Constant(BaseDataMeta.DataType.DATATYPE_DOUBLE, result);
        }
        if (BaseDataMeta.DataType.DATATYPE_FLOAT.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_FLOAT.equals((Object)second.getDataType())) {
            result = Float.valueOf(this.executeAsFloat(first.getFloatValue().floatValue(), second.getFloatValue().floatValue()));
            return new Constant(BaseDataMeta.DataType.DATATYPE_FLOAT, result);
        }
        if (BaseDataMeta.DataType.DATATYPE_LONG.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_LONG.equals((Object)second.getDataType())) {
            result = this.executeAsLong(first.getLongValue(), second.getLongValue());
            return new Constant(BaseDataMeta.DataType.DATATYPE_LONG, result);
        }
        result = this.executeAsInt(first.getIntegerValue(), second.getIntegerValue());
        return new Constant(BaseDataMeta.DataType.DATATYPE_INT, result);
    }

    protected void verifyOperateValue(Constant first, Constant second) {
        if (this.isNotAllowedAsNull(first, second)) {
            throw new NullPointerException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u4e3a\u7a7a");
        }
    }

    protected boolean isNotAllowedAsNull(Constant first, Constant second) {
        return null == first || null == first.getDataValue() || null == second || null == second.getDataValue();
    }

    protected Constant executeAsStringCompatibleType(Constant first, Constant second) {
        throw new IllegalArgumentException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
    }

    @Override
    public Constant verify(int opPositin, BaseDataMeta[] args) throws IllegalExpressionException {
        if (args == null) {
            throw new IllegalArgumentException("\u8fd0\u7b97\u64cd\u4f5c\u7b26\u53c2\u6570\u4e3a\u7a7a");
        }
        if (args.length != 2) {
            throw new IllegalExpressionException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d", this.getThisOperator().getToken(), opPositin);
        }
        BaseDataMeta first = args[1];
        BaseDataMeta second = args[0];
        if (first == null || second == null) {
            throw new NullPointerException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u4e3a\u7a7a");
        }
        if (BaseDataMeta.DataType.DATATYPE_STRING == first.getDataType() || BaseDataMeta.DataType.DATATYPE_STRING == second.getDataType() || BaseDataMeta.DataType.DATATYPE_NULL == first.getDataType() || BaseDataMeta.DataType.DATATYPE_NULL == second.getDataType() || BaseDataMeta.DataType.DATATYPE_BOOLEAN == first.getDataType() || BaseDataMeta.DataType.DATATYPE_BOOLEAN == second.getDataType() || BaseDataMeta.DataType.DATATYPE_DATE == first.getDataType() || BaseDataMeta.DataType.DATATYPE_DATE == second.getDataType()) {
            return this.verifyAsStringCompatibleType();
        }
        if (BaseDataMeta.DataType.DATATYPE_LIST == first.getDataType() || BaseDataMeta.DataType.DATATYPE_LIST == second.getDataType()) {
            return this.verifyAsListType();
        }
        if (BaseDataMeta.DataType.DATATYPE_BIGDECIMAL.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_BIGDECIMAL.equals((Object)second.getDataType())) {
            return new Constant(BaseDataMeta.DataType.DATATYPE_BIGDECIMAL, ZERO);
        }
        if (BaseDataMeta.DataType.DATATYPE_DOUBLE.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_DOUBLE.equals((Object)second.getDataType())) {
            return new Constant(BaseDataMeta.DataType.DATATYPE_DOUBLE, Double.valueOf("0.0"));
        }
        if (BaseDataMeta.DataType.DATATYPE_FLOAT.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_FLOAT.equals((Object)second.getDataType())) {
            return new Constant(BaseDataMeta.DataType.DATATYPE_FLOAT, Float.valueOf("0.0"));
        }
        if (BaseDataMeta.DataType.DATATYPE_LONG.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_LONG.equals((Object)second.getDataType())) {
            return new Constant(BaseDataMeta.DataType.DATATYPE_LONG, Long.valueOf("0"));
        }
        return new Constant(BaseDataMeta.DataType.DATATYPE_INT, Integer.valueOf("0"));
    }

    protected Constant verifyAsStringCompatibleType() {
        throw new IllegalExpressionException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u7c7b\u578b\u9519\u8bef", this.getThisOperator().getToken());
    }

    protected Constant verifyAsListType() {
        throw new IllegalExpressionException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u7c7b\u578b\u9519\u8bef", this.getThisOperator().getToken());
    }

    protected Constant executeAsListType(Constant first, Constant second) {
        throw new IllegalArgumentException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
    }
}

